/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.jotpatch;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.BitField;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.util.Visitor;

public class Patch {
    public static JavaType[] javaHasTypes2JavaTypes(Collection collection) {
        JavaType[] javaTypeArray = new JavaType[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaHasType javaHasType = (JavaHasType)iterator.next();
            javaTypeArray[n] = javaHasType.getResolvedType();
            ++n;
        }
        return javaTypeArray;
    }

    public static JavaType[] typeNames2JavaTypes(JavaProvider javaProvider, String[] stringArray) {
        JavaType[] javaTypeArray = new JavaType[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            javaTypeArray[n] = javaProvider.getClass(string);
            ++n;
        }
        return javaTypeArray;
    }

    public static JavaType[] getParameterTypes(JavaMethod javaMethod) {
        Collection collection = javaMethod.getParameters();
        return Patch.javaHasTypes2JavaTypes(collection);
    }

    public static JavaMethod getJavaMethod(JavaType javaType, String string, JavaType[] javaTypeArray) {
        JavaMethod javaMethod = Patch.getDeclaredJavaMethod(javaType, string, javaTypeArray);
        if (javaMethod != null) {
            return javaMethod;
        }
        Set set = javaType.getHierarchy();
        for (JavaType javaType2 : set) {
            JavaMethod javaMethod2 = Patch.getDeclaredJavaMethod(javaType2, string, javaTypeArray);
            if (javaMethod2 == null) continue;
            return javaMethod2;
        }
        return null;
    }

    public static JavaMethod getDeclaredJavaMethod(JavaType javaType, String string, JavaType[] javaTypeArray) {
        Collection collection = javaType.getDeclaredMethods();
        for (JavaMethod javaMethod : collection) {
            String string2 = javaMethod.getName();
            if (!string.equals(string2) || !CommonUtilities.matchMethod((JavaMethod)javaMethod, (JavaType[])javaTypeArray)) continue;
            return javaMethod;
        }
        return null;
    }

    public static boolean contains(SourceElement sourceElement, int n) {
        boolean bl = false;
        if (sourceElement != null && sourceElement.getStartOffset() <= n && n <= sourceElement.getEndOffset()) {
            bl = true;
        }
        return bl;
    }

    public static boolean contains(SourceElement sourceElement, SourceElement sourceElement2) {
        SourceFile sourceFile;
        SourceFile sourceFile2;
        boolean bl = false;
        if (sourceElement2 != null && (sourceFile2 = sourceElement.getOwningSourceFile()) != null && sourceFile2.equals(sourceFile = sourceElement2.getOwningSourceFile()) && Patch.contains(sourceElement, sourceElement2.getStartOffset())) {
            bl = true;
        }
        return bl;
    }

    public static JavaField getJavaField(JavaType javaType, String string) {
        Collection collection = javaType.getDeclaredFields();
        return (JavaField)Patch.getJavaNamedObject(collection, string);
    }

    private static JavaHasName getJavaNamedObject(Collection collection, String string) {
        for (JavaHasName javaHasName : collection) {
            if (!string.equals(javaHasName.getName())) continue;
            return javaHasName;
        }
        return null;
    }

    public static SourceClass getSourceClass(SourceFile sourceFile, String string) {
        return (SourceClass)Patch.getNamedObject(sourceFile.getSourceClasses(), string);
    }

    public static SourceHasName getNamedObject(Collection collection, String string) {
        for (SourceHasName sourceHasName : collection) {
            String string2 = sourceHasName.getName();
            if (!string.equals(string2)) continue;
            return sourceHasName;
        }
        return null;
    }

    public static String getMinimumReferenceName(SourceFile sourceFile, String string) {
        JavaProvider javaProvider = sourceFile.getProvider();
        JavaClass javaClass = javaProvider.getClass(string);
        if (javaClass != null && !javaClass.isPrimitive()) {
            String string2 = javaClass.getPackageName();
            if (!string2.equals(sourceFile.getPackageName())) {
                List list = sourceFile.getSourceImports();
                for (SourceImport sourceImport : list) {
                    String string3;
                    String string4;
                    if (sourceImport.isStatic() || !((string4 = sourceImport.getName()).endsWith(".*") ? string2.equals(string3 = string4.substring(0, string4.length() - 2)) : string.equals(string4))) continue;
                    return javaClass.getName();
                }
            } else {
                return javaClass.getName();
            }
        }
        return string;
    }

    public static String getText(SourceElement sourceElement) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        TextNode textNode = (TextNode)NodeFactory.find((URL)uRL);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        int n = sourceElement.getStartOffset();
        String string = textBuffer.getString(n, sourceElement.getEndOffset() - n);
        return string;
    }

    public static boolean isAssignment(int n) {
        switch (n) {
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 52: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public static String getShortName(JavaType javaType) {
        String string;
        if (!javaType.isArray()) {
            string = !javaType.isPrimitive() ? javaType.getName() : javaType.getQualifiedName();
        } else {
            JavaType javaType2 = javaType.getComponentType();
            string = Patch.getShortName(javaType2) + "[]";
        }
        return string;
    }

    public static String getTypeName(SourceTypeReference sourceTypeReference) {
        String string = sourceTypeReference.getName();
        int n = sourceTypeReference.getArrayDimension();
        int n2 = 0;
        while (n2 < n) {
            string = string + "[]";
            ++n2;
        }
        return string;
    }

    public static SourceClass getMainClass(SourceFile sourceFile) {
        List list = sourceFile.getSourceClasses();
        URL uRL = sourceFile.getURL();
        String string = URLFileSystem.getName((URL)uRL);
        for (SourceClass sourceClass : list) {
            String string2 = sourceClass.getName();
            if (!string.equals(string2)) continue;
            return sourceClass;
        }
        return null;
    }

    public static SourceClass[] getSubClasses(Context context, SourceClass sourceClass) {
        ArrayList arrayList = new ArrayList();
        SearchClassCriteria searchClassCriteria = new SearchClassCriteria(ClassDescription.createClassDescription((JavaClass)sourceClass), false, false);
        searchClassCriteria.setInclude(false, false, false, false, false, true);
        Project project = context.getProject();
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, searchClassCriteria);
        SearchResults searchResults = searchOperationImpl.search();
        UsageModel usageModel = searchResults.getUsageModel();
        ArrayList arrayList2 = usageModel.getUsageEntries();
        HashSet<URL> hashSet = new HashSet<URL>();
        int n = 0;
        while (n < arrayList2.size()) {
            UsageEntry usageEntry = (UsageEntry)arrayList2.get(n);
            TextNode textNode = usageEntry.getTextNode();
            URL uRL = textNode.getURL();
            hashSet.add(uRL);
            ++n;
        }
        JavaManager javaManager = JavaManager.getJavaManager(project);
        for (URL uRL : hashSet) {
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            1 var18_18 = new 1(sourceClass, arrayList);
            ((Visitor)var18_18).visit((SourceElement)sourceFile);
        }
        return arrayList.toArray(new SourceClass[arrayList.size()]);
    }

    public static SourceElement getOwningBlockStatement(SourceVariable sourceVariable) {
        SourceBlock sourceBlock = null;
        switch (sourceVariable.getSymbolKind()) {
            case 13: {
                SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
                sourceBlock = sourceMethod.getBlock();
                break;
            }
            case 17: {
                SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceVariable;
                sourceBlock = sourceLocalVariable.getOwningBlock();
            }
        }
        return sourceBlock;
    }

    public static boolean isPrivate(SourceHasModifiers sourceHasModifiers) {
        return BitField.isSet((int)sourceHasModifiers.getModifiers(), (int)2);
    }

    public static int getArgumentPos(SourceInvokeExpression sourceInvokeExpression, SourceElement sourceElement) {
        int n = sourceInvokeExpression.getArgumentCount();
        int n2 = 0;
        while (n2 < n) {
            SourceExpression sourceExpression = sourceInvokeExpression.getArgumentAt(n2);
            if (Patch.contains((SourceElement)sourceExpression, sourceElement)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static SourceSuperclassClause getSuperclassClause(SourceClass sourceClass) {
        SourceSuperclassClause sourceSuperclassClause = sourceClass.getSuperclassClause();
        if (sourceSuperclassClause.getStartOffset() == -1 || sourceSuperclassClause.getEndOffset() == -1) {
            return null;
        }
        return sourceSuperclassClause;
    }

    public static SourceInterfacesClause getInterfacesClause(SourceClass sourceClass) {
        SourceInterfacesClause sourceInterfacesClause = sourceClass.getInterfacesClause();
        if (sourceInterfacesClause.getStartOffset() == -1 || sourceInterfacesClause.getEndOffset() == -1) {
            return null;
        }
        return sourceInterfacesClause;
    }

    public static void add(SourceElement sourceElement, SourceElement sourceElement2) {
        sourceElement.getChildren().add(sourceElement2);
    }

    public static SourceElement getElementAt(SourceElement sourceElement, int n) {
        if (Patch.contains(sourceElement, n)) {
            List list = sourceElement.getChildren();
            int n2 = 0;
            while (n2 < list.size()) {
                SourceElement sourceElement2 = (SourceElement)list.get(n2);
                SourceElement sourceElement3 = Patch.getElementAt(sourceElement2, n);
                if (sourceElement3 != null) {
                    return sourceElement3;
                }
                ++n2;
            }
            return sourceElement;
        }
        return null;
    }

    public static final class 1
    extends Visitor {
        private SourceClass _sourceClass;
        private final /* synthetic */ SourceClass v$sourceClass;
        private final /* synthetic */ ArrayList v$implementingClasses;

        public void visit(SourceElement sourceElement) {
            int n = sourceElement.getSymbolKind();
            if (n == 3) {
                SourceClass sourceClass = this._sourceClass;
                this._sourceClass = (SourceClass)sourceElement;
                this.visitChildren(sourceElement);
                this._sourceClass = sourceClass;
            } else {
                super.visit(sourceElement);
            }
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceTypeReference) {
            SourceElement sourceElement = sourceTypeReference.getParent();
            int n = sourceElement.getSymbolKind();
            if (n == 23 || n == 15) {
                this.whenEnterSupeType(sourceTypeReference);
            }
        }

        private void whenEnterSupeType(SourceTypeReference sourceTypeReference) {
            JavaType javaType = sourceTypeReference.getResolvedType();
            if (javaType != null && this.v$sourceClass.equals(javaType)) {
                this.v$implementingClasses.add(this._sourceClass);
            }
        }

        public 1(SourceClass sourceClass, ArrayList arrayList) {
            this.v$implementingClasses = arrayList;
            this.v$sourceClass = sourceClass;
        }
    }
}

