/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.model;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeProfile;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.SearchResultsPerHandler;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;
import oracle.jdevimpl.refactoring.model.BasicOperation;
import oracle.jdevimpl.refactoring.model.CachedKeywordHits;
import oracle.jdevimpl.refactoring.model.SearchProgress;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;
import oracle.jdevimpl.refactoring.util.ProfileConstants;

public class SearchOperationImpl
extends BasicOperation
implements UsageSource {
    private static final boolean DEBUG = false;
    private Project[] _projects;
    private CachedKeywordHits _cachedKeywordHits;
    private ArrayList _messages;
    private SearchResults _searchResults;
    private URL _hintFile;
    private String _hintPackage;
    private ArrayList _hintPackageUrls;
    private HashSet _hintPackageJavaRoots;
    private String _shortTitle;
    private String _longTitle;
    private boolean _userCancelled;

    public SearchOperationImpl(Context context, SearchCriteria searchCriteria) {
        super(context, searchCriteria);
    }

    public void addMessage(String string) {
        if (this._messages == null) {
            this._messages = new ArrayList(2);
        }
        this._messages.add(string);
    }

    public boolean canSearch() {
        boolean bl = false;
        SearchCriteria searchCriteria = this.getCriteria();
        if (searchCriteria != null && searchCriteria.isValid()) {
            bl = true;
        }
        return bl;
    }

    public boolean doSearch() {
        this._searchResults = this.search();
        return this._searchResults != null;
    }

    public SearchResults search() {
        long l = System.currentTimeMillis();
        this._cachedKeywordHits = new CachedKeywordHits();
        SearchProgress searchProgress = new SearchProgress(this);
        searchProgress.start();
        long l2 = System.currentTimeMillis();
        return this.getSearchResults();
    }

    public void doSearch(SearchProgress searchProgress) {
        RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
        RefactoringEvent refactoringEvent = new RefactoringEvent(1, this);
        refManagerImpl.fireRefEvent(refactoringEvent);
        Project[] projectArray = this.findAffectedProjects(searchProgress);
        if (this._messages == null) {
            this.setProjects(projectArray);
            this.searchResults(searchProgress);
        }
        this.showMessages();
    }

    public SearchResults getSearchResults() {
        return this._searchResults;
    }

    protected void setSearchResults(SearchResults searchResults) {
        this._searchResults = searchResults;
    }

    public UsageModel getUsageModel() {
        UsageModel usageModel = null;
        if (this._searchResults != null) {
            usageModel = this._searchResults.getUsageModel();
        }
        return usageModel;
    }

    private void showMessages() {
        if (this._messages != null && !this._messages.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this._messages.size()) {
                String string = (String)this._messages.get(n);
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n;
            }
            JTextArea jTextArea = new JTextArea(stringBuffer.toString(), 20, 80);
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(348), 1);
            jEWTDialog.setContent((Component)jScrollPane);
            jEWTDialog.runDialog();
        }
    }

    private Project[] findAffectedProjects(ProgressIndicator progressIndicator) {
        RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
        ArrayList<Project> arrayList = new ArrayList<Project>();
        Iterator iterator = refManagerImpl.getRegisteredUrlHandlers();
        while (iterator.hasNext()) {
            URLHandler uRLHandler = (URLHandler)iterator.next();
            Project[] projectArray = uRLHandler.getIncludedProjects(this, progressIndicator);
            if (projectArray == null) continue;
            int n = 0;
            while (n < projectArray.length) {
                Project project = projectArray[n];
                if (!arrayList.contains(project)) {
                    arrayList.add(project);
                }
                ++n;
            }
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    private void searchResults(SearchProgress searchProgress) {
        SearchResults searchResults = new SearchResults();
        RefManagerImpl refManagerImpl = RefManagerImpl.getImplInstance();
        Project[] projectArray = this.getProjects();
        HashSet hashSet = new HashSet();
        long l = System.currentTimeMillis();
        int n = -1;
        if (ProfileConstants.OK_SRCHLURL) {
            n = IdeProfile.startEvent((int)3903, (String)(" in " + projectArray.length + " project(s)"));
        }
        int n2 = 0;
        while (n2 < projectArray.length && !this.isUserCancelled()) {
            Project project = projectArray[n2];
            String string = project.getShortLabel();
            String string2 = MessageFormat.format(RefactoringArb.getString(349), string);
            searchProgress.setProgressText(string2);
            searchProgress.setProgressStepText(null);
            Iterator iterator = refManagerImpl.getRegisteredUrlHandlers();
            while (iterator.hasNext() && !this.isUserCancelled()) {
                URLHandler uRLHandler = (URLHandler)iterator.next();
                try {
                    int n3 = -1;
                    if (ProfileConstants.OK_SRCHSURL) {
                        n3 = IdeProfile.startEvent((int)3904, (String)(uRLHandler.getClass().getName() + " " + project.getShortLabel()));
                    }
                    HashSet hashSet2 = uRLHandler.chooseURLs(this, project, searchProgress);
                    if (ProfileConstants.OK_SRCHSURL) {
                        IdeProfile.endEvent((int)n3, (String)(" found " + (hashSet2 == null ? 0 : hashSet2.size()) + " url(s)"));
                    }
                    if (hashSet2 == null) continue;
                    if (!(uRLHandler instanceof TextURLHandler)) {
                        for (URL uRL : hashSet2) {
                            if (!hashSet.contains(uRL)) continue;
                            SearchResultsPerHandler[] searchResultsPerHandlerArray = searchResults.getResults();
                            int n4 = 0;
                            while (n4 < searchResultsPerHandlerArray.length) {
                                SearchResultsPerHandler searchResultsPerHandler = searchResultsPerHandlerArray[n4];
                                URL[] uRLArray = searchResultsPerHandler.getUrls();
                                int n5 = 0;
                                while (n5 < uRLArray.length) {
                                    URL uRL2 = uRLArray[n5];
                                    if (uRL.equals(uRL2)) {
                                        String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
                                        String string4 = searchResultsPerHandler.getHandler().getClass().getName();
                                        String string5 = uRLHandler.getClass().getName();
                                    }
                                    ++n5;
                                }
                                ++n4;
                            }
                        }
                    }
                    hashSet2.removeAll(hashSet);
                    if (hashSet2.isEmpty()) continue;
                    SearchResultsPerHandler searchResultsPerHandler = new SearchResultsPerHandler(uRLHandler, project, hashSet2.toArray(new URL[hashSet2.size()]));
                    searchResults.add(searchResultsPerHandler);
                    hashSet.addAll(hashSet2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        long l2 = System.currentTimeMillis();
        if (ProfileConstants.OK_SRCHLURL) {
            IdeProfile.endEvent((int)n, (String)(" found " + hashSet.size() + " url(s)"));
        }
        RefactoringEvent refactoringEvent = new RefactoringEvent(2, this, searchResults);
        refManagerImpl.fireRefEvent(refactoringEvent);
        SearchResultsPerHandler[] searchResultsPerHandlerArray = searchResults.getResults();
        if (ProfileConstants.OK_FNDUSGL) {
            n = IdeProfile.startEvent((int)3905, (String)(" in " + searchResultsPerHandlerArray.length + " result(s)"));
        }
        int n6 = 0;
        while (n6 < searchResultsPerHandlerArray.length && !this.isUserCancelled()) {
            SearchResultsPerHandler searchResultsPerHandler = searchResultsPerHandlerArray[n6];
            URLHandler uRLHandler = searchResultsPerHandler.getHandler();
            Project project = searchResultsPerHandler.getProject();
            URL[] uRLArray = searchResultsPerHandler.getUrls();
            int n7 = -1;
            if (ProfileConstants.OK_FNDUSGS) {
                n7 = IdeProfile.startEvent((int)3906, (String)(uRLHandler.getClass().getName() + " " + project.getShortLabel()));
            }
            UsageModel usageModel = uRLHandler.findUsages(this, project, uRLArray, searchProgress);
            if (ProfileConstants.OK_FNDUSGS) {
                IdeProfile.endEvent((int)n7);
            }
            if (usageModel == null) {
                usageModel = new UsageModel();
            } else {
                usageModel.sort();
            }
            searchResultsPerHandler.setUsageModel(usageModel);
            ++n6;
        }
        if (ProfileConstants.OK_FNDUSGL) {
            IdeProfile.endEvent((int)n);
        }
        long l3 = System.currentTimeMillis();
        RefactoringEvent refactoringEvent2 = new RefactoringEvent(3, this, searchResults);
        refManagerImpl.fireRefEvent(refactoringEvent2);
        this._searchResults = searchResults;
    }

    public final boolean doRefactoring() {
        boolean bl = false;
        if (!this.isUserCancelled() && this.prepareFiles(this._searchResults)) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            String string = this.getShortTitle();
            commandProcessor.beginTrans(string);
            try {
                this.applyResults();
                commandProcessor.endTrans();
                bl = true;
            }
            catch (AbortedOperationException abortedOperationException) {
                commandProcessor.abortTrans();
            }
            catch (Exception exception) {
                commandProcessor.abortTrans();
                exception.printStackTrace();
            }
        }
        return bl;
    }

    protected void applyResults() throws Exception {
        SearchResultsPerHandler[] searchResultsPerHandlerArray = this._searchResults.getResults();
        int n = 0;
        while (n < searchResultsPerHandlerArray.length) {
            Project project;
            UsageModel usageModel;
            SearchResultsPerHandler searchResultsPerHandler = searchResultsPerHandlerArray[n];
            URLRefactoringHandler uRLRefactoringHandler = (URLRefactoringHandler)searchResultsPerHandler.getHandler();
            if (!uRLRefactoringHandler.doChanges(this, usageModel = searchResultsPerHandler.getUsageModel(), project = searchResultsPerHandler.getProject())) {
                throw new AbortedOperationException();
            }
            ++n;
        }
    }

    private boolean prepareFiles(SearchResults searchResults) {
        HashSet<URL> hashSet = new HashSet<URL>();
        SearchResultsPerHandler[] searchResultsPerHandlerArray = searchResults.getResults();
        int n = 0;
        while (n < searchResultsPerHandlerArray.length) {
            SearchResultsPerHandler searchResultsPerHandler = searchResultsPerHandlerArray[n];
            URLRefactoringHandler uRLRefactoringHandler = (URLRefactoringHandler)searchResultsPerHandler.getHandler();
            UsageModel usageModel = searchResultsPerHandler.getUsageModel();
            Project project = searchResultsPerHandler.getProject();
            Node[] nodeArray = uRLRefactoringHandler.getAffectedNodes(this, usageModel, project);
            int n2 = 0;
            while (n2 < nodeArray.length) {
                Node node = nodeArray[n2];
                URL uRL = node.getURL();
                hashSet.add(uRL);
                ++n2;
            }
            ++n;
        }
        URL[] uRLArray = hashSet.toArray(new URL[hashSet.size()]);
        boolean bl = MakeWritableHelper.makeWritable(uRLArray);
        return bl;
    }

    public HashSet getKeywordHits(URLPath uRLPath, String[] stringArray, ProgressIndicator progressIndicator) {
        HashSet<URL> hashSet = new HashSet<URL>();
        URL[] uRLArray = uRLPath.getEntries();
        int n = -1;
        if (ProfileConstants.OK_KWLHITS) {
            StringBuffer stringBuffer = new StringBuffer("Search ");
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append(", ");
                ++n2;
            }
            stringBuffer.append(" in ");
            stringBuffer.append(uRLArray.length);
            stringBuffer.append(" entries(s) ");
            int n3 = 0;
            while (n3 < uRLArray.length) {
                stringBuffer.append(uRLArray[n3]);
                stringBuffer.append(", ");
                ++n3;
            }
            n = IdeProfile.startEvent((int)3901, (String)stringBuffer.toString());
        }
        int n4 = 0;
        while (n4 < uRLArray.length) {
            URL uRL = uRLArray[n4];
            URL uRL2 = null;
            if (this._hintFile != null) {
                if (URLFileSystem.isBaseURLFor((URL)uRL, (URL)this._hintFile)) {
                    uRL2 = null;
                    hashSet.add(this._hintFile);
                }
            } else if (this._hintPackageUrls != null) {
                if (this._hintPackageJavaRoots.contains(uRL)) {
                    int n5 = 0;
                    while (uRL2 == null && n5 < this._hintPackageUrls.size()) {
                        URL uRL3 = (URL)this._hintPackageUrls.get(n5);
                        if (URLFileSystem.isBaseURLFor((URL)uRL, (URL)uRL3)) {
                            uRL2 = uRL3;
                        }
                        ++n5;
                    }
                } else {
                    uRL2 = uRL;
                }
            } else {
                uRL2 = uRL;
            }
            if (uRL2 != null) {
                URL[] uRLArray2 = this._cachedKeywordHits.get(uRL2, stringArray, progressIndicator);
                int n6 = 0;
                while (n6 < uRLArray2.length) {
                    URL uRL4 = uRLArray2[n6];
                    if (this._hintPackageUrls == null) {
                        hashSet.add(uRL4);
                    } else {
                        URL uRL5 = URLFileSystem.getParent((URL)uRL4);
                        if (uRL2.equals(uRL5)) {
                            hashSet.add(uRL4);
                        }
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        if (ProfileConstants.OK_KWLHITS) {
            IdeProfile.endEvent((int)n, (String)(" found " + hashSet.size() + " url(s)"));
        }
        return hashSet;
    }

    public HashSet getKeywordHits(ContentSet contentSet, String[] stringArray, ProgressIndicator progressIndicator) {
        URLPath uRLPath = contentSet.getAllRootDirs();
        HashSet hashSet = this.getKeywordHits(uRLPath, stringArray, progressIndicator);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : hashSet) {
            if (contentSet.canHaveMember(uRL)) continue;
            arrayList.add(uRL);
        }
        hashSet.removeAll(arrayList);
        return hashSet;
    }

    private Project[] getProjects() {
        return this._projects;
    }

    private void setProjects(Project[] projectArray) {
        this._projects = projectArray;
        if (this._hintPackage != null) {
            this._hintPackageUrls = new ArrayList();
            this._hintPackageJavaRoots = new HashSet();
            String string = this._hintPackage.replace('.', '/');
            int n = 0;
            while (n < projectArray.length) {
                Project project = projectArray[n];
                URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getJavaRootDirs();
                URL[] uRLArray = uRLPath.getEntries();
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    URL uRL = uRLArray[n2];
                    this._hintPackageJavaRoots.add(uRL);
                    URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)string);
                    if (URLFileSystem.exists((URL)uRL2)) {
                        this._hintPackageUrls.add(uRL2);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public boolean runRefactoring(boolean bl) {
        boolean bl2 = false;
        if (this.doSearch()) {
            bl2 = bl ? PreviewLogPage.showUsages(this) : this.doRefactoring();
        }
        return bl2;
    }

    public String getShortTitle() {
        if (this._shortTitle == null) {
            this._shortTitle = this.getCriteria().getShortTitle();
        }
        return this._shortTitle;
    }

    public String getLongTitle() {
        if (this._longTitle == null) {
            this._longTitle = this.getCriteria().getLongTitle();
        }
        return this._longTitle;
    }

    public void clear() {
        super.clear();
        this._cachedKeywordHits = null;
        this._projects = null;
        this._hintPackageUrls = null;
        this._messages = null;
        if (this._searchResults != null) {
            UsageModel usageModel = this._searchResults.getUsageModel();
            usageModel.release();
            this._searchResults = null;
        }
    }

    public void setSearchHintFile(URL uRL) {
        this._hintFile = uRL;
    }

    public void setSearchHintPackage(String string) {
        this._hintPackage = string;
        this._hintPackageUrls = null;
        this._hintPackageJavaRoots = null;
    }

    public void setUserCancelled(boolean bl) {
        this._userCancelled = bl;
    }

    public boolean isUserCancelled() {
        return this._userCancelled;
    }

    public class 1MyRunnable
    implements Runnable {
        URL _failedFile;
        ProgressBar _progressBar;
        private final /* synthetic */ HashSet v$affectedDocuments;
        final /* synthetic */ SearchOperationImpl this$0;

        public void run() {
            Iterator iterator = this.v$affectedDocuments.iterator();
            while (this._failedFile == null && iterator.hasNext()) {
                Node node = (Node)iterator.next();
                URL uRL = node.getURL();
                if (!URLFileSystem.exists((URL)uRL)) continue;
                if (this._progressBar != null) {
                    String string = URLFileSystem.getPlatformPathName((URL)uRL);
                    this._progressBar.updateProgress(null, string);
                }
                if (URLFileSystem.setReadOnly((URL)uRL, (boolean)false) || Util.setReadOnly(uRL, false)) continue;
                this._failedFile = uRL;
            }
            if (this._progressBar != null) {
                this._progressBar.setDoneStatus();
            }
        }

        1MyRunnable(SearchOperationImpl searchOperationImpl, HashSet hashSet) {
            this.v$affectedDocuments = hashSet;
            this.this$0 = searchOperationImpl;
        }
    }
}

