/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.model;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.ProgressBar;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;

public class SearchProgress
implements ProgressIndicator,
Runnable {
    ProgressBar _progressBar;
    private SearchOperationImpl _searchOperation;
    private String _progressStep;
    private String _progressText;
    private ArrayList _listeners;
    private boolean _isUserCancelled;

    void $init$() {
        this._listeners = new ArrayList(1);
    }

    public SearchProgress(SearchOperationImpl searchOperationImpl) {
        this.$init$();
        this._searchOperation = searchOperationImpl;
    }

    public void start() {
        SearchCriteria searchCriteria = this._searchOperation.getCriteria();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        this._searchOperation.setUserCancelled(false);
        if (ideMainWindow != null) {
            this._progressText = searchCriteria.getShortTitle();
            this._progressBar = new ProgressBar((Component)ideMainWindow, this._progressText, (Runnable)this, true);
            this._progressBar.start(RefactoringArb.getString(41), " ");
            this._isUserCancelled = false;
            if (this._progressBar.hasUserCancelled()) {
                this._isUserCancelled = true;
                this._searchOperation.setUserCancelled(true);
                int n = 0;
                while (n < this._listeners.size()) {
                    ActionListener actionListener = (ActionListener)this._listeners.get(n);
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "canceled"));
                    ++n;
                }
            }
        } else {
            this.run();
        }
        this._searchOperation = null;
    }

    public void run() {
        try {
            this._searchOperation.doSearch(this);
        }
        finally {
            if (this._progressBar != null) {
                this._progressBar.setDoneStatus();
            }
        }
    }

    public ProgressBar getProgressBar() {
        return this._progressBar;
    }

    public void setProgressText(String string) {
        this._progressText = string;
        this.updateProgress();
    }

    public boolean isUserCancelled() {
        return this._isUserCancelled;
    }

    public void addActionListener(ActionListener actionListener) {
        this._listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listeners.remove(actionListener);
    }

    public void setProgressStepText(String string) {
        this._progressStep = string;
        this.updateProgress();
    }

    private void updateProgress() {
        if (this._progressBar != null) {
            this._progressBar.updateProgress(this._progressText, this._progressStep);
        }
    }
}

