/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.convertanotoinner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.ide.Context;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;

public class ConvertDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "CVT_ANO2INNER_PREF";
    private JTextField _classNameField;
    private JTable _parameters;
    private SourceVariable[] _sourceVariables;
    private JCheckBox _makeStatic;
    private DefaultTableModel _tableModel;
    private SourceClass _anonymousClass;

    public ConvertDialog(Context context, SourceClass sourceClass, SourceVariable[] sourceVariableArray, boolean bl) {
        super(PREFERENCE_KEY, context);
        this._sourceVariables = sourceVariableArray;
        this._anonymousClass = sourceClass;
        this.init(bl);
    }

    private void init(boolean bl) {
        JLabel jLabel = new JLabel();
        this._classNameField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._classNameField, (String)RefactoringArb.getString(109));
        this._classNameField.setText("My" + this._anonymousClass.getSuperclass().getName());
        this.updateOnChanges(this._classNameField);
        JLabel jLabel2 = new JLabel();
        this._tableModel = new DefaultTableModel(0, 2);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this._parameters = new JTable(this._tableModel, defaultTableColumnModel);
        TableColumn tableColumn = new TableColumn(0, 10, this._parameters.getDefaultRenderer(Boolean.class), this._parameters.getDefaultEditor(Boolean.class));
        tableColumn.setHeaderValue(" ");
        defaultTableColumnModel.addColumn(tableColumn);
        TableColumn tableColumn2 = new TableColumn(1, 500, this._parameters.getDefaultRenderer(String.class), this._parameters.getDefaultEditor(String.class));
        tableColumn2.setHeaderValue(RefactoringArb.getString(343));
        defaultTableColumnModel.addColumn(tableColumn2);
        int n = 0;
        while (n < this._sourceVariables.length) {
            SourceVariable sourceVariable = this._sourceVariables[n];
            String string = sourceVariable.getName();
            Object[] objectArray = new Object[]{Boolean.TRUE, string};
            this._tableModel.addRow(objectArray);
            ++n;
        }
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._parameters, (String)RefactoringArb.getString(344));
        this._makeStatic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._makeStatic, (String)RefactoringArb.getString(345));
        this._makeStatic.setSelected(bl);
        this._makeStatic.setEnabled(bl);
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(this._classNameField.getPreferredSize());
        this.setMessageLabel(jLabel3);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._classNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (this._sourceVariables.length > 0) {
            JScrollPane jScrollPane = new JScrollPane(this._parameters);
            jScrollPane.setPreferredSize(new Dimension(100, 100));
            jScrollPane.getViewport().setBackground(this._parameters.getBackground());
            this.add((Component)jLabel2, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        }
        this.add((Component)this._makeStatic, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._classNameField;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_danontoinner_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(346);
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getClassName();
            if (string2.length() == 0) {
                bl = false;
            } else if (!IdeUtil.isJavaIdentifier((String)string2)) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string2)) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (Character.isLowerCase(string2.charAt(0))) {
                string = RefactoringArb.getString(90);
            } else if (this.owningClassContains(string2)) {
                string = MessageFormat.format(RefactoringArb.getString(347), string2);
                bl = false;
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    public boolean runDialog() {
        boolean bl = super.runDialog();
        TableCellEditor tableCellEditor = this._parameters.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        return bl;
    }

    private boolean owningClassContains(String string) {
        JavaClass javaClass = this._anonymousClass.getOwningClass();
        Collection collection = javaClass.getDeclaredClasses();
        for (JavaClass javaClass2 : collection) {
            if (!string.equals(javaClass2.getName())) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this._classNameField.getText();
    }

    public String[] getVariableNames() {
        int n = this._tableModel.getRowCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            Boolean bl = (Boolean)this._tableModel.getValueAt(n2, 0);
            if (bl.booleanValue()) {
                Object object = this._tableModel.getValueAt(n2, 1);
                stringArray[n2] = (String)object;
            }
            ++n2;
        }
        return stringArray;
    }

    public boolean isMakeStaticSelected() {
        return this._makeStatic.isSelected();
    }
}

