/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.createenum;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class CreateEnumDlg
extends BaseDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "CREATE_ENUM_DEFAULTS";
    private static final int PREF_PREVIEW = 1;
    private JTextField _pkgField;
    private JTextField _clsField;
    private JButton _browsePkg;
    private CustomJTree _customJTree;
    private JMutableTreeNode _root;
    private JavaField _javaField;
    private JCheckBox _preview;

    public CreateEnumDlg(Context context, JavaField javaField) {
        super(PREFERENCE_KEY, context);
        this._javaField = javaField;
        this.init();
    }

    protected String getTitle() {
        return "Create Enumeration";
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = this._pkgField.getText();
            String string2 = this._clsField.getText();
            NameValidation nameValidation = NameValidation.validateClassName(this.getContext().getProject(), string, string2, true);
            String string3 = nameValidation.getMessage();
            boolean bl = nameValidation.isValid();
            if (bl && this.getSelectedFields().length == 0) {
                string3 = null;
                bl = false;
            }
            this.setMessage(string3, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this._preview.isSelected());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._clsField;
    }

    protected String getHelpTopicID() {
        return "f1_xxx";
    }

    private void init() {
        JLabel jLabel = new JLabel();
        this._pkgField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._pkgField, (String)RefactoringArb.getString(341));
        this.updateOnChanges(this._pkgField);
        ClassPickerFactory.attach(this._pkgField, this.getContext(), 0);
        this._browsePkg = new JButton("...");
        this._browsePkg.addActionListener(this);
        JLabel jLabel2 = new JLabel();
        this._clsField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._clsField, (String)RefactoringArb.getString(342));
        this.updateOnChanges(this._clsField);
        this._root = this.createRoot();
        this._customJTree = new CustomJTree(this._root);
        this._customJTree.setRootVisible(false);
        this._customJTree.setShowsRootHandles(false);
        this._customJTree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.updateOnTreeCellChecked(this._customJTree);
        JScrollPane jScrollPane = new JScrollPane((Component)this._customJTree);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(48));
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(new Dimension(400, this._pkgField.getPreferredSize().height));
        this.setMessageLabel(jLabel3);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._pkgField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browsePkg, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._clsField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        JavaClass javaClass = this._javaField.getOwningClass();
        String string = javaClass.getPackageName();
        this._pkgField.setText(string);
        this._preview.setSelected(this.getSettings().isBitSet(1));
    }

    private JMutableTreeNode createRoot() {
        JMutableTreeNode jMutableTreeNode = new JMutableTreeNode("root");
        JavaClass javaClass = this._javaField.getOwningClass();
        JavaType javaType = this._javaField.getResolvedType();
        Collection collection = javaClass.getDeclaredFields();
        Icon icon = JavaIcons.getIcon(2);
        for (JavaField javaField : collection) {
            JavaType javaType2;
            if (!javaField.isStatic() || !javaField.isFinal() || !javaType.equals((Object)(javaType2 = javaField.getResolvedType()))) continue;
            String string = javaField.getName();
            String string2 = javaType2.getName();
            String string3 = string + ":" + string2;
            JTreeCellData jTreeCellData = new JTreeCellData(icon, string3, true);
            jTreeCellData.setUserObject((Object)javaField);
            jTreeCellData.setCheckBoxState(this._javaField.equals(javaField));
            JMutableTreeNode jMutableTreeNode2 = new JMutableTreeNode(jTreeCellData);
            jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode2);
        }
        return jMutableTreeNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.whenBrowsePackage();
    }

    private void whenBrowsePackage() {
        String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.getContext().getProject(), 2, false, null, this._pkgField.getText());
        if (stringArray != null && stringArray.length == 1) {
            this._pkgField.setText(stringArray[0]);
        }
    }

    public String getFqEnumName() {
        String string = this._pkgField.getText();
        String string2 = this._clsField.getText();
        return Util.getFqClassName(string, string2);
    }

    public JavaField[] getSelectedFields() {
        ArrayList<JavaField> arrayList = new ArrayList<JavaField>();
        int n = this._root.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._root.getChildAt(n2);
            JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
            TriStateBoolean triStateBoolean = jTreeCellData.getCheckBoxState();
            if (triStateBoolean.isTrue()) {
                JavaField javaField = (JavaField)jTreeCellData.getUserObject();
                arrayList.add(javaField);
            }
            ++n2;
        }
        return arrayList.toArray(new JavaField[arrayList.size()]);
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }
}

