/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.createenum;

import java.util.ArrayList;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class CreateEnumOperation
implements UsageSource {
    private Context _context;
    private String _fqEnumName;
    private JavaField[] _javaFields;
    private UsageModel _usageModel;
    private static final int USAGE_TYPE_DEF = 0;
    private static final int USAGE_TYPE_REF = 1;

    public CreateEnumOperation(Context context, String string, JavaField[] javaFieldArray) {
        this._context = context;
        this._fqEnumName = string;
        this._javaFields = javaFieldArray;
    }

    public Context getContext() {
        return this._context;
    }

    public String getShortTitle() {
        return "Create Enumeration";
    }

    public String getLongTitle() {
        return "Create Enumeration";
    }

    public boolean canSearch() {
        return true;
    }

    public boolean doSearch() {
        this._usageModel = new UsageModel();
        Project project = this.getContext().getProject();
        int n = 0;
        while (n < this._javaFields.length) {
            JavaField javaField = this._javaFields[n];
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
            UsageEntry usageEntry = new UsageEntry(project, (SourceElement)sourceFieldVariable, 0, 2);
            usageEntry.setUserObject(sourceFieldVariable);
            this._usageModel.addUsageEntry(usageEntry);
            ++n;
        }
        HashSet hashSet = Util.getDependentProjects(this._context.getWorkspace(), this._context.getProject());
        for (Project project2 : hashSet) {
            this.searchFieldsUsages(project2, this._usageModel);
        }
        ArrayList arrayList = this._usageModel.getUsageEntries();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            UsageEntry usageEntry = (UsageEntry)arrayList.get(n2);
            SourceElement sourceElement = (SourceElement)usageEntry.getUserObject();
            SourceFile sourceFile = sourceElement.getOwningSourceFile();
            System.out.println("Usage in " + sourceFile.hashCode());
            ++n2;
        }
        return true;
    }

    private void searchFieldsUsages(Project project, UsageModel usageModel) {
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember[])this._javaFields);
        ArrayList arrayList = new ArrayList();
        FindMemberUsages.FillListsUsageListener fillListsUsageListener = new FindMemberUsages.FillListsUsageListener(null, null, arrayList);
        findMemberUsages.findMemberUsages(project, fillListsUsageListener);
        int n = 0;
        while (n < arrayList.size()) {
            SourceExpression sourceExpression = (SourceExpression)arrayList.get(n);
            UsageEntry usageEntry = new UsageEntry(project, (SourceElement)sourceExpression, 1, 2);
            usageEntry.setUserObject(sourceExpression);
            usageModel.addUsageEntry(usageEntry);
            ++n;
        }
    }

    public UsageModel getUsageModel() {
        return this._usageModel;
    }

    public boolean doRefactoring() {
        UsageModel usageModel = this.getUsageModel();
        ArrayList arrayList = usageModel.getUsageEntries();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            int n = 0;
            while (n < arrayList.size()) {
                UsageEntry usageEntry = (UsageEntry)arrayList.get(n);
                if (usageEntry.isIncluded()) {
                    SourceElement sourceElement = (SourceElement)usageEntry.getUserObject();
                    SourceFile sourceFile = sourceElement.getOwningSourceFile();
                    refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                    SourceFactory sourceFactory = sourceFile.getFactory();
                    block1 : switch (usageEntry.getUsageType()) {
                        case 0: {
                            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                            sourceFieldVariable.removeSelf();
                            break;
                        }
                        case 1: {
                            SourceExpression sourceExpression = (SourceExpression)sourceElement;
                            switch (sourceExpression.getSymbolKind()) {
                                case 58: {
                                    SourceExpression sourceExpression2 = sourceFactory.createExpression(this._fqEnumName + "." + sourceExpression.getText());
                                    sourceExpression.replaceSelf((SourceElement)sourceExpression2);
                                    break block1;
                                }
                                case 50: {
                                    SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceExpression;
                                    String string = sourceDotExpression.getName();
                                    SourceExpression sourceExpression3 = sourceFactory.createExpression(this._fqEnumName + "." + string);
                                    sourceDotExpression.replaceSelf((SourceElement)sourceExpression3);
                                }
                            }
                        }
                    }
                }
                ++n;
            }
            refactoringCommandSupport.commit(this.getContext(), "Create Enumeration");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return true;
    }
}

