/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.duplicate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;

public class DuplicateClassDialog
extends BaseDialog {
    public static final String PREFERENCE_KEY = "DUPLICATE_CLASS_DEFAULTS";
    private JTextField _textField;
    private String _oldName;
    private SourceClass _sourceClass;

    public DuplicateClassDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context);
        this._sourceClass = sourceClass;
        this.init();
        this._oldName = this._sourceClass.getQualifiedName();
        this.setOldName(this._oldName);
    }

    public boolean runDialog() {
        SourceFile sourceFile;
        URL uRL;
        URL uRL2;
        URL uRL3;
        String string;
        boolean bl = super.runDialog();
        if (bl && (string = URLFileSystem.getPlatformPathName((URL)(uRL3 = URLFactory.newURL((URL)(uRL2 = URLFileSystem.getParent((URL)(uRL = (sourceFile = this._sourceClass.getOwningSourceFile()).getURL()))), (String)(this.getNewName() + ".java"))))).length() > 255) {
            Util.showRefactoringErrorMessage(39);
            bl = false;
        }
        return bl;
    }

    private void init() {
        JLabel jLabel = new JLabel();
        this._textField = new JTextField(30);
        this.updateOnChanges(this._textField);
        int n = this._sourceClass.isInterface() ? 110 : 109;
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._textField, (String)RefactoringArb.getString(n));
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(this._textField.getPreferredSize());
        this.setMessageLabel(jLabel2);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._textField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
    }

    public String getNewName() {
        return this._textField.getText();
    }

    private void setOldName(String string) {
        this._textField.setText(string);
        this._textField.setCaretPosition(0);
        this._textField.setSelectionEnd(string.length());
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._textField;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dduplicatetype_html";
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getTitle() {
        String string = this._sourceClass.getName();
        int n = this._sourceClass.isInterface() ? 108 : 107;
        String string2 = MessageFormat.format(RefactoringArb.getString(n), string);
        return string2;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getNewName();
            if (string2.length() == 0) {
                bl = false;
            } else if (this._oldName.equals(string2)) {
                bl = false;
            } else if (string2.endsWith(".")) {
                bl = false;
            } else if (!IdeUtil.isPackageIdentifier((String)string2)) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (string2.lastIndexOf(36) >= 0) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (this.isClassAlreadyPresent(string2)) {
                string = MessageFormat.format(RefactoringArb.getString(36), string2);
                bl = false;
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    private boolean isClassAlreadyPresent(String string) {
        SourceFile sourceFile = this._sourceClass.getOwningSourceFile();
        JavaProvider javaProvider = sourceFile.getProvider();
        SourceClass sourceClass = javaProvider.getSourceClass(string);
        return sourceClass != null;
    }
}

