/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulateFieldDialog;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulateOperation;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;

public class EncapsulateController
implements Controller {
    public static final int REPLACE_CLASS_FLAG = 1;
    public static final int REPLACE_SUB_CLASSES_FLAG = 2;
    public static final int REPLACE_OTHER_CLASSES_FLAG = 4;

    public boolean update(IdeAction ideAction, Context context) {
        SourceClass sourceClass;
        boolean bl = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (sourceClass = ElementAt.getSourceClassAt(context, false, true)) != null && !sourceClass.isAnnotation()) {
            bl = true;
        }
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, true);
        if (sourceClass != null) {
            SourceFieldVariable sourceFieldVariable = null;
            SourceMethod sourceMethod = null;
            ElementAt elementAt = ElementAt.findElementAt(context);
            if (elementAt != null) {
                int n = elementAt.getElementType();
                switch (n) {
                    case 4: {
                        JavaField javaField = (JavaField)elementAt.getJavaElement();
                        sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                        break;
                    }
                    case 3: {
                        JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                        sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    }
                }
            }
            ArrayList<EncapsulatedField> arrayList = new ArrayList<EncapsulatedField>();
            Collection collection = sourceClass.getDeclaredFields();
            for (JavaField javaField : collection) {
                SourceFieldVariable sourceFieldVariable2 = (SourceFieldVariable)javaField.getSourceElement();
                if (sourceFieldVariable2 == null || sourceFieldVariable2.getName() == null) continue;
                SourceTypeReference sourceTypeReference = sourceFieldVariable2.getSourceType();
                JavaType javaType = javaField.getResolvedType();
                if (javaType == null) continue;
                String string = javaField.getName();
                JavaMethod javaMethod = null;
                if ("boolean".equals(sourceTypeReference.getName()) && (javaMethod = EncapsulateController.getGetter(sourceClass, "is", string, javaType)) == null) {
                    javaMethod = EncapsulateController.getGetter(sourceClass, "has", string, javaType);
                }
                if (javaMethod == null) {
                    javaMethod = EncapsulateController.getGetter(sourceClass, "get", string, javaType);
                }
                JavaMethod javaMethod2 = EncapsulateController.getSetter(sourceClass, string, javaType);
                EncapsulatedField encapsulatedField = new EncapsulatedField(sourceFieldVariable2);
                if (sourceFieldVariable2.equals(sourceFieldVariable)) {
                    encapsulatedField.setIncluded(true);
                }
                if (javaMethod != null) {
                    encapsulatedField.setGetterMethod(javaMethod);
                    if (javaMethod.equals((Object)sourceMethod)) {
                        encapsulatedField.setIncluded(true);
                    }
                }
                if (javaMethod2 != null) {
                    encapsulatedField.setSetterMethod(javaMethod2);
                    if (javaMethod2.equals((Object)sourceMethod)) {
                        encapsulatedField.setIncluded(true);
                    }
                }
                arrayList.add(encapsulatedField);
            }
            if (arrayList.isEmpty()) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(339));
            } else {
                EncapsulatedField[] encapsulatedFieldArray = arrayList.toArray(new EncapsulatedField[arrayList.size()]);
                EncapsulateFieldDialog encapsulateFieldDialog = new EncapsulateFieldDialog(context, encapsulatedFieldArray);
                if (encapsulateFieldDialog.runDialog()) {
                    EncapsulateOperation encapsulateOperation = new EncapsulateOperation(context, encapsulatedFieldArray);
                    encapsulateOperation.setMethodAccessibility(encapsulateFieldDialog.getMethodAccessibility());
                    encapsulateOperation.setFieldAcceessibility(encapsulateFieldDialog.getFieldAccessibility());
                    encapsulateOperation.setReplaceType(encapsulateFieldDialog.getReplaceType());
                    encapsulateOperation.setAddTasks(encapsulateFieldDialog.isAddTasksChecked());
                    encapsulateOperation.doSearch();
                    if (encapsulateFieldDialog.hasPreview()) {
                        PreviewLogPage.showUsages(encapsulateOperation);
                    } else {
                        encapsulateOperation.doRefactoring();
                    }
                }
            }
        }
        return true;
    }

    private static JavaMethod getGetter(SourceClass sourceClass, String string, String string2, JavaType javaType) {
        JavaType javaType2;
        JavaMethod javaMethod = null;
        String string3 = EncapsulateController.getBaseName(string2);
        String string4 = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
        String string5 = string + string4;
        JavaMethod javaMethod2 = sourceClass.getMethod(string5, new JavaType[0]);
        if (javaMethod2 != null && javaType.equals((Object)(javaType2 = javaMethod2.getReturnType()))) {
            javaMethod = javaMethod2;
        }
        return javaMethod;
    }

    private static JavaMethod getSetter(SourceClass sourceClass, String string, JavaType javaType) {
        String string2 = EncapsulateController.getBaseName(string);
        String string3 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
        String string4 = "set" + string3;
        JavaMethod javaMethod = sourceClass.getMethod(string4, new JavaType[]{javaType});
        return javaMethod;
    }

    private static String getBaseName(String string) {
        String string2 = RefManagerImpl.getDefaultFieldPrefix();
        if (string.startsWith(string2)) {
            int n = string2.length();
            string = string.substring(n);
        }
        return string;
    }
}

