/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;
import oracle.jdevimpl.refactoring.oprs.encapsulate.FieldsTableModel;
import oracle.jdevimpl.refactoring.util.RadioKeyController;

public class EncapsulateFieldDialog
extends BaseDialog
implements VetoableChangeListener {
    private static final String PREFERENCE_KEY = "ENCAP_DEFAULTS";
    protected static final int PREF_TASKS = 1;
    protected static final int PREF_PREVIEW = 2;
    private final EncapsulatedField[] _fields;
    private JTable _table;
    private JRadioButton _methodPublic;
    private JRadioButton _methodProtected;
    private JRadioButton _methodPrivate;
    private JRadioButton _fieldUnchanged;
    private JRadioButton _fieldProtected;
    private JRadioButton _fieldPrivate;
    private JRadioButton _replaceAll;
    private JRadioButton _replaceExceptClass;
    private JCheckBox _preview;
    private JCheckBox _addTasks;

    public EncapsulateFieldDialog(Context context, EncapsulatedField[] encapsulatedFieldArray) {
        super(PREFERENCE_KEY, context);
        this._fields = encapsulatedFieldArray;
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(328);
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._table;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    public void setDlg(JEWTDialog jEWTDialog) {
        super.setDlg(jEWTDialog);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.isAddTasksChecked());
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dencapsulatefields_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = null;
            boolean bl = true;
            if (!this.hasFieldSelected()) {
                bl = false;
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    private boolean hasFieldSelected() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this._fields.length) {
            EncapsulatedField encapsulatedField = this._fields[n];
            if (encapsulatedField.isIncluded()) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    protected void init() {
        JLabel jLabel = new JLabel();
        FieldsTableModel fieldsTableModel = new FieldsTableModel(this);
        this._table = new NiceTable((TableModel)fieldsTableModel);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._table, (String)RefactoringArb.getString(329));
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(25);
        this._table.setAutoResizeMode(0);
        this.setInitialSelection();
        this.updateOnChanges(this._table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(330)));
        ButtonGroup buttonGroup = new ButtonGroup();
        this._methodPublic = EncapsulateFieldDialog.createRadioButton(jPanel, buttonGroup, "&Public");
        this._methodProtected = EncapsulateFieldDialog.createRadioButton(jPanel, buttonGroup, "P&rotected");
        EncapsulateFieldDialog.createRadioButton(jPanel, buttonGroup, "Pac&kage Private");
        this._methodPrivate = EncapsulateFieldDialog.createRadioButton(jPanel, buttonGroup, "Pr&ivate");
        RadioKeyController.attach(buttonGroup);
        this._methodPublic.setSelected(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(331)));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this._fieldUnchanged = EncapsulateFieldDialog.createRadioButton(jPanel2, buttonGroup2, RefactoringArb.getString(332));
        this._fieldProtected = EncapsulateFieldDialog.createRadioButton(jPanel2, buttonGroup2, "Pr&otected");
        EncapsulateFieldDialog.createRadioButton(jPanel2, buttonGroup2, "Pa&ckage Private");
        this._fieldPrivate = EncapsulateFieldDialog.createRadioButton(jPanel2, buttonGroup2, "Priva&te");
        RadioKeyController.attach(buttonGroup2);
        this._fieldPrivate.setSelected(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(333)));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this._replaceAll = EncapsulateFieldDialog.createRadioButton(jPanel3, buttonGroup3, RefactoringArb.getString(334));
        EncapsulateFieldDialog.createRadioButton(jPanel3, buttonGroup3, RefactoringArb.getString(335));
        this._replaceExceptClass = EncapsulateFieldDialog.createRadioButton(jPanel3, buttonGroup3, RefactoringArb.getString(336));
        RadioKeyController.attach(buttonGroup3);
        this._replaceAll.setSelected(true);
        this._addTasks = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._addTasks, (String)RefactoringArb.getString(337));
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(48));
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(jLabel.getPreferredSize());
        this.setMessageLabel(jLabel2);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)new JScrollPane(this._table), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._addTasks, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        CopyableInteger copyableInteger = this.getSettings();
        this._addTasks.setSelected(copyableInteger.isBitSet(1));
        this._preview.setSelected(copyableInteger.isBitSet(2));
    }

    private void setInitialSelection() {
        if (this._fields.length > 0) {
            int n = 0;
            int n2 = 0;
            while (n2 < this._fields.length) {
                EncapsulatedField encapsulatedField = this._fields[n2];
                if (encapsulatedField.isIncluded()) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this._table.changeSelection(n, 0, false, false);
        }
    }

    private static JRadioButton createRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string) {
        JRadioButton jRadioButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)string);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        return jRadioButton;
    }

    EncapsulatedField[] getFields() {
        return this._fields;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            TableCellEditor tableCellEditor = this._table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            int n = 0;
            while (n < this._fields.length) {
                String string;
                String string2;
                EncapsulatedField encapsulatedField = this._fields[n];
                if (encapsulatedField.isNeedsNewGetter() && !IdeUtil.isJavaIdentifier((String)(string2 = encapsulatedField.getNewGetterName()))) {
                    this._table.changeSelection(n, 2, false, false);
                    String string3 = MessageFormat.format(RefactoringArb.getString(338), string2);
                    JOptionPane.showMessageDialog(this, string3);
                    throw new PropertyVetoException("", propertyChangeEvent);
                }
                if (encapsulatedField.isNeedsNewSetter() && !IdeUtil.isJavaIdentifier((String)(string = encapsulatedField.getNewSetterName()))) {
                    this._table.changeSelection(n, 3, false, false);
                    String string4 = MessageFormat.format(RefactoringArb.getString(338), string);
                    JOptionPane.showMessageDialog(this, string4);
                    throw new PropertyVetoException("", propertyChangeEvent);
                }
                ++n;
            }
        }
    }

    public int getMethodAccessibility() {
        return this._methodPublic.isSelected() ? 1 : (this._methodProtected.isSelected() ? 4 : (this._methodPrivate.isSelected() ? 2 : 0));
    }

    public int getFieldAccessibility() {
        return this._fieldUnchanged.isSelected() ? 1 : (this._fieldProtected.isSelected() ? 4 : (this._fieldPrivate.isSelected() ? 2 : 0));
    }

    public int getReplaceType() {
        if (this._replaceAll.isSelected()) {
            return 7;
        }
        if (this._replaceExceptClass.isSelected()) {
            return 6;
        }
        return 4;
    }

    public boolean isAddTasksChecked() {
        return this._addTasks.isSelected();
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }
}

