/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;
import oracle.jdevimpl.refactoring.util.JavaLexerUtil;
import oracle.jdevimpl.refactoring.util.Visitor;

class EncapsulateOperation
implements UsageSource {
    private Context _context;
    private EncapsulatedField[] _encapsulatedFields;
    private int _methodAccessibility;
    private int _fieldAccessibility;
    private SourceClass _sourceClass;
    private int _replaceType;
    private boolean _addTasksChecked;
    private UsageModel _usageModel;
    private static final int USAGE_TYPE_LHS = 0;
    private static final int USAGE_TYPE_RHS = 1;
    private static final int USAGE_TYPE_FIELD_ACCESS_TYPE = 2;

    public EncapsulateOperation(Context context, EncapsulatedField[] encapsulatedFieldArray) {
        this._context = context;
        this._encapsulatedFields = encapsulatedFieldArray;
        SourceFieldVariable sourceFieldVariable = this._encapsulatedFields[0].getSourceFieldVariable();
        this._sourceClass = sourceFieldVariable.getEnclosingClass();
    }

    public boolean canSearch() {
        return true;
    }

    public boolean doSearch() {
        this._usageModel = new UsageModel();
        URL uRL = this._sourceClass.getURL();
        Project project = Util.getDefiningProject(this._context, uRL);
        this.searchFieldModifiers(project);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = Util.getDependentProjects(this._context.getWorkspace(), this._context.getProject());
        for (Project project2 : hashSet2) {
            this.searchAccesses(project, project2, hashSet);
        }
        return !this._usageModel.getUsageEntries().isEmpty();
    }

    public boolean doRefactoring() {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        boolean bl = false;
        try {
            ArrayList arrayList = this._usageModel.getUsageEntries();
            int n = 0;
            while (n < arrayList.size()) {
                UsageEntry usageEntry = (UsageEntry)arrayList.get(n);
                if (usageEntry.isIncluded()) {
                    Object object = usageEntry.getUserObject();
                    int n2 = usageEntry.getUsageType();
                    switch (n2) {
                        case 0: 
                        case 1: {
                            FieldAccess fieldAccess = (FieldAccess)object;
                            SourceExpression sourceExpression = fieldAccess.getSourceExpression();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceExpression);
                            this.apply(fieldAccess);
                            break;
                        }
                        case 2: {
                            EncapsulatedField encapsulatedField = (EncapsulatedField)object;
                            SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFieldVariable);
                            sourceFieldVariable.removeModifiers(7);
                            sourceFieldVariable.addModifiers(this._fieldAccessibility);
                        }
                    }
                }
                ++n;
            }
            this.addMethods(refactoringCommandSupport);
            Context context = this.getContext();
            String string = this.getShortTitle();
            bl = refactoringCommandSupport.commit(context, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    public Context getContext() {
        return this._context;
    }

    public String getLongTitle() {
        return RefactoringArb.getString(328);
    }

    public String getShortTitle() {
        return this.getLongTitle();
    }

    public UsageModel getUsageModel() {
        return this._usageModel;
    }

    private void searchAccesses(Project project, Project project2, HashSet hashSet) {
        HashSet<String> hashSet2 = new HashSet<String>();
        ArrayList<SourceFieldVariable> arrayList = new ArrayList<SourceFieldVariable>();
        int n = 0;
        while (n < this._encapsulatedFields.length) {
            EncapsulatedField encapsulatedField = this._encapsulatedFields[n];
            if (encapsulatedField.isIncluded()) {
                SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                arrayList.add(sourceFieldVariable);
                String string = sourceFieldVariable.getName();
                hashSet2.add(string);
            }
            ++n;
        }
        JavaMember[] javaMemberArray = arrayList.toArray(new JavaMember[arrayList.size()]);
        URL uRL = this._sourceClass.getURL();
        if (project2.equals((Object)project) && !hashSet.contains(uRL)) {
            this.getFieldAccesses(project2, hashSet2, this._sourceClass.getOwningSourceFile(), this._usageModel);
            hashSet.add(uRL);
        }
        if (this._addTasksChecked || BitField.isSet((int)this._replaceType, (int)4) || BitField.isSet((int)this._replaceType, (int)2)) {
            FindMemberUsages findMemberUsages = new FindMemberUsages(javaMemberArray);
            URL[] uRLArray = findMemberUsages.findMemberUsages(project2);
            int n2 = 0;
            while (n2 < uRLArray.length) {
                URL uRL2 = uRLArray[n2];
                if (!hashSet.contains(uRL2)) {
                    JavaManager javaManager = JavaManager.getJavaManager(project2);
                    SourceFile sourceFile = javaManager.getSourceFile(uRL2);
                    this.getFieldAccesses(project2, hashSet2, sourceFile, this._usageModel);
                    hashSet.add(uRL2);
                }
                ++n2;
            }
        }
    }

    private void getFieldAccesses(Project project, HashSet hashSet, SourceFile sourceFile, UsageModel usageModel) {
        1 var5_5 = new 1(this, project, usageModel, hashSet);
        ((Visitor)var5_5).visit((SourceElement)sourceFile);
    }

    private static boolean isAccessible(int n, SourceClass sourceClass, SourceClass sourceClass2) {
        boolean bl = true;
        switch (n) {
            case 1: {
                break;
            }
            case 4: {
                if (sourceClass.isAssignableFrom((JavaType)sourceClass2)) break;
                bl = false;
                break;
            }
            case 2: {
                if (Patch.contains((SourceElement)sourceClass, (SourceElement)sourceClass2)) break;
                bl = false;
                break;
            }
            default: {
                if (sourceClass.getPackageName().equals(sourceClass2.getPackageName())) break;
                bl = false;
            }
        }
        return bl;
    }

    private void apply(FieldAccess fieldAccess) {
        SourceExpression sourceExpression;
        SourceExpression sourceExpression2 = fieldAccess.getSourceExpression();
        EncapsulatedField encapsulatedField = fieldAccess.getEncapsulatedField();
        SourceFile sourceFile = sourceExpression2.getOwningSourceFile();
        SourceFactory sourceFactory = sourceFile.getFactory();
        if (sourceExpression2.getSymbolKind() == 50) {
            SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceExpression2;
            sourceExpression = sourceDotExpression.getLhsOperand();
            sourceExpression.removeSelf();
        } else {
            sourceExpression = null;
        }
        switch (fieldAccess.getType()) {
            case 2: {
                String string = encapsulatedField.getNewSetterName();
                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpression2.getParent();
                SourceExpression sourceExpression3 = sourceAssignmentExpression.getSecondOperand();
                sourceExpression3.removeSelf();
                SourceExpression[] sourceExpressionArray = new SourceExpression[]{sourceExpression3};
                SourceListExpression sourceListExpression = sourceFactory.createArgumentList(sourceExpressionArray);
                SourceMethodCallExpression sourceMethodCallExpression = sourceFactory.createMethodCall(sourceExpression, string, sourceListExpression);
                sourceAssignmentExpression.replaceSelf((SourceElement)sourceMethodCallExpression);
                break;
            }
            case 1: {
                SourceMethodCallExpression sourceMethodCallExpression = sourceFactory.createMethodCall(sourceExpression, encapsulatedField.getNewGetterName(), null);
                sourceExpression2.replaceSelf((SourceElement)sourceMethodCallExpression);
            }
        }
        if (this._addTasksChecked) {
            switch (fieldAccess.getType()) {
                case 1: 
                case 2: {
                    SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceExpression2);
                    if (EncapsulateOperation.isAccessible(this._methodAccessibility, this._sourceClass, sourceClass)) break;
                    this.createTodoItem(sourceExpression2);
                    break;
                }
                case 4: {
                    this.createTodoItem(sourceExpression2);
                }
            }
        }
    }

    private void createTodoItem(SourceExpression sourceExpression) {
    }

    private void searchFieldModifiers(Project project) {
        if (this._fieldAccessibility != 1) {
            int n = 0;
            while (n < this._encapsulatedFields.length) {
                SourceVariableDeclaration sourceVariableDeclaration;
                LexerToken lexerToken;
                SourceFieldVariable sourceFieldVariable;
                int n2;
                EncapsulatedField encapsulatedField = this._encapsulatedFields[n];
                if (encapsulatedField.isIncluded() && (n2 = (sourceFieldVariable = encapsulatedField.getSourceFieldVariable()).getModifiers() & 7) != this._fieldAccessibility && n2 != 0 && (lexerToken = JavaLexerUtil.findKeywordPosition((SourceElement)(sourceVariableDeclaration = sourceFieldVariable.getOwningDeclaration()), new short[]{128, 127, 126})) != null) {
                    SourceFile sourceFile = sourceVariableDeclaration.getOwningSourceFile();
                    URL uRL = sourceFile.getURL();
                    int n3 = lexerToken.getStartOffset();
                    int n4 = lexerToken.getEndOffset();
                    UsageEntry usageEntry = new UsageEntry(project, uRL, n3, n4 - n3, 2, 2);
                    usageEntry.setUserObject(encapsulatedField);
                    this._usageModel.addUsageEntry(usageEntry);
                }
                ++n;
            }
        }
    }

    private void addMethods(RefactoringCommandSupport refactoringCommandSupport) {
        SourceFile sourceFile = this._sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceClassBody sourceClassBody = this._sourceClass.getSourceBody();
        int n = 0;
        while (n < this._encapsulatedFields.length) {
            EncapsulatedField encapsulatedField = this._encapsulatedFields[n];
            String string = encapsulatedField.getBaseFieldName();
            if (encapsulatedField.isIncluded()) {
                SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                String string2 = sourceFieldVariable.getName();
                SourceTypeReference sourceTypeReference = sourceFieldVariable.getSourceType();
                if (encapsulatedField.isNeedsNewGetter()) {
                    SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string2);
                    SourceReturnStatement sourceReturnStatement = sourceFactory.createReturnStatement((SourceExpression)sourceSimpleNameExpression);
                    SourceBlock sourceBlock = sourceFactory.createBlock(new SourceElement[]{sourceReturnStatement});
                    SourceTypeReference sourceTypeReference2 = (SourceTypeReference)sourceTypeReference.cloneSelf(sourceFile);
                    SourceMethod sourceMethod = sourceFactory.createMethod(sourceTypeReference2, encapsulatedField.getNewGetterName(), sourceFactory.createFormalParameterList(), null, sourceBlock);
                    sourceMethod.addModifiers(this._methodAccessibility);
                    if (sourceFieldVariable.isStatic()) {
                        sourceMethod.addModifiers(8);
                    }
                    sourceMethod.addSelf((SourceElement)sourceClassBody);
                }
                if (encapsulatedField.isNeedsNewSetter()) {
                    String string3 = string;
                    if (IdeUtil.isJavaKeyword((String)string)) {
                        string3 = string3.substring(0, 1);
                    }
                    String string4 = string2.equals(string) ? (sourceFieldVariable.isStatic() ? this._sourceClass.getName() + "." + string2 : "this." + string2) : string2;
                    SourceTypeReference sourceTypeReference3 = sourceFactory.createType((byte)9);
                    SourceExpression sourceExpression = sourceFactory.createExpression(string4);
                    SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string3);
                    SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, sourceExpression, (SourceExpression)sourceSimpleNameExpression);
                    SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement((SourceExpression)sourceAssignmentExpression);
                    SourceBlock sourceBlock = sourceFactory.createBlock(new SourceElement[]{sourceExpressionStatement});
                    SourceFormalParameterList sourceFormalParameterList = sourceFactory.createFormalParameterList();
                    SourceTypeReference sourceTypeReference4 = (SourceTypeReference)sourceTypeReference.cloneSelf(sourceFile);
                    SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(sourceTypeReference4, string3);
                    sourceLocalVariable.addSelf((SourceElement)sourceFormalParameterList);
                    SourceMethod sourceMethod = sourceFactory.createMethod(sourceTypeReference3, encapsulatedField.getNewSetterName(), sourceFormalParameterList, null, sourceBlock);
                    sourceMethod.setModifiers(this._methodAccessibility);
                    if (sourceFieldVariable.isStatic()) {
                        sourceMethod.addModifiers(8);
                    }
                    sourceMethod.addSelf((SourceElement)sourceClassBody);
                }
            }
            ++n;
        }
    }

    public void setMethodAccessibility(int n) {
        this._methodAccessibility = n;
    }

    public void setFieldAcceessibility(int n) {
        this._fieldAccessibility = n;
    }

    public void setReplaceType(int n) {
        this._replaceType = n;
    }

    public void setAddTasks(boolean bl) {
        this._addTasksChecked = bl;
    }

    static EncapsulatedField[] ra$_encapsulatedFields(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._encapsulatedFields;
    }

    static boolean ra$_addTasksChecked(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._addTasksChecked;
    }

    static int ra$_fieldAccessibility(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._fieldAccessibility;
    }

    static SourceClass ra$_sourceClass(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._sourceClass;
    }

    static boolean maS$isAccessible(int n, SourceClass sourceClass, SourceClass sourceClass2) {
        return EncapsulateOperation.isAccessible(n, sourceClass, sourceClass2);
    }

    static int ra$_replaceType(EncapsulateOperation encapsulateOperation) {
        return encapsulateOperation._replaceType;
    }

    final class 1
    extends Visitor {
        private boolean _replaceUsages;
        private SourceClass _currentClass;
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ UsageModel v$usageModel;
        private final /* synthetic */ HashSet v$fieldNames;
        final /* synthetic */ EncapsulateOperation this$0;

        public void visit(SourceElement sourceElement) {
            int n = sourceElement.getSymbolKind();
            switch (n) {
                case 3: {
                    SourceClass sourceClass = (SourceClass)sourceElement;
                    boolean bl = BitField.isSet((int)EncapsulateOperation.ra$_replaceType(this.this$0), (int)4);
                    if (bl && !BitField.isSet((int)EncapsulateOperation.ra$_replaceType(this.this$0), (int)1) && EncapsulateOperation.ra$_sourceClass(this.this$0).equals(sourceElement)) {
                        bl = false;
                    }
                    if (bl && !BitField.isSet((int)EncapsulateOperation.ra$_replaceType(this.this$0), (int)2) && EncapsulateOperation.ra$_sourceClass(this.this$0).isAssignableFrom((JavaType)sourceClass)) {
                        bl = false;
                    }
                    if (!bl && !EncapsulateOperation.ra$_addTasksChecked(this.this$0)) break;
                    boolean bl2 = this._replaceUsages;
                    this._replaceUsages = bl;
                    SourceClass sourceClass2 = this._currentClass;
                    this._currentClass = sourceClass;
                    this.visitChildren(sourceElement);
                    this._replaceUsages = bl2;
                    this._currentClass = sourceClass2;
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    boolean bl = true;
                    int n2 = 0;
                    while (bl && n2 < EncapsulateOperation.ra$_encapsulatedFields(this.this$0).length) {
                        EncapsulatedField encapsulatedField = EncapsulateOperation.ra$_encapsulatedFields(this.this$0)[n2];
                        if (this.isSameMethod(encapsulatedField.getGetterMethod(), sourceMethod)) {
                            bl = false;
                        } else if (this.isSameMethod(encapsulatedField.getSetterMethod(), sourceMethod)) {
                            bl = false;
                        }
                        ++n2;
                    }
                    if (!bl) break;
                    this.visitChildren((SourceElement)sourceMethod);
                    break;
                }
                case 49: {
                    String string;
                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement;
                    Object var12_12 = null;
                    SourceExpression sourceExpression = sourceAssignmentExpression.getFirstOperand();
                    if (sourceExpression != null && (string = sourceExpression.getText()) != null) {
                        int n3 = 0;
                        while (var12_12 == null && n3 < EncapsulateOperation.ra$_encapsulatedFields(this.this$0).length) {
                            JavaHasType javaHasType;
                            SourceFieldVariable sourceFieldVariable;
                            String string2;
                            EncapsulatedField encapsulatedField = EncapsulateOperation.ra$_encapsulatedFields(this.this$0)[n3];
                            if (encapsulatedField.isIncluded() && string.endsWith(string2 = (sourceFieldVariable = encapsulatedField.getSourceFieldVariable()).getName()) && sourceFieldVariable.equals(javaHasType = sourceExpression.getResolvedObject())) {
                                UsageEntry usageEntry = new UsageEntry(this.v$project, (SourceElement)sourceExpression, 0, 2);
                                int n4 = -1;
                                if (this._replaceUsages) {
                                    n4 = 2;
                                } else if (EncapsulateOperation.ra$_addTasksChecked(this.this$0) && !EncapsulateOperation.maS$isAccessible(EncapsulateOperation.ra$_fieldAccessibility(this.this$0), EncapsulateOperation.ra$_sourceClass(this.this$0), this._currentClass)) {
                                    n4 = 4;
                                }
                                if (n4 != -1) {
                                    FieldAccess fieldAccess = new FieldAccess(encapsulatedField, sourceExpression, n4);
                                    usageEntry.setUserObject(fieldAccess);
                                    this.v$usageModel.addUsageEntry(usageEntry);
                                }
                            }
                            ++n3;
                        }
                    }
                    this.visit((SourceElement)sourceAssignmentExpression.getSecondOperand());
                    break;
                }
                default: {
                    super.visit(sourceElement);
                }
            }
        }

        private boolean isSameMethod(JavaMethod javaMethod, SourceMethod sourceMethod) {
            SourceElement sourceElement;
            String string;
            return javaMethod != null && (string = javaMethod.getName()).equals(sourceMethod.getName()) && javaMethod.equals((Object)(sourceElement = javaMethod.getSourceElement()));
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            this.checkFieldRead((SourceExpression)sourceSimpleNameExpression);
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            this.checkFieldRead((SourceExpression)sourceDotExpression);
        }

        private void checkFieldRead(SourceExpression sourceExpression) {
            JavaHasType javaHasType;
            String string = ((SourceHasName)sourceExpression).getName();
            if (this.v$fieldNames.contains(string) && (javaHasType = sourceExpression.getResolvedObject()) != null) {
                int n = 0;
                while (n < EncapsulateOperation.ra$_encapsulatedFields(this.this$0).length) {
                    EncapsulatedField encapsulatedField = EncapsulateOperation.ra$_encapsulatedFields(this.this$0)[n];
                    if (encapsulatedField.isIncluded() && encapsulatedField.getSourceFieldVariable().equals(javaHasType)) {
                        int n2 = -1;
                        if (this._replaceUsages) {
                            n2 = 1;
                        } else if (EncapsulateOperation.ra$_addTasksChecked(this.this$0) && !EncapsulateOperation.maS$isAccessible(EncapsulateOperation.ra$_fieldAccessibility(this.this$0), EncapsulateOperation.ra$_sourceClass(this.this$0), this._currentClass)) {
                            n2 = 4;
                        }
                        if (n2 != -1) {
                            FieldAccess fieldAccess = new FieldAccess(encapsulatedField, sourceExpression, n2);
                            UsageEntry usageEntry = new UsageEntry(this.v$project, (SourceElement)sourceExpression, 1, 2);
                            usageEntry.setUserObject(fieldAccess);
                            this.v$usageModel.addUsageEntry(usageEntry);
                        }
                    }
                    ++n;
                }
            }
        }

        public 1(EncapsulateOperation encapsulateOperation, Project project, UsageModel usageModel, HashSet hashSet) {
            this.v$fieldNames = hashSet;
            this.v$usageModel = usageModel;
            this.v$project = project;
            this.this$0 = encapsulateOperation;
        }
    }

    private static class FieldAccess {
        public static final int TYPE_GETTER = 1;
        public static final int TYPE_SETTER = 2;
        public static final int TYPE_ILL_ACCESS = 4;
        private EncapsulatedField _encapsulatedField;
        private SourceExpression _sourceExpression;
        private int _type;

        public FieldAccess(EncapsulatedField encapsulatedField, SourceExpression sourceExpression, int n) {
            this._encapsulatedField = encapsulatedField;
            this._type = n;
            this._sourceExpression = sourceExpression;
        }

        public EncapsulatedField getEncapsulatedField() {
            return this._encapsulatedField;
        }

        public int getType() {
            return this._type;
        }

        public SourceExpression getSourceExpression() {
            return this._sourceExpression;
        }
    }
}

