/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.refactoring.RefManagerImpl;

public class EncapsulatedField {
    private SourceFieldVariable _sourceFieldVariable;
    private boolean _included;
    private String _newGetterName;
    private boolean _encapsulateClassGetters;
    private JavaMethod _getterMethod;
    private String _newSetterName;
    private boolean _encapsulateClassSetters;
    private JavaMethod _setterMethod;

    void $init$() {
        this._encapsulateClassGetters = true;
        this._encapsulateClassSetters = true;
    }

    public EncapsulatedField(SourceFieldVariable sourceFieldVariable) {
        this.$init$();
        this._sourceFieldVariable = sourceFieldVariable;
    }

    public boolean isIncluded() {
        return this._included;
    }

    public void setIncluded(boolean bl) {
        this._included = bl;
    }

    public boolean isEncapsulateClassGetters() {
        return this._encapsulateClassGetters;
    }

    public void setEncapsulateClassGetters(boolean bl) {
        this._encapsulateClassGetters = bl;
    }

    public boolean isEncapsulateClassSetters() {
        return this._encapsulateClassSetters;
    }

    public void setEncapsulateClassSetters(boolean bl) {
        this._encapsulateClassSetters = bl;
    }

    public JavaMethod getGetterMethod() {
        return this._getterMethod;
    }

    public void setGetterMethod(JavaMethod javaMethod) {
        this._getterMethod = javaMethod;
    }

    public boolean isNeedsNewGetter() {
        boolean bl = false;
        if (this.isIncluded()) {
            JavaMethod javaMethod = this.getGetterMethod();
            if (javaMethod == null) {
                bl = true;
            } else {
                String string;
                String string2 = this.getNewGetterName();
                if (ModelUtil.hasLength((String)string2) && !(string = javaMethod.getName()).equals(string2)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public String getNewGetterName() {
        if (this._newGetterName == null) {
            this._newGetterName = this.getDefaultGetterName();
        }
        return this._newGetterName;
    }

    public void setNewGetterName(String string) {
        this._newGetterName = string;
    }

    public boolean isNeedsNewSetter() {
        boolean bl = false;
        if (this.isIncluded()) {
            JavaMethod javaMethod = this.getSetterMethod();
            if (javaMethod == null) {
                if (!this._sourceFieldVariable.isFinal()) {
                    bl = true;
                }
            } else {
                String string;
                String string2 = this.getNewSetterName();
                if (ModelUtil.hasLength((String)string2) && !(string = javaMethod.getName()).equals(string2)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public String getNewSetterName() {
        if (this._newSetterName == null) {
            this._newSetterName = this.getDefaultSetterName();
        }
        return this._newSetterName;
    }

    public void setNewSetterName(String string) {
        this._newSetterName = string;
    }

    public JavaMethod getSetterMethod() {
        return this._setterMethod;
    }

    public void setSetterMethod(JavaMethod javaMethod) {
        this._setterMethod = javaMethod;
    }

    public SourceFieldVariable getSourceFieldVariable() {
        return this._sourceFieldVariable;
    }

    public void setSourceFieldVariable(SourceFieldVariable sourceFieldVariable) {
        this._sourceFieldVariable = sourceFieldVariable;
    }

    private String getDefaultGetterName() {
        String string = this.getBaseFieldName();
        String string2 = this._sourceFieldVariable.getSourceType().getName();
        String string3 = "boolean".equals(string2) ? (EncapsulatedField.isPrefixed(string, "has") ? "" : "is") : "get";
        return string3 + EncapsulatedField.upperifyFirstLetter(string);
    }

    private String getDefaultSetterName() {
        String string = this.getBaseFieldName();
        return "set" + EncapsulatedField.upperifyFirstLetter(string);
    }

    private static String upperifyFirstLetter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    String getBaseFieldName() {
        SourceTypeReference sourceTypeReference;
        String string;
        String string2;
        String string3 = this._sourceFieldVariable.getName();
        if (string3.startsWith(string2 = RefManagerImpl.getDefaultFieldPrefix())) {
            string3 = string3.substring(string2.length());
        }
        if ((string = (sourceTypeReference = this._sourceFieldVariable.getSourceType()).getName()) != null && "boolean".equals(string) && EncapsulatedField.isPrefixed(string3, "is")) {
            string3 = Character.toLowerCase(string3.charAt(2)) + string3.substring(3);
        }
        return string3;
    }

    private static boolean isPrefixed(String string, String string2) {
        char c;
        boolean bl = false;
        if (string.startsWith(string2) && string.length() > string2.length() && Character.isUpperCase(c = string.charAt(string2.length())) && Character.isJavaIdentifierPart(c)) {
            bl = true;
        }
        return bl;
    }
}

