/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.encapsulate;

import javax.swing.table.AbstractTableModel;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulateFieldDialog;
import oracle.jdevimpl.refactoring.oprs.encapsulate.EncapsulatedField;

class FieldsTableModel
extends AbstractTableModel {
    public static final int COL_INCLUDE = 0;
    public static final int COL_FIELD = 1;
    public static final int COL_GETTER = 2;
    public static final int COL_SETTER = 3;
    private EncapsulateFieldDialog _encapsulateFieldDialog;

    public FieldsTableModel(EncapsulateFieldDialog encapsulateFieldDialog) {
        this._encapsulateFieldDialog = encapsulateFieldDialog;
    }

    public int getRowCount() {
        return this._encapsulateFieldDialog.getFields().length;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return " ";
            }
            case 1: {
                return RefactoringArb.getString(325);
            }
            case 2: {
                return RefactoringArb.getString(326);
            }
            case 3: {
                return RefactoringArb.getString(327);
            }
        }
        return null;
    }

    public Object getValueAt(int n, int n2) {
        EncapsulatedField encapsulatedField = this._encapsulateFieldDialog.getFields()[n];
        switch (n2) {
            case 0: {
                return encapsulatedField.isIncluded();
            }
            case 1: {
                return encapsulatedField.getSourceFieldVariable().getName();
            }
            case 2: {
                return encapsulatedField.getNewGetterName();
            }
            case 3: {
                SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                if (sourceFieldVariable.isFinal()) {
                    return "";
                }
                return encapsulatedField.getNewSetterName();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        EncapsulatedField encapsulatedField = this._encapsulateFieldDialog.getFields()[n];
        switch (n2) {
            case 0: {
                encapsulatedField.setIncluded(Boolean.TRUE.equals(object));
                this.fireTableCellUpdated(n, 0);
                break;
            }
            case 2: {
                encapsulatedField.setNewGetterName(object.toString());
                encapsulatedField.setIncluded(true);
                this.fireTableCellUpdated(n, 2);
                break;
            }
            case 3: {
                encapsulatedField.setNewSetterName(object.toString());
                encapsulatedField.setIncluded(true);
                this.fireTableCellUpdated(n, 3);
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                EncapsulatedField[] encapsulatedFieldArray = this._encapsulateFieldDialog.getFields();
                EncapsulatedField encapsulatedField = encapsulatedFieldArray[n];
                SourceFieldVariable sourceFieldVariable = encapsulatedField.getSourceFieldVariable();
                if (sourceFieldVariable.isFinal()) break;
                return true;
            }
        }
        return false;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }
}

