/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractMethod;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.extractMethod.ParametersModel;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class ExtractMethodDialog
extends BaseDialog
implements TableModelListener,
ListSelectionListener,
ActionListener {
    private static final String PREFERENCE_KEY = "EXTRACT_METHOD_PREFS";
    private ParametersModel _parametersModel;
    private JButton _moveUp;
    private JButton _moveDown;
    private JTable _table;
    private JCheckBox _staticCheckbox;
    private JTextField _nameField;

    public ExtractMethodDialog(Context context) {
        super(PREFERENCE_KEY, context);
        this.init();
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        this.setPreferredSize(new Dimension(420, 240));
        JLabel jLabel = new JLabel();
        this._nameField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._nameField, (String)RefactoringArb.getString(135));
        this.updateOnChanges(this._nameField);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._parametersModel = new ParametersModel();
        this._parametersModel.addTableModelListener(this);
        this._table = new NiceTable((TableModel)this._parametersModel);
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this._moveUp = new JButton();
        ResourceUtils.resButton((AbstractButton)this._moveUp, (String)RefactoringArb.getString(136));
        this._moveUp.addActionListener(this);
        this._moveDown = new JButton();
        ResourceUtils.resButton((AbstractButton)this._moveDown, (String)RefactoringArb.getString(137));
        this._moveDown.addActionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 18, 1, insets, 0, 0));
        jPanel.add((Component)this._moveUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 15, 2, insets, 0, 0));
        jPanel.add((Component)this._moveDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 11, 2, insets, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(138)));
        this._staticCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._staticCheckbox, (String)RefactoringArb.getString(139));
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(this._staticCheckbox.getPreferredSize());
        this.setMessageLabel(jLabel2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._staticCheckbox, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.updateMoveButtons();
    }

    protected String getTitle() {
        return RefactoringArb.getString(134);
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    private JavaHasType[] getArgumentTypes() {
        return this._parametersModel.getArgumentTypes();
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            NameValidation nameValidation = NameValidation.validateMethodName(this.getName(), true);
            String string = nameValidation.getMessage();
            boolean bl = nameValidation.isValid();
            if (bl) {
                if (NameValidation.isMethodAlreadyPresent(this._parametersModel.getSourceClass(), this.getName(), this.getArgumentTypes())) {
                    bl = false;
                    string = RefactoringArb.format(140, this.getName());
                }
                if (bl && (string = this._parametersModel.checkIdentifierNames()).length() != 0) {
                    bl = false;
                }
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameField;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dextractmethod_html";
    }

    public ParametersModel getModel() {
        return this._parametersModel;
    }

    public String getName() {
        return this._nameField.getText();
    }

    public void setStatic(boolean bl, boolean bl2) {
        this._staticCheckbox.setEnabled(bl);
        this._staticCheckbox.setSelected(bl2);
    }

    public boolean isStatic() {
        return this._staticCheckbox.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._moveUp) {
            this.whenMoveUp();
        } else if (object == this._moveDown) {
            this.whenMoveDown();
        }
    }

    private void whenMoveUp() {
        int n = this._table.getSelectedRow();
        this._parametersModel.moveUp(n);
        this._table.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        this.updateOKButton();
    }

    private void whenMoveDown() {
        int n = this._table.getSelectedRow();
        this._parametersModel.moveDown(n);
        this._table.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        this.updateOKButton();
    }

    private void updateMoveButtons() {
        int n = this._table.getSelectedRow();
        int n2 = this._parametersModel.getRowCount();
        this._moveUp.setEnabled(n > 0);
        this._moveDown.setEnabled(n < n2 - 1);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.updateOKButton();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateMoveButtons();
    }
}

