/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractinterface;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.ExtractInterfaceCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceDialog;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeController;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class ExtractInterfaceController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = this.handle(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        this.handle(context, true);
        return true;
    }

    public static boolean canExtract(Context context, SourceClass sourceClass) {
        return ExtractInterfaceController.handle(context, sourceClass, false);
    }

    private boolean handle(Context context, boolean bl) {
        boolean bl2 = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            bl2 = ExtractInterfaceController.handle(context, sourceClass, bl);
        }
        return bl2;
    }

    private static boolean handle(Context context, SourceClass sourceClass, boolean bl) {
        SourceFile sourceFile;
        URL uRL;
        boolean bl2 = false;
        if (sourceClass != null && !sourceClass.isAnnotation() && Util.canRefactor(context, uRL = (sourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            bl2 = true;
            if (bl) {
                if (!sourceClass.isAnonymous()) {
                    if (ExtractInterfaceController.hasMembers(sourceClass)) {
                        ExtractInterfaceController.whenExtract(context, sourceClass);
                    } else {
                        Util.showRefactoringErrorMessage(RefactoringArb.getString(80), RefactoringArb.getString(323));
                    }
                } else {
                    Util.showRefactoringErrorMessage(RefactoringArb.getString(80), RefactoringArb.getString(324));
                }
            }
        }
        return bl2;
    }

    public static void whenExtract(Context context, SourceClass sourceClass) {
        boolean bl;
        ExtractInterfaceDialog extractInterfaceDialog = new ExtractInterfaceDialog(context, sourceClass);
        do {
            String string;
            Project project;
            JavaManager javaManager;
            SourceClass sourceClass2;
            boolean bl2;
            bl = false;
            if (!extractInterfaceDialog.runDialog()) continue;
            String string2 = extractInterfaceDialog.getTypeName();
            String string3 = extractInterfaceDialog.getPackage();
            JavaType[] javaTypeArray = extractInterfaceDialog.getSelectedInterfaces();
            SourceMethod[] sourceMethodArray = extractInterfaceDialog.getSelectedMethods();
            SourceFieldVariable[] sourceFieldVariableArray = extractInterfaceDialog.getSelectedFields();
            boolean bl3 = false;
            try {
                bl3 = ExtractInterfaceController.extractInterface(context, sourceClass, string3, string2, javaTypeArray, sourceMethodArray, sourceFieldVariableArray);
            }
            catch (AbortedOperationException abortedOperationException) {
                bl = true;
            }
            if (!bl3 || !(bl2 = extractInterfaceDialog.hasReplaceUsages()) || (sourceClass2 = (javaManager = JavaManager.getJavaManager(project = context.getProject())).getSourceClass(string = Util.getFqClassName(string3, string2))) == null) continue;
            boolean bl4 = extractInterfaceDialog.hasPreview();
            UseSupertypeController.whenUseSupertype(context, sourceClass, sourceClass2, bl4);
        } while (bl);
    }

    public static boolean extractInterface(Context context, SourceClass sourceClass, String string, String string2, JavaType[] javaTypeArray, SourceMethod[] sourceMethodArray, SourceFieldVariable[] sourceFieldVariableArray) {
        boolean bl = false;
        ClassDescription classDescription = ClassDescription.createClassDescription((JavaClass)sourceClass);
        ExtractInterfaceCriteria extractInterfaceCriteria = new ExtractInterfaceCriteria(classDescription, string, string2, javaTypeArray, sourceMethodArray, sourceFieldVariableArray);
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, extractInterfaceCriteria);
        if (searchOperationImpl.runRefactoring(false)) {
            bl = true;
        }
        return bl;
    }

    private static boolean hasMembers(SourceClass sourceClass) {
        List list = sourceClass.getSourceMethods();
        for (SourceMethod sourceMethod : list) {
            if (!ExtractInterfaceController.isExtractableMethod(sourceMethod)) continue;
            return true;
        }
        Collection collection = sourceClass.getDeclaredFields();
        for (JavaField javaField : collection) {
            SourceFieldVariable sourceFieldVariable;
            SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)javaField.getSourceElement();
            if (sourceMemberVariable.isEnumConstant() || !ExtractInterfaceController.isExtractableField(sourceFieldVariable = (SourceFieldVariable)sourceMemberVariable)) continue;
            return true;
        }
        return false;
    }

    static boolean isExtractableMethod(SourceMethod sourceMethod) {
        return sourceMethod.isPublic() && !sourceMethod.isStatic();
    }

    static boolean isExtractableField(SourceFieldVariable sourceFieldVariable) {
        return sourceFieldVariable.isPublic() && sourceFieldVariable.isStatic() && sourceFieldVariable.isFinal() && sourceFieldVariable.getInitializer() != null;
    }
}

