/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractinterface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceController;

public class ExtractInterfaceDialog
extends BaseDialog
implements TreeCellCheckedListener,
ActionListener {
    public static final String SETTINGS_KEY = "PREF_EXTRACT_INTERFACE";
    private static final int PREF_REPLACE_USAGES = 1;
    private static final int PREF_PREVIEW = 2;
    private JMutableTreeNode _root;
    private JCheckBox _previewCheckbox;
    private JCheckBox _replaceUsagesCheckbox;
    private final SourceClass _sourceClass;
    private JTextField _extractToPkg;
    private JTextField _extractToItfc;
    private CustomJTree _customJTree;
    private HashSet _declaredClasses;

    public ExtractInterfaceDialog(Context context, SourceClass sourceClass) {
        super(SETTINGS_KEY, context);
        this._sourceClass = sourceClass;
        this._declaredClasses = new HashSet();
        SourceClassBody sourceClassBody = sourceClass.getSourceBody();
        List list = SourceElementAsList.asList((SourceElement)sourceClassBody);
        int n = 0;
        while (n < list.size()) {
            SourceClass sourceClass2;
            SourceElement sourceElement = (SourceElement)list.get(n);
            if (sourceElement.getSymbolKind() == 3 && !(sourceClass2 = (SourceClass)sourceElement).isStatic() && !sourceClass2.isAnonymous()) {
                this._declaredClasses.add(sourceClass2);
            }
            ++n;
        }
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(80);
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dextractinterface_html";
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.hasReplaceUsages());
        copyableInteger.setBit(2, this.hasPreview());
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    private void init() {
        CopyableInteger copyableInteger = this.getSettings();
        JLabel jLabel = new JLabel();
        String string = this._sourceClass.getPackageName();
        this._extractToPkg = new JTextField(string);
        this.updateOnChanges(this._extractToPkg);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._extractToPkg, (String)RefactoringArb.getString(81));
        ClassPickerFactory.attach(this._extractToPkg, this.getContext(), 26);
        JLabel jLabel2 = new JLabel();
        this._extractToItfc = new JTextField();
        this.updateOnChanges(this._extractToItfc);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._extractToItfc, (String)RefactoringArb.getString(82));
        this._root = this.createRoot();
        JLabel jLabel3 = new JLabel();
        this._customJTree = new CustomJTree(this._root);
        this._customJTree.setRootVisible(false);
        this._customJTree.setShowsRootHandles(false);
        this._customJTree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this._customJTree.enableToolTips(true);
        this._customJTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this.updateOnTreeCellChecked(this._customJTree);
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._customJTree, (String)RefactoringArb.getString(83));
        JScrollPane jScrollPane = new JScrollPane((Component)this._customJTree);
        this._replaceUsagesCheckbox = new JCheckBox();
        this._replaceUsagesCheckbox.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._replaceUsagesCheckbox, (String)RefactoringArb.getString(84));
        this._replaceUsagesCheckbox.setSelected(copyableInteger.isBitSet(1));
        this._previewCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._previewCheckbox, (String)RefactoringArb.getString(85));
        this._previewCheckbox.setSelected(copyableInteger.isBitSet(2));
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(jLabel2.getPreferredSize());
        this.setMessageLabel(jLabel4);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._extractToPkg, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._extractToItfc, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 1, insets, 0, 0));
        this.add((Component)this._replaceUsagesCheckbox, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._previewCheckbox, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, 10, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        this.setPreferredSize(new Dimension(300, 350));
        this.whenReplaceUsagesChanges();
    }

    private JMutableTreeNode createRoot() {
        JMutableTreeNode jMutableTreeNode = new JMutableTreeNode("root");
        Icon icon = JavaIcons.getIcon(1);
        Icon icon2 = JavaIcons.getIcon(3);
        Icon icon3 = JavaIcons.getIcon(2);
        List list = this._sourceClass.getSourceInterfaces();
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        for (SourceTypeReference sourceTypeReference : list) {
            JavaType javaType = sourceTypeReference.getResolvedType();
            if (javaType == null) continue;
            arrayList.add(javaType);
        }
        Collections.sort(arrayList, new 3());
        for (JavaType javaType : arrayList) {
            String string = javaType.getName();
            MyCellData myCellData = new MyCellData(javaType, icon, string, true);
            myCellData.setCheckBoxState(false);
            JMutableTreeNode jMutableTreeNode2 = new JMutableTreeNode((JTreeCellData)myCellData);
            jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode2);
        }
        ArrayList arrayList2 = new ArrayList(this._sourceClass.getSourceMethods());
        Collections.sort(arrayList2, new 2());
        for (SourceMethod sourceMethod : arrayList2) {
            if (!ExtractInterfaceController.isExtractableMethod(sourceMethod)) continue;
            String string = Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false);
            MyCellData myCellData = new MyCellData(sourceMethod, icon2, string, true);
            myCellData.setCheckBoxState(false);
            JMutableTreeNode jMutableTreeNode3 = new JMutableTreeNode((JTreeCellData)myCellData);
            jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode3);
        }
        Collection collection = this._sourceClass.getDeclaredFields();
        ArrayList arrayList3 = new ArrayList(collection);
        Collections.sort(arrayList3, new 1());
        for (SourceFieldVariable sourceFieldVariable : arrayList3) {
            if (!ExtractInterfaceController.isExtractableField(sourceFieldVariable)) continue;
            String string = sourceFieldVariable.getName();
            MyCellData myCellData = new MyCellData(sourceFieldVariable, icon3, string, true);
            myCellData.setCheckBoxState(false);
            JMutableTreeNode jMutableTreeNode4 = new JMutableTreeNode((JTreeCellData)myCellData);
            jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode4);
        }
        return jMutableTreeNode;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = null;
            boolean bl = true;
            String string2 = this.getTypeName();
            String string3 = this.getPackage();
            String string4 = this.getFQInterfaceName();
            if (string2.length() == 0) {
                bl = false;
            } else if (string2.endsWith(".")) {
                bl = false;
            } else if (string3.endsWith(".")) {
                bl = false;
            } else if (string3.length() == 0) {
                string = RefactoringArb.getString(86);
                bl = false;
            } else if (!IdeUtil.isPackageIdentifier((String)string3)) {
                string = RefactoringArb.getString(86);
                bl = false;
            } else if (!IdeUtil.isJavaIdentifier((String)string2)) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (string2.lastIndexOf(36) >= 0) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string2)) {
                string = RefactoringArb.getString(103);
                bl = false;
            } else if (this.isClassAlreadyPresent(string4)) {
                string = MessageFormat.format(RefactoringArb.getString(88), string2);
                bl = false;
            } else {
                SourceFieldVariable[] sourceFieldVariableArray = this.getSelectedFields();
                int n = 0;
                while (string == null && n < sourceFieldVariableArray.length) {
                    SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n];
                    SourceTypeReference sourceTypeReference = sourceFieldVariable.getSourceType();
                    List list = SourceElementAsList.asList((SourceElement)sourceTypeReference);
                    String string5 = this.searchReference(list);
                    if (string5 == null) {
                        SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
                        List list2 = SourceElementAsList.asList((SourceElement)sourceExpression);
                        string5 = this.searchReference(list2);
                    }
                    if (string5 != null) {
                        string = MessageFormat.format(RefactoringArb.getString(321), sourceFieldVariable.getName(), string5);
                    }
                    ++n;
                }
                SourceMethod[] sourceMethodArray = this.getSelectedMethods();
                int n2 = 0;
                while (string == null && n2 < sourceMethodArray.length) {
                    String string6;
                    SourceMethod sourceMethod = sourceMethodArray[n2];
                    List list = SourceElementAsList.asList((SourceElement)sourceMethod);
                    SourceBlock sourceBlock = sourceMethod.getBlock();
                    if (sourceBlock != null) {
                        List list3 = SourceElementAsList.asList((SourceElement)sourceBlock);
                        list.removeAll(list3);
                    }
                    if ((string6 = this.searchReference(list)) != null) {
                        string = MessageFormat.format(RefactoringArb.getString(322), Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false), string6);
                    }
                    ++n2;
                }
                if (string != null) {
                    bl = false;
                } else if (Util.hasUpperCase(string3)) {
                    string = RefactoringArb.getString(89);
                } else if (!Character.isUpperCase(string2.charAt(0))) {
                    string = RefactoringArb.getString(90);
                }
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    private String searchReference(List list) {
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(n);
            switch (sourceElement.getSymbolKind()) {
                case 28: {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                    JavaType javaType = sourceTypeReference.getResolvedType();
                    if (javaType == null || !this._declaredClasses.contains(javaType)) break;
                    return javaType.getQualifiedName();
                }
            }
            ++n;
        }
        return null;
    }

    public String getTypeName() {
        return this._extractToItfc.getText();
    }

    public String getPackage() {
        return this._extractToPkg.getText();
    }

    public String getFQInterfaceName() {
        return this.getPackage() + "." + this.getTypeName();
    }

    public SourceMethod[] getSelectedMethods() {
        ArrayList arrayList = this.getSelectedElements(SourceMethod.class);
        return arrayList.toArray(new SourceMethod[arrayList.size()]);
    }

    public SourceFieldVariable[] getSelectedFields() {
        ArrayList arrayList = this.getSelectedElements(SourceFieldVariable.class);
        return arrayList.toArray(new SourceFieldVariable[arrayList.size()]);
    }

    public JavaType[] getSelectedInterfaces() {
        ArrayList arrayList = this.getSelectedElements(JavaType.class);
        return arrayList.toArray(new JavaType[arrayList.size()]);
    }

    private ArrayList getSelectedElements(Class clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this._root.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._root.getChildAt(n2);
            MyCellData myCellData = (MyCellData)jMutableTreeNode.getModel();
            if (myCellData.getCheckBoxState().isTrue() && clazz.isInstance(object = myCellData.getUserObject())) {
                arrayList.add(object);
            }
            ++n2;
        }
        return arrayList;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._extractToItfc;
    }

    private boolean isClassAlreadyPresent(String string) {
        Context context = this.getContext();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceClass sourceClass = javaManager.getSourceClass(string);
        return sourceClass != null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._replaceUsagesCheckbox) {
            this.whenReplaceUsagesChanges();
        }
    }

    private void whenReplaceUsagesChanges() {
        boolean bl = this.hasReplaceUsages();
        this._previewCheckbox.setEnabled(bl);
    }

    public boolean hasReplaceUsages() {
        return this._replaceUsagesCheckbox.isSelected();
    }

    public boolean hasPreview() {
        return this._previewCheckbox.isSelected();
    }

    public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
        this.whenTreeChecked(treeCellCheckedEvent, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
        this.whenTreeChecked(treeCellCheckedEvent, false);
    }

    private void whenTreeChecked(TreeCellCheckedEvent treeCellCheckedEvent, boolean bl) {
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeCellCheckedEvent.getSource();
        MyCellData myCellData = (MyCellData)jMutableTreeNode.getModel();
        Object object = myCellData.getUserObject();
        if (object instanceof JavaType) {
            JavaType javaType = (JavaType)object;
            this.selectInterfaceMethods(javaType, bl);
        }
    }

    private void selectInterfaceMethods(JavaType javaType, boolean bl) {
        Collection collection = javaType.getDeclaredMethods();
        for (JavaMethod javaMethod : collection) {
            String string = javaMethod.getSignature();
            Enumeration enumeration = this._root.children();
            while (enumeration.hasMoreElements()) {
                String string2;
                JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)enumeration.nextElement();
                MyCellData myCellData = (MyCellData)jMutableTreeNode.getModel();
                Object object = myCellData.getUserObject();
                if (!(object instanceof SourceMethod)) continue;
                SourceMethod sourceMethod = (SourceMethod)object;
                if (!javaMethod.getName().equals(sourceMethod.getName()) || !string.equals(string2 = sourceMethod.getSignature())) continue;
                myCellData.setEnabled(bl ^ true);
                myCellData.setCheckBoxState(bl);
            }
        }
    }

    public final class 3
    implements Comparator {
        public int compare(Object object, Object object2) {
            JavaType javaType = (JavaType)object;
            JavaType javaType2 = (JavaType)object2;
            return javaType.getName().compareTo(javaType2.getName());
        }
    }

    public final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            SourceMethod sourceMethod = (SourceMethod)object;
            SourceMethod sourceMethod2 = (SourceMethod)object2;
            return sourceMethod.getName().compareTo(sourceMethod2.getName());
        }
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)object;
            SourceFieldVariable sourceFieldVariable2 = (SourceFieldVariable)object2;
            return sourceFieldVariable.getName().compareTo(sourceFieldVariable2.getName());
        }
    }

    private static class MyCellData
    extends JTreeCellData {
        public MyCellData(JavaType javaType, Icon icon, String string, boolean bl) {
            super(icon, string, bl);
            this.setUserObject(javaType);
        }

        public MyCellData(SourceMethod sourceMethod, Icon icon, String string, boolean bl) {
            super(icon, string, bl);
            this.setUserObject(sourceMethod);
        }

        public MyCellData(SourceFieldVariable sourceFieldVariable, Icon icon, String string, boolean bl) {
            super(icon, string, bl);
            this.setUserObject(sourceFieldVariable);
        }
    }
}

