/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.extractinterface;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.ExtractInterfaceCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class ExtractInterfaceURLHandler
extends URLRefactoringHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483534: {
                ExtractInterfaceCriteria extractInterfaceCriteria = (ExtractInterfaceCriteria)searchCriteria;
                ClassDescription classDescription = extractInterfaceCriteria.getSourceClassDescription();
                String string = classDescription.getQualifiedName();
                projectArray = ExtractInterfaceURLHandler.getIncludedProjects(searchOperation, string);
            }
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet<URL> hashSet = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int n = searchCriteria.getSearchType();
        switch (n) {
            case -2147483534: {
                ExtractInterfaceCriteria extractInterfaceCriteria = (ExtractInterfaceCriteria)searchCriteria;
                URL uRL = this.getSourceUrl(extractInterfaceCriteria, project);
                if (uRL == null) break;
                hashSet = new HashSet<URL>(1);
                hashSet.add(uRL);
            }
        }
        return hashSet;
    }

    private URL getSourceUrl(ExtractInterfaceCriteria extractInterfaceCriteria, Project project) {
        SourceClass sourceClass;
        JavaManager javaManager;
        URL uRL = null;
        ClassDescription classDescription = extractInterfaceCriteria.getSourceClassDescription();
        JavaClass javaClass = classDescription.getJavaClass(javaManager = JavaManager.getJavaManager(project));
        if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            uRL = sourceFile.getURL();
        }
        return uRL;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        return null;
    }

    public Node[] getAffectedNodes(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        Node[] nodeArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        ExtractInterfaceCriteria extractInterfaceCriteria = (ExtractInterfaceCriteria)searchCriteria;
        URL uRL = this.getSourceUrl(extractInterfaceCriteria, project);
        if (uRL != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                nodeArray = new Node[]{node};
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return nodeArray;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean bl = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        ExtractInterfaceCriteria extractInterfaceCriteria = (ExtractInterfaceCriteria)searchCriteria;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        ClassDescription classDescription = extractInterfaceCriteria.getSourceClassDescription();
        JavaClass javaClass = classDescription.getJavaClass(javaManager);
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        Context context = searchOperation.getContext();
        JavaType[] javaTypeArray = extractInterfaceCriteria.getSelectedInterfaces(javaManager);
        SourceFieldVariable[] sourceFieldVariableArray = extractInterfaceCriteria.getSelectedFields(javaManager);
        SourceMethod[] sourceMethodArray = extractInterfaceCriteria.getSelectedMethods(javaManager);
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            SourceClass sourceClass2 = ExtractInterfaceURLHandler.createInterface(context, refactoringCommandSupport, javaTypeArray, sourceMethodArray, sourceFieldVariableArray, extractInterfaceCriteria.getPkgName(), extractInterfaceCriteria.getInterfaceName());
            refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
            List list = sourceClass.getSourceInterfaces();
            ArrayList<SourceTypeReference> arrayList = new ArrayList<SourceTypeReference>();
            int n = 0;
            while (n < list.size()) {
                SourceTypeReference sourceTypeReference = (SourceTypeReference)list.get(n);
                JavaType javaType = sourceTypeReference.getResolvedType();
                if (javaType != null) {
                    int n2 = 0;
                    while (n2 < javaTypeArray.length) {
                        JavaType javaType2 = javaTypeArray[n2];
                        if (javaType.equals((Object)javaType2)) {
                            arrayList.add(sourceTypeReference);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < arrayList.size()) {
                SourceTypeReference sourceTypeReference = (SourceTypeReference)arrayList.get(n3);
                sourceTypeReference.removeSelf();
                ++n3;
            }
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            SourceFactory sourceFactory = sourceFile.getFactory();
            String string = sourceClass2.getQualifiedName();
            SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
            list.add(sourceTypeReference);
            int n4 = 0;
            while (n4 < sourceFieldVariableArray.length) {
                SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n4];
                sourceFieldVariable.removeSelf();
                ++n4;
            }
            int n5 = 0;
            while (n5 < sourceMethodArray.length) {
                SourceMethod sourceMethod = sourceMethodArray[n5];
                if (sourceMethod.isAbstract()) {
                    sourceMethod.removeSelf();
                }
                ++n5;
            }
            refactoringCommandSupport.setOpenCreatedFiles(true);
            bl = refactoringCommandSupport.commit(context, RefactoringArb.getString(320));
        }
        catch (AbortedOperationException abortedOperationException) {
            refactoringCommandSupport.abort();
            throw abortedOperationException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    private static SourceClass createInterface(Context context, RefactoringCommandSupport refactoringCommandSupport, JavaType[] javaTypeArray, SourceMethod[] sourceMethodArray, SourceFieldVariable[] sourceFieldVariableArray, String string, String string2) {
        SourceInterfacesClause sourceInterfacesClause;
        SourceFile sourceFile = refactoringCommandSupport.createSourceFile(context, string, string2);
        SourceFactory sourceFactory = sourceFile.getFactory();
        sourceFile.setPackageName(string);
        if (javaTypeArray.length > 0) {
            SourceTypeReference[] sourceTypeReferenceArray = new SourceTypeReference[javaTypeArray.length];
            int n = 0;
            while (n < javaTypeArray.length) {
                JavaType javaType = javaTypeArray[n];
                sourceTypeReferenceArray[n] = sourceFactory.createType(javaType.getQualifiedName());
                ++n;
            }
            sourceInterfacesClause = sourceFactory.createInterfacesClause(sourceTypeReferenceArray);
        } else {
            sourceInterfacesClause = null;
        }
        SourceMember[] sourceMemberArray = new SourceMember[sourceFieldVariableArray.length + sourceMethodArray.length];
        Arrays.sort(sourceFieldVariableArray, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        int n = 0;
        while (n < sourceFieldVariableArray.length) {
            String string3;
            SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n];
            JavaType javaType = sourceFieldVariable.getResolvedType();
            if (javaType == null) {
                SourceTypeReference sourceTypeReference = sourceFieldVariable.getSourceType();
                string3 = sourceTypeReference.getName();
            } else {
                string3 = javaType.getQualifiedName();
            }
            SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
            SourceExpression sourceExpression2 = sourceExpression == null ? null : (SourceExpression)sourceExpression.cloneSelf(sourceFile);
            SourceTypeReference sourceTypeReference = sourceFactory.createType(string3);
            SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(24, sourceTypeReference, sourceFieldVariable.getName(), sourceExpression2);
            sourceMemberArray[n] = sourceFieldDeclaration;
            ++n;
        }
        Arrays.sort(sourceMethodArray, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        int n2 = 0;
        while (n2 < sourceMethodArray.length) {
            SourceMethod sourceMethod = sourceMethodArray[n2];
            SourceMethod sourceMethod2 = (SourceMethod)sourceMethod.cloneSelf(sourceFile);
            SourceBlock sourceBlock = sourceMethod2.getBlock();
            if (sourceBlock != null) {
                sourceBlock.removeSelf();
            }
            sourceMethod2.removeModifiers(1047);
            sourceMethod2.addModifiers(1);
            sourceMemberArray[sourceFieldVariableArray.length + n2] = sourceMethod2;
            ++n2;
        }
        SourceClassBody sourceClassBody = sourceFactory.createClassBody(sourceMemberArray);
        SourceClass sourceClass = sourceFactory.createClass(1, string2, null, null, sourceInterfacesClause, sourceClassBody);
        sourceClass.addModifiers(1);
        sourceClass.addSelf((SourceElement)sourceFile);
        return sourceClass;
    }
}

