/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.inline;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.inline.InlineConstantCommand;
import oracle.jdevimpl.refactoring.oprs.inline.InlineMethodOperation;
import oracle.jdevimpl.refactoring.oprs.inline.InlineVariableCommand;
import oracle.jdevimpl.refactoring.util.RadioKeyController;

public class InlineController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        ElementAt elementAt;
        boolean bl = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            int n = elementAt.getElementType();
            switch (n) {
                case 5: {
                    SourceLocalVariable sourceLocalVariable;
                    SourceExpression sourceExpression;
                    SourceElement sourceElement = elementAt.getSourceElement();
                    if (sourceElement.getSymbolKind() != 17 || (sourceExpression = (sourceLocalVariable = (SourceLocalVariable)elementAt.getSourceElement()).getInitializer()) == null) break;
                    SourceFile sourceFile = sourceElement.getOwningSourceFile();
                    URL uRL = sourceFile.getURL();
                    bl = Util.canRefactor(uRL);
                    break;
                }
                case 4: {
                    SourceExpression sourceExpression;
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                    if (sourceFieldVariable == null || !sourceFieldVariable.isStatic() || !sourceFieldVariable.isFinal() || (sourceExpression = sourceFieldVariable.getInitializer()) == null || !InlineController.isConstant((SourceElement)sourceExpression) || !Util.canRefactor((SourceElement)sourceFieldVariable)) break;
                    bl = true;
                    break;
                }
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    if (sourceMethod == null || !Util.canRefactor((SourceElement)sourceMethod)) break;
                    bl = true;
                }
            }
        }
        ideAction.setEnabled(bl);
        return true;
    }

    private static boolean isConstant(SourceElement sourceElement) {
        boolean bl = true;
        List list = sourceElement.getChildren();
        if (list.size() == 0) {
            if (sourceElement.getSymbolKind() != 53) {
                bl = false;
            }
        } else {
            int n = 0;
            while (bl && n < list.size()) {
                SourceElement sourceElement2 = (SourceElement)list.get(n);
                if (!InlineController.isConstant(sourceElement2)) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            int n = elementAt.getElementType();
            switch (n) {
                case 5: {
                    SourceElement sourceElement = elementAt.getSourceElement();
                    if (sourceElement.getSymbolKind() != 17) break;
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)elementAt.getSourceElement();
                    SourceExpression sourceExpression = InlineController.getUpdatedExpression(elementAt);
                    if (sourceExpression != null) {
                        switch (InlineController.ask()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                InlineVariableCommand inlineVariableCommand = new InlineVariableCommand(context, sourceLocalVariable, sourceExpression);
                                InlineController.invoke(inlineVariableCommand);
                                break;
                            }
                            case 2: {
                                InlineVariableCommand inlineVariableCommand = new InlineVariableCommand(context, sourceLocalVariable);
                                InlineController.invoke(inlineVariableCommand);
                            }
                        }
                        break;
                    }
                    InlineVariableCommand inlineVariableCommand = new InlineVariableCommand(context, sourceLocalVariable);
                    InlineController.invoke(inlineVariableCommand);
                    break;
                }
                case 4: {
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                    SourceExpression sourceExpression = InlineController.getUpdatedExpression(elementAt);
                    if (sourceExpression != null) {
                        switch (InlineController.ask()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                InlineConstantCommand inlineConstantCommand = new InlineConstantCommand(context, sourceFieldVariable, sourceExpression);
                                InlineController.invoke(inlineConstantCommand);
                                break;
                            }
                            case 2: {
                                InlineConstantCommand inlineConstantCommand = new InlineConstantCommand(context, sourceFieldVariable);
                                InlineController.invoke(inlineConstantCommand);
                            }
                        }
                        break;
                    }
                    InlineConstantCommand inlineConstantCommand = new InlineConstantCommand(context, sourceFieldVariable);
                    InlineController.invoke(inlineConstantCommand);
                    break;
                }
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    String string = null;
                    if (sourceMethod != null) {
                        if (sourceMethod.getReturnType() != null) {
                            if (!sourceMethod.isAbstract()) {
                                SourceBlock sourceBlock = sourceMethod.getBlock();
                                if (!InlineController.isReturnInMiddle((SourceElement)sourceBlock)) {
                                    if (!this.hasRefToSuper(sourceBlock)) {
                                        SourceMethodCallExpression sourceMethodCallExpression = this.getMethodCallExpression(elementAt);
                                        this.whenInlineMethod(context, sourceMethod, sourceMethodCallExpression);
                                    }
                                } else {
                                    string = RefactoringArb.getString(311);
                                }
                            } else {
                                string = RefactoringArb.getString(312);
                            }
                        } else {
                            string = RefactoringArb.getString(313);
                        }
                    }
                    if (string == null) break;
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)RefactoringArb.getString(310), null);
                }
            }
        }
        return true;
    }

    private boolean hasRefToSuper(SourceBlock sourceBlock) {
        ArrayList arrayList = InlineMethodOperation.getMethodElements((SourceElement)sourceBlock, (byte)58, new ArrayList());
        int n = 0;
        while (n < arrayList.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)arrayList.get(n);
            if ("super".equals(sourceSimpleNameExpression.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isReturnInMiddle(SourceElement sourceElement) {
        List list = sourceElement.getChildren();
        int n = list.size();
        int n2 = n - 2;
        while (n2 >= 0) {
            SourceElement sourceElement2 = (SourceElement)list.get(n2);
            if (InlineController.containsReturnFromThis(sourceElement2)) {
                return true;
            }
            --n2;
        }
        SourceElement sourceElement3 = (SourceElement)list.get(n - 1);
        if (sourceElement3 != null) {
            switch (sourceElement3.getSymbolKind()) {
                case 40: {
                    SourceIfStatement sourceIfStatement = (SourceIfStatement)sourceElement3;
                    SourceStatement sourceStatement = sourceIfStatement.getPrimaryClause();
                    SourceElseClause sourceElseClause = sourceIfStatement.getElseClause();
                    return InlineController.isReturnInMiddle((SourceElement)sourceStatement) || sourceElseClause != null && InlineController.isReturnInMiddle((SourceElement)sourceElseClause);
                }
                case 34: 
                case 39: 
                case 42: 
                case 46: {
                    return InlineController.containsReturnFromThis(sourceElement3);
                }
            }
        }
        return false;
    }

    private static boolean containsReturnFromThis(SourceElement sourceElement) {
        int n = sourceElement.getSymbolKind();
        switch (n) {
            case 3: {
                return false;
            }
            case 41: {
                return true;
            }
        }
        List list = sourceElement.getChildren();
        int n2 = 0;
        while (n2 < list.size()) {
            SourceElement sourceElement2 = (SourceElement)list.get(n2);
            if (InlineController.containsReturnFromThis(sourceElement2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private SourceMethodCallExpression getMethodCallExpression(ElementAt elementAt) {
        SourceElement sourceElement = elementAt.getSourceContext();
        while (sourceElement != null) {
            switch (sourceElement.getSymbolKind()) {
                case 19: {
                    return null;
                }
                case 54: {
                    return (SourceMethodCallExpression)sourceElement;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    private static SourceExpression getUpdatedExpression(ElementAt elementAt) {
        SourceElement sourceElement = elementAt.getSourceContext();
        while (sourceElement != null && sourceElement.getSymbolKind() != 4) {
            if (sourceElement instanceof SourceExpression) {
                SourceExpression sourceExpression = (SourceExpression)sourceElement;
                return sourceExpression;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    private static int ask() {
        JRadioButton jRadioButton = new JRadioButton(RefactoringArb.getString(314));
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton(RefactoringArb.getString(315));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        RadioKeyController.attach(buttonGroup);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        jPanel.add((Component)jRadioButton2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(316), 3);
        jEWTDialog.setContent((Component)jPanel);
        if (jEWTDialog.runDialog()) {
            if (jRadioButton.isSelected()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private static void invoke(Command command) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            commandProcessor.invoke(command);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void whenInlineMethod(Context context, SourceMethod sourceMethod, SourceMethodCallExpression sourceMethodCallExpression) {
        int n = sourceMethodCallExpression != null ? InlineController.ask() : 2;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                InlineMethodOperation inlineMethodOperation = new InlineMethodOperation();
                inlineMethodOperation.whenInlineMethod(context, sourceMethod, new SourceMethodCallExpression[]{sourceMethodCallExpression});
                break;
            }
            case 2: {
                InlineMethodOperation inlineMethodOperation = new InlineMethodOperation();
                inlineMethodOperation.whenInlineMethod(context, sourceMethod);
            }
        }
    }
}

