/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.SourceElementComparator;

public abstract class IntroduceController
implements Controller {
    protected abstract void replaceExpression(Context var1, SourceExpression var2);

    protected abstract void replaceVariable(Context var1, SourceVariable var2);

    public final boolean update(IdeAction ideAction, Context context) {
        boolean bl = this.handleEvent(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public final boolean handleEvent(IdeAction ideAction, Context context) {
        this.handleEvent(context, true);
        return true;
    }

    private final boolean handleEvent(Context context, boolean bl) {
        View view;
        JavaNode javaNode;
        URL uRL;
        Node node;
        Project project;
        boolean bl2 = false;
        if (context != null && context.getWorkspace() != null && (project = context.getProject()) != null && (node = context.getNode()) instanceof JavaNode && Util.canRefactor(uRL = (javaNode = (JavaNode)node).getURL()) && (view = context.getView()) instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            bl2 = this.handleEvent(context, codeEditor, javaNode, bl);
        }
        return bl2;
    }

    private boolean handleEvent(Context context, CodeEditor codeEditor, JavaNode javaNode, boolean bl) {
        boolean bl2 = false;
        Project project = context.getProject();
        int n = codeEditor.getCaretPosition();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        if (javaManager != null) {
            int n2;
            SourceElement sourceElement;
            int n3;
            URL uRL = javaNode.getURL();
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            int n4 = codeEditor.getSelectionStart();
            if (n4 == (n3 = codeEditor.getSelectionEnd())) {
                sourceElement = Patch.getElementAt((SourceElement)sourceFile, n);
                n2 = n4;
            } else {
                SourceElement sourceElement2 = Patch.getElementAt((SourceElement)sourceFile, n4);
                SourceElement sourceElement3 = Patch.getElementAt((SourceElement)sourceFile, n3);
                sourceElement = IntroduceController.getCommonParent(sourceElement2, sourceElement3);
                if (bl && sourceElement != null) {
                    codeEditor.setSelectionStart(sourceElement.getStartOffset());
                    codeEditor.setSelectionEnd(sourceElement.getEndOffset());
                }
                n2 = -1;
            }
            if (sourceElement != null) {
                bl2 = this.whenIntroduce(context, sourceElement, bl, n2);
            }
        }
        return bl2;
    }

    private static SourceElement getCommonParent(SourceElement sourceElement, SourceElement sourceElement2) {
        HashSet<SourceElement> hashSet = new HashSet<SourceElement>();
        SourceElement sourceElement3 = sourceElement;
        while (sourceElement3 != null) {
            hashSet.add(sourceElement3);
            sourceElement3 = sourceElement3.getParent();
        }
        SourceElement sourceElement4 = sourceElement2;
        while (sourceElement4 != null) {
            if (hashSet.contains(sourceElement4)) {
                return sourceElement4;
            }
            sourceElement4 = sourceElement4.getParent();
        }
        return null;
    }

    protected boolean whenIntroduce(Context context, SourceElement sourceElement, boolean bl, int n) {
        SourceElement sourceElement2 = Util.getAncestorOfKind(1, sourceElement);
        if (sourceElement2 == null) {
            while (sourceElement != null) {
                int n2 = sourceElement.getSymbolKind();
                if (47 <= n2 && n2 < 63 && n2 != 52 && n2 != 62) {
                    boolean bl2 = false;
                    SourceExpression sourceExpression = (SourceExpression)sourceElement;
                    SourceExpression sourceExpression2 = this.getBestExpression(sourceExpression, n);
                    if (this.isAcceptableExpression(sourceExpression2)) {
                        bl2 = true;
                        if (bl) {
                            this.replaceExpression(context, sourceExpression2);
                        }
                    }
                    return bl2;
                }
                if (n2 == 37) {
                    SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceElement;
                    boolean bl3 = false;
                    SourceExpression sourceExpression = sourceExpressionStatement.getExpression();
                    if (this.isAcceptableExpression(sourceExpression)) {
                        bl3 = true;
                        if (bl) {
                            this.replaceExpression(context, sourceExpression);
                        }
                    }
                    return bl3;
                }
                if (n2 == 17) {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceElement;
                    boolean bl4 = false;
                    if (!this.declaredInStatement(sourceLocalVariable.getOwningDeclaration())) {
                        bl4 = true;
                        if (bl) {
                            this.replaceVariable(context, (SourceVariable)sourceLocalVariable);
                        }
                    }
                    return bl4;
                }
                if (n2 == 18) {
                    boolean bl5 = false;
                    SourceLocalVariableDeclaration sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)sourceElement;
                    List list = sourceLocalVariableDeclaration.getVariables();
                    if (list.size() == 1 && !this.dependsOnStatement((SourceElement)sourceLocalVariableDeclaration)) {
                        bl5 = true;
                        if (bl) {
                            SourceVariable sourceVariable = (SourceVariable)list.get(0);
                            this.replaceVariable(context, sourceVariable);
                        }
                    }
                    return bl5;
                }
                if (n2 == 13) {
                    SourceFormalParameter sourceFormalParameter = (SourceFormalParameter)sourceElement;
                    if (bl) {
                        this.replaceVariable(context, (SourceVariable)sourceFormalParameter);
                    }
                    return true;
                }
                if (n2 == 19 || n2 == 6 || n2 == 3) break;
                sourceElement = sourceElement.getParent();
            }
            if (bl) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(308));
            }
        }
        return false;
    }

    private SourceExpression getBestExpression(SourceExpression sourceExpression, int n) {
        SourceExpression sourceExpression2;
        SourceExpression sourceExpression3;
        SourceElement sourceElement = sourceExpression.getParent();
        if (sourceElement.getStartOffset() == n && sourceElement instanceof SourceExpression && (sourceExpression3 = this.getBestExpression(sourceExpression2 = (SourceExpression)sourceElement, n)) != null) {
            return sourceExpression3;
        }
        if (this.isAcceptableExpression(sourceExpression)) {
            return sourceExpression;
        }
        return null;
    }

    private boolean isAcceptableExpression(SourceExpression sourceExpression) {
        String string;
        JavaType javaType;
        JavaElement javaElement;
        boolean bl = false;
        if (!(sourceExpression == null || this.dependsOnStatement((SourceElement)sourceExpression) || (javaElement = sourceExpression.getCompiledObject()) != null && javaElement.getElementKind() == 3 || (javaType = sourceExpression.getResolvedType()) == null || "void".equals(string = javaType.getQualifiedName()))) {
            bl = true;
        }
        return bl;
    }

    private boolean declaredInStatement(SourceVariableDeclaration sourceVariableDeclaration) {
        boolean bl = false;
        SourceElement sourceElement = sourceVariableDeclaration.getParent();
        int n = sourceElement.getSymbolKind();
        switch (n) {
            case 32: 
            case 39: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean dependsOnStatement(SourceElement sourceElement) {
        SourceElement sourceElement2 = Util.getAncestorOfClass(SourceStatement.class, sourceElement);
        if (sourceElement2 != null) {
            List list = SourceElementAsList.asList(sourceElement, 58);
            int n = 0;
            while (n < list.size()) {
                SourceVariable sourceVariable;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(n);
                JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                if (javaHasType != null && javaHasType.getElementKind() == 7 && (sourceVariable = (SourceVariable)javaHasType.getSourceElement()) != null && Patch.contains(sourceElement2, (SourceElement)sourceVariable) && !Patch.contains(sourceElement, (SourceElement)sourceVariable)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    static SourceElement getInsertBeforeElement(SourceExpression[] sourceExpressionArray) {
        SourceExpression sourceExpression = sourceExpressionArray[0];
        while (sourceExpression != null) {
            if (sourceExpression.getSymbolKind() == 2) {
                boolean bl = true;
                int n = 1;
                while (bl && n < sourceExpressionArray.length) {
                    SourceExpression sourceExpression2 = sourceExpressionArray[n];
                    if (!Patch.contains((SourceElement)sourceExpression, (SourceElement)sourceExpression2)) {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) {
                    List list = sourceExpression.getChildren();
                    int n2 = 0;
                    while (n2 < list.size()) {
                        SourceElement sourceElement = (SourceElement)list.get(n2);
                        int n3 = 0;
                        while (n3 < sourceExpressionArray.length) {
                            SourceExpression sourceExpression3 = sourceExpressionArray[n3];
                            if (Patch.contains(sourceElement, (SourceElement)sourceExpression3)) {
                                return sourceElement;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
            }
            sourceExpression = sourceExpression.getParent();
        }
        return null;
    }

    static boolean dependsOnLocal(SourceElement sourceElement) {
        List list = SourceElementAsList.asList(sourceElement);
        int n = 0;
        while (n < list.size()) {
            int n2;
            SourceSimpleNameExpression sourceSimpleNameExpression;
            JavaHasType javaHasType;
            SourceElement sourceElement2 = (SourceElement)list.get(n);
            if (sourceElement2.getSymbolKind() == 58 && (javaHasType = (sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement2).getResolvedObject()) != null && (n2 = javaHasType.getElementKind()) == 7) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static final SourceExpression[] getReplacableExpressions(SourceExpression sourceExpression) {
        SourceExpression[] sourceExpressionArray;
        SourceElement sourceElement = sourceExpression.getParent();
        if (sourceElement instanceof SourceExpressionStatement) {
            sourceExpressionArray = new SourceExpression[]{sourceExpression};
        } else {
            SourceElementComparator sourceElementComparator = new SourceElementComparator();
            SourceElement sourceElement2 = Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceExpression);
            sourceElementComparator.findDuplicates(sourceExpression, sourceElement2);
            sourceExpressionArray = sourceElementComparator.getDuplicates();
        }
        return sourceExpressionArray;
    }
}

