/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.util.BitField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceController;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceDialog;
import oracle.jdevimpl.refactoring.util.JotNaming;
import oracle.jdevimpl.refactoring.util.NameValidation;

public final class IntroduceDataMemberDialog
extends IntroduceDialog
implements ActionListener {
    public static final int ASSIGN_IN_METHOD = 1;
    public static final int ASSIGN_IN_DECL = 2;
    public static final int ASSIGN_IN_CTOR = 3;
    private static final int PREF_ASSIGN_IN_METHOD = 1;
    private static final int PREF_ASSIGN_IN_DECL = 2;
    private static final int PREF_ASSIGN_IN_CTOR = 4;
    private final boolean _constant;
    public static final String PREFERENCE_KEY = "INTRODUCE_FIELD_PREFS";
    private JComboBox _nameComponent;
    private DefaultListComboBoxModel _nameModel;
    private boolean _userChangedName;
    private JRadioButton _radioMethod;
    private JRadioButton _radioDecl;
    private JRadioButton _radioCtor;
    private boolean _userHasChangedAssignment;

    public IntroduceDataMemberDialog(Context context, SourceElement sourceElement, boolean bl, SourceElement[] sourceElementArray) {
        super(PREFERENCE_KEY, context, sourceElement, sourceElementArray);
        this._constant = bl;
    }

    protected void init() {
        JPanel jPanel;
        CopyableInteger copyableInteger = this.getSettings();
        JLabel jLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(61));
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
        Document document = jTextField.getDocument();
        document.addDocumentListener(new 1());
        int n = this.getOccurenceCount();
        if (n > 1) {
            this._replaceAll = new JCheckBox();
            String string = RefactoringArb.getString(62);
            String string2 = MessageFormat.format(string, Integer.toString(n));
            ResourceUtils.resButton((AbstractButton)this._replaceAll, (String)string2);
        }
        JComboBox jComboBox = this.createTypeComponent();
        JLabel jLabel2 = null;
        if (jComboBox != null) {
            jLabel2 = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)jComboBox, (String)RefactoringArb.getString(60));
        }
        SourceMember sourceMember = (SourceMember)Util.getAncestorOfClass(SourceMember.class, this._sourceElement);
        boolean bl = BitField.isSet((int)sourceMember.getModifiers(), (int)8);
        SourceClass sourceClass = sourceMember.getEnclosingClass();
        boolean bl2 = sourceClass.isAnonymous();
        if (!this._constant) {
            boolean bl3 = Util.isInCallToConstructor(this._sourceElement);
            boolean bl4 = IntroduceController.dependsOnLocal(this._sourceElement);
            boolean bl5 = this.hasConstructors();
            boolean bl6 = Util.getAncestorOfClass(SourceFieldVariable.class, this._sourceElement) != null;
            boolean bl7 = !bl3 && !bl6;
            boolean bl8 = !bl4;
            boolean bl9 = bl5 && !bl2 && !bl4 && !bl && !bl6;
            jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(304)));
            ButtonGroup buttonGroup = new ButtonGroup();
            String string = RefactoringArb.getString(305);
            this._radioMethod = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._radioMethod, (String)string);
            this._radioMethod.setEnabled(bl7);
            buttonGroup.add(this._radioMethod);
            jPanel.add(this._radioMethod);
            this._radioMethod.addActionListener(this);
            String string3 = RefactoringArb.getString(306);
            this._radioDecl = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this._radioDecl, (String)string3);
            this._radioDecl.setEnabled(bl8);
            buttonGroup.add(this._radioDecl);
            jPanel.add(this._radioDecl);
            this._radioDecl.addActionListener(this);
            String string4 = RefactoringArb.getString(307);
            this._radioCtor = new JRadioButton();
            this._radioCtor.setEnabled(bl9);
            ResourceUtils.resButton((AbstractButton)this._radioCtor, (String)string4);
            buttonGroup.add(this._radioCtor);
            jPanel.add(this._radioCtor);
            this._radioCtor.addActionListener(this);
            if (bl8 && copyableInteger.isBitSet(2)) {
                this._radioDecl.setSelected(true);
            } else if (bl9 && copyableInteger.isBitSet(4)) {
                this._radioCtor.setSelected(true);
            } else if (bl7 && copyableInteger.isBitSet(1)) {
                this._radioMethod.setSelected(true);
            }
            if (buttonGroup.getSelection() == null) {
                if (this._radioMethod.isEnabled()) {
                    this._radioMethod.setSelected(true);
                } else if (this._radioDecl.isEnabled()) {
                    this._radioDecl.setSelected(true);
                } else if (this._radioCtor.isEnabled()) {
                    this._radioCtor.setSelected(true);
                }
            }
        } else {
            jPanel = null;
        }
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(jLabel.getPreferredSize());
        this.setMessageLabel(jLabel3);
        Insets insets = new Insets(2, 2, 2, 2);
        if (jComboBox != null) {
            this.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
            this.add((Component)jComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        if (this._replaceAll != null) {
            this.add((Component)this._replaceAll, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
        if (jPanel != null) {
            this.add((Component)jPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 2, insets, 0, 0));
        }
        this.add((Component)jLabel3, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    private boolean hasConstructors() {
        SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, this._sourceElement.getParent());
        Collection collection = sourceClass.getDeclaredConstructors();
        return collection.isEmpty() ^ true;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected String getHelpTopicID() {
        return this._constant ? "f1_jrf_dintroduceconst_html" : "f1_jrf_dintroducefield_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = this.getFieldName();
            NameValidation nameValidation = NameValidation.validateFieldName(string, this._constant, this._sourceElement);
            String string2 = nameValidation.getMessage();
            boolean bl = nameValidation.isValid();
            if (this.getAssignPlacement() == 0) {
                bl = false;
            }
            this.setMessage(string2, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected String getTitle() {
        return this._constant ? RefactoringArb.getString(59) : RefactoringArb.getString(58);
    }

    protected int getDefaultPreferences() {
        return 1;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        if (this._userHasChangedAssignment) {
            int n = this.getAssignPlacement();
            copyableInteger.setBit(1, n == 1);
            copyableInteger.setBit(2, n == 2);
            copyableInteger.setBit(4, n == 3);
        }
    }

    protected void fillSuggestedNames() {
        JavaType javaType = this.getSelectedJavaType();
        JavaType javaType2 = javaType.isArray() ? javaType.getComponentType() : javaType;
        String string = javaType2.getRawName();
        List list = this._constant ? JotNaming.suggestConstantNames(this._sourceElement, string) : JotNaming.suggestFieldNames(this._sourceElement, string);
        String string2 = list.isEmpty() ? "" : list.get(0).toString();
        boolean bl = this._userChangedName;
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        this._nameModel.removeAllElements();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            this._nameModel.addElement(e);
            ++n;
        }
        Object object2 = bl ? object : string2;
        comboBoxEditor.setItem(object2);
        this._userChangedName = bl;
    }

    public String getFieldName() {
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        return object.toString();
    }

    public int getAssignPlacement() {
        if (!this._constant) {
            return this._radioMethod.isSelected() ? 1 : (this._radioDecl.isSelected() ? 2 : 3);
        }
        return 2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._radioMethod || object == this._radioDecl || object == this._radioCtor) {
            this._userHasChangedAssignment = true;
        }
    }

    static void wa$_userChangedName(IntroduceDataMemberDialog introduceDataMemberDialog, boolean bl) {
        introduceDataMemberDialog._userChangedName = bl;
    }

    public final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            IntroduceDataMemberDialog.this.updateOKButton();
            IntroduceDataMemberDialog.wa$_userChangedName(IntroduceDataMemberDialog.this, true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            IntroduceDataMemberDialog.this.updateOKButton();
            IntroduceDataMemberDialog.wa$_userChangedName(IntroduceDataMemberDialog.this, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            IntroduceDataMemberDialog.this.updateOKButton();
            IntroduceDataMemberDialog.wa$_userChangedName(IntroduceDataMemberDialog.this, true);
        }
    }
}

