/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import oracle.ide.Context;
import oracle.ide.util.Pair;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.util.ExpressionUtil;

abstract class IntroduceDialog
extends BaseDialog
implements ItemListener {
    private final int _occurenceCount;
    protected JCheckBox _replaceAll;
    private ArrayList _validTypes;
    private JComboBox _typeComponent;
    protected final SourceElement _sourceElement;
    private JavaType _selectedType;

    protected abstract void fillSuggestedNames();

    protected abstract void init();

    IntroduceDialog(String string, Context context, SourceElement sourceElement, SourceElement[] sourceElementArray) {
        super(string, context);
        this._sourceElement = sourceElement;
        this._occurenceCount = sourceElementArray == null ? 0 : sourceElementArray.length;
    }

    public final boolean runDialog() {
        this.init();
        return super.runDialog();
    }

    protected final JComboBox createTypeComponent() {
        this._typeComponent = null;
        ArrayList arrayList = this.getValidTypes();
        int n = arrayList.size();
        switch (n) {
            case 0: {
                this._selectedType = null;
                break;
            }
            case 1: {
                this._selectedType = (JavaType)arrayList.get(0);
                break;
            }
            default: {
                Pair[] pairArray = new Pair[n];
                int n2 = 0;
                while (n2 < n) {
                    JavaType javaType = (JavaType)arrayList.get(n2);
                    pairArray[n2] = new Pair((Object)javaType.getQualifiedName(), (Object)javaType);
                    ++n2;
                }
                JComboBox<Pair> jComboBox = new JComboBox<Pair>(pairArray);
                jComboBox.addItemListener(this);
                jComboBox.setSelectedIndex(0);
                this._typeComponent = jComboBox;
                this._selectedType = (JavaType)pairArray[0].second;
            }
        }
        return this._typeComponent;
    }

    private static ArrayList getValidTypes(SourceExpression sourceExpression) {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        JavaType javaType = sourceExpression.getResolvedType();
        boolean bl = true;
        if (javaType != null) {
            String string;
            JavaType javaType2;
            if (javaType.isArray() && (javaType2 = javaType.getBaseComponentType()).isPrimitive() && "null".equals(string = javaType2.getQualifiedName())) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            arrayList.add(0, javaType);
            if (!javaType.isArray()) {
                JavaType javaType3 = ExpressionUtil.getExpectedType(sourceExpression);
                Set set = javaType.getHierarchy();
                arrayList.addAll(set);
                if (javaType3 != null) {
                    SourceElement sourceElement = sourceExpression.getParent();
                    while (!(sourceElement instanceof JavaClass)) {
                        sourceElement = sourceElement.getParent();
                    }
                    JavaClass javaClass = (JavaClass)sourceElement;
                    String string = javaClass.getPackageName();
                    int n = arrayList.size() - 1;
                    while (n >= 0) {
                        JavaType javaType4 = (JavaType)arrayList.get(n);
                        boolean bl2 = false;
                        boolean bl3 = javaType3.isAssignableFrom(javaType4);
                        if (bl3) {
                            if (javaType4.isPublic()) {
                                bl2 = true;
                            } else if (javaType4.isPackagePrivate()) {
                                if (string.equals(javaType4.getPackageName())) {
                                    bl2 = true;
                                }
                            } else if (javaType4.isProtected()) {
                                if (javaType4.isAssignableFrom((JavaType)javaClass)) {
                                    bl2 = true;
                                } else if (string.equals(javaType4.getPackageName())) {
                                    bl2 = true;
                                }
                            }
                        }
                        if (!bl2) {
                            arrayList.remove(n);
                        }
                        --n;
                    }
                }
            }
        } else {
            JavaType javaType5 = ExpressionUtil.getExpectedType(sourceExpression);
            if (javaType5 != null) {
                arrayList.add(javaType5);
            }
        }
        return arrayList;
    }

    private ArrayList getValidTypes() {
        return this._validTypes;
    }

    private void setValidTypes(ArrayList arrayList) {
        this._validTypes = arrayList;
    }

    public final void setValidTypesFromExpression(SourceExpression sourceExpression) {
        ArrayList arrayList = IntroduceDialog.getValidTypes(sourceExpression);
        this.setValidTypes(arrayList);
    }

    protected final int getOccurenceCount() {
        return this._occurenceCount;
    }

    public final void itemStateChanged(ItemEvent itemEvent) {
        this.fillSuggestedNames();
    }

    final boolean isReplaceAll() {
        return this._replaceAll != null && this._replaceAll.isSelected();
    }

    protected JavaType getSelectedJavaType() {
        JavaType javaType;
        if (this._typeComponent != null) {
            Object object = this._typeComponent.getSelectedItem();
            Pair pair = (Pair)object;
            javaType = (JavaType)pair.second;
        } else {
            javaType = this._selectedType;
        }
        return javaType;
    }

    protected String getSelectedTypeName() {
        String string;
        if (this._typeComponent != null) {
            Object object = this._typeComponent.getSelectedItem();
            Pair pair = (Pair)object;
            string = (String)pair.first;
        } else {
            string = this._selectedType == null ? "java.lang.Object" : this._selectedType.getQualifiedName();
        }
        return string;
    }
}

