/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.Pair;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceController;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceDataMemberDialog;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceFieldFromParamDialog;
import oracle.jdevimpl.refactoring.util.SourceElementComparator;
import oracle.jdevimpl.refactoring.util.Visitor;

public final class IntroduceFieldController
extends IntroduceController {
    private final boolean _isConstant;
    private final String _operationName;

    public IntroduceFieldController(boolean bl) {
        this._isConstant = bl;
        this._operationName = this._isConstant ? RefactoringArb.getString(299) : RefactoringArb.getString(300);
    }

    protected void replaceExpression(Context context, SourceExpression sourceExpression) {
        SourceSimpleNameExpression sourceSimpleNameExpression;
        JavaHasType javaHasType;
        SourceElement sourceElement;
        SourceFormalParameter sourceFormalParameter = null;
        if (sourceExpression.getSymbolKind() == 58 && (sourceElement = (javaHasType = (sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression).getResolvedObject()).getSourceElement()) != null && sourceElement.getSymbolKind() == 13) {
            sourceFormalParameter = (SourceFormalParameter)sourceElement;
        }
        if (sourceFormalParameter != null) {
            this.introduceFromParameter(context, sourceFormalParameter, sourceExpression);
        } else if (!this._isConstant || IntroduceFieldController.isConstantExpression(sourceExpression)) {
            SourceExpression[] sourceExpressionArray = IntroduceFieldController.findDuplicates(sourceExpression);
            IntroduceDataMemberDialog introduceDataMemberDialog = new IntroduceDataMemberDialog(context, (SourceElement)sourceExpression, this._isConstant, (SourceElement[])sourceExpressionArray);
            introduceDataMemberDialog.setValidTypesFromExpression(sourceExpression);
            if (introduceDataMemberDialog.runDialog()) {
                String string = introduceDataMemberDialog.getFieldName();
                String string2 = introduceDataMemberDialog.getSelectedTypeName();
                int n = introduceDataMemberDialog.getAssignPlacement();
                boolean bl = Util.isStaticContext(sourceExpression);
                SourceFile sourceFile = sourceExpression.getOwningSourceFile();
                SourceFactory sourceFactory = sourceFile.getFactory();
                SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceExpression);
                RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                try {
                    switch (n) {
                        case 3: {
                            this.createField(sourceFactory, sourceClass, string2, string, null, bl);
                            this.addInitializerToCtors(sourceFactory, sourceClass, string, sourceExpression);
                            break;
                        }
                        case 2: {
                            this.createField(sourceFactory, sourceClass, string2, string, sourceExpression, bl);
                            break;
                        }
                        case 1: {
                            this.createField(sourceFactory, sourceClass, string2, string, null, bl);
                            SourceExpressionStatement sourceExpressionStatement = IntroduceFieldController.needsPrefix((SourceElement)sourceExpression, string) ? IntroduceFieldController.createFieldAssigment(sourceFactory, "this." + string, sourceExpression) : IntroduceFieldController.createFieldAssigment(sourceFactory, string, sourceExpression);
                            SourceElement sourceElement2 = introduceDataMemberDialog.isReplaceAll() ? IntroduceFieldController.getInsertBeforeElement(sourceExpressionArray) : Util.getStatementLevelElement((SourceElement)sourceExpression);
                            sourceExpressionStatement.addSelfBefore(sourceElement2);
                        }
                    }
                    if (introduceDataMemberDialog.isReplaceAll()) {
                        int n2 = 0;
                        while (n2 < sourceExpressionArray.length) {
                            SourceExpression sourceExpression2 = sourceExpressionArray[n2];
                            this.replaceExpressionWithFieldAccess(sourceExpression2, string, sourceFactory);
                            ++n2;
                        }
                    } else {
                        this.replaceExpressionWithFieldAccess(sourceExpression, string, sourceFactory);
                    }
                    refactoringCommandSupport.commit(context, this._operationName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    refactoringCommandSupport.abort();
                }
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(301));
        }
    }

    private void replaceExpressionWithFieldAccess(SourceExpression sourceExpression, String string, SourceFactory sourceFactory) {
        Object object = IntroduceFieldController.needsPrefix((SourceElement)sourceExpression, string) ? sourceFactory.createExpression("this." + string) : sourceFactory.createSimpleNameExpression(string);
        sourceExpression.replaceSelf((SourceElement)object);
    }

    private static SourceExpression[] findDuplicates(SourceExpression sourceExpression) {
        SourceExpression[] sourceExpressionArray;
        int n;
        SourceElement sourceElement = Util.getAncestorOfClass(SourceMember.class, (SourceElement)sourceExpression);
        boolean bl = false;
        if (sourceElement != null && ((n = sourceElement.getSymbolKind()) == 19 || n == 6)) {
            bl = true;
        }
        if (bl) {
            SourceElementComparator sourceElementComparator = new SourceElementComparator();
            sourceElementComparator.findDuplicates(sourceExpression, sourceElement);
            sourceExpressionArray = sourceElementComparator.getDuplicates();
        } else {
            sourceExpressionArray = new SourceExpression[]{sourceExpression};
        }
        return sourceExpressionArray;
    }

    protected void replaceVariable(Context context, SourceVariable sourceVariable) {
        if (sourceVariable.getSymbolKind() == 13) {
            this.introduceFromParameter(context, (SourceFormalParameter)sourceVariable, null);
        } else {
            this.introduceFromInitialiser(context, sourceVariable);
        }
    }

    private void introduceFromInitialiser(Context context, SourceVariable sourceVariable) {
        if (this.isValidOperation(sourceVariable)) {
            SourceExpression sourceExpression = sourceVariable.getInitializer();
            IntroduceDataMemberDialog introduceDataMemberDialog = new IntroduceDataMemberDialog(context, (SourceElement)sourceExpression, this._isConstant, new SourceElement[0]);
            introduceDataMemberDialog.setValidTypesFromExpression(sourceExpression);
            if (introduceDataMemberDialog.runDialog()) {
                String string = introduceDataMemberDialog.getFieldName();
                String string2 = introduceDataMemberDialog.getSelectedTypeName();
                int n = introduceDataMemberDialog.getAssignPlacement();
                boolean bl = Util.isStaticContext(sourceExpression);
                SourceFile sourceFile = sourceVariable.getOwningSourceFile();
                SourceFactory sourceFactory = sourceFile.getFactory();
                SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceVariable);
                RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                try {
                    refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                    ArrayList arrayList = this.getUsages(sourceVariable, string);
                    switch (n) {
                        case 3: {
                            this.createField(sourceFactory, sourceClass, string2, string, null, bl);
                            IntroduceFieldController.replaceVariableInstances(sourceFactory, arrayList, string);
                            this.addInitializerToCtors(sourceFactory, sourceClass, string, sourceExpression);
                            sourceVariable.removeSelf();
                            break;
                        }
                        case 2: {
                            this.createField(sourceFactory, sourceClass, string2, string, sourceExpression, bl);
                            sourceVariable.removeSelf();
                            IntroduceFieldController.replaceVariableInstances(sourceFactory, arrayList, string);
                            break;
                        }
                        case 1: {
                            this.createField(sourceFactory, sourceClass, string2, string, null, bl);
                            IntroduceFieldController.replaceVariableInstances(sourceFactory, arrayList, string);
                            SourceExpressionStatement sourceExpressionStatement = this.needsPrefix(sourceVariable, string) ? IntroduceFieldController.createFieldAssigment(sourceFactory, "this." + string, sourceExpression) : IntroduceFieldController.createFieldAssigment(sourceFactory, string, sourceExpression);
                            SourceVariableDeclaration sourceVariableDeclaration = sourceVariable.getOwningDeclaration();
                            if (sourceVariableDeclaration.getVariables().size() > 1) {
                                sourceExpressionStatement.addSelfAfter((SourceElement)sourceVariableDeclaration);
                                sourceVariable.removeSelf();
                                break;
                            }
                            sourceVariableDeclaration.replaceSelf((SourceElement)sourceExpressionStatement);
                        }
                    }
                    refactoringCommandSupport.commit(context, this._operationName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    refactoringCommandSupport.abort();
                }
            }
        }
    }

    private boolean isValidOperation(SourceVariable sourceVariable) {
        String string = null;
        SourceExpression sourceExpression = sourceVariable.getInitializer();
        if (sourceExpression == null) {
            string = RefactoringArb.getString(302);
        } else if (this._isConstant) {
            if (!IntroduceFieldController.isConstantExpression(sourceExpression)) {
                string = RefactoringArb.getString(301);
            } else if (this.isAssigned(sourceVariable)) {
                string = RefactoringArb.getString(303);
            }
        }
        if (string == null) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
        return false;
    }

    private boolean isAssigned(SourceVariable sourceVariable) {
        SourceVariableDeclaration sourceVariableDeclaration = sourceVariable.getOwningDeclaration();
        SourceElement sourceElement = sourceVariableDeclaration.getParent();
        List list = SourceElementAsList.asList(sourceElement);
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement2 = (SourceElement)list.get(n);
            switch (sourceElement2.getSymbolKind()) {
                case 49: {
                    JavaHasType javaHasType;
                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceElement2;
                    SourceExpression sourceExpression = sourceAssignmentExpression.getFirstOperand();
                    if (sourceExpression == null || sourceExpression.getSymbolKind() != 58) break;
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression;
                    if (!sourceVariable.getName().equals(sourceSimpleNameExpression.getName()) || !sourceVariable.equals(javaHasType = sourceSimpleNameExpression.getResolvedObject())) break;
                    return true;
                }
                case 61: {
                    SourceUnaryExpression sourceUnaryExpression = (SourceUnaryExpression)sourceElement2;
                    int n2 = sourceUnaryExpression.getOperatorCode();
                    switch (n2) {
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: {
                            return true;
                        }
                    }
                }
            }
            ++n;
        }
        return false;
    }

    private ArrayList getUsages(SourceVariable sourceVariable, String string) {
        ArrayList arrayList = new ArrayList();
        SourceVariableDeclaration sourceVariableDeclaration = sourceVariable.getOwningDeclaration();
        SourceElement sourceElement = sourceVariableDeclaration.getParent();
        String string2 = sourceVariable.getName();
        1 var7_7 = new 1(this, string, string2, sourceVariable, arrayList);
        ((Visitor)var7_7).visit(sourceElement);
        return arrayList;
    }

    private static SourceExpressionStatement createFieldAssigment(SourceFactory sourceFactory, String string, SourceExpression sourceExpression) {
        SourceExpression sourceExpression2 = sourceFactory.createExpression(string);
        SourceExpression sourceExpression3 = (SourceExpression)sourceExpression.cloneSelf(sourceExpression.getOwningSourceFile());
        SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, sourceExpression2, sourceExpression3);
        SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement((SourceExpression)sourceAssignmentExpression);
        return sourceExpressionStatement;
    }

    private void addInitializerToCtors(SourceFactory sourceFactory, SourceClass sourceClass, String string, SourceExpression sourceExpression) {
        boolean bl = false;
        Collection collection = sourceClass.getDeclaredConstructors();
        for (JavaMethod javaMethod : collection) {
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            if (sourceMethod == null || IntroduceFieldController.ctorCallsThis(sourceMethod)) continue;
            SourceExpressionStatement sourceExpressionStatement = IntroduceFieldController.createFieldAssigment(sourceFactory, string, sourceExpression);
            if (Patch.contains((SourceElement)sourceMethod, (SourceElement)sourceExpression)) {
                SourceElement sourceElement = Util.getStatementLevelElement((SourceElement)sourceExpression);
                sourceExpressionStatement.addSelfBefore(sourceElement);
            } else {
                sourceExpressionStatement.addSelf((SourceElement)sourceMethod.getBlock());
            }
            bl = true;
        }
        if (!bl) {
            SourceExpressionStatement sourceExpressionStatement = IntroduceFieldController.createFieldAssigment(sourceFactory, string, sourceExpression);
            SourceBlock sourceBlock = sourceFactory.createBlock(new SourceElement[]{sourceExpressionStatement});
            SourceMethod sourceMethod = sourceFactory.createConstructor(null, null, sourceBlock);
            sourceMethod.addModifiers(1);
            sourceMethod.addSelf((SourceElement)sourceClass);
        }
    }

    private static boolean ctorCallsThis(SourceMethod sourceMethod) {
        try {
            SourceBlock sourceBlock = sourceMethod.getBlock();
            SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceBlock.getChildren().get(0);
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceExpressionStatement.getChildren().get(0);
            JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
            if (javaMethod.isConstructor()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void replaceVariableInstances(SourceFactory sourceFactory, ArrayList arrayList, String string) {
        int n = 0;
        while (n < arrayList.size()) {
            Pair pair = (Pair)arrayList.get(n);
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)pair.first;
            boolean bl = (Boolean)pair.second;
            if (bl) {
                SourceSimpleNameExpression sourceSimpleNameExpression2 = sourceFactory.createSimpleNameExpression("this." + string);
                sourceSimpleNameExpression.replaceSelf((SourceElement)sourceSimpleNameExpression2);
            } else {
                sourceSimpleNameExpression.setName(string);
            }
            ++n;
        }
    }

    private boolean needsPrefix(SourceVariable sourceVariable, String string) {
        if (string.equals(sourceVariable.getName())) {
            return false;
        }
        return IntroduceFieldController.needsPrefix((SourceElement)sourceVariable.getOwningDeclaration(), string);
    }

    private static boolean needsPrefix(SourceElement sourceElement, String string) {
        while (sourceElement != null) {
            int n = sourceElement.getSymbolKind();
            switch (n) {
                case 4: {
                    return false;
                }
                case 2: {
                    SourceBlock sourceBlock = (SourceBlock)sourceElement;
                    Collection collection = sourceBlock.getLocalVariables();
                    for (SourceLocalVariable sourceLocalVariable : collection) {
                        if (!string.equals(sourceLocalVariable.getName())) continue;
                        return true;
                    }
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
                    List list = sourceFormalParameterList.getSourceParameters();
                    int n2 = 0;
                    while (n2 < list.size()) {
                        SourceVariable sourceVariable = (SourceVariable)list.get(n2);
                        String string2 = sourceVariable.getName();
                        if (string.equals(string2)) {
                            return true;
                        }
                        ++n2;
                    }
                    break;
                }
                case 39: {
                    SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                    List list = sourceForStatement.getForVariables();
                    int n3 = 0;
                    while (n3 < list.size()) {
                        SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)list.get(n3);
                        if (string.equals(sourceLocalVariable.getName())) {
                            return true;
                        }
                        ++n3;
                    }
                    break;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return false;
    }

    private void createField(SourceFactory sourceFactory, SourceClass sourceClass, String string, String string2, SourceExpression sourceExpression, boolean bl) {
        SourceFieldDeclaration sourceFieldDeclaration = this.createField(sourceFactory, string, string2, sourceExpression, bl);
        SourceClassBody sourceClassBody = sourceClass.getSourceBody();
        sourceFieldDeclaration.addSelf((SourceElement)sourceClassBody);
    }

    private SourceFieldDeclaration createField(SourceFactory sourceFactory, String string, String string2, SourceExpression sourceExpression, boolean bl) {
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        if (sourceExpression != null) {
            sourceExpression = (SourceExpression)sourceExpression.cloneSelf(sourceExpression.getOwningSourceFile());
        }
        int n = this._isConstant ? 26 : 2 | (bl ? 8 : 0);
        SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(n, sourceTypeReference, string2, sourceExpression);
        return sourceFieldDeclaration;
    }

    private static boolean isConstantExpression(SourceExpression sourceExpression) {
        List list = SourceElementAsList.asList((SourceElement)sourceExpression);
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(n);
            block0 : switch (sourceElement.getSymbolKind()) {
                case 58: {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                    JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                    if (javaHasType == null) break;
                    switch (javaHasType.getElementKind()) {
                        case 7: {
                            return false;
                        }
                        case 5: {
                            JavaField javaField = (JavaField)javaHasType;
                            if (javaField.isStatic() && javaField.isFinal()) break block0;
                            return false;
                        }
                    }
                    break;
                }
                case 54: {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (javaMethod == null || javaMethod.isStatic()) break;
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private void introduceFromParameter(Context context, SourceFormalParameter sourceFormalParameter, SourceExpression sourceExpression) {
        IntroduceFieldFromParamDialog introduceFieldFromParamDialog = new IntroduceFieldFromParamDialog(context, sourceFormalParameter, this._isConstant);
        if (introduceFieldFromParamDialog.runDialog()) {
            String string = introduceFieldFromParamDialog.getFieldType();
            String string2 = introduceFieldFromParamDialog.getFieldName();
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                SourceFile sourceFile = sourceFormalParameter.getOwningSourceFile();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                SourceFactory sourceFactory = sourceFile.getFactory();
                SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceFormalParameter);
                JavaClass javaClass = sourceMethod.getOwningClass();
                SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
                this.createField(sourceFactory, sourceClass, string, string2, null, sourceMethod.isStatic());
                SourceExpression sourceExpression2 = sourceFactory.createExpression(sourceFormalParameter.getName());
                List list = SourceElementAsList.asList((SourceElement)sourceMethod, SourceVariable.class);
                SourceExpressionStatement sourceExpressionStatement = SourceElementAsList.filterNamedElements(list, string2).isEmpty() ? IntroduceFieldController.createFieldAssigment(sourceFactory, string2, sourceExpression2) : IntroduceFieldController.createFieldAssigment(sourceFactory, "this." + string2, sourceExpression2);
                SourceBlock sourceBlock = sourceMethod.getBlock();
                SourceElement sourceElement = null;
                boolean bl = false;
                if (sourceExpression == null) {
                    List list2 = sourceMethod.getSourceParameters();
                    int n = list2.indexOf(sourceFormalParameter);
                    List list3 = SourceElementAsList.asList((SourceElement)sourceBlock, 49);
                    int n2 = n - 1;
                    while (sourceElement == null && n2 >= 0) {
                        SourceVariable sourceVariable = (SourceVariable)list2.get(n2);
                        sourceElement = this.getAssignmentPos(list3, sourceVariable);
                        --n2;
                    }
                    if (sourceElement == null) {
                        bl = true;
                        int n3 = n + 1;
                        while (sourceElement == null && n3 < list2.size()) {
                            SourceVariable sourceVariable = (SourceVariable)list2.get(n3);
                            sourceElement = this.getAssignmentPos(list3, sourceVariable);
                            ++n3;
                        }
                        if (sourceElement == null) {
                            List list4 = sourceBlock.getChildren();
                            int n4 = 0;
                            while (sourceElement == null && n4 < list4.size()) {
                                SourceElement sourceElement2 = (SourceElement)list4.get(n4);
                                if (!this.isCallToThisOrSuper(sourceElement2)) {
                                    sourceElement = sourceElement2;
                                }
                                ++n4;
                            }
                        }
                    }
                } else {
                    sourceElement = Util.getStatementLevelElement((SourceElement)sourceExpression);
                    bl = true;
                    if (this.isCallToThisOrSuper(sourceElement)) {
                        bl = false;
                    }
                }
                if (sourceElement == null) {
                    sourceExpressionStatement.addSelf((SourceElement)sourceBlock);
                } else {
                    sourceExpressionStatement.addSelf(sourceElement, bl);
                }
                refactoringCommandSupport.commit(context, this._operationName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                refactoringCommandSupport.abort();
            }
        }
    }

    private boolean isCallToThisOrSuper(SourceElement sourceElement) {
        if (sourceElement != null) {
            SourceMethodCallExpression sourceMethodCallExpression;
            String string;
            if (sourceElement.getSymbolKind() == 37) {
                SourceExpressionStatement sourceExpressionStatement = (SourceExpressionStatement)sourceElement;
                sourceElement = sourceExpressionStatement.getExpression();
            }
            if (sourceElement.getSymbolKind() == 54 && ("this".equals(string = (sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement).getName()) || "super".equals(string))) {
                return true;
            }
        }
        return false;
    }

    private SourceStatement getAssignmentPos(List list, SourceVariable sourceVariable) {
        String string = sourceVariable.getName();
        int n = 0;
        while (n < list.size()) {
            SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)list.get(n);
            SourceExpression sourceExpression = sourceAssignmentExpression.getSecondOperand();
            List list2 = SourceElementAsList.asList((SourceElement)sourceExpression, 58);
            int n2 = 0;
            while (n2 < list2.size()) {
                JavaHasType javaHasType;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list2.get(n2);
                if (string.equals(sourceSimpleNameExpression.getName()) && sourceVariable.equals(javaHasType = sourceSimpleNameExpression.getResolvedObject())) {
                    SourceStatement sourceStatement = (SourceStatement)Util.getAncestorOfClass(SourceStatement.class, (SourceElement)sourceAssignmentExpression);
                    return sourceStatement;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    static boolean mav$needsPrefix(IntroduceFieldController introduceFieldController, SourceVariable sourceVariable, String string) {
        return introduceFieldController.needsPrefix(sourceVariable, string);
    }

    public final class 1
    extends Visitor {
        boolean _needsPrefix;
        private final /* synthetic */ String v$fieldName;
        private final /* synthetic */ String v$variableName;
        private final /* synthetic */ SourceVariable v$sourceVariable;
        private final /* synthetic */ ArrayList v$ret;
        final /* synthetic */ IntroduceFieldController this$0;

        void $init$() {
            this._needsPrefix = IntroduceFieldController.mav$needsPrefix(this.this$0, this.v$sourceVariable, this.v$fieldName);
        }

        public void visit(SourceElement sourceElement) {
            boolean bl = this._needsPrefix;
            if (!bl) {
                int n = sourceElement.getSymbolKind();
                switch (n) {
                    case 2: {
                        SourceBlock sourceBlock = (SourceBlock)sourceElement;
                        Collection collection = sourceBlock.getLocalVariables();
                        for (SourceLocalVariable sourceLocalVariable : collection) {
                            if (!this.v$fieldName.equals(sourceLocalVariable.getName())) continue;
                            this._needsPrefix = true;
                        }
                        break;
                    }
                    case 19: {
                        SourceMethod sourceMethod = (SourceMethod)sourceElement;
                        SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
                        List list = sourceFormalParameterList.getSourceParameters();
                        int n2 = 0;
                        while (n2 < list.size()) {
                            SourceVariable sourceVariable = (SourceVariable)list.get(n2);
                            String string = sourceVariable.getName();
                            if (this.v$fieldName.equals(string)) {
                                this._needsPrefix = true;
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 39: {
                        SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                        List list = sourceForStatement.getForVariables();
                        int n3 = 0;
                        while (n3 < list.size()) {
                            SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)list.get(n3);
                            if (this.v$fieldName.equals(sourceLocalVariable.getName())) {
                                this._needsPrefix = true;
                            }
                            ++n3;
                        }
                        break;
                    }
                }
            }
            super.visit(sourceElement);
            this._needsPrefix = bl;
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType javaHasType;
            String string = sourceSimpleNameExpression.getName();
            if (this.v$variableName.equals(string) && this.v$sourceVariable.equals(javaHasType = sourceSimpleNameExpression.getResolvedObject())) {
                Boolean bl = this._needsPrefix;
                Pair pair = new Pair((Object)sourceSimpleNameExpression, (Object)bl);
                this.v$ret.add(pair);
            }
        }

        public 1(IntroduceFieldController introduceFieldController, String string, String string2, SourceVariable sourceVariable, ArrayList arrayList) {
            this.v$ret = arrayList;
            this.v$sourceVariable = sourceVariable;
            this.v$variableName = string2;
            this.v$fieldName = string;
            this.this$0 = introduceFieldController;
            this.$init$();
        }
    }
}

