/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.util.JotNaming;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class IntroduceFieldFromParamDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "INTRO_FIELD_FROM_PARAM_PREF";
    private SourceFormalParameter _sourceLocalVariable;
    private boolean _constant;
    private JComboBox _typeCombo;
    private JComboBox _nameComponent;
    private DefaultListComboBoxModel _nameModel;
    private boolean _userChangedName;

    void $init$() {
        this._constant = false;
    }

    public IntroduceFieldFromParamDialog(Context context, SourceFormalParameter sourceFormalParameter, boolean bl) {
        super(PREFERENCE_KEY, context);
        this.$init$();
        this._sourceLocalVariable = sourceFormalParameter;
        this._constant = bl;
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(58);
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    private void init() {
        JLabel jLabel = new JLabel();
        this._typeCombo = new JComboBox(this.buidTypeModel());
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._typeCombo, (String)RefactoringArb.getString(60));
        this._typeCombo.addItemListener(new 2());
        this._typeCombo.setSelectedIndex(0);
        JLabel jLabel2 = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._nameComponent, (String)RefactoringArb.getString(61));
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
        Document document = jTextField.getDocument();
        document.addDocumentListener(new 1());
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(jLabel.getPreferredSize());
        this.setMessageLabel(jLabel3);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._typeCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    private void fillSuggestedNames() {
        String string = (String)this._typeCombo.getSelectedItem();
        List list = this._constant ? JotNaming.suggestConstantNames((SourceElement)this._sourceLocalVariable, string) : JotNaming.suggestFieldNames((SourceElement)this._sourceLocalVariable, string);
        String string2 = list.isEmpty() ? "" : list.get(0).toString();
        boolean bl = this._userChangedName;
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        this._nameModel.removeAllElements();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            this._nameModel.addElement(e);
            ++n;
        }
        Object object2 = bl ? object : string2;
        comboBoxEditor.setItem(object2);
        this._userChangedName = bl;
    }

    private ComboBoxModel buidTypeModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        JavaType javaType = this._sourceLocalVariable.getResolvedType();
        if (javaType != null) {
            defaultComboBoxModel.addElement(javaType.getQualifiedName());
            Set set = javaType.getHierarchy();
            for (JavaClass javaClass : set) {
                String string = javaClass.getQualifiedName();
                defaultComboBoxModel.addElement(string);
            }
        }
        if (defaultComboBoxModel.getSize() == 0) {
            defaultComboBoxModel.addElement("java.lang.Object");
        }
        return defaultComboBoxModel;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = this.getFieldName();
            NameValidation nameValidation = NameValidation.validateFieldName(string, this._constant, (SourceElement)this._sourceLocalVariable);
            this.setMessage(nameValidation.getMessage(), nameValidation.isValid());
            this.setOKButtonEnabled(nameValidation.isValid());
        }
    }

    protected String getHelpTopicID() {
        return this._constant ? "f1_jrf_dintroduceconst_html" : "f1_jrf_dintroducefield_html";
    }

    public String getFieldName() {
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        return object.toString();
    }

    public String getFieldType() {
        return this._typeCombo.getSelectedItem().toString();
    }

    static void mav$fillSuggestedNames(IntroduceFieldFromParamDialog introduceFieldFromParamDialog) {
        introduceFieldFromParamDialog.fillSuggestedNames();
    }

    static void wa$_userChangedName(IntroduceFieldFromParamDialog introduceFieldFromParamDialog, boolean bl) {
        introduceFieldFromParamDialog._userChangedName = bl;
    }

    public final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            IntroduceFieldFromParamDialog.mav$fillSuggestedNames(IntroduceFieldFromParamDialog.this);
        }
    }

    public final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            IntroduceFieldFromParamDialog.this.updateOKButton();
            IntroduceFieldFromParamDialog.wa$_userChangedName(IntroduceFieldFromParamDialog.this, true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            IntroduceFieldFromParamDialog.this.updateOKButton();
            IntroduceFieldFromParamDialog.wa$_userChangedName(IntroduceFieldFromParamDialog.this, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            IntroduceFieldFromParamDialog.this.updateOKButton();
            IntroduceFieldFromParamDialog.wa$_userChangedName(IntroduceFieldFromParamDialog.this, true);
        }
    }
}

