/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.introduce;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.introduce.IntroduceDialog;
import oracle.jdevimpl.refactoring.util.JotNaming;

public abstract class IntroduceVariableDialog
extends IntroduceDialog {
    private static final int PREF_FINAL = 1;
    private JComboBox _nameComponent;
    private JCheckBox _finalCheckbox;
    private DefaultListComboBoxModel _nameModel;
    private boolean _userChangedName;

    protected abstract String getTitle();

    protected abstract String getPreferenceKey();

    IntroduceVariableDialog(String string, Context context, SourceExpression sourceExpression, SourceElement[] sourceElementArray) {
        super(string, context, (SourceElement)sourceExpression, sourceElementArray);
    }

    protected final JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected final void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getVariableName();
            if (string2 != null) {
                if (string2.length() == 0) {
                    bl = false;
                } else {
                    String string3 = IntroduceVariableDialog.canIntroduceVariable(this._sourceElement, string2);
                    if (string3 != null) {
                        string = string3;
                        bl = false;
                    } else if (Character.isUpperCase(string2.charAt(0))) {
                        string = RefactoringArb.getString(67);
                    }
                }
                this.setMessage(string, bl);
                this.setOKButtonEnabled(bl);
            }
        }
    }

    private static String canIntroduceVariable(SourceElement sourceElement, String string) {
        String string2 = null;
        if (!IdeUtil.isJavaIdentifier((String)string)) {
            string2 = RefactoringArb.getString(68);
        } else if (IdeUtil.isJavaReservedWord((String)string)) {
            string2 = RefactoringArb.getString(68);
        } else if (!JotNaming.canIntroduceVariable(sourceElement, string)) {
            string2 = MessageFormat.format(RefactoringArb.getString(36), string);
        }
        return string2;
    }

    protected final void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.isFinal());
    }

    protected final void init() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(61));
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Component component = comboBoxEditor.getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            Document document = jTextField.getDocument();
            document.addDocumentListener(new 1());
        }
        JComboBox jComboBox = this.createTypeComponent();
        JLabel jLabel2 = null;
        if (jComboBox != null) {
            jLabel2 = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)jComboBox, (String)RefactoringArb.getString(60));
        }
        this._finalCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._finalCheckbox, (String)RefactoringArb.getString(278));
        int n = this.getOccurenceCount();
        if (n > 1) {
            this._replaceAll = new JCheckBox();
            String string = RefactoringArb.getString(62);
            String string2 = MessageFormat.format(string, Integer.toString(n));
            ResourceUtils.resButton((AbstractButton)this._replaceAll, (String)string2);
        }
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(this._finalCheckbox.getPreferredSize());
        this.setMessageLabel(jLabel3);
        CopyableInteger copyableInteger = this.getSettings();
        boolean bl = copyableInteger.isBitSet(1);
        this._finalCheckbox.setSelected(bl);
        Insets insets = new Insets(2, 2, 2, 2);
        if (jComboBox != null) {
            this.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
            this.add((Component)jComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        }
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._finalCheckbox, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        if (this._replaceAll != null) {
            this.add((Component)this._replaceAll, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        }
        this.add((Component)jLabel3, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    protected final void fillSuggestedNames() {
        JavaType javaType = this.getSelectedJavaType();
        JavaType javaType2 = javaType.isArray() ? javaType.getComponentType() : javaType;
        String string = javaType2.getRawName();
        List list = this.getVariableNames(string);
        String string2 = list.isEmpty() ? "" : list.get(0).toString();
        boolean bl = this._userChangedName;
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        this._nameModel.removeAllElements();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            this._nameModel.addElement(e);
            ++n;
        }
        Object object2 = bl ? object : string2;
        comboBoxEditor.setItem(object2);
        this._userChangedName = bl;
    }

    protected abstract List getVariableNames(String var1);

    public final String getVariableName() {
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        return object.toString();
    }

    public final boolean isFinal() {
        return this._finalCheckbox.isSelected();
    }

    static void wa$_userChangedName(IntroduceVariableDialog introduceVariableDialog, boolean bl) {
        introduceVariableDialog._userChangedName = bl;
    }

    public final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            IntroduceVariableDialog.this.updateOKButton();
            IntroduceVariableDialog.wa$_userChangedName(IntroduceVariableDialog.this, true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            IntroduceVariableDialog.this.updateOKButton();
            IntroduceVariableDialog.wa$_userChangedName(IntroduceVariableDialog.this, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            IntroduceVariableDialog.this.updateOKButton();
            IntroduceVariableDialog.wa$_userChangedName(IntroduceVariableDialog.this, true);
        }
    }
}

