/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

class MakeStaticCommand {
    private Context _context;
    private SourceMethod _sourceMethod;
    private String _parameterName;

    public MakeStaticCommand(Context context, SourceMethod sourceMethod, String string) {
        this._context = context;
        this._sourceMethod = sourceMethod;
        this._parameterName = string;
    }

    public Context getContext() {
        return this._context;
    }

    public boolean doRefactoring() {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        boolean bl = false;
        try {
            Collection collection = this.getAffectedProjects();
            JavaMember[] javaMemberArray = new JavaMember[]{this._sourceMethod};
            for (Project project : collection) {
                this.adaptCallers(project, javaMemberArray, refactoringCommandSupport);
            }
            this.adaptMethod(refactoringCommandSupport);
            refactoringCommandSupport.commit(this.getContext(), RefactoringArb.getString(277));
            bl = true;
        }
        catch (AbortedOperationException abortedOperationException) {
            refactoringCommandSupport.abort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    private Collection getAffectedProjects() {
        Context context = this.getContext();
        SourceFile sourceFile = this._sourceMethod.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        Project project = Util.getDefiningProject(context, uRL);
        HashSet hashSet = Util.getDependentProjects(context.getWorkspace(), project);
        return hashSet;
    }

    private void adaptMethod(RefactoringCommandSupport refactoringCommandSupport) {
        refactoringCommandSupport.beginTransaction((SourceElement)this._sourceMethod);
        if (this._parameterName != null) {
            JavaClass javaClass = this._sourceMethod.getOwningClass();
            List list = SourceElementAsList.asList((SourceElement)this._sourceMethod, 54);
            List list2 = SourceElementAsList.asList((SourceElement)this._sourceMethod, 58);
            SourceFactory sourceFactory = this._sourceMethod.getOwningSourceFile().getFactory();
            SourceTypeReference sourceTypeReference = sourceFactory.createType(javaClass.getQualifiedName());
            SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(sourceTypeReference, this._parameterName);
            SourceFormalParameterList sourceFormalParameterList = this._sourceMethod.getFormalParameterList();
            sourceLocalVariable.addSelf((SourceElement)sourceFormalParameterList);
            int n = 0;
            while (n < list.size()) {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)list.get(n);
                SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
                if (sourceExpression == null) {
                    List list3 = sourceMethodCallExpression.getChildren();
                    SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(this._parameterName);
                    list3.add(0, sourceSimpleNameExpression);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < list2.size()) {
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list2.get(n2);
                String string = sourceSimpleNameExpression.getText();
                if ("this".equals(string) || "super".equals(string)) {
                    SourceSimpleNameExpression sourceSimpleNameExpression2 = sourceFactory.createSimpleNameExpression(this._parameterName);
                    sourceSimpleNameExpression.replaceSelf((SourceElement)sourceSimpleNameExpression2);
                } else {
                    JavaField javaField;
                    int n3;
                    JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                    if (javaHasType != null && (n3 = javaHasType.getElementKind()) == 5 && !(javaField = (JavaField)javaHasType).isStatic()) {
                        SourceSimpleNameExpression sourceSimpleNameExpression3 = sourceFactory.createSimpleNameExpression(this._parameterName);
                        SourceDotExpression sourceDotExpression = sourceFactory.createDotReference((SourceExpression)sourceSimpleNameExpression3, string);
                        sourceSimpleNameExpression.replaceSelf((SourceElement)sourceDotExpression);
                    }
                }
                ++n2;
            }
        }
        this._sourceMethod.addModifiers(8);
    }

    private void adaptCallers(Project project, JavaMember[] javaMemberArray, RefactoringCommandSupport refactoringCommandSupport) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        FindMemberUsages findMemberUsages = new FindMemberUsages(javaMemberArray);
        findMemberUsages.findMemberUsages(project, new FindMemberUsages.FillListsUsageListener(arrayList2, arrayList, null));
        arrayList2.removeAll(Arrays.asList(javaMemberArray));
        if (arrayList2.isEmpty()) {
            int n = 0;
            while (n < arrayList.size()) {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)arrayList.get(n);
                this.adaptMethodCall(sourceMethodCallExpression, refactoringCommandSupport);
                ++n;
            }
        } else {
            SourceMethod sourceMethod = (SourceMethod)arrayList2.get(0);
            JavaClass javaClass = sourceMethod.getOwningClass();
            String string = javaClass.getQualifiedName();
            String string2 = MessageFormat.format(RefactoringArb.getString(283), string);
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)RefactoringArb.getString(277), null);
            throw new AbortedOperationException();
        }
    }

    private void adaptMethodCall(SourceMethodCallExpression sourceMethodCallExpression, RefactoringCommandSupport refactoringCommandSupport) {
        JavaClass javaClass = this._sourceMethod.getOwningClass();
        boolean bl = false;
        refactoringCommandSupport.beginTransaction((SourceElement)sourceMethodCallExpression);
        SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
        if (sourceExpression != null) {
            SourceSimpleNameExpression sourceSimpleNameExpression;
            String string;
            if (sourceExpression.getSymbolKind() == 58 && ("this".equals(string = (sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression).getText()) || "super".equals(string))) {
                bl = true;
            }
            if (bl) {
                sourceExpression.removeSelf();
            } else {
                boolean bl2 = true;
                SourceMember sourceMember = (SourceMember)Util.getAncestorOfClass(SourceMember.class, (SourceElement)sourceMethodCallExpression);
                JavaClass javaClass2 = sourceMember.getOwningClass();
                if (javaClass.equals((Object)javaClass2)) {
                    bl2 = false;
                }
                if (bl2) {
                    SourceFile sourceFile = sourceMethodCallExpression.getOwningSourceFile();
                    SourceFactory sourceFactory = sourceFile.getFactory();
                    String string2 = javaClass.getQualifiedName();
                    SourceExpression sourceExpression2 = sourceFactory.createExpression(string2);
                    sourceExpression.replaceSelf((SourceElement)sourceExpression2);
                } else {
                    sourceExpression.removeSelf();
                }
                if (this._parameterName != null) {
                    SourceListExpression sourceListExpression = sourceMethodCallExpression.getArgumentList();
                    sourceExpression.addSelf((SourceElement)sourceListExpression);
                }
            }
        } else if (this._parameterName != null) {
            SourceFile sourceFile = sourceMethodCallExpression.getOwningSourceFile();
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceSimpleNameExpression sourceSimpleNameExpression = Patch.contains((SourceElement)this._sourceMethod, (SourceElement)sourceMethodCallExpression) ? sourceFactory.createSimpleNameExpression(this._parameterName) : sourceFactory.createSimpleNameExpression("this");
            SourceListExpression sourceListExpression = sourceMethodCallExpression.getArgumentList();
            sourceSimpleNameExpression.addSelf((SourceElement)sourceListExpression);
        }
    }
}

