/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeFieldStaticFailedDialog;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeStaticCommand;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeStaticDialog;
import oracle.jdevimpl.refactoring.oprs.makestatic.NonStaticFieldUsageSource;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;

public class MakeStaticController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = this.handle(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean bl) {
        ElementAt elementAt;
        boolean bl2 = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            switch (elementAt.getElementType()) {
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    bl2 = MakeStaticController.handle(context, javaMethod, bl);
                    break;
                }
                case 4: {
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    bl2 = MakeStaticController.handle(context, javaField, bl);
                }
            }
        }
        return bl2;
    }

    public static boolean handle(Context context, JavaField javaField, boolean bl) {
        boolean bl2 = false;
        SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
        if (sourceFieldVariable != null && !sourceFieldVariable.isStatic() && Util.canRefactor((SourceElement)sourceFieldVariable)) {
            bl2 = true;
            if (bl) {
                MakeStaticController.whenHandle(context, sourceFieldVariable);
            }
        }
        return bl2;
    }

    public static boolean handle(Context context, JavaMethod javaMethod, boolean bl) {
        boolean bl2 = false;
        SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
        if (sourceMethod != null && !sourceMethod.isStatic() && (bl2 = Util.canRefactor((SourceElement)sourceMethod)) && bl) {
            MakeStaticController.whenHandle(context, javaMethod);
        }
        return bl2;
    }

    private static void whenHandle(Context context, JavaMethod javaMethod) {
        String string = null;
        if (javaMethod.isStatic()) {
            string = RefactoringArb.getString(279);
        } else if (javaMethod.isAbstract()) {
            string = RefactoringArb.getString(280);
        } else {
            JavaClass javaClass = javaMethod.getOwningClass();
            if (javaClass.getOwningClass() != null) {
                string = RefactoringArb.getString(281);
            } else {
                String string2 = MakeStaticController.getInheritedName(javaMethod);
                if (string2 == null) {
                    String string3;
                    SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                    boolean bl = false;
                    if (MakeStaticController.hasSelfUsages(sourceMethod)) {
                        string3 = MakeStaticController.getParameterName(context, sourceMethod);
                        if (string3 == null) {
                            bl = true;
                        }
                    } else {
                        string3 = null;
                    }
                    if (!bl) {
                        MakeStaticCommand makeStaticCommand = new MakeStaticCommand(context, sourceMethod, string3);
                        makeStaticCommand.doRefactoring();
                    }
                } else {
                    string = MessageFormat.format(RefactoringArb.getString(282), string2);
                }
            }
        }
        if (string != null) {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            JOptionPane.showMessageDialog((Component)ideMainWindow, string);
        }
    }

    private static String getParameterName(Context context, SourceMethod sourceMethod) {
        MakeStaticDialog makeStaticDialog = new MakeStaticDialog(context, sourceMethod);
        if (makeStaticDialog.runDialog()) {
            return makeStaticDialog.getVariableName();
        }
        return null;
    }

    private static boolean hasSelfUsages(SourceMethod sourceMethod) {
        List list = SourceElementAsList.asList((SourceElement)sourceMethod);
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(n);
            switch (sourceElement.getSymbolKind()) {
                case 54: {
                    JavaMethod javaMethod;
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
                    if (sourceExpression != null || (javaMethod = sourceMethodCallExpression.getResolvedMethod()).isStatic()) break;
                    return true;
                }
                case 58: {
                    JavaField javaField;
                    int n2;
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                    String string = sourceSimpleNameExpression.getText();
                    if ("this".equals(string) || "super".equals(string)) {
                        return true;
                    }
                    JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                    if (javaHasType == null || (n2 = javaHasType.getElementKind()) != 5 || (javaField = (JavaField)javaHasType).isStatic()) break;
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private static String getInheritedName(JavaMethod javaMethod) {
        JavaMethod javaMethod2;
        JavaClass javaClass = javaMethod.getOwningClass();
        String string = javaMethod.getName();
        JavaType[] javaTypeArray = javaMethod.getParameterTypes();
        JavaType javaType = javaClass.getSuperclass();
        if (javaType != null && (javaMethod2 = javaType.getMethod(string, javaTypeArray)) != null) {
            JavaClass javaClass2 = javaMethod2.getOwningClass();
            return javaClass2.getQualifiedName();
        }
        Collection collection = javaClass.getInterfaces();
        for (JavaType javaType2 : collection) {
            JavaMethod javaMethod3 = javaType2.getMethod(string, javaTypeArray);
            if (javaMethod3 == null) continue;
            JavaClass javaClass3 = javaMethod3.getOwningClass();
            return javaClass3.getQualifiedName();
        }
        return null;
    }

    private static void whenHandle(Context context, SourceFieldVariable sourceFieldVariable) {
        String string = null;
        JavaClass javaClass = sourceFieldVariable.getOwningClass();
        if (javaClass.getOwningClass() != null && !sourceFieldVariable.isFinal()) {
            string = RefactoringArb.getString(281);
        } else {
            NonStaticFieldUsageSource nonStaticFieldUsageSource = new NonStaticFieldUsageSource(context, sourceFieldVariable);
            if (nonStaticFieldUsageSource.doSearch()) {
                UsageModel usageModel = nonStaticFieldUsageSource.getUsageModel();
                if (usageModel.getUsageEntries().isEmpty()) {
                    nonStaticFieldUsageSource.doRefactoring();
                } else {
                    String string2 = javaClass.getQualifiedName();
                    String string3 = sourceFieldVariable.getName();
                    MakeFieldStaticFailedDialog makeFieldStaticFailedDialog = new MakeFieldStaticFailedDialog(string2 + "." + string3);
                    if (makeFieldStaticFailedDialog.runDialog()) {
                        if (makeFieldStaticFailedDialog.isIgnorePressed()) {
                            nonStaticFieldUsageSource.doRefactoring();
                        } else {
                            PreviewLogPage.showUsages(nonStaticFieldUsageSource);
                        }
                    }
                }
            }
        }
        if (string != null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)RefactoringArb.getString(277), null);
        }
    }
}

