/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.util.JotNaming;

public class MakeStaticDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MAKE_STATIC_DEFAULTS";
    protected static final int PREF_FINAL = 1;
    private JComboBox _nameComponent;
    private JCheckBox _finalCheckbox;
    private DefaultListComboBoxModel _nameModel;
    private SourceMethod _sourceMethod;

    protected String getTitle() {
        return RefactoringArb.getString(277);
    }

    public MakeStaticDialog(Context context, SourceMethod sourceMethod) {
        super(PREFERENCE_KEY, context);
        this._sourceMethod = sourceMethod;
        this.init();
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._nameComponent;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmakestatic_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getVariableName();
            if (string2 != null) {
                if (string2.length() == 0) {
                    bl = false;
                } else {
                    String string3 = MakeStaticDialog.canIntroduceVariable((SourceElement)this._sourceMethod, string2);
                    if (string3 != null) {
                        string = string3;
                        bl = false;
                    } else if (Character.isUpperCase(string2.charAt(0))) {
                        string = RefactoringArb.getString(67);
                    }
                }
                this.setMessage(string, bl);
                this.setOKButtonEnabled(bl);
            }
        }
    }

    private static String canIntroduceVariable(SourceElement sourceElement, String string) {
        String string2 = null;
        if (!IdeUtil.isJavaIdentifier((String)string)) {
            string2 = RefactoringArb.getString(68);
        } else if (IdeUtil.isJavaReservedWord((String)string)) {
            string2 = RefactoringArb.getString(68);
        } else if (!JotNaming.canIntroduceVariable(sourceElement, string)) {
            string2 = MessageFormat.format(RefactoringArb.getString(36), string);
        }
        return string2;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.isFinal());
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._nameModel = new DefaultListComboBoxModel();
        this._nameComponent = new JComboBox(this._nameModel);
        this._nameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._nameComponent, (String)RefactoringArb.getString(61));
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Component component = comboBoxEditor.getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            this.updateOnChanges(jTextField);
        }
        this._finalCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._finalCheckbox, (String)RefactoringArb.getString(278));
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(this._finalCheckbox.getPreferredSize());
        this.setMessageLabel(jLabel2);
        CopyableInteger copyableInteger = this.getSettings();
        boolean bl = copyableInteger.isBitSet(1);
        this._finalCheckbox.setSelected(bl);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._nameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._finalCheckbox, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this.fillSuggestedNames();
    }

    protected void fillSuggestedNames() {
        JavaClass javaClass = this._sourceMethod.getOwningClass();
        String string = javaClass.getName();
        List list = JotNaming.suggestNamesFromCamelWord(string);
        this._nameModel.removeAllElements();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            this._nameModel.addElement(e);
            ++n;
        }
    }

    public String getVariableName() {
        ComboBoxEditor comboBoxEditor = this._nameComponent.getEditor();
        Object object = comboBoxEditor.getItem();
        return object.toString();
    }

    public boolean isFinal() {
        return this._finalCheckbox.isSelected();
    }
}

