/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.makestatic;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

class NonStaticFieldUsageSource
implements UsageSource {
    private Context _context;
    private SourceFieldVariable _sourceFieldVariable;
    private UsageModel _nonStaticUsageModel;
    private UsageModel _staticUsageModel;

    public NonStaticFieldUsageSource(Context context, SourceFieldVariable sourceFieldVariable) {
        this._context = context;
        this._sourceFieldVariable = sourceFieldVariable;
    }

    public boolean canSearch() {
        return true;
    }

    public boolean doRefactoring() {
        boolean bl = false;
        JavaClass javaClass = this._sourceFieldVariable.getOwningClass();
        String string = javaClass.getQualifiedName();
        String string2 = this._sourceFieldVariable.getName();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            refactoringCommandSupport.beginTransaction((SourceElement)this._sourceFieldVariable);
            this._sourceFieldVariable.addModifiers(8);
            UsageModel usageModel = this._staticUsageModel;
            ArrayList arrayList = usageModel.getUsageEntries();
            int n = 0;
            while (n < arrayList.size()) {
                SourceDotExpression sourceDotExpression;
                SourceExpression sourceExpression;
                UsageEntry usageEntry = (UsageEntry)arrayList.get(n);
                if (usageEntry.isIncluded() && (sourceExpression = (SourceExpression)usageEntry.getUserObject()).getSymbolKind() == 50 && !this.contains((SourceElement)(sourceDotExpression = (SourceDotExpression)sourceExpression), (byte)54)) {
                    SourceFile sourceFile = sourceDotExpression.getOwningSourceFile();
                    refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                    SourceFactory sourceFactory = sourceFile.getFactory();
                    SourceExpression sourceExpression2 = sourceFactory.createExpression(string + "." + string2);
                    sourceDotExpression.replaceSelf((SourceElement)sourceExpression2);
                }
                ++n;
            }
            refactoringCommandSupport.commit(this._context, RefactoringArb.getString(275));
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    public boolean doSearch() {
        SourceFile sourceFile = this._sourceFieldVariable.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        Project project = Util.getDefiningProject(this._context, uRL);
        HashSet hashSet = Util.getDependentProjects(this._context.getWorkspace(), project);
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)this._sourceFieldVariable);
        UsageModel usageModel = new UsageModel();
        UsageModel usageModel2 = new UsageModel();
        for (Project project2 : hashSet) {
            ArrayList arrayList = new ArrayList();
            findMemberUsages.findMemberUsages(project2, new FindMemberUsages.FillListsUsageListener(null, null, arrayList));
            int n = 0;
            while (n < arrayList.size()) {
                SourceExpression sourceExpression = (SourceExpression)arrayList.get(n);
                UsageEntry usageEntry = new UsageEntry(project2, (SourceElement)sourceExpression, 0, 2);
                usageEntry.setUserObject(sourceExpression);
                UsageModel usageModel3 = Util.isStaticContext(sourceExpression) ? usageModel2 : usageModel;
                usageModel3.addUsageEntry(usageEntry);
                ++n;
            }
        }
        this.setUsageModel(usageModel);
        this.setStaticUsageModel(usageModel2);
        return true;
    }

    private void setUsageModel(UsageModel usageModel) {
        this._nonStaticUsageModel = usageModel;
    }

    public UsageModel getUsageModel() {
        return this._nonStaticUsageModel;
    }

    public Context getContext() {
        return this._context;
    }

    public String getShortTitle() {
        return RefactoringArb.getString(275);
    }

    public String getLongTitle() {
        return MessageFormat.format(RefactoringArb.getString(276), this._sourceFieldVariable.getOwningClass().getQualifiedName() + "." + this._sourceFieldVariable.getName());
    }

    private void setStaticUsageModel(UsageModel usageModel) {
        this._staticUsageModel = usageModel;
    }

    public UsageModel getStaticUsageModel() {
        return this._staticUsageModel;
    }

    private boolean contains(SourceElement sourceElement, byte by) {
        if (sourceElement.getSymbolKind() == by) {
            return true;
        }
        List list = sourceElement.getChildren();
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement2 = (SourceElement)list.get(n);
            if (this.contains(sourceElement2, by)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

