/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Pair;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.MetParam;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigTableModel;
import oracle.jdevimpl.refactoring.oprs.metsig.ParamTable;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class MetSigDialog
extends BaseDialog
implements VetoableChangeListener,
ListSelectionListener,
ActionListener {
    private static final String PREFERENCE_KEY = "PREF_METSIG";
    private static int PREF_ADD_TASKS = 1;
    private SourceMethod _sourceMethod;
    private JTextField _nameField;
    private JTextField _typeField;
    private JButton _typeBrowse;
    private JComboBox _accessField;
    private JTable _paramTable;
    private JButton _moveUp;
    private JButton _moveDown;
    private JButton _add;
    private JButton _remove;
    private MetSigTableModel _paramTableModel;
    private JavaProvider _javaProvider;
    private CallerContext _callerContext;
    private JCheckBox _addTasks;
    private boolean _replace;

    public MetSigDialog(Context context, SourceMethod sourceMethod) {
        super(PREFERENCE_KEY, context);
        this._sourceMethod = sourceMethod;
        SourceFile sourceFile = this._sourceMethod.getOwningSourceFile();
        this._javaProvider = sourceFile.getProvider();
        this._callerContext = CallerContext.createContext((SourceElement)this._sourceMethod);
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(600, 400));
        Insets insets = new Insets(2, 2, 2, 2);
        JLabel jLabel = new JLabel();
        this._nameField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._nameField, (String)RefactoringArb.getString(197));
        this.updateOnChanges(this._nameField);
        JLabel jLabel2 = new JLabel();
        this._typeField = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._typeField, (String)RefactoringArb.getString(251));
        this.updateOnChanges(this._typeField);
        this._typeBrowse = new JButton("...");
        this._typeBrowse.addActionListener(this);
        JLabel jLabel3 = new JLabel();
        this._accessField = new JComboBox<String>(new String[]{"public", "protected", "package private", "private"});
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._accessField, (String)RefactoringArb.getString(252));
        String string = this._sourceMethod.getName();
        this._nameField.setText(string);
        SourceTypeReference sourceTypeReference = this._sourceMethod.getSourceReturnType();
        JavaType javaType = sourceTypeReference.getResolvedType();
        String string2 = javaType == null ? sourceTypeReference.getName() : javaType.getQualifiedName();
        this._typeField.setText(string2);
        this._accessField.setSelectedIndex(this._sourceMethod.isProtected() ? 1 : (this._sourceMethod.isPackagePrivate() ? 2 : (this._sourceMethod.isPrivate() ? 3 : 0)));
        this._paramTableModel = new MetSigTableModel();
        this._paramTableModel.setMethod(this._sourceMethod);
        this._paramTable = new ParamTable(this._sourceMethod, this._paramTableModel);
        this._paramTable.getSelectionModel().addListSelectionListener(this);
        this._moveUp = new JButton();
        this._moveUp.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._moveUp, (String)RefactoringArb.getString(253));
        this._moveDown = new JButton();
        this._moveDown.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._moveDown, (String)RefactoringArb.getString(254));
        this._add = new JButton();
        this._add.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._add, (String)RefactoringArb.getString(255));
        this._remove = new JButton();
        this._remove.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._remove, (String)RefactoringArb.getString(256));
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RefactoringArb.getString(257));
        jPanel.setBorder(titledBorder);
        JScrollPane jScrollPane = new JScrollPane(this._paramTable);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 17, 1, insets, 0, 0));
        jPanel.add((Component)this._moveUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._moveDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._add, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._remove, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        if (this._paramTableModel.getRowCount() > 0) {
            this.setSelectedRow(0);
        }
        this._paramTableModel.addTableModelListener(new 2());
        this._addTasks = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._addTasks, (String)RefactoringArb.getString(258));
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(this._nameField.getPreferredSize());
        this.setMessageLabel(jLabel4);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._typeField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._typeBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        JavaClass javaClass = this._sourceMethod.getOwningClass();
        if (!javaClass.isInterface()) {
            this.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)this._accessField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        }
        this.add((Component)jPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._addTasks, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, 9, 3, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        this.setDefaults();
        this.updateButtons();
    }

    private void setDefaults() {
        CopyableInteger copyableInteger = this.getSettings();
        this._addTasks.setSelected(copyableInteger.isBitSet(PREF_ADD_TASKS));
    }

    protected JComponent getDefaultFocusedComponent() {
        int n = this._paramTable.getRowCount();
        if (n == 0) {
            return this._nameField;
        }
        return this._paramTable;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(PREF_ADD_TASKS, this._addTasks.isSelected());
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dchangemethod_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(154);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            SourceFile sourceFile;
            String string;
            String string2 = this._nameField.getText();
            NameValidation nameValidation = NameValidation.validateMethodName(string2, true);
            boolean bl = nameValidation.isValid();
            String string3 = nameValidation.getMessage();
            if (bl) {
                int n = this._paramTableModel.getRowCount();
                int n2 = 0;
                while (bl && n2 < n) {
                    String string4 = this._paramTableModel.getStringAt(n2, 1);
                    int n3 = n2 + 1;
                    while (bl && n3 < n) {
                        String string5 = this._paramTableModel.getStringAt(n3, 1);
                        if (string4.equals(string5)) {
                            bl = false;
                            string3 = RefactoringArb.getString(259) + string5;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            if (bl && !MetSigDialog.isValidTypeName(string = this._typeField.getText(), sourceFile = this._sourceMethod.getOwningSourceFile())) {
                bl = false;
            }
            this.setMessage(string3, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        boolean bl;
        if (propertyChangeEvent.getPropertyName().equals("closed") && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !(bl = this.canClose())) {
            throw new PropertyVetoException("", propertyChangeEvent);
        }
    }

    public void setDlg(JEWTDialog jEWTDialog) {
        super.setDlg(jEWTDialog);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private boolean canClose() {
        boolean bl;
        SourceFile sourceFile;
        String string;
        this.stopEditing();
        JComponent jComponent = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        String string3 = this._nameField.getText();
        if (!IdeUtil.isJavaIdentifier((String)string3)) {
            string2 = RefactoringArb.getString(71);
            jComponent = this._nameField;
        }
        if (string2 == null && !MetSigDialog.isValidTypeName(string = this._typeField.getText(), sourceFile = this._sourceMethod.getOwningSourceFile())) {
            string2 = RefactoringArb.getString(260);
            jComponent = this._typeField;
        }
        String[] stringArray = null;
        if (string2 == null) {
            int n3 = this._paramTableModel.getRowCount();
            stringArray = new String[n3];
            int n4 = 0;
            while (string2 == null && n4 < n3) {
                Pair pair = this.isValidParameterRow(n4);
                if (pair != null) {
                    this.setSelectedRow(n4);
                    string2 = pair.first.toString();
                    n = n4;
                    n2 = (Integer)pair.second;
                    jComponent = this._paramTable;
                } else {
                    stringArray[n4] = this._paramTableModel.getStringAt(n4, 0);
                }
                ++n4;
            }
        }
        JavaMethod javaMethod = null;
        if (string2 == null) {
            SourceClass sourceClass;
            JavaMethod javaMethod2;
            boolean bl2 = true;
            JavaType[] javaTypeArray = new JavaType[stringArray.length];
            int n5 = 0;
            while (bl2 && n5 < stringArray.length) {
                String string4 = stringArray[n5];
                JavaType javaType = MetSigDialog.resolveType(this._javaProvider, this._callerContext, string4);
                if (javaType != null) {
                    javaTypeArray[n5] = javaType;
                } else {
                    bl2 = false;
                }
                ++n5;
            }
            if (bl2 && (javaMethod2 = (sourceClass = this._sourceMethod.getEnclosingClass()).getMethod(string3, javaTypeArray)) != null && !this._sourceMethod.equals(javaMethod2) && this._sourceMethod.isStatic() == javaMethod2.isStatic()) {
                javaMethod = javaMethod2;
            }
        }
        if (string2 != null) {
            bl = false;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)this.getTitle(), null);
            JTextField jTextField = jComponent;
            int n6 = n;
            int n7 = n2;
            SwingUtilities.invokeLater(new 1(this, jTextField, n6, n7));
        } else {
            bl = true;
            if (javaMethod != null) {
                String string5 = MessageFormat.format(RefactoringArb.getString(261), Util.getFullMethodName(javaMethod, true, true, false), Util.getFullMethodName((JavaMethod)this._sourceMethod, true, false, false), Util.getFullMethodName(javaMethod, true, false, false));
                boolean bl3 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string5, (String)this.getTitle(), (String)"f1_jrf_dchangemethodreplace_html", (boolean)true);
                if (bl3) {
                    this._replace = true;
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    static JavaType resolveType(JavaProvider javaProvider, CallerContext callerContext, String string) {
        int n;
        String string2 = string.replaceAll("[\\[\\]]", "");
        JavaType javaType = callerContext.resolveTypeName(string2);
        int n2 = 0;
        while ((n = string.indexOf(91)) != -1) {
            string = string.substring(n + 1);
            ++n2;
        }
        JavaType javaType2 = javaProvider.getArrayType(javaType, n2);
        return javaType2;
    }

    static boolean isValidTypeName(String string, SourceFile sourceFile) {
        boolean bl = false;
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceTypeReference sourceTypeReference = sourceFactory.createTypeFromText(string);
        if (sourceTypeReference != null) {
            bl = true;
        }
        return bl;
    }

    private Pair isValidParameterRow(int n) {
        SourceFile sourceFile;
        String string = this._paramTableModel.getStringAt(n, 1);
        if (!IdeUtil.isJavaIdentifier((String)string)) {
            return new Pair((Object)RefactoringArb.getString(68), (Object)new Integer(1));
        }
        String string2 = this._paramTableModel.getStringAt(n, 0);
        if (!MetSigDialog.isValidTypeName(string2, sourceFile = this._sourceMethod.getOwningSourceFile())) {
            return new Pair((Object)RefactoringArb.getString(68), (Object)new Integer(0));
        }
        SourceVariable sourceVariable = this._paramTableModel.getVariableAt(n);
        if (sourceVariable == null) {
            String string3 = this._paramTableModel.getStringAt(n, 2);
            if (!ModelUtil.hasLength((String)string3)) {
                String string4 = MessageFormat.format(RefactoringArb.getString(262), string);
                return new Pair((Object)string4, (Object)new Integer(2));
            }
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceExpression sourceExpression = sourceFactory.createExpression(string3);
            if (sourceExpression == null) {
                String string5 = MessageFormat.format(RefactoringArb.getString(263), string);
                return new Pair((Object)string5, (Object)new Integer(2));
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._typeBrowse) {
            this.whenBrowse();
        } else if (object == this._moveUp) {
            this.whenMoveUp();
        } else if (object == this._moveDown) {
            this.whenMoveDown();
        } else if (object == this._add) {
            this.whenAdd();
        } else if (object == this._remove) {
            this.whenRemove();
        }
    }

    private void whenBrowse() {
        String string = this._typeField.getText();
        String string2 = string.replaceAll("[\\[\\]]", "");
        JavaType javaType = this._callerContext.resolveTypeName(string2);
        String string3 = javaType != null ? javaType.getQualifiedName() : string;
        String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.getContext().getProject(), 2, false, null, string3);
        if (stringArray != null && stringArray.length == 1) {
            this._typeField.setText(stringArray[0]);
        }
    }

    private void whenMoveUp() {
        int n = this._paramTable.getSelectedRow();
        this.stopEditing();
        this._paramTableModel.moveRow(n, n, n - 1);
        this.setSelectedRow(n - 1);
    }

    private void whenMoveDown() {
        int n = this._paramTable.getSelectedRow();
        this.stopEditing();
        this._paramTableModel.moveRow(n, n, n + 1);
        this.setSelectedRow(n + 1);
    }

    private void stopEditing() {
        TableCellEditor tableCellEditor = this._paramTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void whenAdd() {
        boolean bl = false;
        int n = this._paramTableModel.getRowCount();
        int n2 = 0;
        while (!bl && n2 < n) {
            if (this._paramTableModel.getStringAt(n2, 1).length() == 0 || this._paramTableModel.getStringAt(n2, 0).length() == 0) {
                this.setSelectedRow(n2);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            int n3 = this._paramTable.getSelectedRow();
            this._paramTableModel.addRow(n3 + 1);
            this.setSelectedRow(n3 + 1);
            this._paramTable.requestFocus();
            this._paramTable.editCellAt(n3 + 1, 0);
        }
    }

    private void whenRemove() {
        int n = this._paramTable.getSelectedRow();
        SourceVariable sourceVariable = this._paramTableModel.getVariableAt(n);
        boolean bl = true;
        if (sourceVariable != null && MetSigDialog.isUsed((SourceElement)this._sourceMethod, sourceVariable)) {
            int n2 = JOptionPane.showConfirmDialog(this, RefactoringArb.getString(264), RefactoringArb.getString(154), 0, 3);
            boolean bl2 = bl = n2 == 0;
        }
        if (bl) {
            this._paramTableModel.removeRow(n);
            if (n <= this._paramTableModel.getRowCount()) {
                --n;
            }
            if (n >= 0) {
                this.setSelectedRow(n);
            }
        }
    }

    private static boolean isUsed(SourceElement sourceElement, SourceVariable sourceVariable) {
        SourceExpression sourceExpression;
        JavaHasType javaHasType;
        if (sourceElement instanceof SourceExpression && sourceVariable.equals(javaHasType = (sourceExpression = (SourceExpression)sourceElement).getResolvedObject())) {
            return true;
        }
        List list = sourceElement.getChildren();
        int n = 0;
        while (n < list.size()) {
            SourceElement sourceElement2 = (SourceElement)list.get(n);
            if (MetSigDialog.isUsed(sourceElement2, sourceVariable)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void setSelectedRow(int n) {
        ListSelectionModel listSelectionModel = this._paramTable.getSelectionModel();
        listSelectionModel.setSelectionInterval(n, n);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void updateButtons() {
        int n = this._paramTable.getSelectedRow();
        this._moveUp.setEnabled(n > 0);
        this._moveDown.setEnabled(0 <= n && n < this._paramTableModel.getRowCount() - 1);
        this._remove.setEnabled(n >= 0);
    }

    public ChangeMethodCriteria getOperation() {
        ArrayList<MetParam> arrayList = new ArrayList<MetParam>();
        int n = this._paramTableModel.getRowCount();
        ArrayList arrayList2 = new ArrayList(this._sourceMethod.getParameters());
        int n2 = 0;
        while (n2 < n) {
            SourceVariable sourceVariable = this._paramTableModel.getVariableAt(n2);
            String string = this._paramTableModel.getStringAt(n2, 0);
            String string2 = this._paramTableModel.getStringAt(n2, 1);
            if (sourceVariable != null) {
                int n3 = arrayList2.indexOf(sourceVariable);
                SourceTypeReference sourceTypeReference = sourceVariable.getSourceType();
                String string3 = !ChangeMethodCriteria.isSameType(sourceTypeReference, string) ? string : null;
                String string4 = sourceVariable.getName();
                String string5 = string4.equals(string2) ? null : string2;
                MetParam metParam = new MetParam(n3, string3, string5, null);
                arrayList.add(metParam);
            } else if (string2.length() != 0) {
                String string6 = this._paramTableModel.getStringAt(n2, 2);
                MetParam metParam = new MetParam(-1, string, string2, string6);
                arrayList.add(metParam);
            }
            ++n2;
        }
        MetParam[] metParamArray = arrayList.toArray(new MetParam[arrayList.size()]);
        ChangeMethodCriteria changeMethodCriteria = new ChangeMethodCriteria(this._sourceMethod, metParamArray);
        String string = this._nameField.getText();
        changeMethodCriteria.setNewMethodName(string);
        String string7 = this._typeField.getText();
        changeMethodCriteria.setNewReturnType(string7);
        String string8 = this._accessField.getSelectedItem().toString();
        int n4 = string8 == "public" ? 1 : (string8 == "protected" ? 4 : (string8 == "private" ? 2 : 0));
        changeMethodCriteria.setAccessibility(n4);
        changeMethodCriteria.setUseTaks(this._addTasks.isSelected());
        changeMethodCriteria.setUseExistingMethod(this._replace);
        return changeMethodCriteria;
    }

    static JTable ra$_paramTable(MetSigDialog metSigDialog) {
        return metSigDialog._paramTable;
    }

    public final class 2
    implements TableModelListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
            MetSigDialog.this.updateOKButton();
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ JComponent v$componentToFocus;
        private final /* synthetic */ int v$epr;
        private final /* synthetic */ int v$epc;
        final /* synthetic */ MetSigDialog this$0;

        public void run() {
            this.v$componentToFocus.requestFocus();
            if (this.v$epr != -1) {
                MetSigDialog.ra$_paramTable(this.this$0).editCellAt(this.v$epr, this.v$epc);
            }
        }

        public 1(MetSigDialog metSigDialog, JComponent jComponent, int n, int n2) {
            this.v$epc = n2;
            this.v$epr = n;
            this.v$componentToFocus = jComponent;
            this.this$0 = metSigDialog;
        }
    }
}

