/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.metsig;

import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.util.IdeUtil;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigDialog;
import oracle.jdevimpl.refactoring.oprs.metsig.NameDocumentListener;
import oracle.jdevimpl.refactoring.oprs.metsig.TypeDocumentListener;

class ParamTable
extends NiceTable {
    private TypeDocumentListener _typeDocumentListener;
    private NameDocumentListener _nameDocumentListener;
    private JavaProvider _javaProvider;
    private CallerContext _callerContext;
    private SourceFile _owningSourceFile;

    public ParamTable(SourceMethod sourceMethod, TableModel tableModel) {
        super(tableModel);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this._typeDocumentListener = new TypeDocumentListener(sourceMethod);
        this._nameDocumentListener = new NameDocumentListener(sourceMethod);
        SourceFile sourceFile = this._owningSourceFile = sourceMethod.getOwningSourceFile();
        this._javaProvider = sourceFile.getProvider();
        this._callerContext = CallerContext.createContext((SourceElement)sourceMethod);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = super.getCellEditor(n, n2);
        this._typeDocumentListener.detachFromEditor(tableCellEditor);
        this._nameDocumentListener.detachFromEditor(tableCellEditor);
        switch (n2) {
            case 0: {
                this._typeDocumentListener.attachToEditor(tableCellEditor);
                break;
            }
            case 1: {
                this._nameDocumentListener.attachToEditor(tableCellEditor);
            }
        }
        return tableCellEditor;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        switch (n2) {
            case 0: {
                String string;
                JLabel jLabel = (JLabel)component;
                String string2 = jLabel.getText();
                boolean bl = false;
                if (MetSigDialog.isValidTypeName(string2, this._owningSourceFile)) {
                    JavaType javaType = MetSigDialog.resolveType(this._javaProvider, this._callerContext, string2);
                    if (javaType != null) {
                        bl = true;
                        string = javaType.getQualifiedName();
                    } else {
                        string = string2;
                    }
                } else {
                    string = MessageFormat.format("Invalid type name: {0}", string2);
                }
                this.setApparence(jLabel, n, n2, bl, string);
                break;
            }
            case 1: {
                String string;
                JLabel jLabel = (JLabel)component;
                String string3 = jLabel.getText();
                boolean bl = false;
                if (IdeUtil.isJavaIdentifier((String)string3)) {
                    string = string3;
                    bl = true;
                } else {
                    string = RefactoringArb.getString(68);
                }
                this.setApparence(jLabel, n, n2, bl, string);
                break;
            }
            default: {
                if (!(component instanceof JComponent)) break;
                JComponent jComponent = (JComponent)component;
                jComponent.setToolTipText(null);
            }
        }
        return component;
    }

    private void setApparence(JLabel jLabel, int n, int n2, boolean bl, String string) {
        boolean bl2;
        Color color = bl ? ((bl2 = this.isCellSelected(n, n2)) ? UIManager.getColor("Table.selectionForeground") : UIManager.getColor("Table.foreground")) : Color.RED;
        jLabel.setToolTipText(string);
        jLabel.setForeground(color);
    }
}

