/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;

public class MoveClassesOperation
extends SearchOperationImpl {
    public MoveClassesOperation(Context context, MoveClassesCriteria moveClassesCriteria) {
        super(context, moveClassesCriteria);
    }

    public boolean runRefactoring(boolean bl) {
        boolean bl2 = false;
        if (!this.urlsAlreadyExist()) {
            bl2 = super.runRefactoring(bl);
        }
        return bl2;
    }

    private boolean urlsAlreadyExist() {
        boolean bl = false;
        MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)this.getCriteria();
        URL uRL = moveClassesCriteria.getOverwrittenUrl();
        if (uRL != null) {
            String string = MessageFormat.format(RefactoringArb.getString(36), URLFileSystem.getPlatformPathName((URL)uRL));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)moveClassesCriteria.getShortTitle(), null);
            bl = true;
        }
        return bl;
    }

    protected void applyResults() throws Exception {
        super.applyResults();
        MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)this.getCriteria();
        MoveFilesCommand moveFilesCommand = new MoveFilesCommand(this.getContext(), moveClassesCriteria);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.invoke((Command)moveFilesCommand);
    }

    private static class MoveFilesCommand
    extends Command {
        private ArrayList _createDirectories;
        private URL[] _oldUrls;
        private URL[] _newUrls;
        private ArrayList _deletedDirectories;
        private URL[][] _movedDirectories;
        private MoveClassesCriteria _moveClassesCriteria;

        public MoveFilesCommand(Context context, MoveClassesCriteria moveClassesCriteria) {
            super(-1, 3, "noname");
            this.context = context;
            this._moveClassesCriteria = moveClassesCriteria;
            this._movedDirectories = this._moveClassesCriteria.getMovedDirectories();
            this._oldUrls = this._moveClassesCriteria.getOldUrls();
            this._newUrls = new URL[this._oldUrls.length];
            int n = 0;
            while (n < this._oldUrls.length) {
                URL uRL = this._oldUrls[n];
                this._newUrls[n] = this._moveClassesCriteria.getNewUrlFor(uRL);
                ++n;
            }
        }

        /*
         * Unable to fully structure code
         */
        public int doit() throws Exception {
            block11: {
                try {
                    this._createDirectories = new ArrayList<E>();
                    this._deletedDirectories = new ArrayList<E>();
                    this._movedDirectories = this._moveClassesCriteria.getMovedDirectories();
                    var1_1 = 0;
                    while (var1_1 < this._movedDirectories.length) {
                        var2_2 = this._movedDirectories[var1_1][1];
                        if (!URLFileSystem.exists((URL)var2_2) && URLFileSystem.mkdir((URL)var2_2)) {
                            this._createDirectories.add(var2_2);
                        }
                        ++var1_1;
                    }
                    var3_3 = 0;
                    while (var3_3 < this._oldUrls.length) {
                        var4_4 = this._oldUrls[var3_3];
                        if (URLFileSystem.exists((URL)var4_4) && !URLFileSystem.renameTo((URL)var4_4, (URL)(var5_5 = this._newUrls[var3_3]))) {
                            throw new Exception("Failed to move " + URLFileSystem.getPlatformPathName((URL)var4_4) + " to " + URLFileSystem.getPlatformPathName((URL)var5_5));
                        }
                        ++var3_3;
                    }
                    var6_6 = this._movedDirectories.length - 1;
                    while (var6_6 >= 0) {
                        var7_7 = this._movedDirectories[var6_6][0];
                        var8_8 = URLFileSystem.list((URL)var7_7);
                        if (var8_8 != null && var8_8.length == 0 && URLFileSystem.delete((URL)var7_7)) {
                            this._deletedDirectories.add(var7_7);
                        }
                        --var6_6;
                    }
                    break block11;
                }
                catch (Exception var9_9) {
                    var10_10 = var9_9.getMessage();
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)var10_10, (String)this._moveClassesCriteria.getShortTitle(), null);
                    var11_11 = 0;
                    ** while (var11_11 < this._oldUrls.length)
                }
lbl-1000:
                // 1 sources

                {
                    var12_12 = this._oldUrls[var11_11];
                    var13_13 = this._newUrls[var11_11];
                    if (!URLFileSystem.exists((URL)var12_12)) {
                        var14_14 = URLFileSystem.getParent((URL)var12_12);
                        URLFileSystem.mkdirs((URL)var14_14);
                        URLFileSystem.renameTo((URL)var13_13, (URL)var12_12);
                    }
                    ++var11_11;
                    continue;
                }
lbl45:
                // 1 sources

                var15_15 = 0;
                while (var15_15 < this._createDirectories.size()) {
                    var16_16 = (URL)this._createDirectories.get(var15_15);
                    URLFileSystem.delete((URL)var16_16);
                    ++var15_15;
                }
                throw var9_9;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int undo() throws Exception {
            try {
                int n;
                Exception exception2;
                int n2 = this._deletedDirectories.size() - 1;
                while (true) {
                    if (n2 < 0) {
                        try {
                            int n3;
                            int n4 = 0;
                            while (true) {
                                URL uRL;
                                if (n4 >= this._oldUrls.length) {
                                    n3 = this._createDirectories.size() - 1;
                                    break;
                                }
                                URL uRL2 = this._newUrls[n4];
                                if (URLFileSystem.exists((URL)uRL2) && !URLFileSystem.renameTo((URL)uRL2, (URL)(uRL = this._oldUrls[n4]))) {
                                    throw new Exception("Failed to move " + URLFileSystem.getPlatformPathName((URL)uRL2) + " to " + URLFileSystem.getPlatformPathName((URL)uRL));
                                }
                                ++n4;
                            }
                            while (n3 >= 0) {
                                URL uRL = (URL)this._createDirectories.get(n3);
                                URLFileSystem.delete((URL)uRL);
                                --n3;
                            }
                            return 0;
                        }
                        catch (Exception exception2) {
                            n = 0;
                            break;
                        }
                    }
                    URL uRL = (URL)this._deletedDirectories.get(n2);
                    if (!URLFileSystem.exists((URL)uRL) && !URLFileSystem.mkdir((URL)uRL)) {
                        throw new Exception("Failed to recreate " + URLFileSystem.getPlatformPathName((URL)uRL));
                    }
                    --n2;
                }
                while (true) {
                    if (n >= this._oldUrls.length) {
                        throw exception2;
                    }
                    URL uRL = this._oldUrls[n];
                    URL uRL3 = this._newUrls[n];
                    if (!URLFileSystem.exists((URL)uRL3)) {
                        URL uRL4 = URLFileSystem.getParent((URL)uRL3);
                        URLFileSystem.mkdirs((URL)uRL4);
                        URLFileSystem.renameTo((URL)uRL, (URL)uRL3);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)this._moveClassesCriteria.getShortTitle(), null);
                throw exception;
            }
        }

        public Node[] getAffectedNodes() {
            return new Node[0];
        }
    }
}

