/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesDialog;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveInnerDialog;
import oracle.jdevimpl.refactoring.oprs.move.MoveInnerOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveSecondaryClassDialog;
import oracle.jdevimpl.refactoring.oprs.move.MoveSecondaryOperation;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMemberController;
import oracle.jdevimpl.refactoring.oprs.movemember.movestatic.MoveStaticOperation;

public class MoveController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            if (context.getView() instanceof NavigatorWindow) {
                return MoveController.updateFromNavigator(ideAction, context);
            }
            ElementAt elementAt = ElementAt.findElementAt(context);
            int n = elementAt != null ? elementAt.getElementType() : -1;
            switch (n) {
                case 1: {
                    SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                    if (sourceClass == null) break;
                    bl = MoveController.canMoveClass(context, sourceClass);
                    break;
                }
                case 3: {
                    SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                    if (sourceMethod == null) break;
                    if (sourceMethod.isStatic()) {
                        bl = MoveController.canMoveStaticMember(context, (SourceMember)sourceMethod);
                        break;
                    }
                    bl = MoveInstanceMemberController.canMoveMember(context, sourceMethod);
                    break;
                }
                case 4: {
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)elementAt.getSourceElement();
                    if (sourceFieldVariable == null) break;
                    bl = MoveController.canMoveStaticMember(context, (SourceMember)sourceFieldVariable);
                    break;
                }
                case 6: {
                    JavaPackage javaPackage = elementAt.getJavaPackage();
                    if (javaPackage == null) break;
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        ideAction.setEnabled(bl);
        return true;
    }

    private static boolean canMoveSourceNode(Context context, JavaSourceNode javaSourceNode) {
        SourceClass sourceClass;
        boolean bl = false;
        Project project = context.getProject();
        URL uRL = javaSourceNode.getURL();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(uRL);
        if (sourceFile != null && (sourceClass = sourceFile.getSourcePrimaryClass()) != null) {
            bl = MoveController.canMoveClass(context, sourceClass);
        }
        return bl;
    }

    public static boolean canMoveClass(Context context, SourceClass sourceClass) {
        boolean bl = false;
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        if (Util.canRefactor(context, uRL)) {
            bl = true;
        }
        return bl;
    }

    private static boolean verifyMovePackage(JavaPackage javaPackage, Context context) {
        return MoveController.checkCanRefactorPackage(context, javaPackage, RefactoringArb.getString(242));
    }

    public static boolean checkCanRefactorPackage(Context context, JavaPackage javaPackage, String string) {
        boolean bl = true;
        Collection collection = javaPackage.getDeclaredClasses();
        Iterator iterator = collection.iterator();
        while (bl && iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
            if (sourceClass == null) continue;
            if (Util.isClassInSources(context.getWorkspace(), context.getProject(), sourceClass)) {
                SourceFile sourceFile = sourceClass.getOwningSourceFile();
                URL uRL = sourceFile.getURL();
                if (Util.canRefactor(uRL)) continue;
                String string2 = MessageFormat.format(RefactoringArb.getString(243), URLFileSystem.getPlatformPathName((URL)uRL));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)string, null);
                bl = false;
                continue;
            }
            String string3 = MessageFormat.format(RefactoringArb.getString(243), javaClass.getQualifiedName());
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string3, (String)string, null);
            bl = false;
        }
        Collection collection2 = javaPackage.getPackages();
        Iterator iterator2 = collection2.iterator();
        while (bl && iterator2.hasNext()) {
            JavaPackage javaPackage2 = (JavaPackage)iterator2.next();
            if (MoveController.verifyMovePackage(javaPackage2, context)) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean canMoveStaticMember(Context context, SourceMember sourceMember) {
        SourceFile sourceFile;
        URL uRL;
        boolean bl = false;
        if (sourceMember.isStatic() && Util.canRefactor(context, uRL = (sourceFile = sourceMember.getOwningSourceFile()).getURL())) {
            bl = true;
        }
        return bl;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        block13: {
            block12: {
                if (context.getView() instanceof NavigatorWindow) break block12;
                ElementAt elementAt = ElementAt.findElementAt(context);
                int n = elementAt != null ? elementAt.getElementType() : -1;
                switch (n) {
                    case 1: {
                        SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                        MoveController.whenMoveClass(context, sourceClass);
                        break;
                    }
                    case 3: {
                        SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                        if (sourceMethod != null) {
                            if (sourceMethod.isStatic()) {
                                MoveController.whenMoveStaticMembers(context, (SourceMember)sourceMethod);
                                break;
                            }
                            this.whenMoveInstanceMember(context, sourceMethod);
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)elementAt.getSourceElement();
                        if (sourceFieldVariable != null) {
                            MoveController.whenMoveStaticMembers(context, (SourceMember)sourceFieldVariable);
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        JavaPackage javaPackage = elementAt.getJavaPackage();
                        if (javaPackage != null && MoveController.verifyMovePackage(javaPackage, context)) {
                            MoveController.whenMovePackage(context, javaPackage);
                            break;
                        }
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
                break block13;
            }
            if (MoveController.updateFromNavigator(ideAction, context)) {
                MoveController.handleEventFromNavigator(context);
            } else {
                return false;
            }
        }
        return true;
    }

    private void whenMoveInstanceMember(Context context, SourceMethod sourceMethod) {
        MoveInstanceMemberController.whenMoveMembers(context, sourceMethod);
    }

    public static void whenMoveClass(Context context, SourceClass sourceClass) {
        if (!sourceClass.isMemberClass()) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            if (sourceClass == Patch.getMainClass(sourceFile)) {
                MoveController.whenMoveOuterClass(context, sourceClass);
            } else {
                MoveController.whenMovePrivateClass(context, sourceClass);
            }
        } else {
            MoveController.whenMoveInnerClass(context, sourceClass);
        }
    }

    private static void whenMoveOuterClass(Context context, SourceClass sourceClass) {
        boolean bl;
        String string = sourceClass.getQualifiedName();
        String string2 = MessageFormat.format(RefactoringArb.getString(51), string);
        String string3 = sourceClass.getPackageName();
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        JavaProvider javaProvider = sourceFile.getProvider();
        SourceClass sourceClass2 = javaProvider.getSourceClass(sourceClass.getQualifiedName());
        boolean bl2 = sourceClass2 == null;
        MoveClassesDialog moveClassesDialog = new MoveClassesDialog(context, string2, string3);
        if (bl2) {
            moveClassesDialog.setAllowSamePackage();
        }
        do {
            bl = false;
            if (!moveClassesDialog.runDialog() || !MoveController.isValidMove(sourceClass, string2)) continue;
            String string4 = moveClassesDialog.getNewPackageName();
            boolean bl3 = moveClassesDialog.isSearchInComments();
            boolean bl4 = moveClassesDialog.isSearchInNonJavaFiles();
            ClassDescription classDescription = ClassDescription.createClassDescription((JavaClass)sourceClass);
            String string5 = classDescription.getClassName();
            String string6 = Util.getFqClassName(string4, string5);
            String string7 = MessageFormat.format(RefactoringArb.getString(52), string, string6);
            MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(bl3, bl4, string7, string2);
            if (bl2) {
                moveClassesCriteria.hintMisplacedFile(sourceFile);
            }
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            String string8 = string4.replace('.', '/');
            URL uRL = PathsConfiguration.getURLForPackage(string8, context);
            if (uRL != null) {
                moveClassesCriteria.setPreferredPackageUrl(string4, uRL);
                moveClassesCriteria.addClassMove(javaManager, string3, string5, string4, string5);
                URL uRL2 = moveClassesCriteria.getOverwrittenUrl();
                if (uRL2 == null) {
                    MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
                    boolean bl5 = moveClassesDialog.isPreview();
                    ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl5);
                    continue;
                }
                String string9 = MessageFormat.format(RefactoringArb.getString(36), URLFileSystem.getPlatformPathName((URL)uRL2));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)string9, (String)moveClassesCriteria.getShortTitle(), null);
                bl = true;
                continue;
            }
            bl = true;
        } while (bl);
    }

    private static boolean isValidMove(SourceClass sourceClass, String string) {
        String string2 = sourceClass.getPackageName();
        if (!ModelUtil.hasLength((String)string2)) {
            List list = SourceElementAsList.asList((SourceElement)sourceClass.getOwningSourceFile(), new int[]{58, 28});
            int n = 0;
            while (n < list.size()) {
                JavaClass javaClass;
                JavaHasType javaHasType;
                SourceElement sourceElement = (SourceElement)list.get(n);
                if (sourceElement.getSymbolKind() == 58) {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                    javaHasType = sourceSimpleNameExpression.getResolvedObject();
                } else {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                    javaHasType = sourceTypeReference.getResolvedType();
                }
                if (javaHasType != null && javaHasType.getElementKind() == 3 && !sourceClass.equals(javaClass = (JavaClass)javaHasType) && !ModelUtil.hasLength((String)javaClass.getPackageName())) {
                    String string3 = MessageFormat.format(RefactoringArb.getString(245), sourceClass.getName());
                    boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string3, (String)string, null);
                    return bl;
                }
                ++n;
            }
        }
        return true;
    }

    private static void whenMovePackage(Context context, JavaPackage javaPackage) {
        String string;
        String string2 = javaPackage.getName();
        String string3 = MessageFormat.format(RefactoringArb.getString(105), string2);
        String string4 = "";
        JavaPackage javaPackage2 = javaPackage.getOwningPackage();
        if (javaPackage2 != null && (string = javaPackage2.getName()) != null && string.length() != 0) {
            string4 = string;
        }
        MoveClassesDialog moveClassesDialog = new MoveClassesDialog(context, string3, string4);
        boolean bl = false;
        do {
            if (!moveClassesDialog.runDialog()) continue;
            String string5 = javaPackage2.getName();
            String string6 = string5.length() == 0 ? "" : string5 + '.';
            String string7 = moveClassesDialog.getNewPackageName();
            String string8 = string7.length() != 0 ? string7 + '.' : "";
            String string9 = MessageFormat.format(RefactoringArb.getString(51), string5);
            String string10 = MessageFormat.format(RefactoringArb.getString(52), string5, string7);
            MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(moveClassesDialog.isSearchInComments(), moveClassesDialog.isSearchInNonJavaFiles(), string10, string9);
            MoveController.addPackageMoves(context, moveClassesCriteria, string2, string6, string8);
            URL uRL = moveClassesCriteria.getOverwrittenUrl();
            if (uRL == null) {
                MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
                boolean bl2 = moveClassesDialog.isPreview();
                ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl2);
                continue;
            }
            String string11 = MessageFormat.format(RefactoringArb.getString(36), URLFileSystem.getPlatformPathName((URL)uRL));
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string11, (String)moveClassesCriteria.getShortTitle(), null);
            bl = true;
        } while (bl);
    }

    public static void addPackageMoves(Context context, MoveClassesCriteria moveClassesCriteria, String string, String string2, String string3) {
        Project project = context.getProject();
        String string4 = string.replace('.', '/');
        String string5 = string4.substring(string2.length());
        String string6 = string3.replace('.', '/') + string5;
        ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
        URLPath uRLPath = projectContent.getJavaRootDirs();
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)string4);
            if (URLFileSystem.exists((URL)uRL2)) {
                moveClassesCriteria.addDirectoryMove(JavaManager.getJavaManager(project), uRL, string4, project, uRL, string6);
            }
            ++n;
        }
    }

    private static void whenMoveInnerClass(Context context, SourceClass sourceClass) {
        MoveInnerDialog moveInnerDialog = new MoveInnerDialog(context, sourceClass);
        if (moveInnerDialog.runDialog()) {
            String string = moveInnerDialog.getFieldName();
            String string2 = moveInnerDialog.getParameterName();
            String string3 = moveInnerDialog.getClassName();
            MoveInnerOperation moveInnerOperation = new MoveInnerOperation(context, sourceClass, string3, string, string2);
            moveInnerOperation.doRefactoring();
        }
    }

    private static void whenMovePrivateClass(Context context, SourceClass sourceClass) {
        MoveSecondaryClassDialog moveSecondaryClassDialog = new MoveSecondaryClassDialog(context, sourceClass);
        if (moveSecondaryClassDialog.runDialog()) {
            String string = moveSecondaryClassDialog.getClassName();
            MoveSecondaryOperation moveSecondaryOperation = new MoveSecondaryOperation(context, sourceClass, string);
            moveSecondaryOperation.doRefactoring();
        }
    }

    public static void whenMoveStaticMembers(Context context, SourceMember sourceMember) {
        MoveStaticOperation moveStaticOperation = new MoveStaticOperation();
        moveStaticOperation.whenMoveMembers(context, sourceMember);
    }

    private static boolean updateFromNavigator(IdeAction ideAction, Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray.length <= 0) {
            ideAction.setEnabled(false);
            return true;
        }
        Element element = elementArray[0];
        if (element instanceof RelativeDirectoryContextFolder) {
            RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
            boolean bl = false;
            String string = relativeDirectoryContextFolder.getRelativePath();
            if (ModelUtil.hasLength((String)string)) {
                bl = true;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (element instanceof JavaSourceNode) {
            boolean bl = true;
            int n = 0;
            while (bl && n < elementArray.length) {
                Element element2 = elementArray[n];
                if (element2 instanceof JavaSourceNode) {
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element2;
                    bl = MoveController.canMoveSourceNode(context, javaSourceNode);
                } else {
                    bl = false;
                }
                ++n;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    private static void handleEventFromNavigator(Context context) {
        String string;
        MoveClassesDialog moveClassesDialog;
        Element[] elementArray = context.getSelection();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager(project);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<JavaSourceNode> arrayList2 = new ArrayList<JavaSourceNode>();
        String string2 = null;
        boolean bl = true;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (bl && n2 < elementArray.length) {
            Element element = elementArray[n2];
            String string4 = null;
            if (element instanceof RelativeDirectoryContextFolder) {
                RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
                String string5 = relativeDirectoryContextFolder.getRelativePath();
                string4 = string5.replace('/', '.');
                JavaPackage javaPackage = javaManager.getPackage(string4);
                bl = MoveController.verifyMovePackage(javaPackage, context);
                if (bl) {
                    arrayList.add(string4);
                    string3 = string4;
                    ++n;
                }
            } else if (element instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                arrayList2.add(javaSourceNode);
                string4 = javaSourceNode.getPackage(project);
                if (n == 0) {
                    String string6;
                    URL uRL = javaSourceNode.getURL();
                    SourceFile sourceFile = javaManager.getSourceFile(uRL);
                    JavaClass javaClass = sourceFile.getPrimaryClass();
                    string3 = string6 = javaClass.getQualifiedName();
                }
                ++n;
            }
            if (string2 == null) {
                string2 = string4;
            } else if (!string2.equals(string4)) {
                string2 = "";
            }
            ++n2;
        }
        if (bl && (moveClassesDialog = new MoveClassesDialog(context, string = n == 1 ? MessageFormat.format(RefactoringArb.getString(51), string3) : RefactoringArb.getString(246), string2)).runDialog()) {
            String string7;
            if (arrayList.size() == 1 && arrayList2.size() == 0) {
                string7 = (String)arrayList.get(0);
            } else if (arrayList.size() == 0 && arrayList2.size() == 1) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)arrayList2.get(0);
                URL uRL = javaSourceNode.getURL();
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                SourceClass sourceClass = sourceFile.getSourcePrimaryClass();
                string7 = sourceClass.getQualifiedName();
            } else {
                string7 = RefactoringArb.getString(247);
            }
            String string8 = moveClassesDialog.getNewPackageName();
            String string9 = MessageFormat.format(RefactoringArb.getString(51), string7);
            String string10 = MessageFormat.format(RefactoringArb.getString(52), string7, string8);
            MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(moveClassesDialog.isSearchInComments(), moveClassesDialog.isSearchInNonJavaFiles(), string10, string9);
            int n3 = 0;
            while (n3 < arrayList.size()) {
                String string11 = (String)arrayList.get(n3);
                JavaPackage javaPackage = javaManager.getPackage(string11);
                JavaPackage javaPackage2 = javaPackage.getOwningPackage();
                String string12 = javaPackage2.getName();
                String string13 = string12.length() == 0 ? "" : string12 + '.';
                String string14 = string8.length() != 0 ? string8 + '.' : "";
                MoveController.addPackageMoves(context, moveClassesCriteria, string11, string13, string14);
                ++n3;
            }
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)arrayList2.get(n4);
                URL uRL = javaSourceNode.getURL();
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                if (sourceFile != null) {
                    JavaClass javaClass = sourceFile.getPrimaryClass();
                    SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
                    String string15 = sourceClass.getName();
                    String string16 = sourceClass.getPackageName();
                    String string17 = string8.replace('.', '/');
                    if (moveClassesCriteria.getPreferredUrl(string17) == null) {
                        URL uRL2 = PathsConfiguration.getURLForPackage(string17, context);
                        moveClassesCriteria.setPreferredPackageUrl(string8, uRL2);
                    }
                    moveClassesCriteria.addClassMove(javaManager, string16, string15, string8, string15);
                }
                ++n4;
            }
            MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
            boolean bl2 = moveClassesDialog.isPreview();
            ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl2);
        }
    }

    public static boolean canMoveClasses(Context context, SourceClass[] sourceClassArray) {
        switch (sourceClassArray.length) {
            case 0: {
                return false;
            }
            case 1: {
                return MoveController.canMoveClass(context, sourceClassArray[0]);
            }
        }
        int n = 0;
        while (n < sourceClassArray.length) {
            SourceClass sourceClass = sourceClassArray[n];
            SourceElement sourceElement = sourceClass.getParent();
            if (sourceElement.getSymbolKind() != 11) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < sourceClassArray.length) {
            SourceClass sourceClass = sourceClassArray[n2];
            if (!MoveController.canMoveClass(context, sourceClass)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void whenMoveClasses(Context context, SourceClass[] sourceClassArray) {
        if (sourceClassArray.length > 1) {
            int n = 0;
            while (n < sourceClassArray.length) {
                SourceClass sourceClass = sourceClassArray[n];
                SourceElement sourceElement = sourceClass.getParent();
                if (sourceElement.getSymbolKind() != 11) {
                    throw new IllegalArgumentException("Invalid class: " + sourceClass.getQualifiedName());
                }
                ++n;
            }
            String string = sourceClassArray[0].getPackageName();
            int n2 = 1;
            while (n2 < sourceClassArray.length) {
                SourceClass sourceClass = sourceClassArray[n2];
                if (!string.equals(sourceClass.getPackageName())) {
                    string = "";
                    break;
                }
                ++n2;
            }
            String string2 = RefactoringArb.getString(246);
            MoveClassesDialog moveClassesDialog = new MoveClassesDialog(context, string2, string);
            if (moveClassesDialog.runDialog()) {
                MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(moveClassesDialog.isSearchInComments(), moveClassesDialog.isSearchInNonJavaFiles(), string2, string2);
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager(project);
                String string3 = moveClassesDialog.getNewPackageName();
                int n3 = 0;
                while (n3 < sourceClassArray.length) {
                    SourceClass sourceClass = sourceClassArray[n3];
                    String string4 = sourceClass.getName();
                    String string5 = sourceClass.getPackageName();
                    String string6 = string3.replace('.', '/');
                    if (moveClassesCriteria.getPreferredUrl(string6) == null) {
                        URL uRL = PathsConfiguration.getURLForPackage(string6, context);
                        moveClassesCriteria.setPreferredPackageUrl(string3, uRL);
                    }
                    moveClassesCriteria.addClassMove(javaManager, string5, string4, string3, string4);
                    ++n3;
                }
                MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
                boolean bl = moveClassesDialog.isPreview();
                ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl);
            }
        } else {
            MoveController.whenMoveClass(context, sourceClassArray[0]);
        }
    }
}

