/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.util.JotNaming;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class MoveInnerDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MOVE_INNER_DEFAULTS";
    private final SourceClass _innerClass;
    private final boolean _isStaticClass;
    private JComboBox _fieldNameComponent;
    private DefaultListComboBoxModel _fieldNameModel;
    private JComboBox _paramNameComponent;
    private DefaultListComboBoxModel _paramNameModel;
    private JTextField _classNameComponent;

    protected String getTitle() {
        return RefactoringArb.getString(239);
    }

    public MoveInnerDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context);
        this._innerClass = sourceClass;
        this._isStaticClass = this._innerClass.isStatic();
        this.init();
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._classNameComponent;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmoveinnerclass_html";
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = this.getClassName();
            Project project = this.getContext().getProject();
            String string2 = this._innerClass.getPackageName();
            NameValidation nameValidation = NameValidation.validateClassName(project, string2, string, true);
            String string3 = nameValidation.getMessage();
            boolean bl = nameValidation.isValid();
            if (!bl) {
                this.setMessage(nameValidation.getMessage(), false);
                this.setOKButtonEnabled(false);
            } else {
                String string4 = this.getFieldName();
                if (string4 != null) {
                    if (string4.length() == 0) {
                        bl = false;
                    } else {
                        String string5 = this.canIntroduceVariable(string4);
                        if (string5 != null) {
                            string3 = string5;
                            bl = false;
                        } else if (Character.isUpperCase(string4.charAt(0))) {
                            string3 = RefactoringArb.getString(67);
                        }
                    }
                }
                this.setMessage(string3, bl);
                this.setOKButtonEnabled(bl);
            }
        }
    }

    private String canIntroduceVariable(String string) {
        String string2 = null;
        if (!IdeUtil.isJavaIdentifier((String)string)) {
            string2 = RefactoringArb.getString(68);
        } else if (IdeUtil.isJavaReservedWord((String)string)) {
            string2 = RefactoringArb.getString(68);
        } else {
            JavaField javaField = this._innerClass.getField("_" + string);
            if (javaField != null) {
                string2 = MessageFormat.format(RefactoringArb.getString(36), string);
            }
        }
        return string2;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._classNameComponent = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._classNameComponent, (String)RefactoringArb.getString(238));
        this.updateOnChanges(this._classNameComponent);
        JLabel jLabel2 = new JLabel();
        this._fieldNameModel = new DefaultListComboBoxModel();
        this._fieldNameComponent = new JComboBox(this._fieldNameModel);
        this._fieldNameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._fieldNameComponent, (String)RefactoringArb.getString(241));
        JLabel jLabel3 = new JLabel();
        this._paramNameModel = new DefaultListComboBoxModel();
        this._paramNameComponent = new JComboBox(this._paramNameModel);
        this._paramNameComponent.setEditable(true);
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._paramNameComponent, (String)RefactoringArb.getString(216));
        if (this._isStaticClass) {
            this._fieldNameComponent.setEnabled(false);
            this._paramNameComponent.setEnabled(false);
        } else {
            this.updateOnChanges(this._fieldNameComponent);
            this.updateOnChanges(this._paramNameComponent);
        }
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(jLabel2.getPreferredSize());
        this.setMessageLabel(jLabel4);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._classNameComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._fieldNameComponent, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
        this.add((Component)this._paramNameComponent, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
        this._classNameComponent.setText(this._innerClass.getName());
        if (!this._isStaticClass) {
            this.fillSuggestedNames();
        }
    }

    protected void fillSuggestedNames() {
        JavaClass javaClass = this._innerClass.getOwningClass();
        String string = javaClass.getName();
        List list = JotNaming.suggestNamesFromCamelWord(string);
        this._fieldNameModel.removeAllElements();
        this._paramNameModel.removeAllElements();
        int n = 0;
        while (n < list.size()) {
            String string2 = (String)list.get(n);
            this._fieldNameModel.addElement((Object)JotNaming.FIELD_FORMATER.toString(string2));
            this._paramNameModel.addElement((Object)JotNaming.VARIABLE_FORMATER.toString(string2));
            ++n;
        }
    }

    public String getClassName() {
        String string = this._classNameComponent.getText();
        return string;
    }

    public String getFieldName() {
        String string;
        if (!this._isStaticClass) {
            ComboBoxEditor comboBoxEditor = this._fieldNameComponent.getEditor();
            Object object = comboBoxEditor.getItem();
            string = object.toString();
        } else {
            string = null;
        }
        return string;
    }

    public String getParameterName() {
        String string;
        if (!this._isStaticClass) {
            ComboBoxEditor comboBoxEditor = this._paramNameComponent.getEditor();
            Object object = comboBoxEditor.getItem();
            string = object.toString();
        } else {
            string = null;
        }
        return string;
    }
}

