/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.MultiMap;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.usage.keyword.KeywordBatchQueryTask;
import oracle.jdeveloper.usage.keyword.KeywordIndex;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.MemberAccess;
import oracle.jdevimpl.refactoring.util.Visitor;

class MoveInnerOperation {
    private final Context _context;
    private final SourceClass _sourceClass;
    private final String _className;
    private final String _fieldName;
    private final String _parameterName;
    private final URL _newURL;

    public MoveInnerOperation(Context context, SourceClass sourceClass, String string, String string2, String string3) {
        URL uRL;
        this._context = context;
        this._sourceClass = sourceClass;
        this._className = string;
        this._fieldName = string2;
        this._parameterName = string3;
        SourceFile sourceFile = this._sourceClass.getOwningSourceFile();
        URL uRL2 = sourceFile.getURL();
        URL uRL3 = URLFileSystem.getParent((URL)uRL2);
        String string4 = this._className + ".java";
        this._newURL = uRL = URLFactory.newURL((URL)uRL3, (String)string4);
    }

    private String getName() {
        return RefactoringArb.getString(239);
    }

    public Context getContext() {
        return this._context;
    }

    protected boolean doRefactoring() {
        boolean bl = false;
        Collection collection = this.getMembersToUpdate();
        if (collection != null) {
            URL uRL = this._sourceClass.getOwningSourceFile().getURL();
            Workspace workspace = this.getContext().getWorkspace();
            Project[] projectArray = Util.getAffectedProjects(workspace, uRL);
            MultiMap multiMap = new MultiMap();
            HashSet hashSet = new HashSet();
            MoveInnerOperation.getAffectedFilesAndSubClasses(this._sourceClass, projectArray, hashSet, multiMap, true);
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                refactoringCommandSupport.setOpenCreatedFiles(true);
                MemberAccess.updateConfirmedMembers(refactoringCommandSupport, collection);
                if (hashSet.size() == 1) {
                    Project project = this.getContext().getProject();
                    SourceFile sourceFile = refactoringCommandSupport.createSourceFile(project, this._newURL);
                    if (sourceFile != null) {
                        this.updateUsages(refactoringCommandSupport, multiMap);
                        this.updateClass(refactoringCommandSupport, sourceFile);
                        bl = refactoringCommandSupport.commit(this.getContext(), this.getName());
                    }
                } else {
                    hashSet.remove(this._sourceClass);
                    SourceClass sourceClass = (SourceClass)hashSet.iterator().next();
                    String string = MessageFormat.format(RefactoringArb.getString(240), this._sourceClass.getQualifiedName(), sourceClass.getQualifiedName());
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, this.getName(), 2);
                }
            }
            finally {
                if (!bl) {
                    refactoringCommandSupport.abort();
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Collection getMembersToUpdate() {
        JavaClass javaClass;
        HashSet<Object> hashSet = new HashSet<Object>();
        SourceFile sourceFile = this._sourceClass.getOwningSourceFile();
        if (this._fieldName != null && (javaClass = this._sourceClass.getOwningClass()).isPrivate()) {
            hashSet.add(javaClass);
        }
        List list = SourceElementAsList.asList((SourceElement)this._sourceClass, 3);
        List list2 = SourceElementAsList.asList((SourceElement)sourceFile, 3);
        list2.removeAll(list);
        List list3 = SourceElementAsList.asList((SourceElement)sourceFile);
        int n = 0;
        while (n < list3.size()) {
            SourceElement sourceElement = (SourceElement)list3.get(n);
            boolean bl = Patch.contains((SourceElement)this._sourceClass, sourceElement);
            int n2 = sourceElement.getSymbolKind();
            block0 : switch (n2) {
                case 28: {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                    JavaType javaType = sourceTypeReference.getResolvedType();
                    if (javaType == null || !javaType.isPrivate()) break;
                    if (javaType.isArray()) {
                        javaType = javaType.getComponentType();
                    }
                    javaType = javaType.getTypeErasure();
                    if ((!bl || !list2.contains(javaType)) && (bl || !list.contains(javaType))) break;
                    hashSet.add(javaType);
                    break;
                }
                case 54: 
                case 56: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement;
                    JavaMethod javaMethod = sourceInvokeExpression.getResolvedMethod();
                    if (javaMethod == null || !javaMethod.isPrivate()) break;
                    JavaClass javaClass2 = javaMethod.getOwningClass();
                    if ((!bl || !list2.contains(javaClass2)) && (bl || !list.contains(javaClass2))) break;
                    hashSet.add(javaMethod);
                    break;
                }
                case 50: 
                case 58: {
                    SourceExpression sourceExpression = (SourceExpression)sourceElement;
                    JavaHasType javaHasType = sourceExpression.getResolvedObject();
                    if (javaHasType == null) break;
                    int n3 = javaHasType.getElementKind();
                    switch (n3) {
                        case 5: {
                            JavaField javaField = (JavaField)javaHasType;
                            if (!javaField.isPrivate()) break;
                            JavaClass javaClass3 = javaField.getOwningClass();
                            if ((!bl || !list2.contains(javaClass3)) && (bl || !list.contains(javaClass3))) break block0;
                            hashSet.add(javaField);
                        }
                    }
                    break;
                }
            }
            ++n;
        }
        return MemberAccess.confirmMembers(hashSet);
    }

    private boolean updateClass(RefactoringCommandSupport refactoringCommandSupport, SourceFile sourceFile) {
        boolean bl = false;
        SourceFile sourceFile2 = this._sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile2);
        JavaClass javaClass = this._sourceClass.getOwningClass();
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>(1);
        JavaClass javaClass2 = javaClass;
        while (javaClass2 != null) {
            hashSet.add(javaClass2);
            javaClass2 = javaClass2.getOwningClass();
        }
        this.updateConstructors();
        if (this._fieldName != null) {
            SourceFactory sourceFactory = sourceFile2.getFactory();
            List list = SourceElementAsList.asList((SourceElement)this._sourceClass);
            int n = 0;
            while (n < list.size()) {
                SourceElement sourceElement = (SourceElement)list.get(n);
                int n2 = sourceElement.getSymbolKind();
                switch (n2) {
                    case 54: {
                        JavaClass javaClass3;
                        JavaMethod javaMethod;
                        SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                        SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
                        if (sourceExpression != null || (javaMethod = sourceMethodCallExpression.getResolvedMethod()) == null || !hashSet.contains(javaClass3 = javaMethod.getOwningClass())) break;
                        SourceExpression sourceExpression2 = !javaMethod.isStatic() ? this.createFieldAccess(sourceFactory, (SourceElement)sourceMethodCallExpression) : sourceFactory.createExpression(javaClass3.getQualifiedName());
                        List list2 = sourceMethodCallExpression.getChildren();
                        list2.add(0, sourceExpression2);
                        break;
                    }
                    case 58: {
                        JavaField javaField;
                        JavaClass javaClass4;
                        int n3;
                        SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                        JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                        if (javaHasType == null || (n3 = javaHasType.getElementKind()) != 5 || !hashSet.contains(javaClass4 = (javaField = (JavaField)javaHasType).getOwningClass())) break;
                        SourceExpression sourceExpression = !javaField.isStatic() ? this.createFieldAccess(sourceFactory, (SourceElement)sourceSimpleNameExpression) : sourceFactory.createExpression(javaClass4.getQualifiedName());
                        SourceDotExpression sourceDotExpression = sourceFactory.createDotReference(sourceExpression, javaField.getName());
                        sourceSimpleNameExpression.replaceSelf((SourceElement)sourceDotExpression);
                        break;
                    }
                    case 61: {
                        JavaType javaType;
                        SourceTypeExpression sourceTypeExpression;
                        SourceTypeReference sourceTypeReference;
                        SourceUnaryExpression sourceUnaryExpression = (SourceUnaryExpression)sourceElement;
                        SourceExpression sourceExpression = sourceUnaryExpression.getFirstOperand();
                        if (sourceExpression == null || sourceExpression.getSymbolKind() != 59 || (sourceTypeReference = (sourceTypeExpression = (SourceTypeExpression)sourceExpression).getSourceType()) == null || !hashSet.contains(javaType = sourceTypeReference.getResolvedType())) break;
                        SourceExpression sourceExpression3 = this.createFieldAccess(sourceFactory, (SourceElement)sourceUnaryExpression);
                        sourceUnaryExpression.replaceSelf((SourceElement)sourceExpression3);
                    }
                }
                ++n;
            }
            String string = javaClass.getQualifiedName();
            SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
            SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(18, sourceTypeReference, this._fieldName);
            SourceClassBody sourceClassBody = this._sourceClass.getSourceBody();
            sourceFieldDeclaration.addSelf((SourceElement)sourceClassBody);
        }
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceClass sourceClass = (SourceClass)this._sourceClass.cloneSelf(sourceFile);
        sourceClass.addSelf((SourceElement)sourceFile);
        sourceClass.removeModifiers(10);
        sourceFile.setPackageName(javaClass.getPackageName());
        sourceClass.setName(this._className);
        this._sourceClass.removeSelf();
        return bl;
    }

    private SourceExpression createFieldAccess(SourceFactory sourceFactory, SourceElement sourceElement) {
        CallerContext callerContext = CallerContext.createContext((SourceElement)sourceElement);
        JavaHasType javaHasType = callerContext.resolveExpressionName(this._fieldName);
        Object object = javaHasType == null ? sourceFactory.createSimpleNameExpression(this._fieldName) : sourceFactory.createExpression("this." + this._fieldName);
        return object;
    }

    private void updateConstructors() {
        SourceFile sourceFile = this._sourceClass.getOwningSourceFile();
        String string = this._sourceClass.getOwningClass().getQualifiedName();
        SourceFactory sourceFactory = sourceFile.getFactory();
        Collection collection = this._sourceClass.getDeclaredConstructors();
        boolean bl = false;
        for (JavaMethod javaMethod : collection) {
            if (javaMethod.isSynthetic()) continue;
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            bl = true;
            if (this._fieldName != null) {
                SourceMethodCallExpression sourceMethodCallExpression = null;
                List list = SourceElementAsList.asList((SourceElement)sourceMethod);
                int n = 0;
                while (n < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n);
                    if (sourceElement.getSymbolKind() == 54) {
                        SourceMethodCallExpression sourceMethodCallExpression2 = (SourceMethodCallExpression)sourceElement;
                        String string2 = sourceMethodCallExpression2.getName();
                        if (!"this".equals(string2)) break;
                        sourceMethodCallExpression = sourceMethodCallExpression2;
                        break;
                    }
                    ++n;
                }
                SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
                SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(0, sourceTypeReference, this._parameterName);
                SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
                sourceLocalVariable.addSelf((SourceElement)sourceFormalParameterList);
                if (sourceMethodCallExpression == null) {
                    Object object = this._fieldName.equals(this._parameterName) ? sourceFactory.createExpression("this." + this._fieldName) : sourceFactory.createSimpleNameExpression(this._fieldName);
                    SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(this._parameterName);
                    SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, (SourceExpression)object, (SourceExpression)sourceSimpleNameExpression);
                    SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement((SourceExpression)sourceAssignmentExpression);
                    SourceBlock sourceBlock = sourceMethod.getBlock();
                    List list2 = sourceBlock.getChildren();
                    list2.add(0, sourceExpressionStatement);
                } else {
                    SourceExpression sourceExpression = sourceFactory.createExpression(this._parameterName);
                    SourceListExpression sourceListExpression = sourceMethodCallExpression.getArgumentList();
                    sourceExpression.addSelf((SourceElement)sourceListExpression);
                }
            }
            sourceMethod.setName(this._className);
        }
        if (!bl && this._fieldName != null) {
            Object object = this._fieldName.equals(this._parameterName) ? sourceFactory.createExpression("this." + this._fieldName) : sourceFactory.createSimpleNameExpression(this._fieldName);
            SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(this._parameterName);
            SourceAssignmentExpression sourceAssignmentExpression = sourceFactory.createAssignment(6, (SourceExpression)object, (SourceExpression)sourceSimpleNameExpression);
            SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement((SourceExpression)sourceAssignmentExpression);
            SourceElement[] sourceElementArray = new SourceElement[]{sourceExpressionStatement};
            SourceBlock sourceBlock = sourceFactory.createBlock(sourceElementArray);
            SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
            SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(0, sourceTypeReference, this._parameterName);
            SourceFormalParameterList sourceFormalParameterList = sourceFactory.createFormalParameterList(sourceLocalVariable);
            SourceMethod sourceMethod = sourceFactory.createConstructor(sourceFormalParameterList, null, sourceBlock);
            SourceClassBody sourceClassBody = this._sourceClass.getSourceBody();
            sourceMethod.addSelf((SourceElement)sourceClassBody);
        }
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, MultiMap multiMap) {
        Set set = multiMap.keySet();
        for (Project project : set) {
            List list = multiMap.get((Object)project);
            int n = 0;
            while (n < list.size()) {
                URL uRL = (URL)list.get(n);
                JavaManager javaManager = JavaManager.getJavaManager(project);
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                this.updateUsages(refactoringCommandSupport, sourceFile);
                ++n;
            }
        }
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, SourceFile sourceFile) {
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceFactory sourceFactory = sourceFile.getFactory();
        String string = this._sourceClass.getName();
        1 var5_5 = new 1(this, string, sourceFactory);
        var5_5.visit((SourceElement)sourceFile);
    }

    protected static void getAffectedFilesAndSubClasses(SourceClass sourceClass, Project[] projectArray, HashSet hashSet, MultiMap multiMap, boolean bl) {
        HashSet<SourceClass> hashSet2 = new HashSet<SourceClass>();
        hashSet2.add(sourceClass);
        HashSet hashSet3 = new HashSet();
        while (!hashSet2.isEmpty()) {
            HashSet<String> hashSet4 = new HashSet<String>();
            for (SourceClass sourceClass2 : hashSet2) {
                String string = sourceClass2.getName();
                hashSet4.add(string);
            }
            hashSet.addAll(hashSet2);
            hashSet2.clear();
            int n = 0;
            while (n < projectArray.length) {
                Project project = projectArray[n];
                HashSet<URL> hashSet5 = new HashSet<URL>();
                URLPath uRLPath = ProjectContent.getInstance((PropertyStorage)project).getJavaRootDirs();
                URL[] uRLArray = uRLPath.getEntries();
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    URL uRL = uRLArray[n2];
                    KeywordIndex keywordIndex = KeywordIndex.getKeywordIndex(uRL);
                    String[] stringArray = hashSet4.toArray(new String[hashSet4.size()]);
                    KeywordBatchQueryTask keywordBatchQueryTask = keywordIndex.getBatchQueryTask(stringArray);
                    Util.waitUntilFinished(keywordBatchQueryTask);
                    URL[][] uRLArray2 = keywordBatchQueryTask.getBatchQueryResult();
                    int n3 = 0;
                    while (n3 < uRLArray2.length) {
                        URL[] uRLArray3 = uRLArray2[n3];
                        int n4 = 0;
                        while (n4 < uRLArray3.length) {
                            URL uRL2 = uRLArray3[n4];
                            hashSet5.add(uRL2);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                JavaManager javaManager = JavaManager.getJavaManager(project);
                for (URL uRL : hashSet5) {
                    SourceFile sourceFile = javaManager.getSourceFile(uRL);
                    List list = SourceElementAsList.asList((SourceElement)sourceFile);
                    int n5 = 0;
                    while (n5 < list.size()) {
                        JavaType javaType;
                        SourceClass sourceClass3;
                        SourceTypeReference sourceTypeReference;
                        SourceElement sourceElement;
                        int n6;
                        SourceElement sourceElement2 = (SourceElement)list.get(n5);
                        int n7 = sourceElement2.getSymbolKind();
                        if (n7 == 28 && ((n6 = (sourceElement = (sourceTypeReference = (SourceTypeReference)sourceElement2).getParent()).getSymbolKind()) == 23 || n6 == 15) && !hashSet.contains(sourceClass3 = (SourceClass)sourceElement.getParent()) && (javaType = sourceTypeReference.getResolvedType()) != null && sourceClass.isAssignableFrom(javaType)) {
                            if (!bl) {
                                hashSet2.add(sourceClass3);
                            } else {
                                hashSet.add(sourceClass3);
                            }
                        }
                        ++n5;
                    }
                }
                hashSet5.removeAll(hashSet3);
                multiMap.addAll((Object)project, hashSet5);
                hashSet3.addAll(hashSet5);
                ++n;
            }
        }
    }

    static String ra$_fieldName(MoveInnerOperation moveInnerOperation) {
        return moveInnerOperation._fieldName;
    }

    static String ra$_className(MoveInnerOperation moveInnerOperation) {
        return moveInnerOperation._className;
    }

    static SourceClass ra$_sourceClass(MoveInnerOperation moveInnerOperation) {
        return moveInnerOperation._sourceClass;
    }

    final class 1
    extends Visitor {
        private final /* synthetic */ String v$innerclassName;
        private final /* synthetic */ SourceFactory v$factory;
        final /* synthetic */ MoveInnerOperation this$0;

        private boolean isInnerClass(SourceTypeReference sourceTypeReference) {
            JavaType javaType;
            boolean bl = false;
            if (sourceTypeReference.getName().endsWith(this.v$innerclassName) && (javaType = sourceTypeReference.getResolvedType()) != null && javaType.equals((Object)MoveInnerOperation.ra$_sourceClass(this.this$0))) {
                bl = true;
            }
            return bl;
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceTypeReference) {
            if (this.isInnerClass(sourceTypeReference)) {
                sourceTypeReference.setName(MoveInnerOperation.ra$_className(this.this$0));
            }
        }

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
            SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
            if (this.isInnerClass(sourceTypeReference)) {
                if (MoveInnerOperation.ra$_fieldName(this.this$0) != null) {
                    SourceExpression sourceExpression;
                    SourceExpression sourceExpression2 = sourceNewClassExpression.getLhsOperand();
                    if (sourceExpression2 == null) {
                        sourceExpression = this.v$factory.createSimpleNameExpression("this");
                    } else {
                        sourceExpression2.removeSelf();
                        sourceExpression = sourceExpression2;
                    }
                    SourceListExpression sourceListExpression = sourceNewClassExpression.getArgumentList();
                    sourceExpression.addSelf((SourceElement)sourceListExpression);
                    sourceTypeReference.setName(MoveInnerOperation.ra$_className(this.this$0));
                } else {
                    SourceTypeReference sourceTypeReference2 = this.v$factory.createType(MoveInnerOperation.ra$_className(this.this$0));
                    sourceTypeReference.replaceSelf((SourceElement)sourceTypeReference2);
                }
            }
        }

        public 1(MoveInnerOperation moveInnerOperation, String string, SourceFactory sourceFactory) {
            this.v$factory = sourceFactory;
            this.v$innerclassName = string;
            this.this$0 = moveInnerOperation;
        }
    }
}

