/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;

public class MovePackageDialog
extends BaseDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "MOVE_CLASS_PREF";
    private static final int PREF_COMMENTS = 1;
    private static final int PREF_NON_JAVA_FILES = 2;
    private static final int PREF_PREVIEW = 4;
    private JTextField _pkgField;
    private JCheckBox _searchInComments;
    private JCheckBox _searchNonJavaFiles;
    private JCheckBox _preview;
    private JButton _browsePackage;
    private JavaPackage _javaPackage;
    private String _prefix;
    private String _suffix;

    public MovePackageDialog(Context context, JavaPackage javaPackage) {
        super(PREFERENCE_KEY, context);
        String string;
        this._javaPackage = javaPackage;
        this._prefix = "";
        this._suffix = this._javaPackage.getName();
        JavaPackage javaPackage2 = this._javaPackage.getOwningPackage();
        if (javaPackage2 != null && (string = javaPackage2.getName()) != null) {
            this._prefix = string;
            this._suffix = this._suffix.substring(string.length() + 1);
        }
        this.init();
    }

    protected String getTitle() {
        String string = this._javaPackage.getName();
        String string2 = MessageFormat.format(RefactoringArb.getString(105), string);
        return string2;
    }

    protected int getDefaultPreferences() {
        return 2;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = "";
            boolean bl = true;
            String string2 = this.getNewPackageName();
            if (this._prefix.equals(string2)) {
                bl = false;
            } else if (string2.endsWith(".")) {
                bl = false;
            } else if (!IdeUtil.isPackageIdentifier((String)string2)) {
                string = RefactoringArb.getString(74);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string2)) {
                string = RefactoringArb.getString(74);
                bl = false;
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
        copyableInteger.setBit(1, this.isSearchInComments());
        copyableInteger.setBit(2, this.isSearchInNonJavaFiles());
        copyableInteger.setBit(4, this.isPreview());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._pkgField;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmovepkg_html";
    }

    private void init() {
        JLabel jLabel = new JLabel();
        String string = this._javaPackage.getOwningPackage().getName();
        this._pkgField = new JTextField(string);
        String string2 = RefactoringArb.getString(106);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._pkgField, (String)string2);
        this.updateOnChanges(this._pkgField);
        ClassPickerFactory.attach(this._pkgField, this.getContext(), 2);
        this._browsePackage = new JButton("...");
        this._browsePackage.addActionListener(this);
        String string3 = RefactoringArb.getString(45);
        this._searchInComments = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._searchInComments, (String)string3);
        String string4 = RefactoringArb.getString(46);
        this._searchNonJavaFiles = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._searchNonJavaFiles, (String)string4);
        String string5 = RefactoringArb.getString(48);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)string5);
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(this._preview.getPreferredSize());
        this.setMessageLabel(jLabel2);
        CopyableInteger copyableInteger = this.getSettings();
        this._searchInComments.setSelected(copyableInteger.isBitSet(1));
        this._searchNonJavaFiles.setSelected(copyableInteger.isBitSet(2));
        this._preview.setSelected(copyableInteger.isBitSet(4));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._pkgField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browsePackage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._searchInComments, new GridBagConstraints(0, 1, 9, 1, 0.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)this._searchNonJavaFiles, new GridBagConstraints(0, 2, 9, 1, 0.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 3, 9, 1, 0.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 9, 9, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
    }

    private void whenBrowse() {
        Project project = this.getContext().getProject();
        String string = this._javaPackage.getOwningPackage().getName();
        1 var3_3 = new 1();
        String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage(this, project, 1, 0, false, var3_3, new String[]{string});
        if (stringArray.length == 1) {
            this._pkgField.setText(stringArray[0]);
        }
    }

    public String getNewPackageName() {
        return this._pkgField.getText();
    }

    public boolean isPreview() {
        return this._preview.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchNonJavaFiles.isSelected();
    }

    public boolean isSearchInComments() {
        return this._searchInComments.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._browsePackage) {
            this.whenBrowse();
        }
    }

    public final class 1
    implements ClassPackageBrowserFilterV2 {
        public boolean acceptPackage(String string) {
            return true;
        }

        public boolean acceptClass(JavaClass javaClass) {
            return false;
        }
    }
}

