/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.move;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.move.MoveInnerOperation;

class MoveSecondaryOperation {
    private Context _context;
    private SourceClass _sourceClass;
    private String _newClassName;
    private URL _newURL;

    public MoveSecondaryOperation(Context context, SourceClass sourceClass, String string) {
        URL uRL;
        this._context = context;
        this._sourceClass = sourceClass;
        this._newClassName = string;
        SourceFile sourceFile = this._sourceClass.getOwningSourceFile();
        URL uRL2 = sourceFile.getURL();
        URL uRL3 = URLFileSystem.getParent((URL)uRL2);
        String string2 = this._newClassName + ".java";
        this._newURL = uRL = URLFactory.newURL((URL)uRL3, (String)string2);
    }

    public Context getContext() {
        return this._context;
    }

    private String getName() {
        return RefactoringArb.getString(237);
    }

    boolean doRefactoring() {
        boolean bl = false;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            Workspace workspace = this.getContext().getWorkspace();
            URL uRL = this._sourceClass.getURL();
            Project[] projectArray = Util.getAffectedProjects(workspace, uRL);
            HashSet hashSet = new HashSet();
            MultiMap multiMap = new MultiMap();
            MoveInnerOperation.getAffectedFilesAndSubClasses(this._sourceClass, projectArray, hashSet, multiMap, true);
            Project project = this.getContext().getProject();
            SourceFile sourceFile = refactoringCommandSupport.createSourceFile(project, this._newURL);
            if (sourceFile != null) {
                this.updateUsages(refactoringCommandSupport, multiMap);
                this.updateClass(refactoringCommandSupport, sourceFile);
                bl = true;
            }
        }
        finally {
            if (bl) {
                refactoringCommandSupport.commit(this.getContext(), this.getName());
            } else {
                refactoringCommandSupport.abort();
            }
        }
        return bl;
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, MultiMap multiMap) {
        Set set = multiMap.keySet();
        for (Project project : set) {
            List list = multiMap.get((Object)project);
            int n = 0;
            while (n < list.size()) {
                URL uRL = (URL)list.get(n);
                JavaManager javaManager = JavaManager.getJavaManager(project);
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                this.updateUsages(refactoringCommandSupport, sourceFile);
                ++n;
            }
        }
    }

    private void updateUsages(RefactoringCommandSupport refactoringCommandSupport, SourceFile sourceFile) {
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        String string = this._sourceClass.getName();
        List list = SourceElementAsList.asList((SourceElement)sourceFile);
        int n = 0;
        while (n < list.size()) {
            JavaType javaType;
            SourceTypeReference sourceTypeReference;
            String string2;
            SourceElement sourceElement = (SourceElement)list.get(n);
            if (sourceElement.getSymbolKind() == 28 && (string2 = (sourceTypeReference = (SourceTypeReference)sourceElement).getName()) != null && string2.endsWith(string) && (javaType = sourceTypeReference.getResolvedType()) != null && javaType.equals((Object)this._sourceClass)) {
                sourceTypeReference.setName(this._newClassName);
            }
            ++n;
        }
    }

    private boolean updateClass(RefactoringCommandSupport refactoringCommandSupport, SourceFile sourceFile) {
        boolean bl = false;
        SourceFile sourceFile2 = this._sourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile2);
        this.updateConstructors();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        SourceClass sourceClass = (SourceClass)this._sourceClass.cloneSelf(sourceFile);
        sourceClass.addSelf((SourceElement)sourceFile);
        String string = sourceFile2.getPackageName();
        sourceFile.setPackageName(string);
        sourceClass.setName(this._newClassName);
        this._sourceClass.removeSelf();
        return bl;
    }

    private void updateConstructors() {
        Collection collection = this._sourceClass.getDeclaredConstructors();
        for (JavaMethod javaMethod : collection) {
            if (javaMethod.isSynthetic()) continue;
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            sourceMethod.setName(this._newClassName);
        }
    }
}

