/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.moveclasses;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.BitField;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.util.Helpers;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.Scope;

public class MoveClassesURLHandler
extends URLRefactoringHandler {
    private static final String MEMBER_NAMES = "MEMBER_NAMES";
    private static final String PACKAGE_SUFFIXES = "PACKAGE_SUFFIXES";
    private static final int TYPE_C1 = 1;
    private static final int TYPE_C2 = 2;
    private static final int TYPE_C2_B = 3;
    private static final int TYPE_C3_A = 4;
    private static final int TYPE_C3_B = 5;
    private static final int TYPE_C4_A = 6;
    private static final int TYPE_C4_D = 7;
    private static final int TYPE_C5_A = 9;
    private static final int TYPE_C5_B = 10;
    private static final int TYPE_C5_C = 11;
    private static final int TYPE_C6 = 12;
    private static final int TYPE_C7 = 13;
    private static final int TYPE_C8 = 14;
    private static final int TYPE_C8_2 = 15;
    private static final int TYPE_C9 = 16;
    private static final int TYPE_M1 = 50;
    private static final int TYPE_M2 = 51;
    private static final int TYPE_M3 = 52;
    private static final int TYPE_D1 = 100;
    private static final int TYPE_D2 = 101;
    private static final int TYPE_D3 = 102;
    private static final String PACKAGE_PRIVATE_MEMBERS = "PPMEMBERS";

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] projectArray = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        if (searchCriteria.getSearchType() == -2147483535) {
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
            Context context = searchOperation.getContext();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            String[] stringArray = moveClassesCriteria.getFqOldClassesNames();
            projectArray = MoveClassesURLHandler.getIncludedProjects(searchOperation, stringArray);
            HashSet hashSet = MoveClassesURLHandler.getPPMemberNames(javaManager, moveClassesCriteria);
            if (!hashSet.isEmpty()) {
                String[] stringArray2 = moveClassesCriteria.getOldPackageNames();
                HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(stringArray2));
                searchOperation.setProperty(MEMBER_NAMES, hashSet);
                searchOperation.setProperty(PACKAGE_SUFFIXES, hashSet2);
            }
        }
        return projectArray;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet hashSet = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        if (searchCriteria.getSearchType() == -2147483535) {
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
            HashSet<String> hashSet2 = new HashSet<String>();
            String[] stringArray = moveClassesCriteria.getOldClsNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                hashSet2.add(string2);
                ++n;
            }
            HashSet hashSet3 = (HashSet)searchOperation.getProperty(MEMBER_NAMES);
            if (hashSet3 != null) {
                hashSet2.addAll(hashSet3);
            }
            String[] stringArray2 = hashSet2.toArray(new String[hashSet2.size()]);
            hashSet = JavaURLHelper.getJavaURLsContaining(searchOperation, project, stringArray2, false, false, Scope.createDummyScope(), progressIndicator);
        }
        return hashSet;
    }

    private static HashSet getPPMemberNames(JavaManager javaManager, MoveClassesCriteria moveClassesCriteria) {
        String[] stringArray = moveClassesCriteria.getFqOldClassesNames();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            SourceClass sourceClass = moveClassesCriteria.findSourceClass(javaManager, string);
            if (sourceClass != null) {
                Collection collection = sourceClass.getDeclaredFields();
                for (JavaField javaField : collection) {
                    if (!javaField.isPackagePrivate()) continue;
                    String string2 = javaField.getName();
                    hashSet.add(string2);
                }
                Collection collection2 = sourceClass.getDeclaredMethods();
                for (JavaMethod javaMethod : collection2) {
                    if (!javaMethod.isPackagePrivate()) continue;
                    String string3 = javaMethod.getName();
                    hashSet.add(string3);
                }
                Collection collection3 = sourceClass.getDeclaredClasses();
                for (JavaClass javaClass : collection3) {
                    JavaElement javaElement;
                    String string4;
                    if (!javaClass.isPackagePrivate() || (string4 = javaClass.getName()) == null || !((javaElement = javaClass.getOwner()) instanceof JavaClass)) continue;
                    hashSet.add(string4);
                }
            } else {
                System.err.println("Cannot find " + string);
            }
            ++n;
        }
        return hashSet;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] uRLArray, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        if (searchCriteria.getSearchType() == -2147483535) {
            UsageModel usageModel2 = new UsageModel();
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
            JavaManager javaManager = JavaManager.getJavaManager(project);
            String[] stringArray = moveClassesCriteria.getOldClsNames();
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                int n2 = string.lastIndexOf(46);
                String string2 = string.substring(n2 + 1);
                hashSet.add(string2);
                ++n;
            }
            String[] stringArray2 = moveClassesCriteria.getOldPackageNames();
            HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(stringArray2));
            HashSet<String> hashSet3 = new HashSet<String>();
            int n3 = 0;
            while (n3 < stringArray2.length) {
                String string = stringArray2[n3];
                JavaPackage javaPackage = javaManager.getPackage(string);
                Collection collection = javaPackage.getDeclaredClasses();
                for (JavaClass javaClass : collection) {
                    String string3 = javaClass.getQualifiedName();
                    if (moveClassesCriteria.isMovedClass(string3)) continue;
                    String string4 = javaClass.getName();
                    hashSet3.add(string4);
                }
                ++n3;
            }
            HashSet<Object> hashSet4 = (HashSet<Object>)searchOperation.getProperty(PACKAGE_PRIVATE_MEMBERS);
            if (hashSet4 == null) {
                hashSet4 = new HashSet<Object>();
            }
            int n4 = 0;
            while (n4 < uRLArray.length && !searchOperation.isUserCancelled()) {
                SourceClass sourceClass;
                SourceName sourceName;
                URL uRL = uRLArray[n4];
                String string = URLFileSystem.getPlatformPathName((URL)uRL);
                progressIndicator.setProgressStepText(string);
                SourceFile sourceFile = javaManager.getSourceFile(uRL);
                boolean bl = false;
                HashSet hashSet5 = (HashSet)searchOperation.getProperty(MEMBER_NAMES);
                HashSet hashSet6 = (HashSet)searchOperation.getProperty(PACKAGE_SUFFIXES);
                JavaClass javaClass = sourceFile.getPrimaryClass();
                String string5 = javaClass.getQualifiedName();
                String string6 = javaClass.getPackageName();
                String string7 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string5);
                String string8 = string7 == null ? string6 : moveClassesCriteria.getNewPackageFromFqNewClassName(string7);
                boolean bl2 = hashSet6 != null && hashSet6.contains(string6);
                boolean bl3 = false;
                HashSet<String> hashSet7 = new HashSet<String>();
                HashSet<String> hashSet8 = new HashSet<String>();
                boolean bl4 = false;
                List list = SourceElementAsList.asList((SourceElement)sourceFile);
                int n5 = 0;
                while (n5 < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(n5);
                    switch (sourceElement.getSymbolKind()) {
                        case 22: {
                            if (string7 != null && string6 != string8) {
                                SourcePackage sourcePackage = (SourcePackage)sourceElement;
                                SourceName sourceName2 = sourcePackage.getNameElement();
                                this.addEntry(project, usageModel2, (SourceElement)sourceName2, string8, 14);
                            }
                            bl4 = true;
                            break;
                        }
                        case 14: {
                            String string9;
                            SourceImport sourceImport = (SourceImport)sourceElement;
                            SourceName sourceName3 = sourceImport.getNameElement();
                            String string10 = sourceName3.getName();
                            if (!sourceImport.isStatic()) {
                                String string11;
                                if (string10.endsWith(".*")) {
                                    String string12 = string10.substring(0, string10.length() - 2);
                                    if (!hashSet2.contains(string12)) break;
                                    if (!bl) {
                                        sourceFile.compile();
                                        bl = true;
                                    }
                                    Collection collection = sourceImport.getImportedElements();
                                    HashSet<String> hashSet9 = new HashSet<String>(collection.size());
                                    for (JavaHasType javaHasType : collection) {
                                        String string13;
                                        JavaType javaType = javaHasType.getResolvedType();
                                        JavaClass javaClass2 = javaType.getTypeErasure();
                                        String string14 = javaClass2.getQualifiedName();
                                        boolean bl5 = true;
                                        String string15 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string14);
                                        if (string15 != null && !string12.equals(string13 = moveClassesCriteria.getNewPackageFromFqNewClassName(string15))) {
                                            bl5 = false;
                                        }
                                        if (!bl5) continue;
                                        hashSet9.add(string14);
                                    }
                                    if (hashSet9.isEmpty()) {
                                        this.addEntry(project, usageModel2, (SourceElement)sourceName3, null, 1);
                                        break;
                                    }
                                    hashSet7.add(string12);
                                    break;
                                }
                                if (moveClassesCriteria.isMovedClass(string10)) {
                                    String string16 = moveClassesCriteria.getPackageFromFqClassName(string10);
                                    if (string16.equals(string8)) {
                                        this.addEntry(project, usageModel2, (SourceElement)sourceName3, null, 1);
                                        break;
                                    }
                                    hashSet8.add(string10);
                                    this.addEntry(project, usageModel2, (SourceElement)sourceName3, null, 2);
                                    break;
                                }
                                SourceClass sourceClass2 = javaManager.getSourceClass(string10);
                                if (sourceClass2 == null || !(string11 = sourceClass2.getPackageName()).equals(string8)) break;
                                this.addEntry(project, usageModel2, (SourceElement)sourceName3, null, 1);
                                break;
                            }
                            JavaClass javaClass3 = sourceImport.getQualifyingType();
                            if (javaClass3 == null || !moveClassesCriteria.isMovedClass(string9 = javaClass3.getQualifiedName())) break;
                            this.addEntry(project, usageModel2, (SourceElement)sourceName3, string9, 3);
                            break;
                        }
                        case 3: {
                            String string17;
                            SourceClass sourceClass3 = (SourceClass)sourceElement;
                            String string18 = sourceClass3.getQualifiedName();
                            if (string18 == null || (string17 = moveClassesCriteria.getOldClsNameFromFqClassName(string18)) == null) break;
                            bl3 = true;
                            String string19 = moveClassesCriteria.getNewClsNameFromFqClassName(string18);
                            if (!string17.equals(string19)) {
                                String string20;
                                String string21 = string17.substring(string17.lastIndexOf(46) + 1);
                                if (string21.equals(string20 = string19.substring(string19.lastIndexOf(46) + 1))) break;
                                this.addEntry(project, usageModel2, (SourceElement)sourceClass3.getNameElement(), null, 4);
                                break;
                            }
                            if (!sourceClass3.equals(javaClass)) break;
                            this.addEntry(project, usageModel2, (SourceElement)sourceClass3.getNameElement(), null, 5);
                            break;
                        }
                        case 1: {
                            String string22;
                            String string23;
                            JavaType javaType;
                            String string24;
                            String string25;
                            SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                            SourceName sourceName4 = sourceAnnotation.getNameElement();
                            if (sourceName4 == null || !hashSet.contains(string25 = (string24 = sourceName4.getName()).substring(string24.lastIndexOf(46) + 1)) || (javaType = sourceAnnotation.getResolvedType()) == null || (string23 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string22 = javaType.getQualifiedName())) == null) break;
                            this.addEntry(project, usageModel2, (SourceElement)sourceAnnotation, string23, 16);
                            break;
                        }
                        case 28: {
                            String string26;
                            JavaType javaType;
                            SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                            SourceName sourceName5 = sourceTypeReference.getNameElement();
                            if (sourceName5 == null) break;
                            String string27 = sourceName5.getName();
                            String string28 = string27.substring(string27.lastIndexOf(46) + 1);
                            if (hashSet.contains(string28)) {
                                SourceClass sourceClass4;
                                String string29;
                                JavaType javaType2;
                                JavaClass javaClass4;
                                String string30;
                                String string31;
                                JavaType javaType3 = sourceTypeReference.getResolvedType();
                                if (javaType3 == null || (string31 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string30 = (javaClass4 = (javaType2 = javaType3.isArray() ? javaType3.getComponentType() : javaType3).getTypeErasure()).getQualifiedName())) == null) break;
                                String string32 = null;
                                String string33 = null;
                                String string34 = string27.replaceAll("\\[\\]<>", "");
                                if (string34.equals(string30)) {
                                    string32 = string31;
                                } else {
                                    String string35;
                                    String string36;
                                    String string37 = javaClass4.getPackageName();
                                    int n6 = string37.length() == 0 ? 0 : string37.length() + 1;
                                    String string38 = string30.substring(n6);
                                    String string39 = moveClassesCriteria.getNewClsNameFromFqNewClassName(string31);
                                    while (!string34.equals(string38)) {
                                        int n7 = string38.indexOf(46);
                                        int n8 = string39.indexOf(46);
                                        if (n7 == -1 || n8 == -1) break;
                                        string38 = string38.substring(n7 + 1);
                                        string39 = string39.substring(n8 + 1);
                                    }
                                    if (!string38.equals(string39)) {
                                        string32 = string39;
                                    }
                                    boolean bl6 = false;
                                    if (string37.equals(string6) && !string8.equals(string36 = moveClassesCriteria.getNewPackageFromFqNewClassName(string31))) {
                                        bl6 = true;
                                    }
                                    boolean bl7 = false;
                                    if (!(hashSet8.contains(string30) || hashSet7.contains(string35 = moveClassesCriteria.getNewPackageFromFqNewClassName(string31)) || string8.equals(string35))) {
                                        bl7 = true;
                                    }
                                    if (bl6 || bl7) {
                                        string33 = string31;
                                    }
                                }
                                if (string32 != null || string33 != null) {
                                    Object[] objectArray = new Object[]{string32, string33};
                                    this.addEntry(project, usageModel2, (SourceElement)sourceName5, objectArray, 6);
                                }
                                if (hashSet4.contains(string31) || !javaType3.isPackagePrivate() || string8.equals(string29 = moveClassesCriteria.getNewPackageFromFqNewClassName(string31)) || (sourceClass4 = moveClassesCriteria.findSourceClass(javaManager, string31)) == null) break;
                                this.addEntry(project, usageModel2, (SourceElement)sourceClass4.getNameElement(), sourceClass4, 52);
                                break;
                            }
                            if (!bl3 || !hashSet3.contains(string28) || (javaType = sourceTypeReference.getResolvedType()) == null || string8.equals(string26 = javaType.getPackageName())) break;
                            String string40 = javaType.getQualifiedName();
                            this.addEntry(project, usageModel2, (SourceElement)sourceTypeReference, string40, 7);
                            break;
                        }
                        case 58: {
                            JavaClass javaClass5;
                            String string41;
                            JavaType javaType;
                            JavaHasType javaHasType;
                            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                            String string42 = sourceSimpleNameExpression.getName();
                            if (hashSet.contains(string42)) {
                                int n9;
                                JavaHasType javaHasType2 = sourceSimpleNameExpression.getResolvedObject();
                                if (javaHasType2 == null || (n9 = javaHasType2.getElementKind()) != 3) break;
                                JavaClass javaClass6 = (JavaClass)javaHasType2;
                                String string43 = javaClass6.getQualifiedName();
                                String string44 = moveClassesCriteria.getPackageFromFqClassName(string43);
                                String string45 = moveClassesCriteria.getNewClsNameFromFqClassName(string43);
                                if (string44.equals(string8)) {
                                    this.addEntry(project, usageModel2, sourceElement, string45, 9);
                                    break;
                                }
                                String string46 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string43);
                                Object[] objectArray = new Object[]{string45, string46};
                                this.addEntry(project, usageModel2, (SourceElement)sourceSimpleNameExpression, objectArray, 10);
                                break;
                            }
                            if (!bl3 || !hashSet3.contains(string42) || (javaHasType = sourceSimpleNameExpression.getResolvedObject()) == null || (javaType = javaHasType.getResolvedType()) == null) break;
                            if (javaType.isArray()) {
                                javaType = javaType.getBaseComponentType();
                            }
                            javaType = javaType.getTypeErasure();
                            int n10 = javaHasType.getElementKind();
                            if (n10 != 3 || string8.equals(string41 = (javaClass5 = (JavaClass)javaHasType).getPackageName())) break;
                            String string47 = javaType.getQualifiedName();
                            this.addEntry(project, usageModel2, (SourceElement)sourceSimpleNameExpression, string47, 11);
                            break;
                        }
                        case 50: {
                            String string48;
                            JavaClass javaClass7;
                            String string49;
                            String string50;
                            JavaField javaField;
                            JavaHasType javaHasType;
                            JavaClass javaClass8;
                            int n11;
                            int n12;
                            JavaHasType javaHasType3;
                            SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                            SourceName sourceName6 = sourceDotExpression.getNameElement();
                            if (sourceName6 == null) break;
                            String string51 = sourceName6.getName();
                            if (hashSet.contains(string51) && (javaHasType3 = sourceDotExpression.getResolvedObject()) != null && (n12 = javaHasType3.getElementKind()) == 3 && (BitField.isSet((int)(n11 = this.getMoveOrRename(moveClassesCriteria, javaClass, javaClass8 = (JavaClass)javaHasType3)), (int)1) || sourceDotExpression.getText().startsWith(javaClass8.getPackageName()))) {
                                this.addEntryWithNewFqName(project, moveClassesCriteria, usageModel2, (SourceElement)sourceDotExpression, (JavaType)javaClass8, 12);
                            }
                            if (!bl2 || !hashSet5.contains(string51) || (javaHasType = sourceDotExpression.getResolvedObject()) == null || javaHasType.getElementKind() != 5 || hashSet4.contains(javaField = (JavaField)javaHasType) || !javaField.isPackagePrivate() || (string50 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string49 = (javaClass7 = javaField.getOwningClass()).getQualifiedName())) == null || string8.equals(string48 = moveClassesCriteria.getNewPackageFromFqNewClassName(string50))) break;
                            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                            hashSet4.add(sourceFieldVariable);
                            SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceFieldVariable);
                            this.addEntry(project, usageModel2, (SourceElement)sourceFieldVariable.getNameElement(), sourceElementHandle, 50);
                            break;
                        }
                        case 6: {
                            String string52;
                            String string53;
                            String string54;
                            SourceMethod sourceMethod;
                            JavaClass javaClass9;
                            String string55;
                            String string56;
                            if (!bl3 || (string56 = moveClassesCriteria.getNewClsNameFromFqClassName(string55 = (javaClass9 = (sourceMethod = (SourceMethod)sourceElement).getOwningClass()).getQualifiedName())) == null || (string54 = string56.substring(string56.lastIndexOf(46) + 1)).equals(string53 = (string52 = javaClass9.getName()).substring(string52.lastIndexOf(46) + 1))) break;
                            SourceName sourceName7 = sourceMethod.getNameElement();
                            this.addEntry(project, usageModel2, (SourceElement)sourceName7, string54, 13);
                            break;
                        }
                        case 54: {
                            String string57;
                            JavaClass javaClass10;
                            String string58;
                            String string59;
                            JavaMethod javaMethod;
                            String string60;
                            SourceMethodCallExpression sourceMethodCallExpression;
                            SourceName sourceName8;
                            if (!bl2 || (sourceName8 = (sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement).getNameElement()) == null || !hashSet5.contains(string60 = sourceName8.getName()) || (javaMethod = (JavaMethod)sourceMethodCallExpression.getResolvedObject()) == null || hashSet4.contains(javaMethod) || !javaMethod.isPackagePrivate() || (string59 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string58 = (javaClass10 = javaMethod.getOwningClass()).getQualifiedName())) == null || string8.equals(string57 = moveClassesCriteria.getNewPackageFromFqNewClassName(string59))) break;
                            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                            hashSet4.add(sourceMethod);
                            SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceMethod);
                            this.addEntry(project, usageModel2, (SourceElement)sourceMethod.getNameElement(), sourceElementHandle, 51);
                            break;
                        }
                        case 67: {
                            String string61;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String string62 = sourceDocReference.getText();
                            int n13 = string62.indexOf(35);
                            if (n13 != -1) {
                                string61 = string62.substring(n13);
                                string62 = string62.substring(0, n13);
                            } else {
                                string61 = "";
                            }
                            String string63 = null;
                            if (hashSet.contains(string62)) {
                                JavaType javaType;
                                JavaHasType javaHasType = sourceDocReference.getResolvedObject();
                                if (javaHasType instanceof JavaMember && n13 != -1) {
                                    JavaMember javaMember = (JavaMember)javaHasType;
                                    javaHasType = javaMember.getOwningClass();
                                }
                                if (javaHasType != null && (javaType = javaHasType.getResolvedType()) != null) {
                                    String string64 = javaType.getQualifiedName();
                                    string63 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string64);
                                }
                            } else {
                                string63 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string62);
                            }
                            if (string63 == null) break;
                            String string65 = string63 + string61;
                            this.addEntry(project, usageModel2, (SourceElement)sourceDocReference, string65, 100);
                            break;
                        }
                        case 69: {
                            if (!moveClassesCriteria.isSearchInComments()) break;
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElement;
                            String string66 = sourceDocTextFragment.getText();
                            String[] stringArray3 = moveClassesCriteria.getFqOldClassesNames();
                            ArrayList<SourceElementEntry> arrayList = new ArrayList<SourceElementEntry>();
                            int n14 = 0;
                            while (n14 < stringArray3.length) {
                                String string67 = stringArray3[n14];
                                if (string66.indexOf(string67) != -1) {
                                    String string68 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string67);
                                    Pattern pattern = Pattern.compile("\\W(" + string67 + ")\\W");
                                    Matcher matcher = pattern.matcher(string66);
                                    while (matcher.find()) {
                                        int n15 = matcher.start(1);
                                        int n16 = matcher.end(1);
                                        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceDocTextFragment, 102);
                                        SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                                        Object[] objectArray = new Object[]{sourceElementHandle, new Integer(n15), new Integer(n16), string68};
                                        sourceElementEntry.setUserObject(objectArray);
                                        arrayList.add(sourceElementEntry);
                                    }
                                }
                                ++n14;
                            }
                            ArrayList<SourceElementEntry> arrayList2 = new ArrayList<SourceElementEntry>();
                            int n17 = 0;
                            while (n17 < stringArray3.length) {
                                String string69;
                                String string70 = stringArray3[n17];
                                String string71 = moveClassesCriteria.getPackageFromFqClassName(string70);
                                if (string6.equals(string71) && string66.indexOf(string69 = moveClassesCriteria.getOldClsNameFromFqClassName(string70)) != -1) {
                                    Pattern pattern = Pattern.compile("\\W(" + string69 + ")\\W");
                                    Matcher matcher = pattern.matcher(string66);
                                    while (matcher.find()) {
                                        int n18 = matcher.start(1);
                                        int n19 = matcher.end(1);
                                        boolean bl8 = false;
                                        int n20 = 0;
                                        while (!bl8 && n20 < arrayList.size()) {
                                            SourceElementEntry sourceElementEntry = (SourceElementEntry)arrayList.get(n20);
                                            Object[] objectArray = (Object[])sourceElementEntry.getUserObject();
                                            int n21 = (Integer)objectArray[1];
                                            int n22 = (Integer)objectArray[2];
                                            if (n21 <= n18 && n19 <= n22) {
                                                bl8 = true;
                                            }
                                            ++n20;
                                        }
                                        if (bl8) continue;
                                        String string72 = moveClassesCriteria.getNewClsNameFromFqClassName(string70);
                                        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, (SourceElement)sourceDocTextFragment, 101);
                                        SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                                        Object[] objectArray = new Object[]{sourceElementHandle, new Integer(n18), new Integer(n19), string72};
                                        sourceElementEntry.setUserObject(objectArray);
                                        arrayList2.add(sourceElementEntry);
                                    }
                                }
                                ++n17;
                            }
                            arrayList.addAll(arrayList2);
                            int n23 = 0;
                            while (n23 < arrayList.size()) {
                                SourceElementEntry sourceElementEntry = (SourceElementEntry)arrayList.get(n23);
                                usageModel2.addUsageEntry(sourceElementEntry);
                                ++n23;
                            }
                            break;
                        }
                    }
                    ++n5;
                }
                if (!bl4 && ModelUtil.hasLength((String)string8) && (sourceName = (sourceClass = (SourceClass)javaClass.getSourceElement()).getNameElement()) != null) {
                    this.addEntry(project, usageModel2, (SourceElement)sourceName, string8, 15);
                }
                ++n4;
            }
            usageModel = usageModel2;
            searchOperation.setProperty(PACKAGE_PRIVATE_MEMBERS, hashSet4);
        }
        return usageModel;
    }

    private void addEntryWithNewFqName(Project project, MoveClassesCriteria moveClassesCriteria, UsageModel usageModel, SourceElement sourceElement, JavaType javaType, int n) {
        String string = javaType.getQualifiedName();
        String string2 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string);
        this.addEntry(project, usageModel, sourceElement, string2, n);
    }

    private void addEntry(Project project, UsageModel usageModel, SourceElement sourceElement, Object object, int n) {
        SourceElementEntry sourceElementEntry = new SourceElementEntry(project, sourceElement, n);
        sourceElementEntry.setUserObject(object);
        usageModel.addUsageEntry(sourceElementEntry);
    }

    private int getMoveOrRename(MoveClassesCriteria moveClassesCriteria, JavaClass javaClass, JavaClass javaClass2) {
        int n = 0;
        String string = javaClass2.getQualifiedName();
        String string2 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string);
        if (string2 != null) {
            String string3;
            String string4;
            String string5;
            String string6 = moveClassesCriteria.getOldClsNameFromFqClassName(string);
            if (!string6.equals(string5 = moveClassesCriteria.getNewClsNameFromFqClassName(string))) {
                n |= 1;
            }
            if (!(string4 = javaClass2.getPackageName()).equals(string3 = moveClassesCriteria.getNewPackageFromFqNewClassName(string2))) {
                n |= 2;
                String string7 = javaClass.getPackageName();
                if (string7.equals(string4)) {
                    String string8 = javaClass.getQualifiedName();
                    String string9 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string8);
                    if (string9 != null) {
                        String string10 = moveClassesCriteria.getNewPackageFromFqNewClassName(string9);
                        if (!string3.equals(string10)) {
                            n |= 4;
                        }
                    } else {
                        n |= 4;
                    }
                }
            }
        }
        return n;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        boolean bl = false;
        try {
            MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchOperation.getCriteria();
            ArrayList arrayList = usageModel.getUsageEntries();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < arrayList.size()) {
                SourceElementEntry sourceElementEntry = (SourceElementEntry)arrayList.get(n);
                if (sourceElementEntry.isIncluded()) {
                    switch (sourceElementEntry.getUsageType()) {
                        case 4: 
                        case 5: {
                            URL uRL = sourceElementEntry.getURL();
                            String[] stringArray = Helpers.getClasses(project, uRL);
                            hashSet.addAll(Arrays.asList(stringArray));
                        }
                    }
                }
                ++n;
            }
            MultiMap multiMap = new MultiMap();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                SourceElementEntry sourceElementEntry = (SourceElementEntry)arrayList.get(n2);
                if (sourceElementEntry.isIncluded()) {
                    SourceElement sourceElement = sourceElementEntry.getSourceElementOrThrow();
                    switch (sourceElementEntry.getUsageType()) {
                        case 1: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceImport sourceImport = (SourceImport)sourceName.getParent();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceImport);
                            sourceImport.removeSelf();
                            break;
                        }
                        case 2: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceImport sourceImport = (SourceImport)sourceName.getParent();
                            String string = sourceImport.getName();
                            String string2 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string);
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceImport);
                            sourceImport.setName(string2);
                            break;
                        }
                        case 3: {
                            SourceName sourceName = (SourceName)sourceElement;
                            String string = (String)sourceElementEntry.getUserObject();
                            String string3 = moveClassesCriteria.getNewFqClsNameFromFqOldClassName(string);
                            String string4 = sourceName.getText();
                            String string5 = string3 + string4.substring(string.length());
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            sourceName.setText(string5);
                            break;
                        }
                        case 4: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceClass sourceClass = (SourceClass)sourceName.getParent();
                            String string = sourceClass.getQualifiedName();
                            String string6 = moveClassesCriteria.getNewClsNameFromFqClassName(string);
                            String string7 = string6.substring(string6.lastIndexOf(46) + 1);
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
                            sourceClass.setName(string7);
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            SourceName sourceName = (SourceName)sourceElement;
                            Object[] objectArray = (Object[])sourceElementEntry.getUserObject();
                            String string = (String)objectArray[0];
                            String string8 = (String)objectArray[1];
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            if (string != null) {
                                sourceName.setText(string);
                            }
                            if (string8 == null) break;
                            SourceFile sourceFile = sourceName.getOwningSourceFile();
                            this.smartAddImport(sourceFile, string8);
                            break;
                        }
                        case 7: {
                            SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                            String string = (String)sourceElementEntry.getUserObject();
                            SourceFile sourceFile = sourceTypeReference.getOwningSourceFile();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                            SourceFactory sourceFactory = sourceFile.getFactory();
                            SourceTypeReference sourceTypeReference2 = sourceFactory.createType(string);
                            sourceTypeReference.replaceSelf((SourceElement)sourceTypeReference2);
                            break;
                        }
                        case 10: {
                            Object[] objectArray = (Object[])sourceElementEntry.getUserObject();
                            String string = (String)objectArray[0];
                            String string9 = (String)objectArray[1];
                            SourceExpression sourceExpression = (SourceExpression)sourceElement;
                            SourceFile sourceFile = sourceExpression.getOwningSourceFile();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                            this.smartAddImport(sourceFile, string9);
                            SourceFactory sourceFactory = sourceFile.getFactory();
                            SourceExpression sourceExpression2 = sourceFactory.createExpression(string);
                            sourceExpression.replaceSelf((SourceElement)sourceExpression2);
                            break;
                        }
                        case 9: 
                        case 11: 
                        case 12: {
                            SourceExpression sourceExpression = (SourceExpression)sourceElement;
                            String string = (String)sourceElementEntry.getUserObject();
                            SourceFile sourceFile = sourceExpression.getOwningSourceFile();
                            SourceFactory sourceFactory = sourceFile.getFactory();
                            SourceExpression sourceExpression3 = sourceFactory.createExpression(string);
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                            sourceExpression.replaceSelf((SourceElement)sourceExpression3);
                            break;
                        }
                        case 13: 
                        case 14: {
                            SourceName sourceName = (SourceName)sourceElement;
                            String string = (String)sourceElementEntry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            sourceName.setText(string);
                            break;
                        }
                        case 15: {
                            SourceFile sourceFile = sourceElement.getOwningSourceFile();
                            String string = (String)sourceElementEntry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                            sourceFile.setPackageName(string);
                            break;
                        }
                        case 16: {
                            SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                            String string = (String)sourceElementEntry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceAnnotation);
                            SourceFile sourceFile = sourceAnnotation.getOwningSourceFile();
                            SourceFactory sourceFactory = sourceFile.getFactory();
                            SourceAnnotation sourceAnnotation2 = sourceFactory.createAnnotation(string);
                            sourceAnnotation.replaceSelf((SourceElement)sourceAnnotation2);
                            break;
                        }
                        case 50: 
                        case 51: 
                        case 52: {
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)sourceElementEntry.getUserObject();
                            SourceHasModifiers sourceHasModifiers = (SourceHasModifiers)sourceElementHandle.getElement();
                            if (sourceHasModifiers == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceHasModifiers);
                            sourceHasModifiers.addModifiers(1);
                            break;
                        }
                        case 100: {
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String string = (String)sourceElementEntry.getUserObject();
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocReference);
                            SourceFile sourceFile = sourceDocReference.getOwningSourceFile();
                            SourceFactory sourceFactory = sourceFile.getFactory();
                            int n3 = string.indexOf(35);
                            SourceDocReference sourceDocReference2 = n3 == -1 ? sourceFactory.createDocReference(string, null, null) : sourceFactory.createDocMemberReferenceFromText(string);
                            sourceDocReference.replaceSelf((SourceElement)sourceDocReference2);
                            break;
                        }
                        case 101: {
                            Object[] objectArray = (Object[])sourceElementEntry.getUserObject();
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)objectArray[0];
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                            if (sourceDocTextFragment == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocTextFragment);
                            multiMap.add((Object)sourceDocTextFragment, (Object)objectArray);
                            break;
                        }
                        case 102: {
                            Object[] objectArray = (Object[])sourceElementEntry.getUserObject();
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)objectArray[0];
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                            if (sourceDocTextFragment == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocTextFragment);
                            multiMap.add((Object)sourceDocTextFragment, (Object)objectArray);
                        }
                    }
                }
                ++n2;
            }
            MoveClassesURLHandler.renameClassInComments(multiMap);
            Context context = searchOperation.getContext();
            refactoringCommandSupport.setSearchOperation(searchOperation);
            bl = refactoringCommandSupport.commit(context, RefactoringArb.getString(236));
            if (bl) {
                String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
                Helpers.removeClasses(project, stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    private void smartAddImport(SourceFile sourceFile, String string) {
        boolean bl = false;
        List list = SourceElementAsList.asList((SourceElement)sourceFile, 14);
        int n = 0;
        while (!bl && n < list.size()) {
            SourceImport sourceImport = (SourceImport)list.get(n);
            String string2 = sourceImport.getName();
            if (string.equals(string2)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceImport sourceImport = sourceFactory.createImportDeclaration(string);
            sourceImport.addSelf((SourceElement)sourceFile);
        }
    }

    private static void renameClassInComments(MultiMap multiMap) {
        Set set = multiMap.keySet();
        for (SourceDocTextFragment sourceDocTextFragment : set) {
            String string = sourceDocTextFragment.getText();
            StringBuffer stringBuffer = new StringBuffer(string);
            List list = multiMap.get((Object)sourceDocTextFragment);
            Collections.sort(list, new 1());
            int n = 0;
            while (n < list.size()) {
                Object[] objectArray = (Object[])list.get(n);
                int n2 = (Integer)objectArray[1];
                int n3 = (Integer)objectArray[2];
                String string2 = (String)objectArray[3];
                stringBuffer.replace(n2, n3, string2);
                ++n;
            }
            SourceFile sourceFile = sourceDocTextFragment.getOwningSourceFile();
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceDocTextFragment sourceDocTextFragment2 = sourceFactory.createDocTextFragment(stringBuffer.toString());
            sourceDocTextFragment.replaceSelf((SourceElement)sourceDocTextFragment2);
        }
    }

    public static final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray2[1];
            return n2 - n;
        }
    }
}

