/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberFieldEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberInterfaceEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberTable;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberTableModel;
import oracle.jdevimpl.refactoring.util.Visitor;

public abstract class MoveMemberDialog
extends BaseDialog
implements VetoableChangeListener {
    private SourceClass _sourceClass;
    protected JTable _members;

    protected abstract Collection getMoveableFields();

    protected abstract Collection getMoveableMethods();

    protected abstract Collection getMoveableInterfaces();

    protected abstract String getDialogTitle();

    protected abstract MultiMap calculateDependencies(SourceClass var1);

    protected abstract boolean canClose();

    public MoveMemberDialog(String string, Context context, SourceClass sourceClass) {
        super(string, context);
        this._sourceClass = sourceClass;
    }

    protected JTable createTable() {
        MoveMemberTableModel moveMemberTableModel = this.createTableModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        MoveMemberTable moveMemberTable = new MoveMemberTable(moveMemberTableModel, defaultTableColumnModel);
        this.updateTableColumns((JTable)((Object)moveMemberTable));
        return moveMemberTable;
    }

    protected void updateTableColumns(JTable jTable) {
        MoveMemberTableModel moveMemberTableModel = (MoveMemberTableModel)jTable.getModel();
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
        while (defaultTableColumnModel.getColumnCount() > 0) {
            TableColumn tableColumn = defaultTableColumnModel.getColumn(0);
            defaultTableColumnModel.removeColumn(tableColumn);
        }
        int n = 0;
        while (n <= 3) {
            int n2 = MoveMemberTableModel.getColumnWidth(n);
            Class clazz = moveMemberTableModel.getColumnClass(n);
            String string = moveMemberTableModel.getColumnName(n);
            TableColumn tableColumn = new TableColumn(n, n2, jTable.getDefaultRenderer(clazz), jTable.getDefaultEditor(clazz));
            tableColumn.setHeaderValue(string);
            defaultTableColumnModel.addColumn(tableColumn);
            ++n;
        }
    }

    protected MoveMemberTableModel createTableModel() {
        MoveMemberTableModel moveMemberTableModel = new MoveMemberTableModel();
        Collection collection = this.getMoveableInterfaces();
        Collection collection2 = this.getMoveableMethods();
        Collection collection3 = this.getMoveableFields();
        MultiMap multiMap = new MultiMap();
        for (JavaType javaType : collection) {
            Collection collection4 = javaType.getDeclaredMethods();
            for (JavaMethod javaMethod : collection4) {
                JavaType[] javaTypeArray = Patch.getParameterTypes(javaMethod);
                JavaMethod javaMethod2 = this._sourceClass.getMethod(javaMethod.getName(), javaTypeArray);
                if (javaMethod2 == null) continue;
                multiMap.add((Object)javaMethod2, (Object)javaType);
            }
        }
        MultiMap multiMap2 = this.calculateDependencies(this._sourceClass);
        int n = collection.size() + collection2.size() + collection3.size();
        ArrayList<MoveMemberEntry> arrayList = new ArrayList<MoveMemberEntry>(n);
        HashMap<Object, MoveMemberEntry> hashMap = new HashMap<Object, MoveMemberEntry>(n);
        for (JavaType javaType : collection) {
            MoveMemberInterfaceEntry moveMemberInterfaceEntry = new MoveMemberInterfaceEntry(javaType);
            arrayList.add(moveMemberInterfaceEntry);
            hashMap.put(javaType, moveMemberInterfaceEntry);
        }
        for (SourceMethod sourceMethod : collection2) {
            MoveMemberMethodEntry moveMemberMethodEntry = new MoveMemberMethodEntry(sourceMethod);
            arrayList.add(moveMemberMethodEntry);
            hashMap.put(sourceMethod, moveMemberMethodEntry);
        }
        for (SourceFieldVariable sourceFieldVariable : collection3) {
            MoveMemberFieldEntry moveMemberFieldEntry = new MoveMemberFieldEntry(sourceFieldVariable);
            arrayList.add(moveMemberFieldEntry);
            hashMap.put(sourceFieldVariable, moveMemberFieldEntry);
        }
        Collections.sort(arrayList, new 3());
        int n2 = 0;
        while (n2 < arrayList.size()) {
            MoveMemberEntry moveMemberEntry = (MoveMemberEntry)arrayList.get(n2);
            if (moveMemberEntry instanceof MoveMemberMemberEntry) {
                MoveMemberMemberEntry moveMemberMemberEntry = (MoveMemberMemberEntry)moveMemberEntry;
                SourceMember sourceMember = moveMemberMemberEntry.getSourceMember();
                List list = multiMap2.get((Object)sourceMember);
                List list2 = this.converToEntryList(list, hashMap);
                moveMemberMemberEntry.setUsedBy(list2);
                if (moveMemberMemberEntry instanceof MoveMemberMethodEntry) {
                    MoveMemberMethodEntry moveMemberMethodEntry = (MoveMemberMethodEntry)moveMemberMemberEntry;
                    List list3 = multiMap.get((Object)sourceMember);
                    List list4 = this.converToEntryList(list3, hashMap);
                    moveMemberMethodEntry.setItfaces(list4);
                }
            }
            moveMemberTableModel.addEntry(moveMemberEntry);
            ++n2;
        }
        moveMemberTableModel.addTableModelListener(new 2());
        return moveMemberTableModel;
    }

    private List converToEntryList(List list, HashMap hashMap) {
        if (list != null) {
            ArrayList<MoveMemberEntry> arrayList = new ArrayList<MoveMemberEntry>(list.size());
            int n = 0;
            while (n < list.size()) {
                Object e = list.get(n);
                MoveMemberEntry moveMemberEntry = (MoveMemberEntry)hashMap.get(e);
                if (moveMemberEntry != null) {
                    arrayList.add(moveMemberEntry);
                }
                ++n;
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public MoveMemberMethodEntry[] getPulledMethodEntries() {
        ArrayList arrayList = this.getEntries(MoveMemberMethodEntry.class);
        return arrayList.toArray(new MoveMemberMethodEntry[arrayList.size()]);
    }

    protected MoveMemberInterfaceEntry[] getPulledInterfaceEntries() {
        ArrayList arrayList = this.getEntries(MoveMemberInterfaceEntry.class);
        return arrayList.toArray(new MoveMemberInterfaceEntry[arrayList.size()]);
    }

    public SourceMember[] getPulledMembers() {
        ArrayList arrayList = this.getEntries(MoveMemberMemberEntry.class);
        SourceMember[] sourceMemberArray = new SourceMember[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            SourceMember sourceMember;
            MoveMemberMemberEntry moveMemberMemberEntry = (MoveMemberMemberEntry)arrayList.get(n);
            sourceMemberArray[n] = sourceMember = moveMemberMemberEntry.getSourceMember();
            ++n;
        }
        Arrays.sort(sourceMemberArray, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        return sourceMemberArray;
    }

    public SourceMethod[] getPulledMethods() {
        ArrayList arrayList = this.getEntries(MoveMemberMethodEntry.class);
        SourceMethod[] sourceMethodArray = new SourceMethod[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            SourceMethod sourceMethod;
            MoveMemberMethodEntry moveMemberMethodEntry = (MoveMemberMethodEntry)arrayList.get(n);
            sourceMethodArray[n] = sourceMethod = moveMemberMethodEntry.getMethod();
            ++n;
        }
        Arrays.sort(sourceMethodArray, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        return sourceMethodArray;
    }

    public SourceFieldVariable[] getPulledFields() {
        ArrayList arrayList = this.getEntries(MoveMemberFieldEntry.class);
        SourceFieldVariable[] sourceFieldVariableArray = new SourceFieldVariable[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            MoveMemberFieldEntry moveMemberFieldEntry = (MoveMemberFieldEntry)arrayList.get(n);
            sourceFieldVariableArray[n] = moveMemberFieldEntry.getField();
            ++n;
        }
        Arrays.sort(sourceFieldVariableArray, Util.SOURCE_ELEMENT_POSITION_COMPARATOR);
        return sourceFieldVariableArray;
    }

    private ArrayList getEntries(Class clazz) {
        ArrayList arrayList = new ArrayList();
        MoveMemberTableModel moveMemberTableModel = (MoveMemberTableModel)this._members.getModel();
        ArrayList arrayList2 = moveMemberTableModel.getEntries();
        int n = 0;
        while (n < arrayList2.size()) {
            MoveMemberEntry moveMemberEntry;
            Object e = arrayList2.get(n);
            if (clazz == e.getClass() && e instanceof MoveMemberEntry && (moveMemberEntry = (MoveMemberEntry)e).isIncluded()) {
                arrayList.add(e);
            }
            ++n;
        }
        return arrayList;
    }

    public SourceClass getSourceSourceClass() {
        return this._sourceClass;
    }

    protected final HashSet calculateDependencies(SourceClass sourceClass, SourceElement sourceElement) {
        HashSet hashSet = new HashSet(0);
        1 var4_4 = new 1(this, sourceClass, hashSet);
        if (sourceElement != null) {
            var4_4.visit(sourceElement);
        }
        return hashSet;
    }

    protected String getTitle() {
        return this.getDialogTitle();
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected void updateOKButton() {
        boolean bl = this.hasSelection();
        this.setOKButtonEnabled(bl);
    }

    protected boolean hasSelection() {
        boolean bl = false;
        MoveMemberTableModel moveMemberTableModel = (MoveMemberTableModel)this._members.getModel();
        ArrayList arrayList = moveMemberTableModel.getEntries();
        int n = 0;
        while (!bl && n < arrayList.size()) {
            MoveMemberEntry moveMemberEntry;
            Object e = arrayList.get(n);
            if (e instanceof MoveMemberEntry && (moveMemberEntry = (MoveMemberEntry)e).isIncluded()) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._members;
    }

    public void setDlg(JEWTDialog jEWTDialog) {
        super.setDlg(jEWTDialog);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        boolean bl;
        if (propertyChangeEvent.getPropertyName().equals("closed") && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !(bl = this.canClose())) {
            throw new PropertyVetoException("", propertyChangeEvent);
        }
    }

    protected final ArrayList getExistingMembers(JavaClass javaClass, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        ArrayList<SourceMethod> arrayList2 = new ArrayList<SourceMethod>();
        MoveMemberMethodEntry[] moveMemberMethodEntryArray = this.getPulledMethodEntries();
        int n = 0;
        while (n < moveMemberMethodEntryArray.length) {
            MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n];
            SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
            arrayList2.add(sourceMethod);
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            SourceMethod sourceMethod = (SourceMethod)arrayList2.get(n2);
            JavaType[] javaTypeArray = Patch.getParameterTypes((JavaMethod)sourceMethod);
            SourceMethod sourceMethod2 = (SourceMethod)javaClass.getDeclaredMethod(sourceMethod.getName(), javaTypeArray);
            if (sourceMethod2 != null) {
                String string = Util.getFullMethodName((JavaMethod)sourceMethod, bl, bl, false);
                arrayList.add(string);
            }
            ++n2;
        }
        SourceFieldVariable[] sourceFieldVariableArray = this.getPulledFields();
        int n3 = 0;
        while (n3 < sourceFieldVariableArray.length) {
            SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n3];
            String string = sourceFieldVariable.getName();
            SourceFieldVariable sourceFieldVariable2 = (SourceFieldVariable)javaClass.getDeclaredField(string);
            if (sourceFieldVariable2 != null) {
                if (bl) {
                    string = javaClass.getName() + "." + string;
                }
                arrayList.add(string);
            }
            ++n3;
        }
        return arrayList;
    }

    public void preselectMember(SourceMember sourceMember) {
        if (sourceMember != null) {
            MoveMemberTableModel moveMemberTableModel = (MoveMemberTableModel)this._members.getModel();
            ArrayList arrayList = moveMemberTableModel.getEntries();
            int n = 0;
            while (n < arrayList.size()) {
                MoveMemberEntry moveMemberEntry = (MoveMemberEntry)arrayList.get(n);
                if (moveMemberEntry.equals(sourceMember)) {
                    moveMemberEntry.setIncluded(true);
                }
                ++n;
            }
        }
    }

    protected boolean confirmCanProceedWithExistingMembers(JavaClass javaClass) {
        boolean bl = true;
        ArrayList arrayList = this.getExistingMembers(javaClass, false);
        if (!arrayList.isEmpty()) {
            String string = RefactoringArb.getString(116);
            Object[] objectArray = new Object[]{javaClass.getName()};
            String string2 = MessageFormat.format(string, objectArray);
            JLabel jLabel = new JLabel();
            JList<Object> jList = new JList<Object>(arrayList.toArray(new Object[arrayList.size()]));
            ResourceUtils.resLabel((JLabel)jLabel, jList, (String)string2);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)new JScrollPane(jList), "Center");
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, RefactoringArb.getString(111), 3);
            jEWTDialog.setOKButtonText(RefactoringArb.getString(356));
            jEWTDialog.setContent((Component)jPanel);
            jEWTDialog.setResizable(true);
            if (!WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                bl = false;
            }
        }
        return bl;
    }

    protected MultiMap calculateDownDependencies(SourceClass sourceClass) {
        List list = sourceClass.getSourceMethods();
        MultiMap multiMap = new MultiMap();
        int n = 0;
        while (n < list.size()) {
            SourceMethod sourceMethod = (SourceMethod)list.get(n);
            HashSet hashSet = this.calculateDependencies(sourceMethod.getEnclosingClass(), (SourceElement)sourceMethod.getBlock());
            for (SourceElement sourceElement : hashSet) {
                multiMap.add((Object)sourceMethod, (Object)sourceElement);
            }
            ++n;
        }
        Collection collection = sourceClass.getSourceFieldVariables();
        for (SourceFieldVariable sourceFieldVariable : collection) {
            SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
            HashSet hashSet = this.calculateDependencies(sourceClass, (SourceElement)sourceExpression);
            for (SourceElement sourceElement : hashSet) {
                multiMap.add((Object)sourceFieldVariable, (Object)sourceElement);
            }
        }
        return multiMap;
    }

    public final class 3
    implements Comparator {
        public int compare(Object object, Object object2) {
            MoveMemberEntry moveMemberEntry = (MoveMemberEntry)object;
            MoveMemberEntry moveMemberEntry2 = (MoveMemberEntry)object2;
            return moveMemberEntry.getStartOffset() - moveMemberEntry2.getStartOffset();
        }
    }

    public final class 2
    implements TableModelListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
            MoveMemberDialog.this.updateOKButton();
        }
    }

    public final class 1
    extends Visitor {
        private final /* synthetic */ SourceClass v$sourceClass;
        private final /* synthetic */ HashSet v$dependencies;
        final /* synthetic */ MoveMemberDialog this$0;

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaClass javaClass;
            SourceMethod sourceMethod;
            JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
            if (javaMethod != null && (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) != null && this.v$sourceClass.equals(javaClass = sourceMethod.getOwningClass())) {
                this.v$dependencies.add(sourceMethod);
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaField javaField;
            SourceElement sourceElement;
            JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
            if (javaHasType instanceof JavaField && (sourceElement = (javaField = (JavaField)javaHasType).getSourceElement()) instanceof SourceFieldVariable) {
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                JavaClass javaClass = javaField.getOwningClass();
                if (this.v$sourceClass.equals(javaClass)) {
                    this.v$dependencies.add(sourceFieldVariable);
                }
            }
        }

        public 1(MoveMemberDialog moveMemberDialog, SourceClass sourceClass, HashSet hashSet) {
            this.v$dependencies = hashSet;
            this.v$sourceClass = sourceClass;
            this.this$0 = moveMemberDialog;
        }
    }
}

