/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;

public abstract class MoveMemberMemberEntry
extends MoveMemberEntry {
    private List _usedBy;
    private boolean _includedRecursion;
    private static final Color STATIC_MEMBER_COLOR = new Color(0, 128, 0);

    boolean isIncluded() {
        return super.isIncluded() || this.isIncludedThroughDependencies();
    }

    boolean isEnabled(int n) {
        if (n == 0 && this.isIncludedThroughDependencies()) {
            return false;
        }
        return super.isEnabled(n);
    }

    String getTooltipAt(int n) {
        MoveMemberMemberEntry moveMemberMemberEntry = this.shouldBeIncludedBecauseOf();
        if (moveMemberMemberEntry != null) {
            int n2 = this.getSourceMember().isStatic() ? 118 : 117;
            String string = moveMemberMemberEntry.getText();
            return MessageFormat.format(RefactoringArb.getString(n2), string);
        }
        return super.getTooltipAt(n);
    }

    Color getCellForeground(int n) {
        if (!this.isIncluded()) {
            int n2 = 0;
            while (n2 < this._usedBy.size()) {
                MoveMemberEntry moveMemberEntry = (MoveMemberEntry)this._usedBy.get(n2);
                if (moveMemberEntry.isIncluded() && !moveMemberEntry.isAbstract()) {
                    SourceMember sourceMember;
                    MoveMemberMemberEntry moveMemberMemberEntry;
                    SourceMember sourceMember2;
                    boolean bl = false;
                    if (moveMemberEntry instanceof MoveMemberMemberEntry && (sourceMember2 = (moveMemberMemberEntry = (MoveMemberMemberEntry)moveMemberEntry).getSourceMember()).isStatic() && (sourceMember = this.getSourceMember()).isStatic()) {
                        bl = true;
                    }
                    if (bl) {
                        return STATIC_MEMBER_COLOR;
                    }
                    return Color.RED;
                }
                ++n2;
            }
        }
        return super.getCellForeground(n);
    }

    int getStartOffset() {
        return this.getSourceMember().getStartOffset();
    }

    protected boolean shouldBeIncluded() {
        return this.shouldBeIncludedBecauseOf() != null;
    }

    private MoveMemberMemberEntry shouldBeIncludedBecauseOf() {
        if (!this.isIncluded()) {
            int n = 0;
            while (n < this._usedBy.size()) {
                MoveMemberMemberEntry moveMemberMemberEntry = (MoveMemberMemberEntry)this._usedBy.get(n);
                if (moveMemberMemberEntry.isIncluded()) {
                    return moveMemberMemberEntry;
                }
                ++n;
            }
        }
        return null;
    }

    protected boolean isIncludedThroughDependencies() {
        return this.getIncludedThroughDependencies() != null;
    }

    protected MoveMemberMemberEntry getIncludedThroughDependencies() {
        if (!this._includedRecursion) {
            this._includedRecursion = true;
            try {
                int n = 0;
                while (n < this._usedBy.size()) {
                    MoveMemberEntry moveMemberEntry = (MoveMemberEntry)this._usedBy.get(n);
                    if (moveMemberEntry.isIncludeDependencies() && moveMemberEntry.isIncluded()) {
                        MoveMemberMemberEntry moveMemberMemberEntry = (MoveMemberMemberEntry)moveMemberEntry;
                        this._includedRecursion = false;
                        return moveMemberMemberEntry;
                    }
                    ++n;
                }
            }
            finally {
                this._includedRecursion = false;
            }
        }
        return null;
    }

    void setUsedBy(List list) {
        this._usedBy = list;
    }

    abstract SourceMember getSourceMember();

    public boolean equals(Object object) {
        return object == this || object == this.getSourceMember();
    }
}

