/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember;

import java.text.MessageFormat;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberInterfaceEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMemberEntry;

public class MoveMemberMethodEntry
extends MoveMemberMemberEntry {
    private SourceMethod _method;
    private List _itfaces;

    MoveMemberMethodEntry(SourceMethod sourceMethod) {
        this._method = sourceMethod;
        SourceTypeReference sourceTypeReference = sourceMethod.getSourceReturnType();
        JavaType javaType = sourceTypeReference.getResolvedType();
        String string = javaType != null ? this.getShortTypeName(javaType) : sourceTypeReference.getName();
        String string2 = Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false) + ":" + string;
        this.setText(string2);
    }

    public SourceMethod getMethod() {
        return this._method;
    }

    boolean isIncluded() {
        return super.isIncluded() || this.isIncludedThroughInterface();
    }

    boolean isIncludeDependencies() {
        if (this.isAbstract()) {
            return false;
        }
        return super.isIncludeDependencies();
    }

    private boolean isIncludedThroughInterface() {
        return this.getIncludedThroughInterface() != null;
    }

    private MoveMemberInterfaceEntry getIncludedThroughInterface() {
        int n = 0;
        while (n < this._itfaces.size()) {
            MoveMemberEntry moveMemberEntry = (MoveMemberEntry)this._itfaces.get(n);
            if (moveMemberEntry.isIncluded()) {
                MoveMemberInterfaceEntry moveMemberInterfaceEntry = (MoveMemberInterfaceEntry)moveMemberEntry;
                return moveMemberInterfaceEntry;
            }
            ++n;
        }
        return null;
    }

    public boolean isAbstract() {
        return super.isAbstract() || this._method.isAbstract();
    }

    boolean isEnabled(int n) {
        switch (n) {
            case 0: {
                if (!this.isIncludedThroughInterface()) break;
                return false;
            }
            case 2: {
                if (!this._method.isAbstract() && !this._method.isStatic()) break;
                return false;
            }
            case 3: {
                if (!this.isAbstract()) break;
                return false;
            }
        }
        return super.isEnabled(n);
    }

    String getTooltipAt(int n) {
        switch (n) {
            case 0: {
                MoveMemberMemberEntry moveMemberMemberEntry = this.getIncludedThroughDependencies();
                if (moveMemberMemberEntry != null) {
                    return MessageFormat.format(RefactoringArb.getString(119), moveMemberMemberEntry.getText());
                }
                MoveMemberInterfaceEntry moveMemberInterfaceEntry = this.getIncludedThroughInterface();
                if (moveMemberInterfaceEntry == null) break;
                return MessageFormat.format(RefactoringArb.getString(119), moveMemberInterfaceEntry.getInterfaceClass().getName());
            }
            case 2: {
                if (!this._method.isAbstract()) break;
                return RefactoringArb.getString(120);
            }
            case 3: {
                if (!this.isAbstract()) break;
                return RefactoringArb.getString(121);
            }
        }
        return super.getTooltipAt(n);
    }

    void setItfaces(List list) {
        this._itfaces = list;
    }

    SourceMember getSourceMember() {
        return this.getMethod();
    }
}

