/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.ExtractSuperclassCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.BasicOperation;
import oracle.jdevimpl.refactoring.util.Visitor;

public class ExtractSuperclassCommand {
    private Context _context;
    private ExtractSuperclassCriteria _criteria;
    private URL _superClassUrl;
    private HashSet _abstractMethodDescriptions;

    private ExtractSuperclassCommand(Context context, SourceClass sourceClass, String string, String string2, JavaType[] javaTypeArray, SourceMethod[] sourceMethodArray, SourceFieldVariable[] sourceFieldVariableArray, HashSet hashSet) {
        this._context = context;
        this._superClassUrl = Util.createTypeURL(this._context, string, string2);
        ClassDescription[] classDescriptionArray = new ClassDescription[javaTypeArray.length];
        int n = 0;
        while (n < javaTypeArray.length) {
            ClassDescription classDescription;
            JavaType javaType = javaTypeArray[n];
            JavaClass javaClass = javaType.getTypeErasure();
            classDescriptionArray[n] = classDescription = ClassDescription.createClassDescription(javaClass);
            ++n;
        }
        HashSet<MethodDescription> hashSet2 = new HashSet<MethodDescription>();
        int n2 = 0;
        while (n2 < javaTypeArray.length) {
            JavaType javaType = javaTypeArray[n2];
            Collection collection = javaType.getMethods();
            for (JavaMethod javaMethod : collection) {
                MethodDescription methodDescription = new MethodDescription(javaMethod);
                hashSet2.add(methodDescription);
            }
            ++n2;
        }
        this._abstractMethodDescriptions = new HashSet();
        int n3 = 0;
        while (n3 < sourceMethodArray.length) {
            SourceMethod sourceMethod = sourceMethodArray[n3];
            MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
            hashSet2.add(methodDescription);
            if (hashSet.contains(sourceMethod)) {
                this._abstractMethodDescriptions.add(methodDescription);
            }
            ++n3;
        }
        ArrayList<FieldDescription> arrayList = new ArrayList<FieldDescription>(sourceFieldVariableArray.length);
        int n4 = 0;
        while (n4 < sourceFieldVariableArray.length) {
            SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n4];
            FieldDescription fieldDescription = new FieldDescription((JavaField)sourceFieldVariable);
            arrayList.add(fieldDescription);
            ++n4;
        }
        this._criteria = new ExtractSuperclassCriteria(ClassDescription.createClassDescription(string, string2, false), ClassDescription.createClassDescription((JavaClass)sourceClass), classDescriptionArray, hashSet2.toArray(new MethodDescription[hashSet2.size()]), arrayList.toArray(new FieldDescription[arrayList.size()]));
    }

    public static boolean doit(Context context, SourceClass sourceClass, String string, String string2, JavaType[] javaTypeArray, SourceMethod[] sourceMethodArray, SourceFieldVariable[] sourceFieldVariableArray, HashSet hashSet) {
        boolean bl = false;
        ExtractSuperclassCommand extractSuperclassCommand = new ExtractSuperclassCommand(context, sourceClass, string, string2, javaTypeArray, sourceMethodArray, sourceFieldVariableArray, hashSet);
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.setOpenCreatedFiles(true);
        try {
            BasicOperation basicOperation = new BasicOperation(extractSuperclassCommand._context, extractSuperclassCommand._criteria);
            refactoringCommandSupport.setSearchOperation(basicOperation);
            Project project = extractSuperclassCommand._context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaClass javaClass = extractSuperclassCommand.getSubClassDescription().getJavaClass(javaManager);
            SourceClass sourceClass2 = (SourceClass)javaClass.getSourceElement();
            SourceTransaction sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceClass2);
            ExtractSuperclassCommand extractSuperclassCommand2 = extractSuperclassCommand;
            extractSuperclassCommand2.getClass();
            MethodsVisitor methodsVisitor = extractSuperclassCommand2.new MethodsVisitor(sourceClass2);
            methodsVisitor.visit((SourceElement)sourceClass2);
            sourceTransaction.savepoint();
            SourceFile sourceFile = refactoringCommandSupport.createSourceFile(project, extractSuperclassCommand._superClassUrl);
            SourceClass sourceClass3 = extractSuperclassCommand.createSuperclass(refactoringCommandSupport, javaManager, sourceFile);
            if (sourceClass3 != null) {
                extractSuperclassCommand.removeSubclassParts(javaManager, sourceClass3);
            }
            refactoringCommandSupport.setOpenCreatedFiles(true);
            refactoringCommandSupport.commit(extractSuperclassCommand._context, RefactoringArb.getString(91));
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return bl;
    }

    private void removeSubclassParts(JavaManager javaManager, SourceClass sourceClass) {
        JavaClass javaClass = this.getSubClassDescription().getJavaClass(javaManager);
        SourceClass sourceClass2 = (SourceClass)javaClass.getSourceElement();
        SourceFile sourceFile = sourceClass2.getOwningSourceFile();
        int n = 0;
        while (n < this.getMethodDescriptions().length) {
            JavaMethod javaMethod;
            JavaClass javaClass2;
            MethodDescription methodDescription = this.getMethodDescriptions()[n];
            if (!this._abstractMethodDescriptions.contains(methodDescription) && javaClass.equals((Object)(javaClass2 = (javaMethod = methodDescription.getJavaMethod(javaManager)).getOwningClass()))) {
                SourceElement sourceElement = javaMethod.getSourceElement();
                sourceElement.removeSelf();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.getFieldDescriptions().length) {
            FieldDescription fieldDescription = this.getFieldDescriptions()[n2];
            JavaField javaField = fieldDescription.getJavaField(javaManager);
            if (javaClass.equals((Object)javaField.getOwningClass())) {
                SourceElement sourceElement = javaField.getSourceElement();
                sourceElement.removeSelf();
            }
            ++n2;
        }
        SourceFactory sourceFactory = sourceFile.getFactory();
        if (!sourceClass2.isAnonymous()) {
            String string = sourceClass.getName();
            SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
            sourceClass2.setSourceSuperclass(sourceTypeReference);
            List list = sourceClass2.getSourceInterfaces();
            int n3 = list.size() - 1;
            while (n3 >= 0) {
                SourceTypeReference sourceTypeReference2 = (SourceTypeReference)list.get(n3);
                JavaType javaType = sourceTypeReference2.getResolvedType();
                int n4 = 0;
                while (n4 < this.getInterfaceDescriptions().length) {
                    ClassDescription classDescription = this.getInterfaceDescriptions()[n4];
                    JavaClass javaClass3 = classDescription.getJavaClass(javaManager);
                    if (javaType.equals((Object)javaClass3)) {
                        sourceTypeReference2.removeSelf();
                        break;
                    }
                    ++n4;
                }
                --n3;
            }
        } else {
            SourceElement sourceElement = sourceClass2.getParent();
            if (sourceElement.getSymbolKind() == 56) {
                SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceElement;
                SourceTypeReference sourceTypeReference = sourceNewClassExpression.getSourceType();
                String string = sourceClass.getQualifiedName();
                SourceTypeReference sourceTypeReference3 = sourceFactory.createType(string);
                sourceTypeReference.replaceSelf((SourceElement)sourceTypeReference3);
            }
        }
    }

    private SourceClass createSuperclass(RefactoringCommandSupport refactoringCommandSupport, JavaManager javaManager, SourceFile sourceFile) {
        refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
        String string = this.getSuperclassDescription().getPackageName();
        String string2 = this.getSuperclassDescription().getClassName();
        SourceFactory sourceFactory = sourceFile.getFactory();
        sourceFile.setPackageName(string);
        SourceMember[] sourceMemberArray = this.createMembers(javaManager, sourceFile, sourceFactory);
        SourceClassBody sourceClassBody = sourceFactory.createClassBody(sourceMemberArray);
        SourceClass sourceClass = sourceFactory.createClass(0, string2, null, null, null, sourceClassBody);
        sourceClass.setModifiers(1);
        this.createSuperClause(javaManager, sourceFactory, sourceClass);
        if (this.superIsAbstract(javaManager)) {
            sourceClass.addModifiers(1024);
        }
        Patch.add((SourceElement)sourceFile, (SourceElement)sourceClass);
        return sourceClass;
    }

    private boolean superIsAbstract(JavaManager javaManager) {
        if (!this._abstractMethodDescriptions.isEmpty()) {
            return true;
        }
        int n = 0;
        while (n < this.getMethodDescriptions().length) {
            MethodDescription methodDescription = this.getMethodDescriptions()[n];
            JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
            if (javaMethod.isAbstract()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void createSuperClause(JavaManager javaManager, SourceFactory sourceFactory, SourceClass sourceClass) {
        ClassDescription classDescription = this.getSubClassDescription();
        JavaClass javaClass = classDescription.getJavaClass(javaManager);
        SourceClass sourceClass2 = (SourceClass)javaClass.getSourceElement();
        SourceTypeReference sourceTypeReference = null;
        if (!sourceClass2.isAnonymous()) {
            SourceTypeReference sourceTypeReference2 = sourceClass2.getSourceSuperclass();
            if (sourceTypeReference2 != null) {
                String string;
                JavaType javaType = sourceTypeReference2.getResolvedType();
                String string2 = javaType != null ? (string = javaType.getQualifiedName()) : sourceTypeReference2.getName();
                sourceTypeReference = sourceFactory.createType(string2);
            }
        } else {
            SourceElement sourceElement = sourceClass2.getParent();
            if (sourceElement.getSymbolKind() == 56) {
                SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)sourceElement;
                SourceTypeReference sourceTypeReference3 = sourceNewClassExpression.getSourceType();
                JavaType javaType = sourceTypeReference3.getResolvedType();
                String string = javaType.getQualifiedName();
                sourceTypeReference = sourceFactory.createType(string);
            }
        }
        if (sourceTypeReference != null) {
            sourceClass.setSourceSuperclass(sourceTypeReference);
        }
        int n = 0;
        while (n < this.getInterfaceDescriptions().length) {
            ClassDescription classDescription2 = this.getInterfaceDescriptions()[n];
            String string = classDescription2.getQualifiedName();
            SourceTypeReference sourceTypeReference4 = sourceFactory.createType(string);
            sourceClass.getSourceInterfaces().add(sourceTypeReference4);
            ++n;
        }
    }

    private SourceMember[] createMembers(JavaManager javaManager, SourceFile sourceFile, SourceFactory sourceFactory) {
        ClassDescription classDescription = this.getSubClassDescription();
        JavaClass javaClass = classDescription.getJavaClass(javaManager);
        MethodDescription[] methodDescriptionArray = this.getMethodDescriptions();
        ArrayList<Object> arrayList = new ArrayList<Object>(methodDescriptionArray.length + this.getFieldDescriptions().length);
        int n = 0;
        while (n < methodDescriptionArray.length) {
            JavaClass javaClass2;
            MethodDescription methodDescription = methodDescriptionArray[n];
            JavaMethod javaMethod = methodDescription.getJavaMethod(javaManager);
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            if (sourceMethod != null && javaClass.equals((Object)(javaClass2 = sourceMethod.getOwningClass()))) {
                SourceMethod sourceMethod2 = (SourceMethod)sourceMethod.cloneSelf(sourceFile);
                if (this._abstractMethodDescriptions.contains(methodDescription) && !sourceMethod.isAbstract()) {
                    sourceMethod2.addModifiers(1024);
                    SourceBlock sourceBlock = sourceMethod2.getBlock();
                    sourceBlock.removeSelf();
                }
                arrayList.add(sourceMethod2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.getFieldDescriptions().length) {
            FieldDescription fieldDescription = this.getFieldDescriptions()[n2];
            JavaField javaField = fieldDescription.getJavaField(javaManager);
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
            SourceFieldVariable sourceFieldVariable2 = (SourceFieldVariable)sourceFieldVariable.cloneSelf(sourceFile);
            SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(sourceFieldVariable2);
            arrayList.add(sourceFieldDeclaration);
            ++n2;
        }
        SourceMember[] sourceMemberArray = arrayList.toArray(new SourceMember[arrayList.size()]);
        return sourceMemberArray;
    }

    public String getName() {
        return this._criteria.getShortTitle();
    }

    public ClassDescription getSuperclassDescription() {
        return this._criteria.getSuperclassDescription();
    }

    public ClassDescription getSubClassDescription() {
        return this._criteria.getSubClassDescription();
    }

    public MethodDescription[] getMethodDescriptions() {
        return this._criteria.getMethodDescriptions();
    }

    public FieldDescription[] getFieldDescriptions() {
        return this._criteria.getFieldDescriptions();
    }

    public ClassDescription[] getInterfaceDescriptions() {
        return this._criteria.getInterfaceDescriptions();
    }

    static HashSet ra$_abstractMethodDescriptions(ExtractSuperclassCommand extractSuperclassCommand) {
        return extractSuperclassCommand._abstractMethodDescriptions;
    }

    private class MethodsVisitor
    extends Visitor {
        private int _inMovingCode;
        private final SourceFile _subClassFile;
        boolean _superNeedsToImportSub;
        private SourceClass _subSourceClass;

        public MethodsVisitor(SourceClass sourceClass) {
            this._subSourceClass = sourceClass;
            this._subClassFile = sourceClass.getOwningSourceFile();
        }

        private boolean isInMovingCode() {
            return this._inMovingCode > 0;
        }

        private boolean isMovingMethod(JavaMethod javaMethod) {
            MethodDescription methodDescription = new MethodDescription(javaMethod);
            int n = 0;
            while (n < ExtractSuperclassCommand.this.getMethodDescriptions().length) {
                MethodDescription methodDescription2 = ExtractSuperclassCommand.this.getMethodDescriptions()[n];
                if (!ExtractSuperclassCommand.ra$_abstractMethodDescriptions(ExtractSuperclassCommand.this).contains(methodDescription2) && methodDescription.equals(methodDescription2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private boolean isMovingField(JavaField javaField) {
            String string;
            boolean bl = false;
            JavaClass javaClass = javaField.getOwningClass();
            String string2 = ExtractSuperclassCommand.this.getSubClassDescription().getQualifiedName();
            if (string2.equals(javaClass.getQualifiedName()) && this.isNameOfMovingField(string = javaField.getName())) {
                bl = true;
            }
            return bl;
        }

        private boolean isNameOfMovingField(String string) {
            int n = 0;
            while (n < ExtractSuperclassCommand.this.getFieldDescriptions().length) {
                FieldDescription fieldDescription = ExtractSuperclassCommand.this.getFieldDescriptions()[n];
                String string2 = fieldDescription.getMemberName();
                if (string.equals(string2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private void changeAccessModifier(JavaMethod javaMethod, int n) {
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            if (sourceMethod != null) {
                sourceMethod.removeModifiers(7);
                sourceMethod.addModifiers(n);
            }
        }

        private void changeAccessModifier(JavaField javaField, int n) {
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
            SourceFieldDeclaration sourceFieldDeclaration = (SourceFieldDeclaration)sourceFieldVariable.getParent();
            int n2 = BitField.unset((int)sourceFieldDeclaration.getModifiers(), (int)7);
            sourceFieldDeclaration.setModifiers(n2 | n);
        }

        protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
            if (this.isMovingMethod((JavaMethod)sourceMethod)) {
                ++this._inMovingCode;
            }
            super.whenEnterMethodDeclaration(sourceMethod);
        }

        protected void whenExitMethodDeclaration(SourceMethod sourceMethod) {
            if (this.isMovingMethod((JavaMethod)sourceMethod)) {
                --this._inMovingCode;
            }
        }

        protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
            if (this.isMovingField((JavaField)sourceFieldVariable)) {
                ++this._inMovingCode;
            }
            super.whenEnterFieldVariable(sourceFieldVariable);
        }

        protected void whenExitFieldVariable(SourceFieldVariable sourceFieldVariable) {
            if (this.isMovingField((JavaField)sourceFieldVariable)) {
                --this._inMovingCode;
            }
            super.whenExitFieldVariable(sourceFieldVariable);
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
            if (javaMethod != null) {
                if (this.isInMovingCode()) {
                    if (!this.isMovingMethod(javaMethod)) {
                        JavaClass javaClass = javaMethod.getOwningClass();
                        if (javaClass.equals((Object)this._subSourceClass)) {
                            if (javaMethod.isStatic()) {
                                SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
                                if (sourceExpression == null) {
                                    SourceFactory sourceFactory = this._subClassFile.getFactory();
                                    String string = ExtractSuperclassCommand.this.getSubClassDescription().getClassName();
                                    SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string);
                                    sourceMethodCallExpression.getChildren().add(0, sourceSimpleNameExpression);
                                    this._superNeedsToImportSub = true;
                                }
                                if (javaMethod.isPrivate() || javaMethod.isProtected()) {
                                    this.changeAccessModifier(javaMethod, 1);
                                }
                            }
                        } else if (javaMethod.isPackagePrivate()) {
                            this.changeAccessModifier(javaMethod, 4);
                        }
                    }
                } else if (this.isMovingMethod(javaMethod) && javaMethod.isPrivate()) {
                    this.changeAccessModifier(javaMethod, 4);
                }
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
            if (javaHasType instanceof JavaField) {
                JavaField javaField = (JavaField)javaHasType;
                if (this.isInMovingCode()) {
                    if (!this.isMovingField(javaField)) {
                        SourceFactory sourceFactory = this._subClassFile.getFactory();
                        String string = ExtractSuperclassCommand.this.getSubClassDescription().getClassName();
                        SourceSimpleNameExpression sourceSimpleNameExpression2 = sourceFactory.createSimpleNameExpression(string);
                        SourceDotExpression sourceDotExpression = sourceFactory.createDotReference((SourceExpression)sourceSimpleNameExpression2, javaField.getName());
                        SourceElement sourceElement = sourceSimpleNameExpression.getParent();
                        List list = sourceElement.getChildren();
                        int n = list.indexOf(sourceSimpleNameExpression);
                        list.add(n, sourceDotExpression);
                        sourceSimpleNameExpression.removeSelf();
                        if (javaField.isPrivate() || javaField.isProtected()) {
                            this.changeAccessModifier(javaField, 1);
                        }
                    }
                } else if (this.isMovingField(javaField) && javaField.isPrivate()) {
                    this.changeAccessModifier(javaField, 4);
                }
            }
        }
    }
}

