/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberInterfaceEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveUpDownDialog;
import oracle.jdevimpl.refactoring.oprs.rename.RenamePackageDialog;

public class ExtractSuperclassDialog
extends MoveUpDownDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "EXTRACT_SUPER_PREF_KEY";
    private JTextField _pkgName;
    private JTextField _className;
    private JCheckBox _replaceUsages;
    private JCheckBox _preview;
    private JButton _browsePackage;

    public ExtractSuperclassDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
    }

    public boolean init() {
        this.setPreferredSize(new Dimension(420, 240));
        JLabel jLabel = new JLabel();
        String string = this.getSourceSourceClass().getPackageName();
        this._pkgName = new JTextField(string);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._pkgName, (String)RefactoringArb.getString(230));
        this.updateOnChanges(this._pkgName);
        ClassPickerFactory.attach(this._pkgName, this.getContext(), 2);
        this._browsePackage = new JButton("...");
        this._browsePackage.addActionListener(this);
        JLabel jLabel2 = new JLabel();
        this._className = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._className, (String)RefactoringArb.getString(231));
        this.updateOnChanges(this._className);
        this._members = this.createTable();
        JScrollPane jScrollPane = new JScrollPane(this._members);
        jScrollPane.getViewport().setBackground(this._members.getBackground());
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._members, (String)RefactoringArb.getString(83));
        this._replaceUsages = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._replaceUsages, (String)RefactoringArb.getString(232));
        this._replaceUsages.addActionListener(this);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(233));
        this._preview.setEnabled(false);
        this._replaceUsages.setSelected(false);
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(this._pkgName.getPreferredSize());
        this.setMessageLabel(jLabel4);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._pkgName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browsePackage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._className, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._replaceUsages, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, 13, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
        return true;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = null;
            String string2 = null;
            boolean bl = true;
            String string3 = this.getPackage();
            String string4 = this.getSuperClassName();
            if (string3.endsWith(".")) {
                bl = false;
            } else if (!IdeUtil.isPackageIdentifier((String)string3)) {
                string2 = RefactoringArb.getString(74);
                bl = false;
            } else if (IdeUtil.isJavaReservedWord((String)string3)) {
                string2 = RefactoringArb.getString(74);
                bl = false;
            } else if (RenamePackageDialog.hasUpperCase(string3)) {
                string = RefactoringArb.getString(76);
            }
            if (string2 == null) {
                if (string4.length() == 0) {
                    bl = false;
                } else if (!IdeUtil.isJavaIdentifier((String)string4)) {
                    string2 = RefactoringArb.getString(103);
                    bl = false;
                } else if (string4.lastIndexOf(36) >= 0) {
                    string2 = RefactoringArb.getString(103);
                    bl = false;
                } else if (IdeUtil.isJavaReservedWord((String)string4)) {
                    string2 = RefactoringArb.getString(103);
                    bl = false;
                } else if (this.isClassAlreadyPresent(string4)) {
                    string2 = MessageFormat.format(RefactoringArb.getString(36), string4);
                    bl = false;
                } else if (!Character.isUpperCase(string4.charAt(0))) {
                    string = RefactoringArb.getString(104);
                }
            }
            if (!this.hasSelection()) {
                bl = false;
            }
            if (string2 != null) {
                this.setMessage(string2, false);
            } else {
                this.setMessage(string, true);
            }
            this.setOKButtonEnabled(bl);
        }
    }

    private boolean isClassAlreadyPresent(String string) {
        SourceClass sourceClass = this.getSourceSourceClass();
        JavaProvider javaProvider = sourceClass.getOwningSourceFile().getProvider();
        String string2 = this.getPackage();
        String string3 = string2.length() == 0 ? string : string2 + "." + string;
        SourceClass sourceClass2 = javaProvider.getSourceClass(string3);
        return sourceClass2 != null;
    }

    protected boolean canClose() {
        return true;
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(234);
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._className;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dextractsuperclass_html";
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        List list = sourceClass.getSourceMethods();
        MultiMap multiMap = new MultiMap();
        int n = 0;
        while (n < list.size()) {
            SourceMethod sourceMethod = (SourceMethod)list.get(n);
            HashSet hashSet = this.calculateDependencies(sourceMethod.getEnclosingClass(), (SourceElement)sourceMethod.getBlock());
            for (SourceElement sourceElement : hashSet) {
                multiMap.add((Object)sourceElement, (Object)sourceMethod);
            }
            ++n;
        }
        Collection collection = sourceClass.getSourceFieldVariables();
        for (SourceFieldVariable sourceFieldVariable : collection) {
            SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
            HashSet hashSet = this.calculateDependencies(sourceClass, (SourceElement)sourceExpression);
            for (SourceElement sourceElement : hashSet) {
                multiMap.add((Object)sourceElement, (Object)sourceFieldVariable);
            }
        }
        return multiMap;
    }

    public String getSuperClassName() {
        return this._className.getText();
    }

    public String getPackage() {
        return this._pkgName.getText();
    }

    public JavaType[] getPulledInterfaces() {
        MoveMemberInterfaceEntry[] moveMemberInterfaceEntryArray = this.getPulledInterfaceEntries();
        JavaType[] javaTypeArray = new JavaType[moveMemberInterfaceEntryArray.length];
        int n = 0;
        while (n < moveMemberInterfaceEntryArray.length) {
            JavaType javaType;
            MoveMemberInterfaceEntry moveMemberInterfaceEntry = moveMemberInterfaceEntryArray[n];
            javaTypeArray[n] = javaType = moveMemberInterfaceEntry.getInterfaceClass();
            ++n;
        }
        return javaTypeArray;
    }

    public boolean hasReplaceUsages() {
        return this._replaceUsages.isSelected();
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._replaceUsages) {
            this._preview.setEnabled(this._replaceUsages.isSelected());
        } else if (object == this._browsePackage) {
            this.whenBrowse();
        }
    }

    private void whenBrowse() {
        String string;
        Project project = this.getContext().getProject();
        String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage((Component)this, project, 1, false, null, string = this._pkgName.getText());
        if (stringArray.length == 1) {
            this._pkgName.setText(stringArray[0]);
        }
    }
}

