/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceDataSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMemberDialog;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;
import oracle.jdevimpl.refactoring.util.MemberAccess;
import oracle.jdevimpl.refactoring.util.Visitor;

public class MoveInstanceMemberController {
    private static final boolean HAS_BUG_CANNOT_MOVE_MOD_BLOCK = true;
    private static final String OPR_TITLE = RefactoringArb.getString(223);

    public static boolean canMoveMember(Context context, SourceMethod sourceMethod) {
        return MoveInstanceMemberController.handle(context, sourceMethod, false);
    }

    public static void whenMoveMembers(Context context, SourceMethod sourceMethod) {
        MoveInstanceMemberController.handle(context, sourceMethod, true);
    }

    private static boolean handle(Context context, SourceMethod sourceMethod, boolean bl) {
        SourceClass sourceClass;
        JavaClass javaClass;
        boolean bl2 = false;
        if (!sourceMethod.isAbstract() && (javaClass = sourceMethod.getOwningClass()) != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null && Util.canRefactor((SourceElement)sourceClass)) {
            bl2 = true;
            if (bl) {
                MoveInstanceMemberController.initiateMoveMember(context, sourceClass, sourceMethod);
            }
        }
        return bl2;
    }

    private static void initiateMoveMember(Context context, SourceClass sourceClass, SourceMethod sourceMethod) {
        String string = null;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(MoveInstanceMemberController.getAvailableFields(sourceClass));
        arrayList.addAll(MoveInstanceMemberController.getAvailableGetters(sourceClass));
        arrayList.addAll(MoveInstanceMemberController.getAvailableParameters(sourceMethod));
        if (arrayList.isEmpty()) {
            string = RefactoringArb.getString(224);
        } else if (MoveInstanceMemberController.referencesSuper(sourceMethod)) {
            string = RefactoringArb.getString(226);
        } else {
            Collection collection = sourceMethod.getOverriddenMethods();
            if (!collection.isEmpty()) {
                JavaMethod javaMethod = (JavaMethod)collection.toArray()[0];
                string = MessageFormat.format(RefactoringArb.getString(227), Util.getFullMethodName(javaMethod, true, true, false));
            }
        }
        if (string == null) {
            String string2;
            if (!sourceClass.isAnonymous()) {
                String string3 = sourceClass.getName();
                string2 = Character.toLowerCase(string3.charAt(0)) + string3.substring(1);
            } else {
                string2 = "p";
            }
            MoveInstanceMemberDialog moveInstanceMemberDialog = new MoveInstanceMemberDialog(context, arrayList, string2, sourceMethod);
            if (moveInstanceMemberDialog.runDialog()) {
                String string4 = moveInstanceMemberDialog.getParamName();
                MoveInstanceDataSource moveInstanceDataSource = moveInstanceMemberDialog.getSelectedData();
                boolean bl = moveInstanceMemberDialog.isUseDelegate();
                String string5 = moveInstanceMemberDialog.getMethodName();
                MoveInstanceMemberController.doMoveMember(context, sourceMethod, string4, moveInstanceDataSource, bl, string5);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, OPR_TITLE, 2);
        }
    }

    private static ArrayList getAvailableFields(SourceClass sourceClass) {
        ArrayList<SourceFieldVariable> arrayList = new ArrayList<SourceFieldVariable>();
        Collection collection = sourceClass.getDeclaredFields();
        for (JavaField javaField : collection) {
            SourceFieldVariable sourceFieldVariable;
            SourceClass sourceClass2;
            JavaType javaType = javaField.getResolvedType();
            if (javaType == null || !MoveInstanceMemberController.isUsableType(javaType) || !Util.canRefactor((SourceElement)(sourceClass2 = (SourceClass)javaType.getSourceElement())) || (sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement()) == null) continue;
            arrayList.add(sourceFieldVariable);
        }
        return arrayList;
    }

    private static ArrayList getAvailableGetters(SourceClass sourceClass) {
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>();
        Collection collection = sourceClass.getDeclaredMethods();
        for (JavaMethod javaMethod : collection) {
            SourceMethod sourceMethod;
            SourceClass sourceClass2;
            JavaType javaType;
            if (!javaMethod.getParameters().isEmpty() || !MoveInstanceMemberController.isUsableType(javaType = javaMethod.getReturnType()) || !Util.canRefactor((SourceElement)(sourceClass2 = (SourceClass)javaType.getSourceElement())) || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null || !MoveInstanceMemberController.isConstMethod(sourceMethod)) continue;
            arrayList.add(javaMethod);
        }
        return arrayList;
    }

    private static boolean isConstMethod(SourceMethod sourceMethod) {
        1 var1_1 = new 1();
        var1_1.visit((SourceElement)sourceMethod);
        return var1_1.isCanceled() ^ true;
    }

    private static ArrayList getAvailableParameters(SourceMethod sourceMethod) {
        ArrayList<SourceElement> arrayList = new ArrayList<SourceElement>();
        Collection collection = sourceMethod.getParameters();
        for (JavaLocalVariable javaLocalVariable : collection) {
            SourceElement sourceElement;
            JavaType javaType = javaLocalVariable.getResolvedType();
            if (!MoveInstanceMemberController.isUsableType(javaType) || !Util.canRefactor(sourceElement = javaType.getSourceElement())) continue;
            arrayList.add(javaLocalVariable.getSourceElement());
        }
        return arrayList;
    }

    private static boolean referencesSuper(SourceMethod sourceMethod) {
        List list = SourceElementAsList.asList((SourceElement)sourceMethod);
        int n = 0;
        while (n < list.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression;
            SourceElement sourceElement = (SourceElement)list.get(n);
            if (sourceElement.getSymbolKind() == 58 && "super".equals((sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement).getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isUsableType(JavaType javaType) {
        if (javaType.isPrimitive() || javaType.isArray() || javaType.isInterface() || javaType.isDeprecated() || javaType.isEnum() || !javaType.isExported() || javaType.isHidden() || javaType.isAnnotation()) {
            return false;
        }
        return !"void".equals(javaType.getName());
    }

    private static void doMoveMember(Context context, SourceMethod sourceMethod, String string, MoveInstanceDataSource moveInstanceDataSource, boolean bl, String string2) {
        MultiMap multiMap = MoveInstanceMemberController.getUsages(context, sourceMethod);
        JavaClass javaClass = sourceMethod.getOwningClass();
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        JavaType javaType = moveInstanceDataSource.getJavaType();
        SourceClass sourceClass2 = (SourceClass)javaType.getSourceElement();
        SourceFile sourceFile2 = sourceClass2.getOwningSourceFile();
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceFactory sourceFactory2 = sourceFile2.getFactory();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile2);
            if (!MemberAccess.updateAccessModifiers(refactoringCommandSupport, (SourceElement)sourceMethod, sourceClass2)) {
                throw new AbortedOperationException();
            }
            SrcMethodVisitor srcMethodVisitor = MoveInstanceMemberController.getReferences(moveInstanceDataSource, sourceMethod);
            boolean bl2 = srcMethodVisitor.needsAdditionalParam();
            SourceTypeReference sourceTypeReference = Util.createSourceType(sourceMethod.getSourceReturnType(), sourceFile2);
            SourceFormalParameterList sourceFormalParameterList = sourceMethod.getFormalParameterList();
            SourceFormalParameterList sourceFormalParameterList2 = (SourceFormalParameterList)sourceFormalParameterList.cloneSelf(sourceFile2);
            if (bl2) {
                String string3 = javaClass.getQualifiedName();
                SourceTypeReference sourceTypeReference2 = sourceFactory2.createType(string3);
                SourceLocalVariable sourceLocalVariable = sourceFactory2.createLocalVariable(sourceTypeReference2, string);
                sourceLocalVariable.addSelf((SourceElement)sourceFormalParameterList2);
            }
            SourceThrowsClause sourceThrowsClause = (SourceThrowsClause)sourceMethod.getThrowsClause().cloneSelf(sourceFile2);
            SourceBlock sourceBlock = MoveInstanceMemberController.createTargetSourceBlock(refactoringCommandSupport, srcMethodVisitor, sourceMethod, string, sourceFile2);
            SourceMethod sourceMethod2 = moveInstanceDataSource.createMethod(sourceFactory2, sourceTypeReference, string2, sourceFormalParameterList2, sourceThrowsClause, sourceBlock);
            sourceMethod2.setModifiers(sourceMethod.getModifiers());
            SourceClassBody sourceClassBody = sourceClass2.getSourceBody();
            sourceMethod2.addSelf((SourceElement)sourceClassBody);
            if (bl) {
                SourceBlock sourceBlock2 = sourceFactory.createBlock();
                SourceMethodCallExpression sourceMethodCallExpression = moveInstanceDataSource.createDelegate(sourceFactory, srcMethodVisitor, sourceMethod, string2, bl2);
                Object object = "void".equals(sourceMethod.getSourceReturnType().getName()) ? sourceFactory.createExpressionStatement((SourceExpression)sourceMethodCallExpression) : sourceFactory.createReturnStatement((SourceExpression)sourceMethodCallExpression);
                object.addSelf((SourceElement)sourceBlock2);
                sourceMethod.getBlock().replaceSelf((SourceElement)sourceBlock2);
            } else {
                sourceMethod.removeSelf();
                HashSet hashSet = new HashSet();
                Set set = multiMap.keySet();
                for (Project project : set) {
                    List list = multiMap.get((Object)project);
                    MoveInstanceMemberController.replaceCallers(hashSet, bl2, list, refactoringCommandSupport, moveInstanceDataSource, string2);
                }
            }
            refactoringCommandSupport.commit(context, OPR_TITLE);
        }
        catch (AbortedOperationException abortedOperationException) {
            refactoringCommandSupport.abort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static MultiMap getUsages(Context context, SourceMethod sourceMethod) {
        1MyRunnable myRunnable = new 1MyRunnable((Component)Ide.getMainWindow(), context, sourceMethod);
        return myRunnable.start();
    }

    private static void replaceCallers(HashSet hashSet, boolean bl, List list, RefactoringCommandSupport refactoringCommandSupport, MoveInstanceDataSource moveInstanceDataSource, String string) {
        int n = 0;
        while (n < list.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)list.get(n);
            SourceFile sourceFile = sourceMethodCallExpression.getOwningSourceFile();
            URL uRL = sourceFile.getURL();
            if (!hashSet.contains(uRL)) {
                hashSet.add(uRL);
                SourceFactory sourceFactory = sourceFile.getFactory();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                moveInstanceDataSource.transformMethodCall(sourceFactory, bl, sourceMethodCallExpression);
                sourceMethodCallExpression.setName(string);
            }
            ++n;
        }
    }

    private static SourceBlock createTargetSourceBlock(RefactoringCommandSupport refactoringCommandSupport, SrcMethodVisitor srcMethodVisitor, SourceMethod sourceMethod, String string, SourceFile sourceFile) {
        SourceBlock sourceBlock = sourceMethod.getBlock();
        HashSet<String> hashSet = new HashSet<String>();
        JavaClass javaClass = sourceMethod.getOwningClass();
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        SourceFile sourceFile2 = sourceClass.getOwningSourceFile();
        Collection collection = sourceClass.getFields();
        for (JavaField javaField : collection) {
            String string2 = javaField.getName();
            hashSet.add(string2);
        }
        ArrayList arrayList = srcMethodVisitor.getReplaceWithParam();
        ArrayList arrayList2 = srcMethodVisitor.getDotExpressWithParam();
        ArrayList arrayList3 = srcMethodVisitor.getLhsMethodCallWithParam();
        ArrayList arrayList4 = srcMethodVisitor.getNewInnerClass();
        ArrayList arrayList5 = srcMethodVisitor.getClassRefMethod();
        ArrayList arrayList6 = srcMethodVisitor.getClassRefInner();
        ArrayList arrayList7 = srcMethodVisitor.getUnrefMethodCall();
        ArrayList arrayList8 = srcMethodVisitor.getUnrefDotExpr();
        ArrayList arrayList9 = srcMethodVisitor.getReplaceWithThis();
        SourceFactory sourceFactory = sourceClass.getOwningSourceFile().getFactory();
        int n = 0;
        while (n < arrayList.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)arrayList.get(n);
            SourceSimpleNameExpression sourceSimpleNameExpression2 = sourceFactory.createSimpleNameExpression(string);
            sourceSimpleNameExpression.replaceSelf((SourceElement)sourceSimpleNameExpression2);
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)arrayList2.get(n2);
            SourceSimpleNameExpression sourceSimpleNameExpression3 = sourceFactory.createSimpleNameExpression(string);
            SourceDotExpression sourceDotExpression = sourceFactory.createDotReference((SourceExpression)sourceSimpleNameExpression3, sourceSimpleNameExpression.getName());
            sourceSimpleNameExpression.replaceSelf((SourceElement)sourceDotExpression);
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList3.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)arrayList3.get(n3);
            SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string);
            sourceMethodCallExpression.setLhsOperand((SourceExpression)sourceSimpleNameExpression);
            ++n3;
        }
        int n4 = 0;
        while (n4 < arrayList4.size()) {
            SourceNewClassExpression sourceNewClassExpression = (SourceNewClassExpression)arrayList4.get(n4);
            SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string);
            sourceNewClassExpression.setLhsOperand((SourceExpression)sourceSimpleNameExpression);
            ++n4;
        }
        int n5 = 0;
        while (n5 < arrayList5.size()) {
            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)arrayList5.get(n5);
            SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(javaClass.getQualifiedName());
            sourceMethodCallExpression.setLhsOperand((SourceExpression)sourceSimpleNameExpression);
            ++n5;
        }
        int n6 = 0;
        while (n6 < arrayList6.size()) {
            Object[] objectArray = (Object[])arrayList6.get(n6);
            SourceTypeReference sourceTypeReference = (SourceTypeReference)objectArray[0];
            String string3 = (String)objectArray[1];
            SourceTypeReference sourceTypeReference2 = sourceFactory.createType(string3);
            sourceTypeReference.replaceSelf((SourceElement)sourceTypeReference2);
            ++n6;
        }
        int n7 = 0;
        while (n7 < arrayList7.size()) {
            SourceExpression sourceExpression = (SourceExpression)arrayList7.get(n7);
            sourceExpression.removeSelf();
            ++n7;
        }
        int n8 = 0;
        while (n8 < arrayList8.size()) {
            SourceDotExpression sourceDotExpression = (SourceDotExpression)arrayList8.get(n8);
            String string4 = sourceDotExpression.getName();
            SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(string4);
            sourceDotExpression.replaceSelf((SourceElement)sourceSimpleNameExpression);
            ++n8;
        }
        int n9 = 0;
        while (n9 < arrayList9.size()) {
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)arrayList9.get(n9);
            SourceSimpleNameExpression sourceSimpleNameExpression4 = sourceFactory.createSimpleNameExpression("this");
            sourceSimpleNameExpression.replaceSelf((SourceElement)sourceSimpleNameExpression4);
            ++n9;
        }
        SourceTransaction sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceFile2);
        sourceTransaction.savepoint();
        SourceBlock sourceBlock2 = (SourceBlock)sourceBlock.cloneSelf(sourceFile);
        return sourceBlock2;
    }

    static SrcMethodVisitor getReferences(MoveInstanceDataSource moveInstanceDataSource, SourceMethod sourceMethod) {
        HashSet<String> hashSet = new HashSet<String>();
        JavaClass javaClass = sourceMethod.getOwningClass();
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        Collection collection = sourceClass.getFields();
        for (JavaField javaField : collection) {
            String string = javaField.getName();
            hashSet.add(string);
        }
        SrcMethodVisitor srcMethodVisitor = new SrcMethodVisitor(moveInstanceDataSource, sourceClass, hashSet);
        srcMethodVisitor.visit((SourceElement)sourceMethod.getBlock());
        return srcMethodVisitor;
    }

    static String ra$OPR_TITLE() {
        return OPR_TITLE;
    }

    public static final class 1
    extends Visitor {
        protected void whenEnterAssignmentExpression(SourceAssignmentExpression sourceAssignmentExpression) {
            int n;
            JavaHasType javaHasType;
            boolean bl = false;
            SourceExpression sourceExpression = sourceAssignmentExpression.getFirstOperand();
            if (sourceExpression != null && (javaHasType = sourceExpression.getResolvedObject()) != null && (n = javaHasType.getElementKind()) != 5) {
                bl = true;
            }
            if (!bl) {
                this.cancel();
            }
        }

        protected void whenEnterUnaryExpression(SourceUnaryExpression sourceUnaryExpression) {
            int n = sourceUnaryExpression.getOperatorCode();
            switch (n) {
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    this.cancel();
                }
            }
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            this.cancel();
        }
    }

    public static class 1MyRunnable
    implements Runnable {
        ProgressBar _progressBar;
        final MultiMap _sourceInvokeExpressions;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ SourceMethod v$sourceMethod;

        void $init$() {
            this._sourceInvokeExpressions = new MultiMap();
        }

        public 1MyRunnable(Component component, Context context, SourceMethod sourceMethod) {
            this.v$sourceMethod = sourceMethod;
            this.v$context = context;
            this.$init$();
            this._progressBar = new ProgressBar(component, MoveInstanceMemberController.ra$OPR_TITLE(), (Runnable)this, false);
        }

        public MultiMap start() {
            this._progressBar.start(RefactoringArb.getString(228), "");
            return this._sourceInvokeExpressions;
        }

        public void run() {
            Project project = Util.getDefiningProject(this.v$context, this.v$sourceMethod.getOwningSourceFile().getURL());
            HashSet hashSet = Util.getDependentProjects(this.v$context.getWorkspace(), project);
            int n = 0;
            int n2 = hashSet.size();
            for (Project project2 : hashSet) {
                this._progressBar.updateProgress(100 * n++ / n2, RefactoringArb.getString(229), project2.getShortLabel());
                List list = this._sourceInvokeExpressions.getOrCreate((Object)project2);
                FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)this.v$sourceMethod);
                findMemberUsages.findMemberUsages(project2, new FindMemberUsages.FillListsUsageListener(null, list, null));
            }
            this._progressBar.setDoneStatus();
        }
    }

    public static class SrcMethodVisitor
    extends Visitor {
        private final MoveInstanceDataSource _selectedData;
        private SourceClass _sourceClass;
        private final HashSet _knownFieldNames;
        private final ArrayList _lhsMethodCallWithParam;
        private final ArrayList _newInnerClass;
        private final ArrayList _classRefMethod;
        private final ArrayList _classRefInner;
        private final ArrayList _unrefMethodCall;
        private final ArrayList _unrefDotExpr;
        private final ArrayList _replaceWithParam;
        private final ArrayList _replaceWithThis;
        private final ArrayList _dotExpressWithParam;

        void $init$() {
            this._lhsMethodCallWithParam = new ArrayList();
            this._newInnerClass = new ArrayList();
            this._classRefMethod = new ArrayList();
            this._classRefInner = new ArrayList();
            this._unrefMethodCall = new ArrayList();
            this._unrefDotExpr = new ArrayList();
            this._replaceWithParam = new ArrayList();
            this._replaceWithThis = new ArrayList();
            this._dotExpressWithParam = new ArrayList();
        }

        public SrcMethodVisitor(MoveInstanceDataSource moveInstanceDataSource, SourceClass sourceClass, HashSet hashSet) {
            this.$init$();
            this._selectedData = moveInstanceDataSource;
            this._sourceClass = sourceClass;
            this._knownFieldNames = hashSet;
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            SourceExpression sourceExpression = sourceMethodCallExpression.getLhsOperand();
            if (sourceExpression == null || "this".equals(sourceExpression.getText())) {
                boolean bl;
                JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
                boolean bl2 = bl = javaMethod == null || javaMethod.isStatic();
                if (bl) {
                    this._classRefMethod.add(sourceMethodCallExpression);
                } else {
                    this._lhsMethodCallWithParam.add(sourceMethodCallExpression);
                }
            } else if (this._selectedData.matches(sourceExpression)) {
                this._unrefMethodCall.add(sourceExpression);
                this.visitChildren((SourceElement)sourceMethodCallExpression.getArgumentList());
                this.skipChildren();
            }
        }

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceNewClassExpression) {
            JavaClass javaClass;
            JavaClass javaClass2;
            JavaMethod javaMethod;
            SourceExpression sourceExpression = sourceNewClassExpression.getLhsOperand();
            if ((sourceExpression == null || "this".equals(sourceExpression.getText())) && (javaMethod = sourceNewClassExpression.getResolvedMethod()) != null && (javaClass2 = javaMethod.getOwningClass()) != null && (javaClass = javaClass2.getOwningClass()) != null && this._sourceClass.equals(javaClass) && !javaClass2.isStatic()) {
                SourceListExpression sourceListExpression = sourceNewClassExpression.getArgumentList();
                this.visitChildren((SourceElement)sourceListExpression);
                this.skipChildren();
                this._newInnerClass.add(sourceNewClassExpression);
            }
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            SourceExpression sourceExpression = sourceDotExpression.getLhsOperand();
            if (this._selectedData.matches(sourceExpression)) {
                this._unrefDotExpr.add(sourceDotExpression);
                this.skipChildren();
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            String string = sourceSimpleNameExpression.getName();
            if ("this".equals(string)) {
                this._replaceWithParam.add(sourceSimpleNameExpression);
            } else if (this._knownFieldNames.contains(string)) {
                JavaHasType javaHasType = sourceSimpleNameExpression.getResolvedObject();
                switch (javaHasType.getElementKind()) {
                    case 5: {
                        if (this._selectedData.equals(javaHasType)) {
                            this._replaceWithThis.add(sourceSimpleNameExpression);
                            break;
                        }
                        this._dotExpressWithParam.add(sourceSimpleNameExpression);
                    }
                }
            } else if (this._selectedData.matches((SourceExpression)sourceSimpleNameExpression)) {
                this._replaceWithThis.add(sourceSimpleNameExpression);
            }
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceTypeReference) {
            JavaType javaType = sourceTypeReference.getResolvedType();
            if (javaType != null) {
                boolean bl = false;
                JavaClass javaClass = javaType.getTypeErasure();
                while (javaClass != null && !bl) {
                    if (this._sourceClass.equals(javaClass)) {
                        bl = true;
                    }
                    javaClass = javaClass.getOwningClass();
                }
                if (bl) {
                    this._classRefInner.add(new Object[]{sourceTypeReference, javaType.getQualifiedName()});
                }
            }
        }

        public ArrayList getDotExpressWithParam() {
            return this._dotExpressWithParam;
        }

        public ArrayList getLhsMethodCallWithParam() {
            return this._lhsMethodCallWithParam;
        }

        public ArrayList getNewInnerClass() {
            return this._newInnerClass;
        }

        public ArrayList getClassRefMethod() {
            return this._classRefMethod;
        }

        public ArrayList getClassRefInner() {
            return this._classRefInner;
        }

        public ArrayList getReplaceWithParam() {
            return this._replaceWithParam;
        }

        public ArrayList getReplaceWithThis() {
            return this._replaceWithThis;
        }

        public ArrayList getUnrefDotExpr() {
            return this._unrefDotExpr;
        }

        public ArrayList getUnrefMethodCall() {
            return this._unrefMethodCall;
        }

        public boolean needsAdditionalParam() {
            return !this._dotExpressWithParam.isEmpty() || !this._lhsMethodCallWithParam.isEmpty() || !this._newInnerClass.isEmpty() || !this._replaceWithParam.isEmpty();
        }
    }
}

