/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.dialogs.BaseDialog;
import oracle.jdevimpl.refactoring.dialogs.CopyableInteger;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceDataSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceFieldSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMemberController;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceMethodSource;
import oracle.jdevimpl.refactoring.oprs.movemember.moveinstancemember.MoveInstanceParamSource;
import oracle.jdevimpl.refactoring.util.JotTreeCellRenderer;
import oracle.jdevimpl.refactoring.util.NameValidation;
import oracle.jdevimpl.refactoring.util.RadioKeyController;

public class MoveInstanceMemberDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "MOVE_MEMBER_PREFS";
    private JTextField _paramName;
    private JRadioButton _radioUseDelegate;
    private JTree _targets;
    private JTextField _methodName;
    private SourceMethod _sourceMethod;
    private DefaultMutableTreeNode _root;
    private TreePath _lastSelectedPath;
    private boolean _needsParam;

    public MoveInstanceMemberDialog(Context context, List list, String string, SourceMethod sourceMethod) {
        super(PREFERENCE_KEY, context);
        this._sourceMethod = sourceMethod;
        this.init(list, string);
    }

    private void init(List list, String string) {
        this._root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = 0;
        while (n < list.size()) {
            JavaHasType javaHasType = (JavaHasType)list.get(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.addNode(javaHasType);
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = defaultMutableTreeNode2;
            }
            ++n;
        }
        JLabel jLabel = new JLabel();
        this._targets = new JTree(this._root);
        this._targets.setCellRenderer((TreeCellRenderer)((Object)new JotTreeCellRenderer()));
        this._targets.setRootVisible(false);
        IdeUtil.expandAllTreeRows((JTree)this._targets);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._targets, (String)RefactoringArb.getString(214));
        JScrollPane jScrollPane = new JScrollPane(this._targets);
        this.updateOnSelectionChange(this._targets);
        JLabel jLabel2 = new JLabel();
        this._methodName = new JTextField(30);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._methodName, (String)RefactoringArb.getString(215));
        this.updateOnChanges(this._methodName);
        JLabel jLabel3 = new JLabel();
        this._paramName = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._paramName, (String)RefactoringArb.getString(216));
        this.updateOnChanges(this._paramName);
        this._radioUseDelegate = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._radioUseDelegate, (String)RefactoringArb.getString(217));
        JRadioButton jRadioButton = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)RefactoringArb.getString(218));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._radioUseDelegate);
        buttonGroup.add(jRadioButton);
        RadioKeyController.attach(buttonGroup);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(219)));
        box.add(this._radioUseDelegate);
        box.add(jRadioButton);
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(jLabel3.getPreferredSize());
        this.setMessageLabel(jLabel4);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._methodName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._paramName, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)box, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (defaultMutableTreeNode != null) {
            Object[] objectArray = defaultMutableTreeNode.getPath();
            this._targets.setSelectionPath(new TreePath(objectArray));
        }
        this._methodName.setText(this._sourceMethod.getName());
        this._paramName.setText(string);
        this._radioUseDelegate.setSelected(true);
    }

    private DefaultMutableTreeNode addNode(JavaHasType javaHasType) {
        JavaType javaType = javaHasType.getResolvedType();
        JavaClass javaClass = javaType.getTypeErasure();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this._root.children();
        while (defaultMutableTreeNode == null && enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!javaClass.equals(defaultMutableTreeNode2.getUserObject())) continue;
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(javaClass);
            this._root.add(defaultMutableTreeNode);
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(javaHasType);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode3;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._targets;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateSettings(CopyableInteger copyableInteger) {
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dchangemethodreplace_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(220);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            boolean bl = true;
            String string = null;
            boolean bl2 = false;
            if (this._paramName.isEnabled()) {
                String string2 = this._paramName.getText();
                if (string2.length() != 0 && IdeUtil.isJavaIdentifier((String)string2)) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (!bl2) {
                string = RefactoringArb.getString(221);
                bl = false;
            } else {
                TreePath treePath = this._targets.getSelectionPath();
                if (treePath == null || treePath.getPathCount() <= 2) {
                    string = null;
                    bl = false;
                } else {
                    String string3;
                    JavaType javaType;
                    Collection collection;
                    MoveInstanceDataSource moveInstanceDataSource = this.getSelectedData();
                    if (!treePath.equals(this._lastSelectedPath)) {
                        this._lastSelectedPath = treePath;
                        MoveInstanceMemberController.SrcMethodVisitor srcMethodVisitor = MoveInstanceMemberController.getReferences(moveInstanceDataSource, this._sourceMethod);
                        this._needsParam = srcMethodVisitor.needsAdditionalParam();
                        this._paramName.setEnabled(this._needsParam);
                    }
                    NameValidation nameValidation = NameValidation.validateMethodName(this.getMethodName(), false);
                    string = nameValidation.getMessage();
                    bl = nameValidation.isValid();
                    if (string == null && !(collection = (javaType = moveInstanceDataSource.getJavaType()).getMethods(string3 = this.getMethodName())).isEmpty()) {
                        JavaType[] javaTypeArray;
                        JavaMethod javaMethod;
                        ArrayList<JavaType> arrayList = new ArrayList<JavaType>(Arrays.asList(this._sourceMethod.getParameterTypes()));
                        Object object = this.getSelectedUserObject();
                        if (object instanceof SourceLocalVariable || object instanceof SourceFormalParameter) {
                            SourceVariable sourceVariable = (SourceVariable)object;
                            SourceElement sourceElement = sourceVariable.getParent();
                            int n = sourceElement.getChildren().indexOf(sourceVariable);
                            arrayList.remove(n);
                        }
                        if (this._needsParam) {
                            JavaClass javaClass = this._sourceMethod.getOwningClass();
                            arrayList.add((JavaType)javaClass);
                        }
                        if ((javaMethod = javaType.getMethod(string3, javaTypeArray = arrayList.toArray(new JavaType[arrayList.size()]))) != null) {
                            bl = false;
                            string = MessageFormat.format(RefactoringArb.getString(222), javaType.getName());
                        }
                    }
                }
            }
            this.setMessage(string, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    public String getMethodName() {
        return this._methodName.getText();
    }

    public String getParamName() {
        return this._paramName.getText();
    }

    public MoveInstanceDataSource getSelectedData() {
        MoveInstanceDataSource moveInstanceDataSource = null;
        Object object = this.getSelectedUserObject();
        if (object instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)object;
            moveInstanceDataSource = new MoveInstanceMethodSource(javaMethod);
        } else if (object instanceof SourceLocalVariable || object instanceof SourceFormalParameter) {
            SourceVariable sourceVariable = (SourceVariable)object;
            moveInstanceDataSource = new MoveInstanceParamSource(sourceVariable);
        } else if (object instanceof JavaField) {
            JavaField javaField = (JavaField)object;
            moveInstanceDataSource = new MoveInstanceFieldSource(javaField);
        }
        return moveInstanceDataSource;
    }

    private Object getSelectedUserObject() {
        TreePath treePath = this._targets.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        return object;
    }

    public boolean isUseDelegate() {
        return this._radioUseDelegate.isSelected();
    }
}

