/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.movestatic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.controls.classpick.Filter;
import oracle.jdeveloper.controls.classpick.TextFieldAdapter;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberDialog;

public class MoveStaticDialog
extends MoveMemberDialog
implements Filter {
    public static final String PREFERENCE_KEY = "MOVE_STAT_PREF_KEY";
    private JTextField _targetClassField;

    public MoveStaticDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
        this.init();
    }

    public boolean init() {
        this.setPreferredSize(new Dimension(420, 240));
        JComponent jComponent = this.createTargetComponent();
        JLabel jLabel = null;
        if (jComponent != null) {
            jLabel = new JLabel();
            JComponent jComponent2 = GraphicsUtils.getFocusableComponentOrChild((Component)jComponent, (boolean)true);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)jComponent2, (String)RefactoringArb.getString(112));
        }
        this._members = this.createTable();
        JScrollPane jScrollPane = new JScrollPane(this._members);
        jScrollPane.getViewport().setBackground(this._members.getBackground());
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._members, (String)RefactoringArb.getString(83));
        Insets insets = new Insets(2, 2, 2, 2);
        if (jComponent != null) {
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)jComponent, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        }
        this.add((Component)jLabel2, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        return true;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dmovemembers_html";
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(211);
    }

    protected JComponent createTargetComponent() {
        1MyListeners myListeners = new 1MyListeners();
        this._targetClassField = new JTextField();
        this.updateOnChanges(this._targetClassField);
        JButton jButton = new JButton("...");
        jButton.addActionListener(myListeners);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this._targetClassField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        TextFieldAdapter textFieldAdapter = ClassPickerFactory.attach(this._targetClassField, this.getContext(), 26);
        textFieldAdapter.setFilter(this);
        return jPanel;
    }

    protected boolean canClose() {
        SourceClass sourceClass = this.getTargetClass();
        return this.confirmCanProceedWithExistingMembers((JavaClass)sourceClass);
    }

    protected JTable createTable() {
        JTable jTable = super.createTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        jTable.removeColumn(tableColumn);
        return jTable;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._targetClassField;
    }

    SourceClass getTargetClass() {
        JavaProvider javaProvider = this.getProvider();
        String string = this.getTargetClassName();
        SourceClass sourceClass = javaProvider.getSourceClass(string);
        return sourceClass;
    }

    public String getTargetClassName() {
        return this._targetClassField.getText();
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        return this.calculateDownDependencies(sourceClass);
    }

    protected void updateOKButton() {
        SourceClass sourceClass;
        boolean bl = false;
        if (this.hasSelection() && (sourceClass = this.getTargetClass()) != null && this.getSourceSourceClass() != sourceClass) {
            bl = true;
        }
        this.setOKButtonEnabled(bl);
    }

    private JavaProvider getProvider() {
        SourceClass sourceClass = this.getSourceSourceClass();
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        JavaProvider javaProvider = sourceFile.getProvider();
        return javaProvider;
    }

    private void whenBrowse() {
        SourceClass sourceClass;
        String string;
        1 var4_4;
        Project project = this.getContext().getProject();
        String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage(this, project, 2, 0, false, var4_4 = new 1(), new String[]{string = (sourceClass = this.getSourceSourceClass()).getPackageName()});
        if (stringArray != null && stringArray.length == 1) {
            String string2 = stringArray[0];
            JavaProvider javaProvider = sourceClass.getOwningSourceFile().getProvider();
            SourceClass sourceClass2 = javaProvider.getSourceClass(string2);
            if (sourceClass2 != null) {
                this._targetClassField.setText(string2);
            }
        }
    }

    protected Collection getMoveableFields() {
        SourceClass sourceClass = this.getSourceSourceClass();
        Collection collection = sourceClass.getDeclaredFields();
        ArrayList<SourceFieldVariable> arrayList = new ArrayList<SourceFieldVariable>(collection.size());
        for (SourceFieldVariable sourceFieldVariable : collection) {
            if (!sourceFieldVariable.isStatic()) continue;
            arrayList.add(sourceFieldVariable);
        }
        return arrayList;
    }

    protected Collection getMoveableMethods() {
        ArrayList<SourceMethod> arrayList = new ArrayList<SourceMethod>();
        List list = this.getSourceSourceClass().getSourceMethods();
        int n = 0;
        while (n < list.size()) {
            SourceMethod sourceMethod = (SourceMethod)list.get(n);
            if (sourceMethod.isStatic()) {
                arrayList.add(sourceMethod);
            }
            ++n;
        }
        return arrayList;
    }

    protected Collection getMoveableInterfaces() {
        return Collections.EMPTY_LIST;
    }

    public boolean acceptPackageName(String string) {
        return true;
    }

    public boolean acceptClassName(String string, String string2) {
        if (string.length() > 0) {
            string2 = string + '.' + string2;
        }
        SourceClass sourceClass = this.getProvider().getSourceClass(string2);
        return !this.getSourceSourceClass().equals(sourceClass);
    }

    static void mav$whenBrowse(MoveStaticDialog moveStaticDialog) {
        moveStaticDialog.whenBrowse();
    }

    public class 1MyListeners
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MoveStaticDialog.mav$whenBrowse(MoveStaticDialog.this);
        }

        1MyListeners() {
        }
    }

    public final class 1
    implements ClassPackageBrowserFilterV2 {
        public boolean acceptPackage(String string) {
            return true;
        }

        public boolean acceptClass(JavaClass javaClass) {
            String string = MoveStaticDialog.this.getSourceSourceClass().getQualifiedName();
            String string2 = javaClass.getName();
            return !string2.equals(string);
        }
    }
}

