/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.movestatic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.movestatic.MoveStaticDialog;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class MoveStaticOperation {
    private static final int NEEDS_PUBLIC = 1;
    private static final int NEEDS_PROTECTED = 2;
    private static final int NEEDS_PPRIVATE = 4;
    private HashMap _memberAccessNeeds;
    private ArrayList _methodCalls;
    private ArrayList _fieldAccesses;
    private static final boolean HAS_BUG_NEEDS_SAVEPOINT_FOR_MODIFIERS = true;

    void $init$() {
        this._memberAccessNeeds = new HashMap();
    }

    public void whenMoveMembers(Context context, SourceMember sourceMember) {
        SourceClass sourceClass = sourceMember.getEnclosingClass();
        MoveStaticDialog moveStaticDialog = new MoveStaticDialog(context, sourceClass);
        moveStaticDialog.preselectMember(sourceMember);
        if (moveStaticDialog.runDialog()) {
            SourceClass sourceClass2 = moveStaticDialog.getTargetClass();
            SourceClassBody sourceClassBody = sourceClass2.getSourceBody();
            SourceFieldVariable[] sourceFieldVariableArray = moveStaticDialog.getPulledFields();
            MoveMemberMethodEntry[] moveMemberMethodEntryArray = moveStaticDialog.getPulledMethodEntries();
            this.populateCallers(context.getProject(), sourceFieldVariableArray, moveMemberMethodEntryArray);
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
                SourceTransaction sourceTransaction = refactoringCommandSupport.beginTransaction((SourceElement)sourceClass2);
                this.adaptCallers(refactoringCommandSupport, sourceClass2);
                this.moveFields(sourceClassBody, sourceFieldVariableArray);
                this.moveMethods(sourceTransaction, sourceClassBody, moveMemberMethodEntryArray);
                refactoringCommandSupport.commit(context, RefactoringArb.getString(211));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                refactoringCommandSupport.abort();
            }
        }
    }

    private void populateCallers(Project project, SourceFieldVariable[] sourceFieldVariableArray, MoveMemberMethodEntry[] moveMemberMethodEntryArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(sourceFieldVariableArray.length + moveMemberMethodEntryArray.length);
        arrayList.addAll(Arrays.asList(sourceFieldVariableArray));
        int n = 0;
        while (n < moveMemberMethodEntryArray.length) {
            MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n];
            SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
            arrayList.add(sourceMethod);
            ++n;
        }
        SourceMember[] sourceMemberArray = arrayList.toArray(new SourceMember[arrayList.size()]);
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember[])sourceMemberArray);
        this._methodCalls = new ArrayList();
        this._fieldAccesses = new ArrayList();
        FindMemberUsages.FillListsUsageListener fillListsUsageListener = new FindMemberUsages.FillListsUsageListener(null, this._methodCalls, this._fieldAccesses);
        findMemberUsages.findMemberUsages(project, fillListsUsageListener);
    }

    private void moveMethods(SourceTransaction sourceTransaction, SourceClassBody sourceClassBody, MoveMemberMethodEntry[] moveMemberMethodEntryArray) {
        SourceFile sourceFile = sourceClassBody.getOwningSourceFile();
        int n = 0;
        while (n < moveMemberMethodEntryArray.length) {
            MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n];
            SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
            int n2 = this.getFixedModifiers((SourceMember)sourceMethod);
            SourceMethod sourceMethod2 = (SourceMethod)sourceMethod.cloneSelf(sourceFile);
            sourceMethod2.addSelf((SourceElement)sourceClassBody);
            sourceMethod.removeSelf();
            sourceTransaction.savepoint();
            sourceMethod2.setModifiers(n2);
            ++n;
        }
    }

    private void moveFields(SourceClassBody sourceClassBody, SourceFieldVariable[] sourceFieldVariableArray) {
        SourceFile sourceFile = sourceClassBody.getOwningSourceFile();
        int n = 0;
        while (n < sourceFieldVariableArray.length) {
            SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n];
            int n2 = this.getFixedModifiers((SourceMember)sourceFieldVariable);
            SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceFieldVariable.getSourceType().cloneSelf(sourceFile);
            SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
            SourceExpression sourceExpression2 = sourceExpression == null ? null : (SourceExpression)sourceExpression.cloneSelf(sourceFile);
            String string = sourceFieldVariable.getName();
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(n2, sourceTypeReference, string, sourceExpression2);
            sourceFieldDeclaration.addSelf((SourceElement)sourceClassBody);
            sourceFieldVariable.removeSelf();
            ++n;
        }
    }

    private void adaptCallers(RefactoringCommandSupport refactoringCommandSupport, SourceClass sourceClass) {
        int n = 0;
        while (n < this._methodCalls.size()) {
            SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)this._methodCalls.get(n);
            SourceFile sourceFile = sourceInvokeExpression.getOwningSourceFile();
            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory sourceFactory = sourceFile.getFactory();
            JavaMethod javaMethod = sourceInvokeExpression.getResolvedMethod();
            SourceClass sourceClass2 = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceInvokeExpression);
            boolean bl = sourceClass.isAssignableFrom((JavaType)sourceClass2);
            boolean bl2 = sourceClass.getPackageName().equals(sourceClass2.getPackageName());
            this.addMemberAccessNeeds((JavaMember)javaMethod, bl, bl2);
            SourceExpression sourceExpression = sourceInvokeExpression.getLhsOperand();
            if (sourceExpression == null) {
                if (!bl) {
                    SourceExpression sourceExpression2 = sourceFactory.createExpression(sourceClass.getQualifiedName());
                    sourceInvokeExpression.setLhsOperand(sourceExpression2);
                }
            } else if (bl) {
                sourceExpression.removeSelf();
            } else {
                sourceExpression.removeSelf();
                SourceExpression sourceExpression3 = sourceFactory.createExpression(sourceClass.getQualifiedName());
                sourceInvokeExpression.setLhsOperand(sourceExpression3);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this._fieldAccesses.size()) {
            SourceExpression sourceExpression = (SourceExpression)this._fieldAccesses.get(n2);
            SourceClass sourceClass3 = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceExpression);
            boolean bl = sourceClass.isAssignableFrom((JavaType)sourceClass3);
            boolean bl3 = sourceClass.getPackageName().equals(sourceClass3.getPackageName());
            this.addMemberAccessNeeds((JavaMember)sourceExpression.getResolvedObject(), bl, bl3);
            SourceFile sourceFile = sourceExpression.getOwningSourceFile();
            refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
            SourceFactory sourceFactory = sourceFile.getFactory();
            switch (sourceExpression.getSymbolKind()) {
                case 58: {
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceExpression;
                    if (bl) break;
                    String string = sourceClass.getQualifiedName() + '.' + sourceSimpleNameExpression.getName();
                    SourceExpression sourceExpression4 = sourceFactory.createExpression(string);
                    sourceSimpleNameExpression.replaceSelf((SourceElement)sourceExpression4);
                    break;
                }
                case 50: {
                    SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceExpression;
                    SourceExpression sourceExpression5 = sourceDotExpression.getLhsOperand();
                    if (sourceExpression5 == null) break;
                    if (bl) {
                        SourceSimpleNameExpression sourceSimpleNameExpression = sourceFactory.createSimpleNameExpression(sourceDotExpression.getName());
                        sourceDotExpression.replaceSelf((SourceElement)sourceSimpleNameExpression);
                        break;
                    }
                    String string = sourceClass.getQualifiedName() + '.' + sourceDotExpression.getName();
                    SourceExpression sourceExpression6 = sourceFactory.createExpression(string);
                    sourceDotExpression.replaceSelf((SourceElement)sourceExpression6);
                }
            }
            ++n2;
        }
    }

    private int getFixedModifiers(SourceMember sourceMember) {
        int n = sourceMember.getModifiers();
        Integer n2 = (Integer)this._memberAccessNeeds.get(sourceMember);
        if (n2 != null) {
            int n3 = n2;
            if (!sourceMember.isPublic()) {
                if (BitField.isSet((int)n3, (int)1)) {
                    n = BitField.unset((int)n, (int)6);
                    n = BitField.set((int)n, (int)1);
                } else if (BitField.isSet((int)n3, (int)2)) {
                    if (!sourceMember.isProtected()) {
                        n = BitField.unset((int)n, (int)3);
                        n = BitField.set((int)n, (int)4);
                    }
                } else if (BitField.isSet((int)n3, (int)4) && !sourceMember.isProtected()) {
                    n = BitField.unset((int)n, (int)7);
                }
            }
        }
        return n;
    }

    private void addMemberAccessNeeds(JavaMember javaMember, boolean bl, boolean bl2) {
        int n = !bl ? (bl2 ? 4 : 1) : 2;
        Integer n2 = (Integer)this._memberAccessNeeds.get(javaMember);
        int n3 = n2 != null ? n2 : 0;
        this._memberAccessNeeds.put(javaMember, new Integer(n3 | n));
    }

    public MoveStaticOperation() {
        this.$init$();
    }
}

