/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pullup;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpDialog;
import oracle.jdevimpl.refactoring.util.Visitor;

public class PullUpController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = PullUpController.handle(context, false);
        ideAction.setEnabled(bl);
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        PullUpController.handle(context, true);
        return true;
    }

    public static boolean canPullUp(SourceClass sourceClass) {
        return PullUpController.canPullUp(null, sourceClass, false);
    }

    private static boolean handle(Context context, boolean bl) {
        SourceClass sourceClass;
        boolean bl2 = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (sourceClass = ElementAt.getSourceClassAt(context, false, false)) != null) {
            bl2 = PullUpController.canPullUp(context, sourceClass, bl);
        }
        return bl2;
    }

    private static boolean canPullUp(Context context, SourceClass sourceClass, boolean bl) {
        boolean bl2 = false;
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        if (Util.canRefactor(uRL) && (sourceClass.getSourceSuperclass() != null || !sourceClass.getSourceInterfaces().isEmpty())) {
            bl2 = true;
            if (bl) {
                ArrayList arrayList = PullUpController.getPossibleTargets(context, sourceClass);
                if (!arrayList.isEmpty()) {
                    if (PullUpController.hasMembersToMove(sourceClass)) {
                        SourceMember sourceMember = PullUpController.getEnclosingMember(context);
                        PullUpController.whenPullUp(context, sourceClass, sourceMember);
                    } else {
                        Util.showRefactoringErrorMessage(RefactoringArb.getString(111), RefactoringArb.getString(209));
                    }
                } else {
                    Util.showRefactoringErrorMessage(RefactoringArb.getString(111), RefactoringArb.getString(114));
                }
            }
        }
        return bl2;
    }

    public static void whenPullUp(Context context, SourceClass sourceClass, SourceMember sourceMember) {
        PullUpDialog pullUpDialog = new PullUpDialog(context, sourceClass);
        if (pullUpDialog.init()) {
            pullUpDialog.preselectMember(sourceMember);
            if (pullUpDialog.runDialog()) {
                try {
                    PullUpController.whenPullUp(context, sourceClass, pullUpDialog);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static SourceMember getEnclosingMember(Context context) {
        SourceMember sourceMember = null;
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            int n = codeEditor.getCaretPosition();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            Node node = context.getNode();
            URL uRL = node.getURL();
            SourceFile sourceFile = javaManager.getSourceFile(uRL);
            1 var10_10 = new 1(n);
            var10_10.visit((SourceElement)sourceFile);
            Object object = var10_10.getUserData();
            if (object != null) {
                sourceMember = (SourceMember)object;
            }
        } else {
            ElementAt elementAt = ElementAt.findElementAt(context);
            switch (elementAt.getElementType()) {
                case 3: 
                case 4: {
                    sourceMember = (SourceMember)elementAt.getSourceElement();
                }
            }
        }
        return sourceMember;
    }

    private static void whenPullUp(Context context, SourceClass sourceClass, PullUpDialog pullUpDialog) {
        SourceClass sourceClass2 = pullUpDialog.getTarget();
        SourceFile sourceFile = sourceClass2.getOwningSourceFile();
        MoveMemberMethodEntry[] moveMemberMethodEntryArray = pullUpDialog.getPulledMethodEntries();
        SourceFieldVariable[] sourceFieldVariableArray = pullUpDialog.getPulledFields();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.beginTransaction((SourceElement)sourceClass2);
        try {
            SourceClassBody sourceClassBody = sourceClass2.getSourceBody();
            boolean bl = sourceClass2.isInterface();
            boolean bl2 = false;
            int n = 0;
            while (n < moveMemberMethodEntryArray.length) {
                SourceBlock sourceBlock;
                MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n];
                SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
                SourceMethod sourceMethod2 = (SourceMethod)sourceMethod.cloneSelf(sourceFile);
                if ((bl || moveMemberMethodEntry.isAbstract()) && (sourceBlock = sourceMethod2.getBlock()) != null) {
                    sourceBlock.removeSelf();
                }
                if (!bl && moveMemberMethodEntry.isAbstract()) {
                    sourceMethod2.addModifiers(1024);
                    bl2 = true;
                }
                if (bl) {
                    sourceMethod2.removeModifiers(1025);
                } else {
                    PullUpController.adaptModifiers(refactoringCommandSupport, (SourceMember)sourceMethod, (SourceMember)sourceMethod2);
                }
                sourceMethod2.addSelf((SourceElement)sourceClassBody);
                if (!moveMemberMethodEntry.isAbstract() && !bl) {
                    refactoringCommandSupport.beginTransaction((SourceElement)sourceMethod);
                    sourceMethod.removeSelf();
                }
                ++n;
            }
            if (bl2) {
                sourceClass2.addModifiers(1024);
            }
            SourceFactory sourceFactory = sourceFile.getFactory();
            int n2 = 0;
            while (n2 < sourceFieldVariableArray.length) {
                SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n2];
                SourceFieldVariable sourceFieldVariable2 = (SourceFieldVariable)sourceFieldVariable.cloneSelf(sourceFile);
                PullUpController.adaptModifiers(refactoringCommandSupport, (SourceMember)sourceFieldVariable, (SourceMember)sourceFieldVariable2);
                SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(sourceFieldVariable2);
                sourceFieldDeclaration.addSelf((SourceElement)sourceClassBody);
                refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
                sourceFieldVariable.removeSelf();
                ++n2;
            }
            refactoringCommandSupport.commit(context, RefactoringArb.getString(111));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static void adaptModifiers(RefactoringCommandSupport refactoringCommandSupport, SourceMember sourceMember, SourceMember sourceMember2) {
        String string;
        String string2;
        SourceFile sourceFile = sourceMember.getOwningSourceFile();
        SourceFile sourceFile2 = sourceMember2.getOwningSourceFile();
        boolean bl = false;
        if (sourceMember2.isPrivate()) {
            bl = true;
        } else if (sourceMember2.isPackagePrivate() && !(string2 = sourceFile.getPackageName()).equals(string = sourceFile2.getPackageName())) {
            bl = true;
        }
        if (bl) {
            refactoringCommandSupport.beginTransaction((SourceElement)sourceMember);
            sourceMember.removeModifiers(2);
            sourceMember.addModifiers(4);
            sourceMember2.removeModifiers(2);
            sourceMember2.addModifiers(4);
        }
    }

    public static boolean hasMembersToMove(SourceClass sourceClass) {
        Collection collection = sourceClass.getDeclaredMethods();
        if (collection.size() > 0) {
            return true;
        }
        Collection collection2 = sourceClass.getDeclaredFields();
        return collection2.size() > 0;
    }

    static ArrayList getPossibleTargets(Context context, SourceClass sourceClass) {
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        ArrayList<SourceElement> arrayList = new ArrayList<SourceElement>();
        ArrayList<JavaType> arrayList2 = new ArrayList<JavaType>();
        arrayList2.add(sourceClass.getSuperclass());
        arrayList2.addAll(sourceClass.getInterfaces());
        while (!arrayList2.isEmpty()) {
            SourceElement sourceElement;
            SourceClass sourceClass2;
            JavaType javaType = (JavaType)arrayList2.remove(0);
            if (javaType == null) continue;
            arrayList2.add(javaType.getSuperclass());
            arrayList2.addAll(javaType.getInterfaces());
            JavaClass javaClass = javaType.getTypeErasure();
            if (javaClass == null || !PullUpController.isValidTarget(workspace, project, sourceClass2 = (SourceClass)javaClass.getSourceElement()) || arrayList.contains(sourceElement = javaClass.getSourceElement())) continue;
            arrayList.add(sourceElement);
        }
        return arrayList;
    }

    static boolean isValidTarget(Workspace workspace, Project project, SourceClass sourceClass) {
        boolean bl = false;
        if (sourceClass != null && Util.isClassInSources(workspace, project, sourceClass) && Util.canRefactor((SourceElement)sourceClass)) {
            bl = true;
        }
        return bl;
    }

    public static final class 1
    extends Visitor {
        private final /* synthetic */ int v$caretPosition;

        protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
            this.whenEnter((SourceMember)sourceMethod);
        }

        protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
            this.whenEnter((SourceMember)sourceFieldVariable);
        }

        private void whenEnter(SourceMember sourceMember) {
            if (sourceMember.getStartOffset() <= this.v$caretPosition && this.v$caretPosition <= sourceMember.getEndOffset()) {
                this.setUserData(sourceMember);
            }
        }

        protected void whenEnterFieldDeclaration(SourceFieldDeclaration sourceFieldDeclaration) {
            List list = sourceFieldDeclaration.getVariables();
            if (list.size() == 1) {
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)list.get(0);
                this.whenEnter((SourceMember)sourceFieldVariable);
            }
        }

        public 1(int n) {
            this.v$caretPosition = n;
        }
    }
}

