/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pullup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.Context;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberTableModel;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveUpDownDialog;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpController;
import oracle.jdevimpl.refactoring.util.JotListCellRenderer;

public class PullUpDialog
extends MoveUpDownDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "PULL_UP_PREF_KEY";
    private DefaultComboBoxModel _targetModel;
    private JComboBox _targetComboBox;

    public PullUpDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
    }

    public boolean init() {
        boolean bl = false;
        if (this.buildTargetModel()) {
            this.setPreferredSize(new Dimension(420, 240));
            JComponent jComponent = this.createTargetComponent();
            JLabel jLabel = new JLabel();
            JComponent jComponent2 = GraphicsUtils.getFocusableComponentOrChild((Component)jComponent, (boolean)true);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)jComponent2, (String)RefactoringArb.getString(112));
            this._members = this.createTable();
            JScrollPane jScrollPane = new JScrollPane(this._members);
            jScrollPane.getViewport().setBackground(this._members.getBackground());
            JLabel jLabel2 = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._members, (String)RefactoringArb.getString(83));
            Insets insets = new Insets(2, 2, 2, 2);
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)jComponent, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)jLabel2, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
            bl = true;
        }
        return bl;
    }

    protected boolean canClose() {
        SourceClass sourceClass = this.getTarget();
        return this.confirmCanProceedWithExistingMembers((JavaClass)sourceClass);
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(111);
    }

    private boolean buildTargetModel() {
        SourceClass sourceClass;
        boolean bl = false;
        Context context = this.getContext();
        ArrayList arrayList = PullUpController.getPossibleTargets(context, sourceClass = this.getSourceSourceClass());
        if (arrayList.isEmpty()) {
            Util.showRefactoringErrorMessage(111, 114);
        } else {
            Object[] objectArray = arrayList.toArray(new Object[arrayList.size()]);
            this._targetModel = new DefaultComboBoxModel<Object>(objectArray);
            bl = true;
        }
        return bl;
    }

    public SourceClass getTarget() {
        SourceClass sourceClass = null;
        if (this._targetModel != null) {
            sourceClass = (SourceClass)this._targetModel.getSelectedItem();
        }
        return sourceClass;
    }

    protected Collection getMoveableInterfaces() {
        ArrayList arrayList = new ArrayList(super.getMoveableInterfaces());
        SourceClass sourceClass = this.getTarget();
        if (sourceClass != null && sourceClass.isInterface()) {
            int n = arrayList.size() - 1;
            while (n >= 0) {
                JavaType javaType = (JavaType)arrayList.get(n);
                if (javaType.isAssignableFrom((JavaType)sourceClass)) {
                    arrayList.remove(n);
                }
                --n;
            }
        }
        return arrayList;
    }

    protected ComboBoxModel getTargetModel() {
        return this._targetModel;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dpullmembersup_html";
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        List list = sourceClass.getSourceMethods();
        MultiMap multiMap = new MultiMap();
        int n = 0;
        while (n < list.size()) {
            SourceMethod sourceMethod = (SourceMethod)list.get(n);
            HashSet hashSet = this.calculateDependencies(sourceMethod.getEnclosingClass(), (SourceElement)sourceMethod.getBlock());
            for (SourceElement sourceElement : hashSet) {
                multiMap.add((Object)sourceElement, (Object)sourceMethod);
            }
            ++n;
        }
        Collection collection = sourceClass.getSourceFieldVariables();
        for (SourceFieldVariable sourceFieldVariable : collection) {
            SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
            HashSet hashSet = this.calculateDependencies(sourceClass, (SourceElement)sourceExpression);
            for (SourceElement sourceElement : hashSet) {
                multiMap.add((Object)sourceElement, (Object)sourceFieldVariable);
            }
        }
        return multiMap;
    }

    protected JComponent createTargetComponent() {
        this._targetComboBox = new JComboBox(this._targetModel);
        this._targetComboBox.setRenderer(new JotListCellRenderer());
        this._targetComboBox.addActionListener(this);
        return this._targetComboBox;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MoveMemberTableModel moveMemberTableModel = this.createTableModel();
        this._members.setModel(moveMemberTableModel);
        this.updateTableColumns(this._members);
        if (this.getTarget().isInterface()) {
            ArrayList arrayList = moveMemberTableModel.getEntries();
            int n = 0;
            while (n < arrayList.size()) {
                MoveMemberEntry moveMemberEntry = (MoveMemberEntry)arrayList.get(n);
                moveMemberEntry.setEnabled(2, false);
                moveMemberEntry.setEnabled(3, false);
                ++n;
            }
        }
    }
}

