/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pushdown;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.refactoring.criteria.PushDownCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.BasicOperation;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpController;
import oracle.jdevimpl.refactoring.oprs.movemember.pushdown.PushDownDialog;

public class PushDownController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        SourceClass sourceClass;
        boolean bl = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (sourceClass = ElementAt.getSourceClassAt(context, false, false)) != null) {
            bl = PushDownController.canPushDown(sourceClass);
        }
        ideAction.setEnabled(bl);
        return true;
    }

    public static boolean canPushDown(SourceClass sourceClass) {
        SourceFile sourceFile;
        URL uRL;
        boolean bl = false;
        if (!sourceClass.isAnnotation() && !sourceClass.isAnonymous() && PullUpController.hasMembersToMove(sourceClass) && Util.canRefactor(uRL = (sourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            bl = true;
        }
        return bl;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
        if (sourceClass != null) {
            PushDownController.whenPushDown(context, sourceClass, (SourceMember)null);
        }
        return true;
    }

    private static int fixMethodModifiers(int n) {
        if (BitField.isSet((int)n, (int)2) || Util.isPackagePrivate(n)) {
            n = BitField.unset((int)n, (int)2);
            n = BitField.set((int)n, (int)4);
        }
        return n;
    }

    public static void whenPushDown(Context context, SourceClass sourceClass, SourceMember sourceMember) {
        PushDownDialog pushDownDialog = new PushDownDialog(context, sourceClass);
        if (pushDownDialog.init() && pushDownDialog.runDialog() && pushDownDialog.isValidOperation()) {
            try {
                PushDownController.whenPushDown(context, sourceClass, pushDownDialog);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void whenPushDown(Context context, SourceClass sourceClass, PushDownDialog pushDownDialog) {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            MoveMemberMethodEntry[] moveMemberMethodEntryArray = pushDownDialog.getPulledMethodEntries();
            SourceFieldVariable[] sourceFieldVariableArray = pushDownDialog.getPulledFields();
            SourceClass[] sourceClassArray = pushDownDialog.getSubClasses();
            int n = 0;
            while (n < sourceClassArray.length) {
                SourceClass sourceClass2 = sourceClassArray[n];
                SourceClassBody sourceClassBody = sourceClass2.getSourceBody();
                SourceFile sourceFile = sourceClass2.getOwningSourceFile();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                SourceFactory sourceFactory = sourceFile.getFactory();
                int n2 = 0;
                while (n2 < moveMemberMethodEntryArray.length) {
                    MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n2];
                    SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
                    int n3 = sourceMethod.getModifiers();
                    int n4 = PushDownController.fixMethodModifiers(n3);
                    SourceMethod sourceMethod2 = (SourceMethod)sourceMethod.cloneSelf(sourceFile);
                    sourceMethod2.setModifiers(n4);
                    sourceMethod2.addSelf((SourceElement)sourceClassBody);
                    ++n2;
                }
                int n5 = 0;
                while (n5 < sourceFieldVariableArray.length) {
                    SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n5];
                    int n6 = PushDownController.fixMethodModifiers(sourceFieldVariable.getModifiers());
                    SourceFieldVariable sourceFieldVariable2 = (SourceFieldVariable)sourceFieldVariable.cloneSelf(sourceFile);
                    sourceFieldVariable2.setModifiers(n6);
                    SourceFieldDeclaration sourceFieldDeclaration = sourceFactory.createFieldDeclaration(sourceFieldVariable2);
                    sourceFieldDeclaration.addSelf((SourceElement)sourceClassBody);
                    ++n5;
                }
                ++n;
            }
            boolean bl = false;
            int n7 = 0;
            while (n7 < moveMemberMethodEntryArray.length) {
                MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n7];
                SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceMethod);
                if (moveMemberMethodEntry.isAbstract()) {
                    if (!sourceMethod.isAbstract()) {
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceMethod);
                        SourceBlock sourceBlock = sourceMethod.getBlock();
                        sourceBlock.removeSelf();
                        sourceMethod.addModifiers(1024);
                        bl = true;
                    }
                } else {
                    sourceMethod.removeSelf();
                }
                ++n7;
            }
            int n8 = 0;
            while (n8 < sourceFieldVariableArray.length) {
                SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n8];
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFieldVariable);
                sourceFieldVariable.removeSelf();
                ++n8;
            }
            if (bl && !sourceClass.isAbstract()) {
                refactoringCommandSupport.beginTransaction((SourceElement)sourceClass);
                sourceClass.addModifiers(1024);
            }
            ClassDescription[] classDescriptionArray = new ClassDescription[sourceClassArray.length];
            int n9 = 0;
            while (n9 < sourceClassArray.length) {
                SourceClass sourceClass3 = sourceClassArray[n9];
                classDescriptionArray[n9] = ClassDescription.createClassDescription((JavaClass)sourceClass3);
                ++n9;
            }
            MethodDescription[] methodDescriptionArray = new MethodDescription[moveMemberMethodEntryArray.length];
            boolean[] blArray = new boolean[methodDescriptionArray.length];
            int n10 = 0;
            while (n10 < moveMemberMethodEntryArray.length) {
                MoveMemberMethodEntry moveMemberMethodEntry = moveMemberMethodEntryArray[n10];
                SourceMethod sourceMethod = moveMemberMethodEntry.getMethod();
                methodDescriptionArray[n10] = new MethodDescription((JavaMethod)sourceMethod);
                blArray[n10] = moveMemberMethodEntry.isAbstract();
                ++n10;
            }
            FieldDescription[] fieldDescriptionArray = new FieldDescription[sourceFieldVariableArray.length];
            int n11 = 0;
            while (n11 < sourceFieldVariableArray.length) {
                SourceFieldVariable sourceFieldVariable = sourceFieldVariableArray[n11];
                fieldDescriptionArray[n11] = new FieldDescription((JavaField)sourceFieldVariable);
                ++n11;
            }
            PushDownCriteria pushDownCriteria = new PushDownCriteria(ClassDescription.createClassDescription((JavaClass)sourceClass), classDescriptionArray, methodDescriptionArray, blArray, fieldDescriptionArray);
            BasicOperation basicOperation = new BasicOperation(context, pushDownCriteria);
            refactoringCommandSupport.setSearchOperation(basicOperation);
            refactoringCommandSupport.commit(context, RefactoringArb.getString(208));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }
}

