/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class RenameClassDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_CLASS_DEFAULTS";
    private SourceClass _sourceClass;
    private String _oldName;

    public RenameClassDialog(Context context, SourceClass sourceClass) {
        super(context, PREFERENCE_KEY);
        this._sourceClass = sourceClass;
        this._oldName = this._sourceClass.getName();
        int n = this._oldName.lastIndexOf(36);
        if (n >= 0) {
            this._oldName = this._oldName.substring(n + 1);
        }
        this.setOldName(this._oldName);
    }

    public boolean runDialog() {
        SourceFile sourceFile;
        URL uRL;
        URL uRL2;
        URL uRL3;
        String string;
        boolean bl = super.runDialog();
        if (bl && (string = URLFileSystem.getPlatformPathName((URL)(uRL3 = URLFactory.newURL((URL)(uRL2 = URLFileSystem.getParent((URL)(uRL = (sourceFile = this._sourceClass.getOwningSourceFile()).getURL()))), (String)(this.getNewName() + ".java"))))).length() > 255) {
            Util.showRefactoringErrorMessage(49, 39);
            bl = false;
        }
        return bl;
    }

    protected String getTitle() {
        String string = this._sourceClass.getName();
        String string2 = MessageFormat.format(RefactoringArb.getString(49), string);
        return string2;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String string = this.getNewName();
            Project project = this.getContext().getProject();
            String string2 = this._sourceClass.getPackageName();
            boolean bl = false;
            String string3 = null;
            if (!this._oldName.equals(string)) {
                NameValidation nameValidation = NameValidation.validateClassName(project, string2, string, true);
                bl = nameValidation.isValid();
                string3 = nameValidation.getMessage();
            }
            this.setMessage(string3, bl);
            this.setOKButtonEnabled(bl);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }
}

