/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameVariableCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigController;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveController;
import oracle.jdevimpl.refactoring.oprs.rename.RenameClassDialog;
import oracle.jdevimpl.refactoring.oprs.rename.RenamePackageDialog;
import oracle.jdevimpl.refactoring.oprs.rename.RenameVariableDialog;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldDialog;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodDialog;

public class RenameController
implements Controller {
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            ElementAt elementAt = ElementAt.findElementAt(context);
            int n = elementAt != null ? elementAt.getElementType() : -1;
            switch (n) {
                case 3: 
                case 4: 
                case 7: {
                    JavaMember javaMember = (JavaMember)elementAt.getJavaElement();
                    bl = RenameController.canRenameMember(context, javaMember);
                    break;
                }
                case 1: 
                case 2: {
                    bl = RenameController.canRename(context, elementAt);
                    break;
                }
                case 5: {
                    SourceElement sourceElement = elementAt.getSourceElement();
                    SourceFile sourceFile = sourceElement.getOwningSourceFile();
                    URL uRL = sourceFile.getURL();
                    bl = Util.canRefactor(uRL);
                    break;
                }
                case 6: {
                    bl = RenameController.canRenamePackage();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        ideAction.setEnabled(bl);
        return true;
    }

    private static boolean canRename(Context context, ElementAt elementAt) {
        JavaElement javaElement = elementAt.getJavaElement();
        boolean bl = RenameController.canRename(context, javaElement);
        return bl;
    }

    private static boolean canRename(Context context, JavaElement javaElement) {
        boolean bl = false;
        SourceElement sourceElement = javaElement.getSourceElement();
        if (sourceElement != null) {
            SourceFile sourceFile = sourceElement.getOwningSourceFile();
            URL uRL = sourceFile.getURL();
            bl = Util.canRefactor(context, uRL);
        }
        return bl;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        int n = elementAt != null ? elementAt.getElementType() : -1;
        switch (n) {
            case 3: {
                SourceMethod sourceMethod;
                SourceMethod sourceMethod2 = (SourceMethod)elementAt.getSourceElement();
                if (sourceMethod2 == null || (sourceMethod = MetSigController.confirmSourceMethod(sourceMethod2)) == null) break;
                RenameController.whenRenameMethod(context, sourceMethod);
                break;
            }
            case 4: 
            case 7: {
                SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)elementAt.getSourceElement();
                if (sourceMemberVariable == null) break;
                RenameController.whenRenameField(context, sourceMemberVariable);
                break;
            }
            case 1: {
                SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                if (sourceClass == null) break;
                RenameController.whenRenameClass(context, sourceClass);
                break;
            }
            case 5: {
                SourceVariable sourceVariable = (SourceVariable)elementAt.getSourceElement();
                SourceFile sourceFile = sourceVariable.getOwningSourceFile();
                RenameController.whenRenameVariable(context, sourceVariable, sourceFile);
                break;
            }
            case 2: {
                SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                if (sourceMethod == null) break;
                SourceClass sourceClass = sourceMethod.getEnclosingClass();
                RenameController.whenRenameClass(context, sourceClass);
                break;
            }
            case 6: {
                JavaPackage javaPackage = elementAt.getJavaPackage();
                RenameController.whenRenamePackage(context, javaPackage);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean checkCanRefactor(SourceElement sourceElement) {
        if (Util.canRefactor(sourceElement)) {
            return true;
        }
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        URL uRL = sourceFile.getURL();
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(RefactoringArb.getString(202), URLFileSystem.getPlatformPathName((URL)uRL)));
        return false;
    }

    public static boolean canRenameClass(Context context, SourceClass sourceClass) {
        return RenameController.canRename(context, (JavaElement)sourceClass);
    }

    public static void whenRenameClass(Context context, SourceClass sourceClass) {
        RenameClassDialog renameClassDialog;
        if (RenameController.checkCanRefactor((SourceElement)sourceClass) && (renameClassDialog = new RenameClassDialog(context, sourceClass)).runDialog()) {
            int n;
            String string = renameClassDialog.getNewName();
            boolean bl = renameClassDialog.isSearchInComments();
            boolean bl2 = renameClassDialog.isSearchInNonJavaFiles();
            String string2 = sourceClass.getPackageName();
            String string3 = sourceClass.getName();
            String string4 = sourceClass.getQualifiedName();
            String string5 = string4.substring(0, string4.length() - string3.length()) + string;
            String string6 = MessageFormat.format(RefactoringArb.getString(49), string4);
            String string7 = MessageFormat.format(RefactoringArb.getString(50), string4, string5);
            MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(bl, bl2, string7, string6);
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            SourceClass sourceClass2 = javaManager.getSourceClass(string4);
            if (sourceClass2 == null) {
                SourceFile sourceFile = sourceClass.getOwningSourceFile();
                moveClassesCriteria.hintMisplacedFile(sourceFile);
            }
            if ((n = string2.length()) > 0) {
                ++n;
            }
            moveClassesCriteria.addClassMove(javaManager, string2, string4.substring(n), string2, string5.substring(n));
            MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
            Util.setOperationHints((SearchOperationImpl)moveClassesOperation, (JavaClass)sourceClass, false);
            boolean bl3 = renameClassDialog.hasPreview();
            ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl3);
        }
    }

    public static boolean canRenameMethod(Context context, SourceMethod sourceMethod) {
        return RenameController.canRenameMember(context, (JavaMember)sourceMethod);
    }

    public static void whenRenameMethod(Context context, SourceMethod sourceMethod) {
        RenameMethodDialog renameMethodDialog = new RenameMethodDialog(context, sourceMethod);
        if (renameMethodDialog.runDialog()) {
            String string = renameMethodDialog.getNewName();
            boolean bl = renameMethodDialog.isSearchInComments();
            boolean bl2 = renameMethodDialog.isSearchInNonJavaFiles();
            MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
            RenameMethodCriteria renameMethodCriteria = new RenameMethodCriteria(methodDescription, string, bl, bl2);
            SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, renameMethodCriteria);
            Util.setOperationHints(searchOperationImpl, (JavaMember)sourceMethod, false);
            boolean bl3 = renameMethodDialog.hasPreview();
            searchOperationImpl.runRefactoring(bl3);
        }
    }

    public static boolean canRenameField(Context context, SourceFieldVariable sourceFieldVariable) {
        return RenameController.canRenameMember(context, (JavaMember)sourceFieldVariable);
    }

    public static void whenRenameField(Context context, SourceMemberVariable sourceMemberVariable) {
        RenameFieldDialog renameFieldDialog;
        SourceTypeReference sourceTypeReference = sourceMemberVariable.getSourceType();
        JavaType javaType = sourceTypeReference.getResolvedType();
        if (javaType != null && (renameFieldDialog = new RenameFieldDialog(context, sourceMemberVariable)).runDialog()) {
            String string = renameFieldDialog.getNewName();
            boolean bl = renameFieldDialog.isSearchInComments();
            boolean bl2 = renameFieldDialog.isSearchInNonJavaFiles();
            boolean bl3 = renameFieldDialog.hasPreview();
            RenameController.renameField(context, sourceMemberVariable, string, bl, bl2, true, bl3);
        }
    }

    private static void whenRenameVariable(Context context, SourceVariable sourceVariable, SourceFile sourceFile) {
        RenameVariableDialog renameVariableDialog = new RenameVariableDialog(context, sourceVariable);
        if (renameVariableDialog.runDialog()) {
            String string = renameVariableDialog.getNewName();
            boolean bl = renameVariableDialog.isSearchInComments();
            RenameVariableCriteria renameVariableCriteria = new RenameVariableCriteria(sourceVariable, sourceFile, string, bl);
            SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, renameVariableCriteria);
            boolean bl2 = renameVariableDialog.hasPreview();
            searchOperationImpl.runRefactoring(bl2);
        }
    }

    public static boolean canRenamePackage() {
        return true;
    }

    public static void whenRenamePackage(Context context, JavaPackage javaPackage) {
        String string;
        RenamePackageDialog renamePackageDialog;
        if (RenameController.checkCanRenamePackage(context, javaPackage) && (renamePackageDialog = new RenamePackageDialog(context, string = javaPackage.getName())).runDialog()) {
            String string2 = renamePackageDialog.getNewName();
            boolean bl = renamePackageDialog.isSearchInComments();
            boolean bl2 = renamePackageDialog.isSearchInNonJavaFiles();
            String string3 = MessageFormat.format(RefactoringArb.getString(49), string);
            String string4 = MessageFormat.format(RefactoringArb.getString(50), string, string2);
            MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(bl, bl2, string4, string3);
            Project project = context.getProject();
            String string5 = string.replace('.', '/');
            String string6 = string2.replace('.', '/');
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
            URLPath uRLPath = projectContent.getJavaRootDirs();
            URL[] uRLArray = uRLPath.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)string5);
                if (URLFileSystem.exists((URL)uRL2)) {
                    JavaManager javaManager = JavaManager.getJavaManager(project);
                    moveClassesCriteria.addDirectoryMove(javaManager, uRL, string5, project, uRL, string6);
                }
                ++n;
            }
            MoveClassesOperation moveClassesOperation = new MoveClassesOperation(context, moveClassesCriteria);
            boolean bl3 = renamePackageDialog.hasPreview();
            ((SearchOperationImpl)moveClassesOperation).runRefactoring(bl3);
        }
    }

    private static boolean checkCanRenamePackage(Context context, JavaPackage javaPackage) {
        return MoveController.checkCanRefactorPackage(context, javaPackage, RefactoringArb.getString(203));
    }

    private static boolean canRenameMember(Context context, JavaMember javaMember) {
        JavaClass javaClass;
        SourceClass sourceClass;
        boolean bl = false;
        if (RenameController.canRename(context, (JavaElement)javaMember) && !(sourceClass = (SourceClass)(javaClass = javaMember.getOwningClass()).getSourceElement()).isAnonymous()) {
            bl = true;
        }
        return bl;
    }

    public static boolean renameField(Context context, SourceMemberVariable sourceMemberVariable, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        SourceMethod sourceMethod = null;
        SourceMethod sourceMethod2 = null;
        MethodDescription methodDescription = null;
        MethodDescription methodDescription2 = null;
        String string2 = null;
        String string3 = null;
        if (bl3) {
            String string4 = RenameController.getBaseName(sourceMemberVariable.getName());
            JavaClass javaClass = sourceMemberVariable.getOwningClass();
            JavaType javaType = sourceMemberVariable.getResolvedType();
            sourceMethod = RenameController.getGetter(javaClass, javaType, string4);
            sourceMethod2 = RenameController.getSetter(javaClass, javaType, string4);
            if (sourceMethod != null || sourceMethod2 != null) {
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(361), (String)RefactoringArb.getString(206), null);
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        sourceMethod = null;
                        sourceMethod2 = null;
                        break;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
            if (sourceMethod != null) {
                String string5 = sourceMethod.getName();
                String string6 = string5.substring(0, string5.length() - string4.length());
                string2 = string6 + RenameController.getBaseName(string);
                methodDescription = new MethodDescription((JavaMethod)sourceMethod);
            }
            if (sourceMethod2 != null) {
                String string7 = sourceMethod2.getName();
                String string8 = string7.substring(0, string7.length() - string4.length());
                string3 = string8 + RenameController.getBaseName(string);
                methodDescription2 = new MethodDescription((JavaMethod)sourceMethod2);
            }
        }
        FieldDescription fieldDescription = new FieldDescription((JavaField)sourceMemberVariable);
        RenameFieldCriteria renameFieldCriteria = new RenameFieldCriteria(fieldDescription, string, methodDescription, string2, methodDescription2, string3, bl, bl2);
        SearchOperationImpl searchOperationImpl = new SearchOperationImpl(context, renameFieldCriteria);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(sourceMemberVariable);
        if (sourceMethod != null) {
            arrayList.add(sourceMethod);
        }
        if (sourceMethod2 != null) {
            arrayList.add(sourceMethod2);
        }
        JavaMember[] javaMemberArray = arrayList.toArray(new JavaMember[arrayList.size()]);
        Util.setOperationHints(searchOperationImpl, javaMemberArray);
        boolean bl5 = searchOperationImpl.runRefactoring(bl4);
        return bl5;
    }

    private static String getBaseName(String string) {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        String string2 = codingStyleOptions.getFieldPrefix();
        String string3 = codingStyleOptions.getFieldSuffix();
        if (string2 != null && string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if (string3 != null && string.endsWith(string3)) {
            string = string.substring(0, string.length() - string3.length());
        }
        string = Character.toUpperCase(string.charAt(0)) + (string.length() > 0 ? string.substring(1) : "");
        return string;
    }

    private static SourceMethod getGetter(JavaClass javaClass, JavaType javaType, String string) {
        if (javaType != null) {
            PrimitiveType primitiveType = PrimitiveType.lookupPrimitive((String)"boolean");
            Collection collection = javaClass.getDeclaredMethods();
            for (JavaMethod javaMethod : collection) {
                JavaType javaType2;
                String string2;
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                if (sourceMethod == null || !(string2 = sourceMethod.getName()).endsWith(string) || !sourceMethod.getParameters().isEmpty() || !ModelUtil.areEqual((Object)(javaType2 = sourceMethod.getReturnType()), (Object)javaType)) continue;
                String[] stringArray = !primitiveType.equals((Object)javaType2) ? new String[]{"get"} : new String[]{"is", "has", "get"};
                int n = 0;
                while (n < stringArray.length) {
                    String string3 = stringArray[n];
                    if (string2.startsWith(string3) && string2.length() == string3.length() + string.length()) {
                        return sourceMethod;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    private static SourceMethod getSetter(JavaClass javaClass, JavaType javaType, String string) {
        if (javaType != null) {
            PrimitiveType primitiveType = PrimitiveType.lookupPrimitive((String)"void");
            Collection collection = javaClass.getDeclaredMethods("set" + string);
            for (JavaMethod javaMethod : collection) {
                JavaType javaType2;
                SourceVariable sourceVariable;
                JavaType javaType3;
                List list;
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                if (sourceMethod == null || (list = sourceMethod.getSourceParameters()).size() != 1 || !javaType.equals((Object)(javaType3 = (sourceVariable = (SourceVariable)list.get(0)).getResolvedType())) || !(javaType2 = sourceMethod.getReturnType()).equals((Object)primitiveType)) continue;
                return sourceMethod;
            }
        }
        return null;
    }
}

